/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.billing.controller;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.validation.Valid;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.parsers.ParserConfigurationException;
import ninja.theteam.yubusin.ebilling.billing.dto.BillStatusRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.CancelBillRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.CreateBillRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.CreateBillResponse;
import ninja.theteam.yubusin.ebilling.billing.dto.QueryOnlineOfflineModeRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.QueryOnlineOfflineModeResponse;
import ninja.theteam.yubusin.ebilling.billing.dto.SetOfflineModeRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.SetOfflineModeResponse;
import ninja.theteam.yubusin.ebilling.billing.dto.SetOnlineModeRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.SetOnlineModeResponse;
import ninja.theteam.yubusin.ebilling.billing.service.BillingService;
import ninja.theteam.yubusin.ebilling.billing.service.OfflineBillingService;
import ninja.theteam.yubusin.ebilling.soap.billing.RespuestaComunicacion;
import ninja.theteam.yubusin.ebilling.soap.billing.RespuestaRecepcion;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.xml.sax.SAXException;

@RestController
@RequestMapping(value={"/api/billing"})
public class BillingRestController {
    private BillingService billingService;
    private OfflineBillingService offlineBillingService;

    public BillingRestController(BillingService billingService, OfflineBillingService offlineBillingService) {
        this.billingService = billingService;
        this.offlineBillingService = offlineBillingService;
    }

    @GetMapping(value={"/ping"})
    public RespuestaComunicacion ping() {
        return this.billingService.ping();
    }

    @PostMapping(value={"/bills"})
    public CreateBillResponse createBill(@RequestBody CreateBillRequest request) throws DatatypeConfigurationException, GeneralSecurityException, IOException, ParserConfigurationException, XMLSecurityException, SAXException {
        CreateBillResponse response = new CreateBillResponse();
        this.billingService.createBill(request, response);
        return response;
    }

    @PostMapping(value={"/bill-status"})
    public RespuestaRecepcion billStatus(@RequestBody BillStatusRequest request) {
        return this.billingService.billStatus(request);
    }

    @PostMapping(value={"/cancel-bill"})
    public RespuestaRecepcion cancelBill(@RequestBody CancelBillRequest request) {
        return this.billingService.cancelBill(request);
    }

    @PostMapping(value={"/query-online-offline-mode"})
    public QueryOnlineOfflineModeResponse queryOnlineOfflineMode(@RequestBody QueryOnlineOfflineModeRequest request) {
        return this.offlineBillingService.queryOnlineOfflineMode(request);
    }

    @PostMapping(value={"/set-offline-mode"})
    public SetOfflineModeResponse setOfflineMode(@Valid @RequestBody SetOfflineModeRequest request) {
        return this.offlineBillingService.setOfflineMode(request);
    }

    @PostMapping(value={"/set-online-mode"})
    public SetOnlineModeResponse setOnlineMode(@RequestBody SetOnlineModeRequest request) {
        return this.offlineBillingService.setOnlineMode(request);
    }

    @GetMapping(value={"/prepare-offline-bill-packages"})
    public void prepareOfflineBillPackages() {
        this.billingService.prepareOfflineBillPackages();
    }

    @GetMapping(value={"/process-offline-bill-packages"})
    public void processOfflineBillPackages() {
        this.billingService.processOfflineBillPackages();
    }

    @GetMapping(value={"/validate-offline-bill-packages"})
    public void validateOfflineBillPackages() {
        this.billingService.validateOfflineBillPackages();
    }
}

