/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.billing.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import ninja.theteam.yubusin.ebilling.billing.model.Bill;
import ninja.theteam.yubusin.ebilling.billing.model.OfflineBillPackageStatus;
import ninja.theteam.yubusin.ebilling.billing.model.OfflineEvent;
import ninja.theteam.yubusin.ebilling.common.model.BaseModel;

@Entity
public class OfflineBillPackage
extends BaseModel {
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", nullable=false)
    private OfflineBillPackageStatus offlineBillPackageStatus;
    @Column(nullable=false)
    private Date date;
    @Lob
    @Column(nullable=false)
    private String billHash;
    @Lob
    @Column(nullable=false)
    private String compressedData;
    private String descriptionCode;
    private Integer statusCode;
    private String receptionCode;
    @ManyToOne(optional=false)
    @JoinColumn(name="offline_event_id", nullable=false, foreignKey=@ForeignKey(name="offline_bill_package_offline_event_id_foreign"))
    private OfflineEvent offlineEvent;
    @OneToMany(mappedBy="offlineBillPackage", cascade={CascadeType.MERGE})
    private List<Bill> bills = new ArrayList();

    public void addBill(Bill bill) {
        this.getBills().add(bill);
        bill.setOfflineBillPackage(this);
    }

    public void addBills(List<Bill> bills) {
        for (Bill bill : bills) {
            this.addBill(bill);
        }
    }

    public OfflineBillPackageStatus getOfflineBillPackageStatus() {
        return this.offlineBillPackageStatus;
    }

    public Date getDate() {
        return this.date;
    }

    public String getBillHash() {
        return this.billHash;
    }

    public String getCompressedData() {
        return this.compressedData;
    }

    public String getDescriptionCode() {
        return this.descriptionCode;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public String getReceptionCode() {
        return this.receptionCode;
    }

    public OfflineEvent getOfflineEvent() {
        return this.offlineEvent;
    }

    public List<Bill> getBills() {
        return this.bills;
    }

    public void setOfflineBillPackageStatus(OfflineBillPackageStatus offlineBillPackageStatus) {
        this.offlineBillPackageStatus = offlineBillPackageStatus;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setBillHash(String billHash) {
        this.billHash = billHash;
    }

    public void setCompressedData(String compressedData) {
        this.compressedData = compressedData;
    }

    public void setDescriptionCode(String descriptionCode) {
        this.descriptionCode = descriptionCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public void setReceptionCode(String receptionCode) {
        this.receptionCode = receptionCode;
    }

    public void setOfflineEvent(OfflineEvent offlineEvent) {
        this.offlineEvent = offlineEvent;
    }

    public void setBills(List<Bill> bills) {
        this.bills = bills;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OfflineBillPackage)) {
            return false;
        }
        OfflineBillPackage other = (OfflineBillPackage)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$statusCode = this.getStatusCode();
        Integer other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        OfflineBillPackageStatus this$offlineBillPackageStatus = this.getOfflineBillPackageStatus();
        OfflineBillPackageStatus other$offlineBillPackageStatus = other.getOfflineBillPackageStatus();
        if (this$offlineBillPackageStatus == null ? other$offlineBillPackageStatus != null : !this$offlineBillPackageStatus.equals(other$offlineBillPackageStatus)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$billHash = this.getBillHash();
        String other$billHash = other.getBillHash();
        if (this$billHash == null ? other$billHash != null : !this$billHash.equals(other$billHash)) {
            return false;
        }
        String this$compressedData = this.getCompressedData();
        String other$compressedData = other.getCompressedData();
        if (this$compressedData == null ? other$compressedData != null : !this$compressedData.equals(other$compressedData)) {
            return false;
        }
        String this$descriptionCode = this.getDescriptionCode();
        String other$descriptionCode = other.getDescriptionCode();
        if (this$descriptionCode == null ? other$descriptionCode != null : !this$descriptionCode.equals(other$descriptionCode)) {
            return false;
        }
        String this$receptionCode = this.getReceptionCode();
        String other$receptionCode = other.getReceptionCode();
        if (this$receptionCode == null ? other$receptionCode != null : !this$receptionCode.equals(other$receptionCode)) {
            return false;
        }
        OfflineEvent this$offlineEvent = this.getOfflineEvent();
        OfflineEvent other$offlineEvent = other.getOfflineEvent();
        if (this$offlineEvent == null ? other$offlineEvent != null : !this$offlineEvent.equals(other$offlineEvent)) {
            return false;
        }
        List this$bills = this.getBills();
        List other$bills = other.getBills();
        return !(this$bills == null ? other$bills != null : !((Object)this$bills).equals(other$bills));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OfflineBillPackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        OfflineBillPackageStatus $offlineBillPackageStatus = this.getOfflineBillPackageStatus();
        result = result * 59 + ($offlineBillPackageStatus == null ? 43 : $offlineBillPackageStatus.hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $billHash = this.getBillHash();
        result = result * 59 + ($billHash == null ? 43 : $billHash.hashCode());
        String $compressedData = this.getCompressedData();
        result = result * 59 + ($compressedData == null ? 43 : $compressedData.hashCode());
        String $descriptionCode = this.getDescriptionCode();
        result = result * 59 + ($descriptionCode == null ? 43 : $descriptionCode.hashCode());
        String $receptionCode = this.getReceptionCode();
        result = result * 59 + ($receptionCode == null ? 43 : $receptionCode.hashCode());
        OfflineEvent $offlineEvent = this.getOfflineEvent();
        result = result * 59 + ($offlineEvent == null ? 43 : $offlineEvent.hashCode());
        List $bills = this.getBills();
        result = result * 59 + ($bills == null ? 43 : ((Object)$bills).hashCode());
        return result;
    }

    public String toString() {
        return "OfflineBillPackage(offlineBillPackageStatus=" + this.getOfflineBillPackageStatus() + ", date=" + this.getDate() + ", billHash=" + this.getBillHash() + ", compressedData=" + this.getCompressedData() + ", descriptionCode=" + this.getDescriptionCode() + ", statusCode=" + this.getStatusCode() + ", receptionCode=" + this.getReceptionCode() + ", offlineEvent=" + this.getOfflineEvent() + ", bills=" + this.getBills() + ")";
    }
}

