/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.billing.service;

import java.util.Optional;
import ninja.theteam.yubusin.ebilling.billing.dto.CreateBillRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.CreateBillRequestDetail;
import ninja.theteam.yubusin.ebilling.billing.dto.CreateBillResponse;
import ninja.theteam.yubusin.ebilling.billing.model.Bill;
import ninja.theteam.yubusin.ebilling.billing.model.BillDetail;
import ninja.theteam.yubusin.ebilling.billing.model.BillType;
import ninja.theteam.yubusin.ebilling.billing.model.OfflineEvent;
import ninja.theteam.yubusin.ebilling.billing.repository.BillRepository;
import ninja.theteam.yubusin.ebilling.billing.service.OfflineEventService;
import org.springframework.stereotype.Service;

@Service
public class BillService {
    private final BillRepository billRepository;
    private final OfflineEventService offlineEventService;

    public BillService(BillRepository billRepository, OfflineEventService offlineEventService) {
        this.billRepository = billRepository;
        this.offlineEventService = offlineEventService;
    }

    public void saveOnline(CreateBillRequest request, CreateBillResponse response) {
        this.save(request, response, true, null);
    }

    public void saveOffline(CreateBillRequest request, CreateBillResponse response, String cafc) {
        this.save(request, response, false, cafc);
    }

    private void save(CreateBillRequest request, CreateBillResponse response, boolean isOnline, String cafc) {
        Bill bill = new Bill();
        bill.setBillType(isOnline ? BillType.ONLINE : BillType.OFFLINE);
        bill.setCafc(cafc);
        bill.setBranchOffice(request.getCodigoSucursal());
        bill.setPosCode(request.getCodigoPuntoVenta());
        bill.setBillNumber(request.getNumeroFactura());
        bill.setCuf(response.getCuf());
        bill.setExceptionCode(request.getCodigoExcepcion());
        bill.setSocialReasonName(request.getNombreRazonSocial());
        bill.setIdentityDocumentTypeCode(request.getCodigoTipoDocumentoIdentidad());
        bill.setDocumentNumber(request.getNumeroDocumento());
        bill.setComplement(request.getComplemento());
        bill.setCustomerCode(request.getCodigoCliente());
        bill.setPaymentMethodCode(request.getCodigoMetodoPago());
        bill.setUser(request.getUsuario());
        bill.setSectorDocumentCode(request.getCodigoDocumentoSector());
        bill.setCurrencyCode(request.getCodigoMoneda());
        bill.setExchangeRate(request.getTipoCambio());
        bill.setTotalAmount(request.getMontoTotal());
        bill.setTotalAmountTax(request.getMontoTotalSujetoIva());
        bill.setTotalAmountCurrency(request.getMontoTotalMoneda());
        bill.setAddress(response.getDireccion());
        bill.setEmissionDate(response.getFecha());
        bill.setBillLegend(response.getLeyenda());
        bill.setBillHash(response.getHash());
        bill.setBillXml(response.getFactura());
        if (isOnline) {
            bill.setReceptionCode(response.getRespuestaRecepcion().getCodigoRecepcion());
        } else {
            Optional offlineEventOpt = this.offlineEventService.getActiveOfflineEvent(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
            bill.setOfflineEvent((OfflineEvent)offlineEventOpt.get());
        }
        for (CreateBillRequestDetail createBillRequestDetail : request.getDetalle()) {
            BillDetail billDetail = new BillDetail();
            billDetail.setBill(bill);
            billDetail.setBranchOffice(request.getCodigoSucursal());
            billDetail.setPosCode(request.getCodigoPuntoVenta());
            billDetail.setEconomicActivity(createBillRequestDetail.getActividadEconomica());
            billDetail.setProductCodeSin(createBillRequestDetail.getCodigoProductoSin());
            billDetail.setProductCode(createBillRequestDetail.getCodigoProducto());
            billDetail.setMeasureUnit(createBillRequestDetail.getUnidadMedida());
            billDetail.setDescription(createBillRequestDetail.getDescripcion());
            billDetail.setQuantity(createBillRequestDetail.getCantidad());
            billDetail.setUnitPrice(createBillRequestDetail.getPrecioUnitario());
            billDetail.setDiscountAmount(createBillRequestDetail.getMontoDescuento());
            billDetail.setSubTotal(createBillRequestDetail.getSubTotal());
            bill.getBillDetails().add(billDetail);
        }
        this.billRepository.save((Object)bill);
    }

    public int countAllByOfflineEventId(Long offlineEventId) {
        return this.billRepository.countAllByOfflineEventId(offlineEventId);
    }

    public int countAllByOfflineBillPackageId(Long offlineBillPackageId) {
        return this.billRepository.countAllByOfflineBillPackageId(offlineBillPackageId);
    }
}

