/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.billing.service;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.BindingProvider;
import ninja.theteam.yubusin.ebilling.billing.dto.BillStatusRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.CancelBillRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.CreateBillRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.CreateBillRequestDetail;
import ninja.theteam.yubusin.ebilling.billing.dto.CreateBillResponse;
import ninja.theteam.yubusin.ebilling.billing.dto.CreateMassiveBillsRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.ReceiptOfflineBillPackageRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.ValidateMassiveBillReceiptRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.ValidateOfflineBillPackageRequest;
import ninja.theteam.yubusin.ebilling.billing.model.Bill;
import ninja.theteam.yubusin.ebilling.billing.model.BillType;
import ninja.theteam.yubusin.ebilling.billing.model.OfflineBillPackage;
import ninja.theteam.yubusin.ebilling.billing.model.OfflineBillPackageStatus;
import ninja.theteam.yubusin.ebilling.billing.model.OfflineEvent;
import ninja.theteam.yubusin.ebilling.billing.model.OfflineEventStatus;
import ninja.theteam.yubusin.ebilling.billing.service.BillService;
import ninja.theteam.yubusin.ebilling.billing.service.OfflineBillPackageService;
import ninja.theteam.yubusin.ebilling.billing.service.OfflineEventService;
import ninja.theteam.yubusin.ebilling.billing.service.RandomLegendService;
import ninja.theteam.yubusin.ebilling.codes.service.CufdService;
import ninja.theteam.yubusin.ebilling.codes.service.CuisService;
import ninja.theteam.yubusin.ebilling.common.exception.OfflineBillPackageException;
import ninja.theteam.yubusin.ebilling.common.exception.OfflineModeException;
import ninja.theteam.yubusin.ebilling.common.exception.SiatNotRespondingException;
import ninja.theteam.yubusin.ebilling.common.exception.SignificantEventException;
import ninja.theteam.yubusin.ebilling.common.model.Util;
import ninja.theteam.yubusin.ebilling.config.EBillingAppConfig;
import ninja.theteam.yubusin.ebilling.email.service.EmailService;
import ninja.theteam.yubusin.ebilling.signature.service.CufService;
import ninja.theteam.yubusin.ebilling.signature.service.GZipService;
import ninja.theteam.yubusin.ebilling.signature.service.HashService;
import ninja.theteam.yubusin.ebilling.signature.service.SignerService;
import ninja.theteam.yubusin.ebilling.signature.service.TarService;
import ninja.theteam.yubusin.ebilling.soap.billing.MensajeRecepcion;
import ninja.theteam.yubusin.ebilling.soap.billing.ObjectFactory;
import ninja.theteam.yubusin.ebilling.soap.billing.RespuestaComunicacion;
import ninja.theteam.yubusin.ebilling.soap.billing.RespuestaRecepcion;
import ninja.theteam.yubusin.ebilling.soap.billing.ServicioFacturacion;
import ninja.theteam.yubusin.ebilling.soap.billing.ServicioFacturacion_Service;
import ninja.theteam.yubusin.ebilling.soap.billing.SolicitudAnulacion;
import ninja.theteam.yubusin.ebilling.soap.billing.SolicitudRecepcionFactura;
import ninja.theteam.yubusin.ebilling.soap.billing.SolicitudRecepcionMasiva;
import ninja.theteam.yubusin.ebilling.soap.billing.SolicitudRecepcionPaquete;
import ninja.theteam.yubusin.ebilling.soap.billing.SolicitudValidacionRecepcion;
import ninja.theteam.yubusin.ebilling.soap.billing.SolicitudVerificacionEstado;
import ninja.theteam.yubusin.ebilling.soap.codes.RespuestaCufd;
import ninja.theteam.yubusin.ebilling.soap.codes.RespuestaCuis;
import ninja.theteam.yubusin.ebilling.soap.model.FacturaElectronicaCompraVenta;
import org.apache.commons.codec.binary.Base64;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.xml.sax.SAXException;

@Service
public class BillingService {
    private static final Logger logger = LoggerFactory.getLogger(BillingService.class);
    private static final QName SERVICE_NAME = new QName("https://siat.impuestos.gob.bo/ServicioFacturacionCompraVenta", "ServicioFacturacion");
    private final EBillingAppConfig eBillingAppConfig;
    private final CuisService cuisService;
    private final CufdService cufdService;
    private final CufService cufService;
    private final GZipService gZipService;
    private final TarService tarService;
    private final HashService hashService;
    private final SignerService signerService;
    private final RandomLegendService randomLegendService;
    private final BillService billService;
    private final OfflineEventService offlineEventService;
    private final OfflineBillPackageService offlineBillPackageService;
    private final EmailService emailService;

    public BillingService(EBillingAppConfig eBillingAppConfig, CuisService cuisService, CufdService cufdService, CufService cufService, GZipService gZipService, TarService tarService, HashService hashService, SignerService signerService, RandomLegendService randomLegendService, BillService billService, OfflineEventService offlineEventService, OfflineBillPackageService offlineBillPackageService, EmailService emailService) {
        this.eBillingAppConfig = eBillingAppConfig;
        this.cuisService = cuisService;
        this.cufdService = cufdService;
        this.cufService = cufService;
        this.gZipService = gZipService;
        this.tarService = tarService;
        this.hashService = hashService;
        this.signerService = signerService;
        this.randomLegendService = randomLegendService;
        this.billService = billService;
        this.offlineEventService = offlineEventService;
        this.offlineBillPackageService = offlineBillPackageService;
        this.emailService = emailService;
    }

    public RespuestaComunicacion ping() {
        try {
            logger.debug("Invoking ping...");
            RespuestaComunicacion response = this.getPort().verificarComunicacion();
            logger.debug("pong");
            return response;
        }
        catch (Exception e) {
            logger.error("SIAT is not responding. Dying gracefully.");
            throw new SiatNotRespondingException("SIAT is not responding. It is recommended to change to offline mode.");
        }
    }

    public void createBill(CreateBillRequest request, CreateBillResponse response) {
        boolean isOfflineMode = this.offlineEventService.isOfflineMode(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
        Optional offlineEventOpt = this.offlineEventService.getActiveOfflineEvent(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
        try {
            SolicitudRecepcionFactura solicitudRecepcionFactura = this.buildCreateBillRequest(request, response, isOfflineMode, offlineEventOpt);
            if (!isOfflineMode) {
                logger.debug("Invoking recepcionFactura...");
                RespuestaRecepcion respuestaRecepcion = this.getPort().recepcionFactura(solicitudRecepcionFactura);
                logger.debug("recepcionFactura.result=" + respuestaRecepcion.isTransaccion());
                response.setRespuestaRecepcion(respuestaRecepcion);
                response.setTipo(BillType.ONLINE.name());
                if (respuestaRecepcion.getCodigoRecepcion() != null) {
                    this.billService.saveOnline(request, response);
                }
            } else {
                response.setTipo(BillType.OFFLINE.name());
                this.billService.saveOffline(request, response, ((OfflineEvent)offlineEventOpt.get()).getCafc());
            }
        }
        catch (Exception e) {
            if (isOfflineMode) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            logger.error("SIAT is not responding. Dying gracefully.");
            throw new SiatNotRespondingException("SIAT is not responding. It is recommended to change to offline mode.");
        }
    }

    public RespuestaRecepcion cancelBill(CancelBillRequest request) {
        if (this.offlineEventService.isOfflineMode(request.getCodigoSucursal(), request.getCodigoPuntoVenta())) {
            throw new OfflineModeException("Cannot cancel the bill. The offline mode is active.");
        }
        SolicitudAnulacion solicitudAnulacion = new ObjectFactory().createSolicitudAnulacion();
        solicitudAnulacion.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        solicitudAnulacion.setCodigoSistema("6D23688410B63B72FBD7EC6");
        solicitudAnulacion.setNit(EBillingAppConfig.NIT.longValue());
        solicitudAnulacion.setCodigoDocumentoSector(1);
        solicitudAnulacion.setCodigoEmision(1);
        solicitudAnulacion.setCodigoModalidad(1);
        solicitudAnulacion.setCufd(this.cufdService.getCufd(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudAnulacion.setCuis(this.cuisService.getCuis(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudAnulacion.setTipoFacturaDocumento(1);
        solicitudAnulacion.setCodigoSucursal(request.getCodigoSucursal().intValue());
        solicitudAnulacion.setCodigoPuntoVenta(request.getCodigoPuntoVenta());
        solicitudAnulacion.setCodigoMotivo(request.getCodigoMotivo().intValue());
        solicitudAnulacion.setCuf(request.getCuf());
        logger.debug("Invoking anulacionFactura...");
        RespuestaRecepcion respuestaRecepcion = this.getPort().anulacionFactura(solicitudAnulacion);
        logger.debug("anulacionFactura.result=" + respuestaRecepcion);
        return respuestaRecepcion;
    }

    public RespuestaRecepcion billStatus(BillStatusRequest request) {
        SolicitudVerificacionEstado solicitudVerificacionEstado = new ObjectFactory().createSolicitudVerificacionEstado();
        solicitudVerificacionEstado.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        solicitudVerificacionEstado.setCodigoPuntoVenta(request.getCodigoPuntoVenta());
        solicitudVerificacionEstado.setCodigoSistema("6D23688410B63B72FBD7EC6");
        solicitudVerificacionEstado.setCodigoSucursal(request.getCodigoSucursal().intValue());
        solicitudVerificacionEstado.setNit(EBillingAppConfig.NIT.longValue());
        solicitudVerificacionEstado.setCodigoDocumentoSector(1);
        solicitudVerificacionEstado.setCodigoEmision(1);
        solicitudVerificacionEstado.setCodigoModalidad(1);
        solicitudVerificacionEstado.setTipoFacturaDocumento(1);
        solicitudVerificacionEstado.setCufd(this.cufdService.getCufd(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudVerificacionEstado.setCuis(this.cuisService.getCuis(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudVerificacionEstado.setCuf(request.getCuf());
        logger.debug("Invoking verificacionEstadoFactura...");
        RespuestaRecepcion respuestaRecepcion = this.getPort().verificacionEstadoFactura(solicitudVerificacionEstado);
        logger.debug("verificacionEstadoFactura.result=" + respuestaRecepcion);
        return respuestaRecepcion;
    }

    public RespuestaRecepcion createOfflineBillPackage(ReceiptOfflineBillPackageRequest request) throws GeneralSecurityException, IOException, ParserConfigurationException, XMLSecurityException, SAXException, DatatypeConfigurationException {
        RespuestaCufd respuestaCufd = this.cufdService.getCufd(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
        RespuestaCufd respuestaCufdEvento = this.cufdService.getCufd(request.getCufdEvento());
        String legend = this.randomLegendService.getRandomLegend(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
        ArrayList<String> billList = new ArrayList<String>();
        GregorianCalendar billDate = Util.getNewGregorianCalendar();
        billDate.setTime(request.getDate());
        for (CreateBillRequest createBillRequest : request.getRequestList()) {
            String cuf = this.cufService.getCuf(EBillingAppConfig.NIT, billDate, createBillRequest.getCodigoSucursal(), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1), createBillRequest.getNumeroFactura(), createBillRequest.getCodigoPuntoVenta(), respuestaCufdEvento.getCodigoControl());
            FacturaElectronicaCompraVenta bill = this.getBill(createBillRequest, billDate, respuestaCufdEvento.getDireccion(), respuestaCufdEvento.getCodigo(), cuf, legend, request.getCafc());
            String signedBill = this.getSignedBill(bill);
            billList.add(signedBill);
        }
        byte[] tarData = this.tarService.tarCompress(billList);
        byte[] compressedData = this.gZipService.compress(tarData);
        SolicitudRecepcionPaquete solicitudRecepcionPaquete = new ObjectFactory().createSolicitudRecepcionPaquete();
        solicitudRecepcionPaquete.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        solicitudRecepcionPaquete.setCodigoSistema("6D23688410B63B72FBD7EC6");
        solicitudRecepcionPaquete.setNit(EBillingAppConfig.NIT.longValue());
        solicitudRecepcionPaquete.setCodigoDocumentoSector(1);
        solicitudRecepcionPaquete.setCodigoEmision(2);
        solicitudRecepcionPaquete.setCodigoModalidad(1);
        solicitudRecepcionPaquete.setCuis(this.cuisService.getCuis(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudRecepcionPaquete.setCufd(respuestaCufd.getCodigo());
        solicitudRecepcionPaquete.setTipoFacturaDocumento(1);
        solicitudRecepcionPaquete.setCodigoSucursal(request.getCodigoSucursal().intValue());
        solicitudRecepcionPaquete.setCodigoPuntoVenta(request.getCodigoPuntoVenta());
        GregorianCalendar date = Util.getNewGregorianCalendar();
        XMLGregorianCalendar sendDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(date);
        sendDate.setTimezone(Integer.MIN_VALUE);
        solicitudRecepcionPaquete.setFechaEnvio(sendDate.toString());
        solicitudRecepcionPaquete.setCodigoEvento(request.getCodigoEvento());
        solicitudRecepcionPaquete.setCafc(request.getCafc());
        solicitudRecepcionPaquete.setCantidadFacturas(billList.size());
        solicitudRecepcionPaquete.setArchivo(compressedData);
        solicitudRecepcionPaquete.setHashArchivo(this.hashService.sha256Hash(compressedData));
        logger.debug("Invoking recepcionPaqueteFactura...");
        RespuestaRecepcion response = this.getPort().recepcionPaqueteFactura(solicitudRecepcionPaquete);
        logger.debug("recepcionPaqueteFactura.result=" + response);
        return response;
    }

    public void prepareOfflineBillPackages() {
        List offlineEventList = this.offlineEventService.getFinishedOfflineEvents();
        for (OfflineEvent offlineEvent : offlineEventList) {
            offlineEvent.setOfflineEventStatus(OfflineEventStatus.PROCESSING);
            offlineEvent = this.offlineEventService.save(offlineEvent);
            try {
                int i;
                ArrayList<OfflineBillPackage> offlineBillPackageList = new ArrayList<OfflineBillPackage>();
                ArrayList billPackageList = new ArrayList();
                ArrayList billPackageXmlList = new ArrayList();
                int packageCount = -1;
                for (i = 0; i < offlineEvent.getBills().size(); ++i) {
                    if (i % 500 == 0) {
                        ++packageCount;
                        billPackageList.add(new ArrayList());
                        billPackageXmlList.add(new ArrayList());
                    }
                    Bill bill = (Bill)offlineEvent.getBills().get(i);
                    String billXml = new String(Base64.decodeBase64((String)bill.getBillXml()), StandardCharsets.UTF_8);
                    ((List)billPackageList.get(packageCount)).add(bill);
                    ((List)billPackageXmlList.get(packageCount)).add(billXml);
                }
                for (i = 0; i < billPackageList.size(); ++i) {
                    List billList = (List)billPackageList.get(i);
                    List billXmlList = (List)billPackageXmlList.get(i);
                    byte[] tarData = this.tarService.tarCompress(billXmlList);
                    byte[] compressedData = this.gZipService.compress(tarData);
                    String hash = this.hashService.sha256Hash(compressedData);
                    OfflineBillPackage offlineBillPackage = new OfflineBillPackage();
                    offlineBillPackage.setOfflineBillPackageStatus(OfflineBillPackageStatus.PROCESS_PENDING);
                    offlineBillPackage.setBranchOffice(offlineEvent.getBranchOffice());
                    offlineBillPackage.setPosCode(offlineEvent.getPosCode());
                    offlineBillPackage.setDate(Util.getNewGregorianCalendar().getTime());
                    offlineBillPackage.setBillHash(hash);
                    offlineBillPackage.setCompressedData(Base64.encodeBase64String((byte[])compressedData));
                    offlineBillPackage.setOfflineEvent(offlineEvent);
                    offlineBillPackage.addBills(billList);
                    offlineBillPackageList.add(this.offlineBillPackageService.save(offlineBillPackage));
                }
                offlineEvent.setOfflineEventStatus(OfflineEventStatus.PROCESS_COMPLETED);
                offlineEvent = this.offlineEventService.save(offlineEvent);
                String subject = String.format("prepareOfflineBillPackage: OK, branchOffice %d, posCode %d, envCode %d", offlineEvent.getBranchOffice(), offlineEvent.getPosCode(), this.eBillingAppConfig.getEnvironmentCode());
                String text = "OfflineEvent(" + "id=" + offlineEvent.getId() + ", " + "status=" + offlineEvent.getOfflineEventStatus() + ", " + "description=" + offlineEvent.getDescription() + ", " + "startDate=" + offlineEvent.getStartDate() + ", " + "endDate=" + offlineEvent.getEndDate() + ", " + "receptionCode=" + offlineEvent.getReceptionCode() + ", " + "cafc=" + offlineEvent.getCafc() + ", " + "packages=" + billPackageList.size() + ")";
                this.emailService.sendSimpleMessage(this.eBillingAppConfig.getToEmail(), subject, text);
                logger.debug(text);
            }
            catch (Exception e) {
                offlineEvent.setOfflineEventStatus(OfflineEventStatus.EVENT_FINISHED);
                this.offlineEventService.save(offlineEvent);
                String subject = String.format("prepareOfflineBillPackage: ERROR, branchOffice %d, posCode %d, envCode %d", offlineEvent.getBranchOffice(), offlineEvent.getPosCode(), this.eBillingAppConfig.getEnvironmentCode());
                this.emailService.sendSimpleMessage(this.eBillingAppConfig.getToEmail(), subject, e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
                throw new SignificantEventException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void processOfflineBillPackages() {
        List offlineBillPackageList = this.offlineBillPackageService.getPendingOfflineBillPackages();
        for (OfflineBillPackage offlineBillPackage : offlineBillPackageList) {
            offlineBillPackage.setOfflineBillPackageStatus(OfflineBillPackageStatus.PROCESSING);
            offlineBillPackage = this.offlineBillPackageService.save(offlineBillPackage);
            try {
                RespuestaCuis respuestaCuis = this.cuisService.getCuis(offlineBillPackage.getBranchOffice(), offlineBillPackage.getPosCode());
                RespuestaCufd respuestaCufd = this.cufdService.getCufd(offlineBillPackage.getBranchOffice(), offlineBillPackage.getPosCode());
                SolicitudRecepcionPaquete solicitudRecepcionPaquete = new ObjectFactory().createSolicitudRecepcionPaquete();
                solicitudRecepcionPaquete.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
                solicitudRecepcionPaquete.setCodigoSistema("6D23688410B63B72FBD7EC6");
                solicitudRecepcionPaquete.setNit(EBillingAppConfig.NIT.longValue());
                solicitudRecepcionPaquete.setCodigoDocumentoSector(1);
                solicitudRecepcionPaquete.setCodigoEmision(2);
                solicitudRecepcionPaquete.setCodigoModalidad(1);
                solicitudRecepcionPaquete.setCuis(respuestaCuis.getCodigo());
                solicitudRecepcionPaquete.setCufd(respuestaCufd.getCodigo());
                solicitudRecepcionPaquete.setTipoFacturaDocumento(1);
                solicitudRecepcionPaquete.setCodigoSucursal(offlineBillPackage.getBranchOffice().intValue());
                solicitudRecepcionPaquete.setCodigoPuntoVenta(offlineBillPackage.getPosCode());
                GregorianCalendar date = Util.getNewGregorianCalendar();
                XMLGregorianCalendar sendDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(date);
                sendDate.setTimezone(Integer.MIN_VALUE);
                solicitudRecepcionPaquete.setFechaEnvio(sendDate.toString());
                int billsCount = this.billService.countAllByOfflineBillPackageId(offlineBillPackage.getId());
                solicitudRecepcionPaquete.setCodigoEvento(offlineBillPackage.getOfflineEvent().getReceptionCode().longValue());
                solicitudRecepcionPaquete.setCafc(offlineBillPackage.getOfflineEvent().getCafc());
                solicitudRecepcionPaquete.setCantidadFacturas(billsCount);
                solicitudRecepcionPaquete.setArchivo(Base64.decodeBase64((String)offlineBillPackage.getCompressedData()));
                solicitudRecepcionPaquete.setHashArchivo(offlineBillPackage.getBillHash());
                logger.debug("Invoking recepcionPaqueteFactura...");
                RespuestaRecepcion response = this.getPort().recepcionPaqueteFactura(solicitudRecepcionPaquete);
                logger.debug("recepcionPaqueteFactura.result=" + response.isTransaccion());
                if (!response.isTransaccion().booleanValue()) {
                    StringBuilder responseStringBuilder = new StringBuilder();
                    responseStringBuilder.append("codigoDescripcion: ").append(response.getCodigoDescripcion()).append("\n").append("codigoEstado: ").append(response.getCodigoEstado()).append("\n").append("codigoRecepcion: ").append(response.getCodigoRecepcion()).append("\n\n");
                    for (MensajeRecepcion mensajeRecepcion : response.getMensajesList()) {
                        responseStringBuilder.append("Advertencia: ").append(mensajeRecepcion.isAdvertencia()).append("\n").append("NumeroArchivo: ").append(mensajeRecepcion.getNumeroArchivo()).append("\n").append("NumeroDetalle: ").append(mensajeRecepcion.getNumeroDetalle()).append("\n").append("C\u00f3digo: ").append(mensajeRecepcion.getCodigo()).append("\n").append("Descripci\u00f3n: ").append(mensajeRecepcion.getDescripcion()).append("\n\n");
                    }
                    String subject = String.format("processOfflineBillPackages: ERROR, branchOffice %d, posCode %d, envCode %d", offlineBillPackage.getBranchOffice(), offlineBillPackage.getPosCode(), this.eBillingAppConfig.getEnvironmentCode());
                    this.emailService.sendSimpleMessage(this.eBillingAppConfig.getToEmail(), subject, responseStringBuilder.toString());
                    logger.error(responseStringBuilder.toString());
                    throw new OfflineBillPackageException(responseStringBuilder.toString());
                }
                offlineBillPackage.setDate(date.getTime());
                offlineBillPackage.setDescriptionCode(response.getCodigoDescripcion());
                offlineBillPackage.setStatusCode(response.getCodigoEstado());
                offlineBillPackage.setReceptionCode(response.getCodigoRecepcion());
                offlineBillPackage.setOfflineBillPackageStatus(OfflineBillPackageStatus.AWAITING_VALIDATION);
                offlineBillPackage = this.offlineBillPackageService.save(offlineBillPackage);
                String subject = String.format("processOfflineBillPackages: OK, branchOffice %d, posCode %d, envCode %d", offlineBillPackage.getBranchOffice(), offlineBillPackage.getPosCode(), this.eBillingAppConfig.getEnvironmentCode());
                String text = "OfflineBillPackage(" + "id=" + offlineBillPackage.getId() + ", " + "date=" + offlineBillPackage.getDate().getTime() + ", " + "description=" + offlineBillPackage.getDescriptionCode() + ", " + "receptionCode=" + offlineBillPackage.getReceptionCode() + ", " + "status=" + offlineBillPackage.getOfflineBillPackageStatus() + ", " + "billsCount=" + billsCount + ")";
                this.emailService.sendSimpleMessage(this.eBillingAppConfig.getToEmail(), subject, text);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                offlineBillPackage.setOfflineBillPackageStatus(OfflineBillPackageStatus.PROCESS_PENDING);
                this.offlineBillPackageService.save(offlineBillPackage);
                String subject = String.format("processOfflineBillPackages: ERROR, branchOffice %d, posCode %d, envCode %d", offlineBillPackage.getBranchOffice(), offlineBillPackage.getPosCode(), this.eBillingAppConfig.getEnvironmentCode());
                this.emailService.sendSimpleMessage(this.eBillingAppConfig.getToEmail(), subject, e.getMessage());
            }
        }
    }

    public void validateOfflineBillPackages() {
        List offlineBillPackageList = this.offlineBillPackageService.getAwaitingValidationOfflineBillPackages();
        for (OfflineBillPackage offlineBillPackage : offlineBillPackageList) {
            try {
                offlineBillPackage.setOfflineBillPackageStatus(OfflineBillPackageStatus.PROCESSING_VALIDATION);
                offlineBillPackage = this.offlineBillPackageService.save(offlineBillPackage);
                SolicitudValidacionRecepcion solicitudValidacionRecepcion = new ObjectFactory().createSolicitudValidacionRecepcion();
                solicitudValidacionRecepcion.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
                solicitudValidacionRecepcion.setCodigoSistema("6D23688410B63B72FBD7EC6");
                solicitudValidacionRecepcion.setNit(EBillingAppConfig.NIT.longValue());
                solicitudValidacionRecepcion.setCodigoDocumentoSector(1);
                solicitudValidacionRecepcion.setCodigoEmision(2);
                solicitudValidacionRecepcion.setCodigoModalidad(1);
                solicitudValidacionRecepcion.setCuis(this.cuisService.getCuis(offlineBillPackage.getBranchOffice(), offlineBillPackage.getPosCode()).getCodigo());
                solicitudValidacionRecepcion.setCufd(this.cufdService.getCufd(offlineBillPackage.getBranchOffice(), offlineBillPackage.getPosCode()).getCodigo());
                solicitudValidacionRecepcion.setTipoFacturaDocumento(1);
                solicitudValidacionRecepcion.setCodigoSucursal(offlineBillPackage.getBranchOffice().intValue());
                solicitudValidacionRecepcion.setCodigoPuntoVenta(offlineBillPackage.getPosCode());
                solicitudValidacionRecepcion.setCodigoRecepcion(offlineBillPackage.getReceptionCode());
                logger.debug("Invoking validacionRecepcionPaqueteFactura...");
                RespuestaRecepcion response = this.getPort().validacionRecepcionPaqueteFactura(solicitudValidacionRecepcion);
                logger.debug("validacionRecepcionPaqueteFactura.result=" + response.isTransaccion());
                if (!response.isTransaccion().booleanValue() || response.getCodigoEstado() != 908) {
                    StringBuilder responseStringBuilder = new StringBuilder();
                    responseStringBuilder.append("codigoDescripcion: ").append(response.getCodigoDescripcion()).append("\n").append("codigoEstado: ").append(response.getCodigoEstado()).append("\n").append("codigoRecepcion: ").append(response.getCodigoRecepcion()).append("\n\n");
                    for (MensajeRecepcion mensajeRecepcion : response.getMensajesList()) {
                        responseStringBuilder.append("Advertencia: ").append(mensajeRecepcion.isAdvertencia()).append("\n").append("NumeroArchivo: ").append(mensajeRecepcion.getNumeroArchivo()).append("\n").append("NumeroDetalle: ").append(mensajeRecepcion.getNumeroDetalle()).append("\n").append("C\u00f3digo: ").append(mensajeRecepcion.getCodigo()).append("\n").append("Descripci\u00f3n: " + mensajeRecepcion.getDescripcion()).append("\n\n");
                    }
                    String subject = String.format("validateOfflineBillPackages: INFO, branchOffice %d, posCode %d, envCode %d", offlineBillPackage.getBranchOffice(), offlineBillPackage.getPosCode(), this.eBillingAppConfig.getEnvironmentCode());
                    this.emailService.sendSimpleMessage(this.eBillingAppConfig.getToEmail(), subject, responseStringBuilder.toString());
                    logger.error(responseStringBuilder.toString());
                    if (!response.isTransaccion().booleanValue() || response.getCodigoEstado() != 904) {
                        throw new OfflineBillPackageException(responseStringBuilder.toString());
                    }
                }
                offlineBillPackage.setOfflineBillPackageStatus(OfflineBillPackageStatus.PROCESS_COMPLETED);
                offlineBillPackage.setStatusCode(response.getCodigoEstado());
                offlineBillPackage.setDescriptionCode(response.getCodigoDescripcion());
                offlineBillPackage.setReceptionCode(response.getCodigoRecepcion());
                offlineBillPackage = this.offlineBillPackageService.save(offlineBillPackage);
                String subject = String.format("validateOfflineBillPackages: OK, branchOffice %d, posCode %d, envCode %d", offlineBillPackage.getBranchOffice(), offlineBillPackage.getPosCode(), this.eBillingAppConfig.getEnvironmentCode());
                String text = "OfflineBillPackage(" + "id=" + offlineBillPackage.getId() + ", " + "date=" + offlineBillPackage.getDate().getTime() + ", " + "description=" + offlineBillPackage.getDescriptionCode() + ", " + "receptionCode=" + offlineBillPackage.getReceptionCode() + ", " + "status=" + offlineBillPackage.getOfflineBillPackageStatus() + ")";
                this.emailService.sendSimpleMessage(this.eBillingAppConfig.getToEmail(), subject, text);
            }
            catch (Exception e) {
                offlineBillPackage.setOfflineBillPackageStatus(OfflineBillPackageStatus.AWAITING_VALIDATION);
                this.offlineBillPackageService.save(offlineBillPackage);
            }
        }
    }

    public RespuestaRecepcion validateOfflineBillPackage(ValidateOfflineBillPackageRequest request) {
        SolicitudValidacionRecepcion solicitudValidacionRecepcion = new ObjectFactory().createSolicitudValidacionRecepcion();
        solicitudValidacionRecepcion.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        solicitudValidacionRecepcion.setCodigoSistema("6D23688410B63B72FBD7EC6");
        solicitudValidacionRecepcion.setNit(EBillingAppConfig.NIT.longValue());
        solicitudValidacionRecepcion.setCodigoDocumentoSector(1);
        solicitudValidacionRecepcion.setCodigoEmision(2);
        solicitudValidacionRecepcion.setCodigoModalidad(1);
        solicitudValidacionRecepcion.setCuis(this.cuisService.getCuis(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudValidacionRecepcion.setCufd(this.cufdService.getCufd(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudValidacionRecepcion.setTipoFacturaDocumento(1);
        solicitudValidacionRecepcion.setCodigoSucursal(request.getCodigoSucursal().intValue());
        solicitudValidacionRecepcion.setCodigoPuntoVenta(request.getCodigoPuntoVenta());
        solicitudValidacionRecepcion.setCodigoRecepcion(request.getCodigoRecepcion());
        logger.debug("Invoking validacionRecepcionPaqueteFactura...");
        RespuestaRecepcion response = this.getPort().validacionRecepcionPaqueteFactura(solicitudValidacionRecepcion);
        logger.debug("validacionRecepcionPaqueteFactura.result=" + response);
        return response;
    }

    public RespuestaRecepcion createMassiveBills(CreateMassiveBillsRequest request) {
        SolicitudRecepcionMasiva solicitudRecepcionMasiva = new ObjectFactory().createSolicitudRecepcionMasiva();
        solicitudRecepcionMasiva.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        solicitudRecepcionMasiva.setCodigoPuntoVenta(request.getCodigoPuntoVenta());
        solicitudRecepcionMasiva.setCodigoSistema("6D23688410B63B72FBD7EC6");
        solicitudRecepcionMasiva.setCodigoSucursal(request.getCodigoSucursal().intValue());
        solicitudRecepcionMasiva.setNit(EBillingAppConfig.NIT.longValue());
        solicitudRecepcionMasiva.setCodigoDocumentoSector(1);
        solicitudRecepcionMasiva.setCodigoEmision(3);
        solicitudRecepcionMasiva.setCodigoModalidad(1);
        solicitudRecepcionMasiva.setCufd(this.cufdService.getCufd(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudRecepcionMasiva.setCuis(this.cuisService.getCuis(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudRecepcionMasiva.setTipoFacturaDocumento(1);
        solicitudRecepcionMasiva.setArchivo(null);
        solicitudRecepcionMasiva.setFechaEnvio(null);
        solicitudRecepcionMasiva.setHashArchivo(null);
        solicitudRecepcionMasiva.setCantidadFacturas(0);
        logger.debug("Invoking recepcionMasivaFactura...");
        RespuestaRecepcion response = this.getPort().recepcionMasivaFactura(solicitudRecepcionMasiva);
        logger.debug("recepcionMasivaFactura.result=" + response);
        return response;
    }

    public RespuestaRecepcion validateMassiveBillReceipt(ValidateMassiveBillReceiptRequest request) {
        SolicitudValidacionRecepcion solicitudValidacionRecepcion = new ObjectFactory().createSolicitudValidacionRecepcion();
        solicitudValidacionRecepcion.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        solicitudValidacionRecepcion.setCodigoPuntoVenta(request.getCodigoPuntoVenta());
        solicitudValidacionRecepcion.setCodigoSistema("6D23688410B63B72FBD7EC6");
        solicitudValidacionRecepcion.setCodigoSucursal(request.getCodigoSucursal().intValue());
        solicitudValidacionRecepcion.setNit(EBillingAppConfig.NIT.longValue());
        solicitudValidacionRecepcion.setCodigoDocumentoSector(1);
        solicitudValidacionRecepcion.setCodigoEmision(3);
        solicitudValidacionRecepcion.setCodigoModalidad(1);
        solicitudValidacionRecepcion.setCufd(this.cufdService.getCufd(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudValidacionRecepcion.setCuis(this.cuisService.getCuis(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudValidacionRecepcion.setTipoFacturaDocumento(1);
        solicitudValidacionRecepcion.setCodigoRecepcion(null);
        logger.debug("Invoking validacionRecepcionMasivaFactura...");
        RespuestaRecepcion response = this.getPort().validacionRecepcionMasivaFactura(solicitudValidacionRecepcion);
        logger.debug("validacionRecepcionMasivaFactura.result=" + response);
        return response;
    }

    public String billToXmlString(FacturaElectronicaCompraVenta bill) {
        String xml = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{FacturaElectronicaCompraVenta.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.fragment", (Object)false);
            marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)"facturaElectronicaCompraVenta.xsd");
            StringWriter out = new StringWriter();
            marshaller.marshal((Object)bill, (Writer)out);
            xml = out.toString();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return xml;
    }

    public FacturaElectronicaCompraVenta getBill(CreateBillRequest request, GregorianCalendar date, String address, String cufd, String cuf, String legend, String cafc) throws DatatypeConfigurationException {
        ninja.theteam.yubusin.ebilling.soap.model.ObjectFactory factory = new ninja.theteam.yubusin.ebilling.soap.model.ObjectFactory();
        FacturaElectronicaCompraVenta bill = factory.createFacturaElectronicaCompraVenta();
        FacturaElectronicaCompraVenta.Cabecera header = factory.createFacturaElectronicaCompraVentaCabecera();
        header.setNitEmisor(EBillingAppConfig.NIT.longValue());
        header.setRazonSocialEmisor("COOPERATIVA INTEGRAL DE SERVICIOS COCHABAMBA LTDA.");
        header.setMunicipio("Punata");
        header.setTelefono("4577003");
        header.setNumeroFactura((long)request.getNumeroFactura().intValue());
        header.setCuf(cuf);
        header.setCufd(cufd);
        header.setCodigoSucursal(request.getCodigoSucursal().intValue());
        header.setDireccion(address);
        header.setCodigoPuntoVenta(request.getCodigoPuntoVenta());
        header.setCafc(cafc);
        XMLGregorianCalendar emissionDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(date);
        emissionDate.setTimezone(Integer.MIN_VALUE);
        header.setFechaEmision(emissionDate);
        header.setCodigoExcepcion(request.getCodigoExcepcion());
        header.setNombreRazonSocial(request.getNombreRazonSocial());
        header.setCodigoTipoDocumentoIdentidad(request.getCodigoTipoDocumentoIdentidad().intValue());
        header.setNumeroDocumento(request.getNumeroDocumento());
        header.setComplemento(request.getComplemento());
        header.setCodigoCliente(request.getCodigoCliente());
        header.setCodigoMetodoPago(request.getCodigoMetodoPago().intValue());
        header.setUsuario(request.getUsuario());
        header.setCodigoDocumentoSector(request.getCodigoDocumentoSector());
        header.setCodigoMoneda(request.getCodigoMoneda().intValue());
        header.setTipoCambio(request.getTipoCambio());
        header.setMontoTotal(request.getMontoTotal());
        header.setMontoTotalSujetoIva(request.getMontoTotalSujetoIva());
        header.setMontoTotalMoneda(request.getMontoTotalMoneda());
        header.setDescuentoAdicional(request.getDescuentoAdicional());
        header.setLeyenda(this.normalizeString(legend));
        bill.setCabecera(header);
        for (CreateBillRequestDetail detail : request.getDetalle()) {
            FacturaElectronicaCompraVenta.Detalle detalle = factory.createFacturaElectronicaCompraVentaDetalle();
            detalle.setActividadEconomica(detail.getActividadEconomica());
            detalle.setCodigoProductoSin(detail.getCodigoProductoSin().intValue());
            detalle.setCodigoProducto(detail.getCodigoProducto());
            detalle.setUnidadMedida(detail.getUnidadMedida().intValue());
            detalle.setDescripcion(detail.getDescripcion());
            detalle.setCantidad(detail.getCantidad());
            detalle.setPrecioUnitario(detail.getPrecioUnitario());
            detalle.setMontoDescuento(detail.getMontoDescuento());
            detalle.setSubTotal(detail.getSubTotal());
            bill.getDetalle().add(detalle);
        }
        return bill;
    }

    private SolicitudRecepcionFactura buildCreateBillRequest(CreateBillRequest request, CreateBillResponse response, boolean isOfflineMode, Optional<OfflineEvent> offlineEventOpt) throws DatatypeConfigurationException, GeneralSecurityException, IOException, ParserConfigurationException, XMLSecurityException, SAXException {
        RespuestaCuis respuestaCuis = this.cuisService.getCuis(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
        RespuestaCufd respuestaCufd = isOfflineMode ? this.cufdService.getCufd(offlineEventOpt.get().getCufd()) : this.cufdService.getCufd(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
        GregorianCalendar date = Util.getNewGregorianCalendar();
        String legend = this.randomLegendService.getRandomLegend(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
        int emissionCode = isOfflineMode ? 2 : 1;
        String cuf = this.cufService.getCuf(EBillingAppConfig.NIT, date, request.getCodigoSucursal(), Integer.valueOf(1), Integer.valueOf(emissionCode), Integer.valueOf(1), Integer.valueOf(1), request.getNumeroFactura(), request.getCodigoPuntoVenta(), respuestaCufd.getCodigoControl());
        FacturaElectronicaCompraVenta bill = this.getBill(request, date, respuestaCufd.getDireccion(), respuestaCufd.getCodigo(), cuf, legend, isOfflineMode ? offlineEventOpt.get().getCafc() : null);
        String signedBill = this.getSignedBill(bill);
        byte[] compressedBill = this.gZipService.compress(signedBill.getBytes(StandardCharsets.UTF_8));
        String hash = this.hashService.sha256Hash(compressedBill);
        SolicitudRecepcionFactura solicitudRecepcionFactura = new ObjectFactory().createSolicitudRecepcionFactura();
        solicitudRecepcionFactura.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        solicitudRecepcionFactura.setCodigoSistema("6D23688410B63B72FBD7EC6");
        solicitudRecepcionFactura.setNit(EBillingAppConfig.NIT.longValue());
        solicitudRecepcionFactura.setCodigoModalidad(1);
        solicitudRecepcionFactura.setCodigoEmision(emissionCode);
        solicitudRecepcionFactura.setCodigoDocumentoSector(1);
        solicitudRecepcionFactura.setTipoFacturaDocumento(1);
        solicitudRecepcionFactura.setCodigoSucursal(request.getCodigoSucursal().intValue());
        solicitudRecepcionFactura.setCodigoPuntoVenta(request.getCodigoPuntoVenta());
        solicitudRecepcionFactura.setCuis(respuestaCuis.getCodigo());
        solicitudRecepcionFactura.setCufd(respuestaCufd.getCodigo());
        solicitudRecepcionFactura.setArchivo(compressedBill);
        solicitudRecepcionFactura.setHashArchivo(hash);
        XMLGregorianCalendar sendDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(date);
        sendDate.setTimezone(Integer.MIN_VALUE);
        solicitudRecepcionFactura.setFechaEnvio(sendDate.toString());
        System.out.println(signedBill);
        logger.debug(signedBill);
        response.setNumeroFactura(Long.valueOf(bill.getCabecera().getNumeroFactura()));
        response.setCuf(bill.getCabecera().getCuf());
        response.setDireccion(bill.getCabecera().getDireccion());
        response.setFecha(Long.valueOf(date.getTimeInMillis()));
        response.setLeyenda(legend);
        response.setHash(hash);
        response.setFactura(Base64.encodeBase64String((byte[])signedBill.getBytes(StandardCharsets.UTF_8)));
        return solicitudRecepcionFactura;
    }

    private String getSignedBill(FacturaElectronicaCompraVenta bill) throws GeneralSecurityException, IOException, ParserConfigurationException, XMLSecurityException, SAXException {
        String xml = this.billToXmlString(bill);
        xml = xml.replace("xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\" ", "");
        byte[] data = xml.getBytes(StandardCharsets.UTF_8);
        PrivateKey privateKey = this.signerService.getPrivateKey2();
        X509Certificate certificate = this.signerService.getCertificate();
        byte[] sinedXML = this.signerService.sign(data, privateKey, new X509Certificate[]{certificate});
        String signedXmlString = new String(sinedXML);
        signedXmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n" + signedXmlString;
        return signedXmlString;
    }

    private String normalizeString(String inputStr) {
        String normalize = Normalizer.normalize(inputStr, Normalizer.Form.NFKD);
        String regex = "[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+";
        return new String(normalize.replaceAll(regex, "").getBytes(StandardCharsets.US_ASCII), StandardCharsets.US_ASCII);
    }

    private ServicioFacturacion getPort() {
        URL wsdlURL = ServicioFacturacion_Service.WSDL_LOCATION;
        ServicioFacturacion_Service ss = new ServicioFacturacion_Service(wsdlURL, SERVICE_NAME);
        ServicioFacturacion port = ss.getServicioFacturacionPort();
        Map req_ctx = ((BindingProvider)port).getRequestContext();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("apikey", Collections.singletonList("TokenApi " + this.eBillingAppConfig.getToken()));
        req_ctx.put("javax.xml.ws.http.request.headers", headers);
        return port;
    }
}

