/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.billing.service;

import java.util.GregorianCalendar;
import java.util.Optional;
import javax.xml.datatype.DatatypeConfigurationException;
import ninja.theteam.yubusin.ebilling.billing.dto.QueryOnlineOfflineModeRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.QueryOnlineOfflineModeResponse;
import ninja.theteam.yubusin.ebilling.billing.dto.SetOfflineModeRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.SetOfflineModeResponse;
import ninja.theteam.yubusin.ebilling.billing.dto.SetOnlineModeRequest;
import ninja.theteam.yubusin.ebilling.billing.dto.SetOnlineModeResponse;
import ninja.theteam.yubusin.ebilling.billing.model.OfflineEvent;
import ninja.theteam.yubusin.ebilling.billing.model.OfflineEventStatus;
import ninja.theteam.yubusin.ebilling.billing.service.BillingService;
import ninja.theteam.yubusin.ebilling.billing.service.OfflineEventService;
import ninja.theteam.yubusin.ebilling.codes.service.CufdService;
import ninja.theteam.yubusin.ebilling.common.exception.InvalidParameterException;
import ninja.theteam.yubusin.ebilling.common.exception.OfflineModeException;
import ninja.theteam.yubusin.ebilling.common.exception.SignificantEventException;
import ninja.theteam.yubusin.ebilling.common.model.Util;
import ninja.theteam.yubusin.ebilling.config.EBillingAppConfig;
import ninja.theteam.yubusin.ebilling.email.service.EmailService;
import ninja.theteam.yubusin.ebilling.operations.dto.RegisterSignificantEventRequest;
import ninja.theteam.yubusin.ebilling.operations.service.BillingOperationsService;
import ninja.theteam.yubusin.ebilling.soap.operations.EventosSignificativosDto;
import ninja.theteam.yubusin.ebilling.soap.operations.MensajeServicio;
import ninja.theteam.yubusin.ebilling.soap.operations.RespuestaListaEventos;
import ninja.theteam.yubusin.ebilling.soap.synchronization.ParametricasDto;
import ninja.theteam.yubusin.ebilling.soap.synchronization.RespuestaListaParametricas;
import ninja.theteam.yubusin.ebilling.synchronization.service.SyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OfflineBillingService {
    private static final Logger logger = LoggerFactory.getLogger(OfflineBillingService.class);
    private final EBillingAppConfig eBillingAppConfig;
    private final OfflineEventService offlineEventService;
    private final CufdService cufdService;
    private final SyncService syncService;
    private final BillingService billingService;
    private final BillingOperationsService billingOperationsService;
    private final EmailService emailService;

    public OfflineBillingService(EBillingAppConfig eBillingAppConfig, OfflineEventService offlineEventService, CufdService cufdService, SyncService syncService, BillingService billingService, BillingOperationsService billingOperationsService, EmailService emailService) {
        this.eBillingAppConfig = eBillingAppConfig;
        this.offlineEventService = offlineEventService;
        this.cufdService = cufdService;
        this.syncService = syncService;
        this.billingService = billingService;
        this.billingOperationsService = billingOperationsService;
        this.emailService = emailService;
    }

    public SetOfflineModeResponse setOfflineMode(SetOfflineModeRequest request) {
        if (this.offlineEventService.isOfflineMode(request.getCodigoSucursal(), request.getCodigoPuntoVenta())) {
            throw new OfflineModeException("The offline mode is already active.");
        }
        boolean validEventCode = false;
        String description = null;
        RespuestaListaParametricas listaParametricas = this.syncService.syncSignificantEvents(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
        for (ParametricasDto parametricasDto : listaParametricas.getListaCodigos()) {
            if (parametricasDto.getCodigoClasificador() != request.getEventCode()) continue;
            validEventCode = true;
            description = parametricasDto.getDescripcion();
            break;
        }
        if (!validEventCode) {
            throw new InvalidParameterException("Event code is not valid.");
        }
        OfflineEvent offlineEvent = new OfflineEvent();
        offlineEvent.setOfflineEventStatus(OfflineEventStatus.EVENT_STARTED);
        offlineEvent.setBranchOffice(request.getCodigoSucursal());
        offlineEvent.setPosCode(request.getCodigoPuntoVenta());
        offlineEvent.setEventCode(request.getEventCode());
        offlineEvent.setStartDate(Util.getNewGregorianCalendar().getTime());
        offlineEvent.setCufd(this.cufdService.getCufd(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        offlineEvent.setCafc(request.getCafc());
        offlineEvent.setDescription(description);
        offlineEvent = this.offlineEventService.save(offlineEvent);
        SetOfflineModeResponse response = new SetOfflineModeResponse();
        response.setIsOnline(Boolean.valueOf(false));
        response.setStartDate(Long.valueOf(offlineEvent.getStartDate().getTime()));
        response.setEventCode(offlineEvent.getEventCode());
        response.setDescription(offlineEvent.getDescription());
        String subject = String.format("setOfflineMode: OK, branchOffice %d, posCode %d, envCode %d", offlineEvent.getBranchOffice(), offlineEvent.getPosCode(), this.eBillingAppConfig.getEnvironmentCode());
        this.emailService.sendSimpleMessage(this.eBillingAppConfig.getToEmail(), subject, response.toString());
        return response;
    }

    public SetOnlineModeResponse setOnlineMode(SetOnlineModeRequest request) {
        Optional offlineEventServiceOpt = this.offlineEventService.getActiveOfflineEvent(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
        if (!offlineEventServiceOpt.isPresent()) {
            throw new OfflineModeException("The offline mode is not active.");
        }
        OfflineEvent offlineEvent = (OfflineEvent)offlineEventServiceOpt.get();
        try {
            GregorianCalendar startEvent = Util.getNewGregorianCalendar();
            GregorianCalendar endEvent = Util.getNewGregorianCalendar();
            startEvent.setTime(offlineEvent.getStartDate());
            RegisterSignificantEventRequest registerSignificantEventRequest = new RegisterSignificantEventRequest();
            registerSignificantEventRequest.setCodigoSucursal(offlineEvent.getBranchOffice());
            registerSignificantEventRequest.setCodigoPuntoVenta(offlineEvent.getPosCode());
            registerSignificantEventRequest.setCufd(offlineEvent.getCufd());
            registerSignificantEventRequest.setEventCode(offlineEvent.getEventCode());
            registerSignificantEventRequest.setDescription(offlineEvent.getDescription());
            registerSignificantEventRequest.setStartEvent(startEvent);
            registerSignificantEventRequest.setEndEvent(endEvent);
            RespuestaListaEventos respuestaListaEventos = this.billingOperationsService.registerSignificantEvent(registerSignificantEventRequest);
            if (!respuestaListaEventos.isTransaccion().booleanValue()) {
                StringBuilder responseStringBuilder = new StringBuilder();
                responseStringBuilder.append("codigoRecepcionEventoSignificativo: ").append(respuestaListaEventos.getCodigoRecepcionEventoSignificativo()).append("\n");
                for (MensajeServicio mensajeServicio : respuestaListaEventos.getMensajesList()) {
                    responseStringBuilder.append("C\u00f3digo: ").append(mensajeServicio.getCodigo()).append("\n").append("Descripci\u00f3n: ").append(mensajeServicio.getDescripcion()).append("\n\n");
                }
                for (EventosSignificativosDto eventosSignificativosDto : respuestaListaEventos.getListaCodigos()) {
                    responseStringBuilder.append("codigoEvento: ").append(eventosSignificativosDto.getCodigoEvento()).append("\n").append("codigoRecepcionEventoSignificativo: ").append(eventosSignificativosDto.getCodigoRecepcionEventoSignificativo()).append("\n").append("descripcion: ").append(eventosSignificativosDto.getDescripcion()).append("\n").append("fechaInicio: ").append(eventosSignificativosDto.getFechaInicio()).append("\n").append("fechaFin: ").append(eventosSignificativosDto.getFechaFin()).append("\n\n");
                }
                String subject = String.format("setOnlineMode: ERROR, branchOffice %d, posCode %d, envCode %d", offlineEvent.getBranchOffice(), offlineEvent.getPosCode(), this.eBillingAppConfig.getEnvironmentCode());
                this.emailService.sendSimpleMessage(this.eBillingAppConfig.getToEmail(), subject, responseStringBuilder.toString());
                logger.error(responseStringBuilder.toString());
                throw new SignificantEventException(responseStringBuilder.toString());
            }
            offlineEvent.setOfflineEventStatus(OfflineEventStatus.EVENT_FINISHED);
            offlineEvent.setEndDate(endEvent.getTime());
            offlineEvent.setReceptionCode(respuestaListaEventos.getCodigoRecepcionEventoSignificativo());
            offlineEvent = this.offlineEventService.save(offlineEvent);
            SetOnlineModeResponse response = new SetOnlineModeResponse();
            response.setIsOnline(Boolean.valueOf(true));
            response.setStartDate(Long.valueOf(offlineEvent.getStartDate().getTime()));
            response.setEndDate(Long.valueOf(offlineEvent.getEndDate().getTime()));
            response.setEventCode(offlineEvent.getEventCode());
            response.setDescription(offlineEvent.getDescription());
            response.setOfflineEventReceptionCode(offlineEvent.getReceptionCode());
            response.setOfflineBillsCount(Integer.valueOf(offlineEvent.getBills().size()));
            String subject = String.format("setOnlineMode: OK, branchOffice %d, posCode %d, envCode %d", offlineEvent.getBranchOffice(), offlineEvent.getPosCode(), this.eBillingAppConfig.getEnvironmentCode());
            this.emailService.sendSimpleMessage(this.eBillingAppConfig.getToEmail(), subject, response.toString());
            return response;
        }
        catch (DatatypeConfigurationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SignificantEventException(e.getMessage(), (Throwable)e);
        }
    }

    public QueryOnlineOfflineModeResponse queryOnlineOfflineMode(QueryOnlineOfflineModeRequest request) {
        Optional offlineEventServiceOpt = this.offlineEventService.getActiveOfflineEvent(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
        QueryOnlineOfflineModeResponse response = new QueryOnlineOfflineModeResponse();
        if (offlineEventServiceOpt.isPresent()) {
            response.setIsOnline(Boolean.valueOf(false));
            response.setEventCode(((OfflineEvent)offlineEventServiceOpt.get()).getEventCode());
            response.setStartDate(Long.valueOf(((OfflineEvent)offlineEventServiceOpt.get()).getStartDate().getTime()));
            response.setDescription(((OfflineEvent)offlineEventServiceOpt.get()).getDescription());
            response.setOfflineBills(Integer.valueOf(((OfflineEvent)offlineEventServiceOpt.get()).getBills().size()));
        } else {
            response.setIsOnline(Boolean.valueOf(true));
        }
        return response;
    }
}

