/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.billing.service;

import java.util.List;
import java.util.Optional;
import ninja.theteam.yubusin.ebilling.billing.model.OfflineEvent;
import ninja.theteam.yubusin.ebilling.billing.model.OfflineEventStatus;
import ninja.theteam.yubusin.ebilling.billing.repository.OfflineEventRepository;
import org.springframework.stereotype.Service;

@Service
public class OfflineEventService {
    private OfflineEventRepository offlineEventRepository;

    public OfflineEventService(OfflineEventRepository offlineEventRepository) {
        this.offlineEventRepository = offlineEventRepository;
    }

    public boolean isOfflineMode(Integer branchOffice, Integer posCode) {
        return this.offlineEventRepository.existsOfflineEventByBranchOfficeEqualsAndPosCodeEqualsAndEndDateIsNull(branchOffice, posCode);
    }

    public Optional<OfflineEvent> getActiveOfflineEvent(Integer branchOffice, Integer posCode) {
        return this.offlineEventRepository.getOfflineEventByBranchOfficeEqualsAndPosCodeEqualsAndEndDateIsNull(branchOffice, posCode);
    }

    public OfflineEvent save(OfflineEvent offlineEvent) {
        return (OfflineEvent)this.offlineEventRepository.save((Object)offlineEvent);
    }

    public List<OfflineEvent> getFinishedOfflineEvents() {
        return this.offlineEventRepository.getAllByOfflineEventStatusEquals(OfflineEventStatus.EVENT_FINISHED);
    }
}

