/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.codes.service;

import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import ninja.theteam.yubusin.ebilling.codes.model.Cufd;
import ninja.theteam.yubusin.ebilling.codes.repository.CufdRepository;
import ninja.theteam.yubusin.ebilling.codes.service.CuisService;
import ninja.theteam.yubusin.ebilling.common.exception.SiatNotRespondingException;
import ninja.theteam.yubusin.ebilling.common.model.Util;
import ninja.theteam.yubusin.ebilling.config.EBillingAppConfig;
import ninja.theteam.yubusin.ebilling.soap.codes.ObjectFactory;
import ninja.theteam.yubusin.ebilling.soap.codes.RespuestaCufd;
import ninja.theteam.yubusin.ebilling.soap.codes.RespuestaCuis;
import ninja.theteam.yubusin.ebilling.soap.codes.ServicioFacturacionCodigos;
import ninja.theteam.yubusin.ebilling.soap.codes.ServicioFacturacionCodigos_Service;
import ninja.theteam.yubusin.ebilling.soap.codes.SolicitudCufd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CufdService {
    private static final Logger logger = LoggerFactory.getLogger(CufdService.class);
    private static final QName SERVICE_NAME = new QName("https://siat.impuestos.gob.bo/FacturacionCodigos", "ServicioFacturacionCodigos");
    private EBillingAppConfig eBillingAppConfig;
    private CuisService cuisService;
    private CufdRepository cufdRepository;

    public CufdService(EBillingAppConfig eBillingAppConfig, CuisService cuisService, CufdRepository cufdRepository) {
        this.eBillingAppConfig = eBillingAppConfig;
        this.cuisService = cuisService;
        this.cufdRepository = cufdRepository;
    }

    public RespuestaCufd getCufd(Integer branchOffice, Integer posCode) {
        return this.getCufd(branchOffice, posCode, false);
    }

    public RespuestaCufd getCufd(Integer branchOffice, Integer posCode, boolean forceRefresh) {
        RespuestaCufd response;
        logger.debug("Invoking solicitudCufd...");
        if (forceRefresh) {
            response = this.getCufdFromSiat(branchOffice, posCode, null);
        } else {
            AtomicBoolean isExpiredCache = new AtomicBoolean(false);
            response = this.getCufdFromCache(branchOffice, posCode, isExpiredCache);
            if (response == null || isExpiredCache.get()) {
                response = this.getCufdFromSiat(branchOffice, posCode, response);
            }
        }
        return response;
    }

    private RespuestaCufd getCufdFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.cufdRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            Cufd cufd = this.cufdRepository.getCufdByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaCufd response = new ObjectFactory().createRespuestaCufd();
            isExpiredCache.set(cufd.isExpired());
            response.setTransaccion(Boolean.valueOf(false));
            response.setCodigo(cufd.getCode());
            response.setCodigoControl(cufd.getControlCode());
            response.setDireccion(cufd.getAddress());
            response.setFechaVigencia(Util.convert((Date)cufd.getExpirationDate()));
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaCufd getCufdFromSiat(Integer branchOffice, Integer posCode, RespuestaCufd expiredResponse) {
        try {
            SolicitudCufd request = this.buildCufdRequest(branchOffice, posCode);
            RespuestaCufd response = this.getRespuestaCufd(request);
            Cufd cufd = new Cufd();
            cufd.setCode(response.getCodigo());
            cufd.setControlCode(response.getCodigoControl());
            cufd.setAddress(response.getDireccion());
            cufd.setExpirationDate(Util.convert((XMLGregorianCalendar)response.getFechaVigencia()));
            cufd.setBranchOffice(branchOffice);
            cufd.setPosCode(posCode);
            this.cufdRepository.save((Object)cufd);
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    private RespuestaCufd getRespuestaCufd(SolicitudCufd request) {
        URL wsdlURL = ServicioFacturacionCodigos_Service.WSDL_LOCATION;
        ServicioFacturacionCodigos_Service ss = new ServicioFacturacionCodigos_Service(wsdlURL, SERVICE_NAME);
        ServicioFacturacionCodigos port = ss.getServicioFacturacionCodigosPort();
        Map req_ctx = ((BindingProvider)port).getRequestContext();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("apikey", Collections.singletonList("TokenApi " + this.eBillingAppConfig.getToken()));
        req_ctx.put("javax.xml.ws.http.request.headers", headers);
        RespuestaCufd response = port.cufd(request);
        return response;
    }

    private SolicitudCufd buildCufdRequest(Integer branchOffice, Integer posCode) {
        RespuestaCuis respuestaCuis = this.cuisService.getCuis(branchOffice, posCode);
        ObjectFactory factory = new ObjectFactory();
        SolicitudCufd request = factory.createSolicitudCufd();
        request.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        request.setCodigoSistema("6D23688410B63B72FBD7EC6");
        request.setNit(EBillingAppConfig.NIT.longValue());
        request.setCodigoModalidad(1);
        request.setCuis(respuestaCuis.getCodigo());
        request.setCodigoSucursal(branchOffice.intValue());
        request.setCodigoPuntoVenta(factory.createSolicitudCuisCodigoPuntoVenta(posCode));
        return request;
    }

    public RespuestaCufd getCufd(String cufdCode) {
        Cufd cufd = this.cufdRepository.getCufdByCodeEquals(cufdCode);
        RespuestaCufd respuestaCufd = new ObjectFactory().createRespuestaCufd();
        respuestaCufd.setTransaccion(Boolean.valueOf(false));
        respuestaCufd.setCodigo(cufd.getCode());
        respuestaCufd.setCodigoControl(cufd.getControlCode());
        respuestaCufd.setDireccion(cufd.getAddress());
        respuestaCufd.setFechaVigencia(Util.convert((Date)cufd.getExpirationDate()));
        return respuestaCufd;
    }
}

