/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.codes.service;

import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import ninja.theteam.yubusin.ebilling.codes.model.Cuis;
import ninja.theteam.yubusin.ebilling.codes.repository.CuisRepository;
import ninja.theteam.yubusin.ebilling.common.model.Util;
import ninja.theteam.yubusin.ebilling.config.EBillingAppConfig;
import ninja.theteam.yubusin.ebilling.soap.codes.ObjectFactory;
import ninja.theteam.yubusin.ebilling.soap.codes.RespuestaCuis;
import ninja.theteam.yubusin.ebilling.soap.codes.ServicioFacturacionCodigos;
import ninja.theteam.yubusin.ebilling.soap.codes.ServicioFacturacionCodigos_Service;
import ninja.theteam.yubusin.ebilling.soap.codes.SolicitudCuis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CuisService {
    private static final Logger logger = LoggerFactory.getLogger(CuisService.class);
    private static final QName SERVICE_NAME = new QName("https://siat.impuestos.gob.bo/FacturacionCodigos", "ServicioFacturacionCodigos");
    private EBillingAppConfig eBillingAppConfig;
    private CuisRepository cuisRepository;

    public CuisService(EBillingAppConfig eBillingAppConfig, CuisRepository cuisRepository) {
        this.eBillingAppConfig = eBillingAppConfig;
        this.cuisRepository = cuisRepository;
    }

    public RespuestaCuis getCuis(Integer branchOffice, Integer posCode) {
        RespuestaCuis respuestaCuis;
        Date now = new Date();
        Optional optCuis = this.cuisRepository.getCuisByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateAfter(branchOffice, posCode, now);
        if (optCuis.isPresent()) {
            respuestaCuis = new ObjectFactory().createRespuestaCuis();
            respuestaCuis.setTransaccion(Boolean.valueOf(false));
            respuestaCuis.setCodigo(((Cuis)optCuis.get()).getCode());
            respuestaCuis.setFechaVigencia(Util.convert((Date)((Cuis)optCuis.get()).getExpirationDate()));
        } else {
            SolicitudCuis request = this.buildCuisRequest(branchOffice, posCode);
            respuestaCuis = this.getCuis(request);
            Cuis cuis = new Cuis();
            cuis.setCode(respuestaCuis.getCodigo());
            cuis.setExpirationDate(Util.convert((XMLGregorianCalendar)respuestaCuis.getFechaVigencia()));
            cuis.setBranchOffice(branchOffice);
            cuis.setPosCode(posCode);
            this.cuisRepository.save((Object)cuis);
        }
        return respuestaCuis;
    }

    private RespuestaCuis getCuis(SolicitudCuis request) {
        URL wsdlURL = ServicioFacturacionCodigos_Service.WSDL_LOCATION;
        ServicioFacturacionCodigos_Service ss = new ServicioFacturacionCodigos_Service(wsdlURL, SERVICE_NAME);
        ServicioFacturacionCodigos port = ss.getServicioFacturacionCodigosPort();
        Map req_ctx = ((BindingProvider)port).getRequestContext();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("apikey", Collections.singletonList("TokenApi " + this.eBillingAppConfig.getToken()));
        req_ctx.put("javax.xml.ws.http.request.headers", headers);
        logger.debug("Invoking solicitudCuis...");
        RespuestaCuis response = port.cuis(request);
        logger.debug("solicitudCuis.result=" + response.isTransaccion());
        return response;
    }

    private SolicitudCuis buildCuisRequest(Integer branchOffice, Integer posCode) {
        ObjectFactory factory = new ObjectFactory();
        SolicitudCuis request = new ObjectFactory().createSolicitudCuis();
        request.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        request.setCodigoSistema("6D23688410B63B72FBD7EC6");
        request.setNit(EBillingAppConfig.NIT.longValue());
        request.setCodigoModalidad(1);
        request.setCodigoSucursal(branchOffice.intValue());
        request.setCodigoPuntoVenta(factory.createSolicitudCuisCodigoPuntoVenta(posCode));
        return request;
    }
}

