/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.codes.service;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import ninja.theteam.yubusin.ebilling.codes.dto.NitVerificationRequest;
import ninja.theteam.yubusin.ebilling.codes.dto.NitVerificationResponse;
import ninja.theteam.yubusin.ebilling.codes.service.CuisService;
import ninja.theteam.yubusin.ebilling.config.EBillingAppConfig;
import ninja.theteam.yubusin.ebilling.soap.codes.MensajeServicio;
import ninja.theteam.yubusin.ebilling.soap.codes.ObjectFactory;
import ninja.theteam.yubusin.ebilling.soap.codes.RespuestaCuis;
import ninja.theteam.yubusin.ebilling.soap.codes.RespuestaVerificarNit;
import ninja.theteam.yubusin.ebilling.soap.codes.ServicioFacturacionCodigos;
import ninja.theteam.yubusin.ebilling.soap.codes.ServicioFacturacionCodigos_Service;
import ninja.theteam.yubusin.ebilling.soap.codes.SolicitudVerificarNit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NitVerificationService {
    private CuisService cuisService;
    private static final Logger logger = LoggerFactory.getLogger(NitVerificationService.class);
    private static final QName SERVICE_NAME = new QName("https://siat.impuestos.gob.bo/FacturacionCodigos", "ServicioFacturacionCodigos");
    private final EBillingAppConfig eBillingAppConfig;

    public NitVerificationService(EBillingAppConfig eBillingAppConfig, CuisService cuisService) {
        this.eBillingAppConfig = eBillingAppConfig;
        this.cuisService = cuisService;
    }

    public RespuestaVerificarNit validateNit(NitVerificationRequest request, NitVerificationResponse response) {
        RespuestaCuis respuestaCuis = this.cuisService.getCuis(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
        ObjectFactory factory = new ObjectFactory();
        SolicitudVerificarNit solicitudVerificarNit = factory.createSolicitudVerificarNit();
        solicitudVerificarNit.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        solicitudVerificarNit.setCodigoModalidad(1);
        solicitudVerificarNit.setCodigoSistema("6D23688410B63B72FBD7EC6");
        solicitudVerificarNit.setCodigoSucursal(request.getCodigoSucursal().intValue());
        solicitudVerificarNit.setCuis(respuestaCuis.getCodigo());
        solicitudVerificarNit.setNit(EBillingAppConfig.NIT.longValue());
        solicitudVerificarNit.setNitParaVerificacion(request.getNitParaVerificacion().longValue());
        logger.debug("Invoking verificarNit...");
        RespuestaVerificarNit respuestaVerificarNit = this.getPort().verificarNit(solicitudVerificarNit);
        logger.debug("verificarNit.result=" + respuestaVerificarNit.isTransaccion());
        for (MensajeServicio mensajeServicio : respuestaVerificarNit.getMensajesList()) {
            response.setCode(mensajeServicio.getCodigo());
            response.setMensaje(mensajeServicio.getDescripcion());
        }
        response.setNitParaVerificacion(request.getNitParaVerificacion());
        return respuestaVerificarNit;
    }

    private ServicioFacturacionCodigos getPort() {
        URL wsdlURL = ServicioFacturacionCodigos_Service.WSDL_LOCATION;
        ServicioFacturacionCodigos_Service ss = new ServicioFacturacionCodigos_Service(wsdlURL, SERVICE_NAME);
        ServicioFacturacionCodigos port = ss.getServicioFacturacionCodigosPort();
        Map req_ctx = ((BindingProvider)port).getRequestContext();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("apikey", Collections.singletonList("TokenApi " + this.eBillingAppConfig.getToken()));
        req_ctx.put("javax.xml.ws.http.request.headers", headers);
        return port;
    }
}

