/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.common.exception;

import ninja.theteam.yubusin.ebilling.common.exception.ApiError;
import ninja.theteam.yubusin.ebilling.common.exception.InvalidParameterException;
import ninja.theteam.yubusin.ebilling.common.exception.OfflineModeException;
import ninja.theteam.yubusin.ebilling.common.exception.SiatNotRespondingException;
import ninja.theteam.yubusin.ebilling.common.exception.SignificantEventException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@Order(value=-2147483648)
@ControllerAdvice
public class RestExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(RestExceptionHandler.class);

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        String error = "Malformed JSON request";
        return this.buildResponseEntity(new ApiError(HttpStatus.BAD_REQUEST, (Throwable)ex, error));
    }

    private ResponseEntity<Object> buildResponseEntity(ApiError apiError) {
        return new ResponseEntity((Object)apiError, apiError.getStatus());
    }

    @ExceptionHandler(value={SiatNotRespondingException.class})
    protected ResponseEntity<Object> handleException(SiatNotRespondingException ex) {
        ApiError apiError = new ApiError(HttpStatus.SERVICE_UNAVAILABLE, (Throwable)ex, ex.getMessage());
        return this.buildResponseEntity(apiError);
    }

    @ExceptionHandler(value={OfflineModeException.class})
    protected ResponseEntity<Object> handleException(OfflineModeException ex) {
        ApiError apiError = new ApiError(HttpStatus.PRECONDITION_REQUIRED, (Throwable)ex, ex.getMessage());
        return this.buildResponseEntity(apiError);
    }

    @ExceptionHandler(value={SignificantEventException.class})
    protected ResponseEntity<Object> handleException(SignificantEventException ex) {
        ApiError apiError = new ApiError(HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)ex, ex.getMessage());
        return this.buildResponseEntity(apiError);
    }

    @ExceptionHandler(value={InvalidParameterException.class})
    protected ResponseEntity<Object> handleException(InvalidParameterException ex) {
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST, (Throwable)ex, ex.getMessage());
        return this.buildResponseEntity(apiError);
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleException(Exception ex) {
        logger.error(ex.getMessage(), (Throwable)ex);
        ApiError apiError = new ApiError(HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)ex, ex.getMessage());
        return this.buildResponseEntity(apiError);
    }
}

