/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.config;

import java.util.Properties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.PropertySource;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@ComponentScan(basePackages={"ninja.theteam.yubusin.ebilling.email"})
@PropertySource(value={"classpath:application.properties"})
public class EmailConfiguration {
    @Value(value="${spring.mail.host}")
    private String mailServerHost;
    @Value(value="${spring.mail.port}")
    private Integer mailServerPort;
    @Value(value="${spring.mail.username}")
    private String mailServerUsername;
    @Value(value="${spring.mail.password}")
    private String mailServerPassword;
    @Value(value="${spring.mail.properties.mail.smtp.auth}")
    private String mailServerAuth;
    @Value(value="${spring.mail.properties.mail.smtp.starttls.enable}")
    private String mailServerStartTls;

    @Bean
    public JavaMailSender getJavaMailSender() {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(this.mailServerHost);
        mailSender.setPort(this.mailServerPort.intValue());
        mailSender.setUsername(this.mailServerUsername);
        mailSender.setPassword(this.mailServerPassword);
        Properties props = mailSender.getJavaMailProperties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.auth", this.mailServerAuth);
        props.put("mail.smtp.starttls.enable", this.mailServerStartTls);
        props.put("mail.debug", "true");
        return mailSender;
    }

    @Bean
    public SimpleMailMessage templateSimpleMessage() {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setText("This is the test email template for your email:\n%s\n");
        return message;
    }
}

