/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.email.service;

import java.util.List;
import ninja.theteam.yubusin.ebilling.config.EBillingAppConfig;
import ninja.theteam.yubusin.ebilling.email.service.EmailService;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service(value="EmailService")
public class EmailServiceImpl
implements EmailService {
    private final EBillingAppConfig eBillingAppConfig;
    private final JavaMailSender emailSender;

    public EmailServiceImpl(EBillingAppConfig eBillingAppConfig, JavaMailSender emailSender) {
        this.eBillingAppConfig = eBillingAppConfig;
        this.emailSender = emailSender;
    }

    public void sendSimpleMessage(List<String> to, String subject, String text) {
        try {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setFrom(this.eBillingAppConfig.getFromEmail());
            message.setTo(to.toArray(new String[0]));
            message.setSubject(subject);
            message.setText(text);
            this.emailSender.send(message);
        }
        catch (MailException exception) {
            exception.printStackTrace();
        }
    }
}

