/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.operations.controller;

import javax.xml.datatype.DatatypeConfigurationException;
import ninja.theteam.yubusin.ebilling.operations.dto.ClosePosRequest;
import ninja.theteam.yubusin.ebilling.operations.dto.QueryPosRequest;
import ninja.theteam.yubusin.ebilling.operations.dto.QuerySignificantEventsRequest;
import ninja.theteam.yubusin.ebilling.operations.dto.RegisterCommissionPosRequest;
import ninja.theteam.yubusin.ebilling.operations.dto.RegisterPosRequest;
import ninja.theteam.yubusin.ebilling.operations.service.BillingOperationsService;
import ninja.theteam.yubusin.ebilling.soap.operations.RespuestaCierrePuntoVenta;
import ninja.theteam.yubusin.ebilling.soap.operations.RespuestaComunicacion;
import ninja.theteam.yubusin.ebilling.soap.operations.RespuestaConsultaPuntoVenta;
import ninja.theteam.yubusin.ebilling.soap.operations.RespuestaListaEventos;
import ninja.theteam.yubusin.ebilling.soap.operations.RespuestaPuntoVentaComisionista;
import ninja.theteam.yubusin.ebilling.soap.operations.RespuestaRegistroPuntoVenta;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/billing-operations"})
public class BillingOperationsController {
    private BillingOperationsService billingOperationsService;

    public BillingOperationsController(BillingOperationsService billingOperationsService) {
        this.billingOperationsService = billingOperationsService;
    }

    @GetMapping(value={"/ping"})
    public RespuestaComunicacion ping() {
        return this.billingOperationsService.ping();
    }

    @PostMapping(value={"/query-pos"})
    public RespuestaConsultaPuntoVenta queryPos(@RequestBody QueryPosRequest request) {
        return this.billingOperationsService.queryPos(request);
    }

    @PostMapping(value={"/register-pos"})
    public RespuestaRegistroPuntoVenta registerPos(@RequestBody RegisterPosRequest request) {
        return this.billingOperationsService.registerPos(request);
    }

    @PostMapping(value={"/close-pos"})
    public RespuestaCierrePuntoVenta closePos(@RequestBody ClosePosRequest request) {
        return this.billingOperationsService.closePos(request);
    }

    @PostMapping(value={"/register-commission-pos"})
    public RespuestaPuntoVentaComisionista registerCommissionPos(@RequestBody RegisterCommissionPosRequest request) throws DatatypeConfigurationException {
        return this.billingOperationsService.registerCommissionPos(request);
    }

    @PostMapping(value={"/query-significant-events"})
    public RespuestaListaEventos querySignificantEvents(@RequestBody QuerySignificantEventsRequest request) throws DatatypeConfigurationException {
        return this.billingOperationsService.querySignificantEvents(request);
    }
}

