/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.operations.service;

import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import ninja.theteam.yubusin.ebilling.codes.service.CufdService;
import ninja.theteam.yubusin.ebilling.codes.service.CuisService;
import ninja.theteam.yubusin.ebilling.common.exception.SiatNotRespondingException;
import ninja.theteam.yubusin.ebilling.common.model.Util;
import ninja.theteam.yubusin.ebilling.config.EBillingAppConfig;
import ninja.theteam.yubusin.ebilling.operations.dto.ClosePosRequest;
import ninja.theteam.yubusin.ebilling.operations.dto.CloseSystemOperationsRequest;
import ninja.theteam.yubusin.ebilling.operations.dto.QueryPosRequest;
import ninja.theteam.yubusin.ebilling.operations.dto.QuerySignificantEventsRequest;
import ninja.theteam.yubusin.ebilling.operations.dto.RegisterCommissionPosRequest;
import ninja.theteam.yubusin.ebilling.operations.dto.RegisterPosRequest;
import ninja.theteam.yubusin.ebilling.operations.dto.RegisterSignificantEventRequest;
import ninja.theteam.yubusin.ebilling.soap.codes.RespuestaCufd;
import ninja.theteam.yubusin.ebilling.soap.operations.ObjectFactory;
import ninja.theteam.yubusin.ebilling.soap.operations.RespuestaCierrePuntoVenta;
import ninja.theteam.yubusin.ebilling.soap.operations.RespuestaCierreSistemas;
import ninja.theteam.yubusin.ebilling.soap.operations.RespuestaComunicacion;
import ninja.theteam.yubusin.ebilling.soap.operations.RespuestaConsultaPuntoVenta;
import ninja.theteam.yubusin.ebilling.soap.operations.RespuestaListaEventos;
import ninja.theteam.yubusin.ebilling.soap.operations.RespuestaPuntoVentaComisionista;
import ninja.theteam.yubusin.ebilling.soap.operations.RespuestaRegistroPuntoVenta;
import ninja.theteam.yubusin.ebilling.soap.operations.ServicioFacturacionOperaciones;
import ninja.theteam.yubusin.ebilling.soap.operations.ServicioFacturacionOperaciones_Service;
import ninja.theteam.yubusin.ebilling.soap.operations.SolicitudCierrePuntoVenta;
import ninja.theteam.yubusin.ebilling.soap.operations.SolicitudConsultaEvento;
import ninja.theteam.yubusin.ebilling.soap.operations.SolicitudConsultaPuntoVenta;
import ninja.theteam.yubusin.ebilling.soap.operations.SolicitudEventoSignificativo;
import ninja.theteam.yubusin.ebilling.soap.operations.SolicitudOperaciones;
import ninja.theteam.yubusin.ebilling.soap.operations.SolicitudPuntoVentaComisionista;
import ninja.theteam.yubusin.ebilling.soap.operations.SolicitudRegistroPuntoVenta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BillingOperationsService {
    private static final Logger logger = LoggerFactory.getLogger(BillingOperationsService.class);
    private static final QName SERVICE_NAME = new QName("https://siat.impuestos.gob.bo/FacturacionOperaciones", "ServicioFacturacionOperaciones");
    private final EBillingAppConfig eBillingAppConfig;
    private final CuisService cuisService;
    private final CufdService cufdService;

    public BillingOperationsService(EBillingAppConfig eBillingAppConfig, CuisService cuisService, CufdService cufdService) {
        this.eBillingAppConfig = eBillingAppConfig;
        this.cuisService = cuisService;
        this.cufdService = cufdService;
    }

    public RespuestaComunicacion ping() {
        try {
            logger.debug("Invoking ping...");
            RespuestaComunicacion response = this.getPort().verificarComunicacion();
            logger.debug("pong");
            return response;
        }
        catch (Exception e) {
            logger.error("SIAT is not responding. Dying gracefully.");
            throw new SiatNotRespondingException("SIAT is not responding. It is recommended to change to offline mode.");
        }
    }

    public RespuestaRegistroPuntoVenta registerPos(RegisterPosRequest request) {
        ObjectFactory factory = new ObjectFactory();
        SolicitudRegistroPuntoVenta solicitudRegistroPuntoVenta = factory.createSolicitudRegistroPuntoVenta();
        solicitudRegistroPuntoVenta.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        solicitudRegistroPuntoVenta.setCodigoModalidad(1);
        solicitudRegistroPuntoVenta.setCodigoSistema("6D23688410B63B72FBD7EC6");
        solicitudRegistroPuntoVenta.setCodigoSucursal(request.getCodigoSucursal().intValue());
        solicitudRegistroPuntoVenta.setCuis(this.cuisService.getCuis(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudRegistroPuntoVenta.setNit(EBillingAppConfig.NIT.longValue());
        solicitudRegistroPuntoVenta.setCodigoTipoPuntoVenta(request.getCodigoTipoPuntoVenta());
        solicitudRegistroPuntoVenta.setNombrePuntoVenta(request.getNombrePuntoVenta());
        solicitudRegistroPuntoVenta.setDescripcion(request.getDescripcion());
        logger.debug("Invoking registroPuntoVenta...");
        RespuestaRegistroPuntoVenta response = this.getPort().registroPuntoVenta(solicitudRegistroPuntoVenta);
        logger.debug("registroPuntoVenta.result=" + response);
        return response;
    }

    public RespuestaPuntoVentaComisionista registerCommissionPos(RegisterCommissionPosRequest request) throws DatatypeConfigurationException {
        ObjectFactory factory = new ObjectFactory();
        SolicitudPuntoVentaComisionista solicitudPuntoVentaComisionista = factory.createSolicitudPuntoVentaComisionista();
        solicitudPuntoVentaComisionista.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        solicitudPuntoVentaComisionista.setCodigoModalidad(1);
        solicitudPuntoVentaComisionista.setCodigoSistema("6D23688410B63B72FBD7EC6");
        solicitudPuntoVentaComisionista.setCodigoSucursal(request.getCodigoSucursal().intValue());
        solicitudPuntoVentaComisionista.setCuis(this.cuisService.getCuis(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudPuntoVentaComisionista.setNit(EBillingAppConfig.NIT.longValue());
        solicitudPuntoVentaComisionista.setNombrePuntoVenta(request.getNombrePuntoVenta());
        solicitudPuntoVentaComisionista.setDescripcion(request.getDescripcion());
        solicitudPuntoVentaComisionista.setNitComisionista(request.getNitComisionista().longValue());
        solicitudPuntoVentaComisionista.setNumeroContrato(request.getNumeroContrato());
        solicitudPuntoVentaComisionista.setFechaInicio(Util.convert((Date)new Date(request.getFechaInicio())));
        solicitudPuntoVentaComisionista.setFechaFin(Util.convert((Date)new Date(request.getFechaFin())));
        logger.debug("Invoking registroPuntoVentaComisionista...");
        RespuestaPuntoVentaComisionista response = this.getPort().registroPuntoVentaComisionista(solicitudPuntoVentaComisionista);
        logger.debug("registroPuntoVentaComisionista.result=" + response);
        return response;
    }

    public RespuestaConsultaPuntoVenta queryPos(QueryPosRequest request) {
        ObjectFactory factory = new ObjectFactory();
        SolicitudConsultaPuntoVenta solicitudConsultaPuntoVenta = factory.createSolicitudConsultaPuntoVenta();
        solicitudConsultaPuntoVenta.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        solicitudConsultaPuntoVenta.setCodigoSistema("6D23688410B63B72FBD7EC6");
        solicitudConsultaPuntoVenta.setCodigoSucursal(request.getCodigoSucursal().intValue());
        solicitudConsultaPuntoVenta.setCuis(this.cuisService.getCuis(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudConsultaPuntoVenta.setNit(EBillingAppConfig.NIT.longValue());
        logger.debug("Invoking consultaPuntoVenta...");
        RespuestaConsultaPuntoVenta response = this.getPort().consultaPuntoVenta(solicitudConsultaPuntoVenta);
        logger.debug("consultaPuntoVenta.result=" + response);
        return response;
    }

    public RespuestaCierrePuntoVenta closePos(ClosePosRequest request) {
        ObjectFactory factory = new ObjectFactory();
        SolicitudCierrePuntoVenta solicitudCierrePuntoVenta = factory.createSolicitudCierrePuntoVenta();
        solicitudCierrePuntoVenta.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        solicitudCierrePuntoVenta.setCodigoSistema("6D23688410B63B72FBD7EC6");
        solicitudCierrePuntoVenta.setCodigoSucursal(request.getCodigoSucursal().intValue());
        solicitudCierrePuntoVenta.setCuis(this.cuisService.getCuis(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudCierrePuntoVenta.setNit(EBillingAppConfig.NIT.longValue());
        solicitudCierrePuntoVenta.setCodigoPuntoVenta(request.getCodigoPuntoVentaCerrar().intValue());
        logger.debug("Invoking cierrePuntoVenta...");
        RespuestaCierrePuntoVenta response = this.getPort().cierrePuntoVenta(solicitudCierrePuntoVenta);
        logger.debug("cierrePuntoVenta.result=" + response);
        return response;
    }

    public RespuestaCierreSistemas closeSystemOperations(CloseSystemOperationsRequest request) {
        SolicitudOperaciones solicitudOperaciones = null;
        logger.debug("Invoking cierreOperacionesSistema...");
        RespuestaCierreSistemas response = this.getPort().cierreOperacionesSistema(solicitudOperaciones);
        logger.debug("cierreOperacionesSistema.result=" + response);
        return response;
    }

    public RespuestaListaEventos querySignificantEvents(QuerySignificantEventsRequest request) throws DatatypeConfigurationException {
        ObjectFactory factory = new ObjectFactory();
        SolicitudConsultaEvento solicitudConsultaEvento = factory.createSolicitudConsultaEvento();
        solicitudConsultaEvento.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        solicitudConsultaEvento.setCodigoSistema("6D23688410B63B72FBD7EC6");
        solicitudConsultaEvento.setNit(EBillingAppConfig.NIT.longValue());
        solicitudConsultaEvento.setCuis(this.cuisService.getCuis(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudConsultaEvento.setCufd(this.cufdService.getCufd(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudConsultaEvento.setCodigoSucursal(request.getCodigoSucursal().intValue());
        solicitudConsultaEvento.setCodigoPuntoVenta(factory.createSolicitudConsultaEventoCodigoPuntoVenta(request.getCodigoPuntoVenta()));
        XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(request.getDate());
        xmlGregorianCalendar.setTimezone(Integer.MIN_VALUE);
        solicitudConsultaEvento.setFechaEvento(xmlGregorianCalendar);
        logger.debug("Invoking consultaEventoSignificativo...");
        RespuestaListaEventos response = this.getPort().consultaEventoSignificativo(solicitudConsultaEvento);
        logger.debug("consultaEventoSignificativo.result=" + response);
        return response;
    }

    public RespuestaListaEventos registerSignificantEvent(RegisterSignificantEventRequest request) throws DatatypeConfigurationException {
        ObjectFactory factory = new ObjectFactory();
        RespuestaCufd respuestaCufd = this.cufdService.getCufd(request.getCodigoSucursal(), request.getCodigoPuntoVenta(), true);
        SolicitudEventoSignificativo solicitudEventoSignificativo = factory.createSolicitudEventoSignificativo();
        solicitudEventoSignificativo.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        solicitudEventoSignificativo.setCodigoSistema("6D23688410B63B72FBD7EC6");
        solicitudEventoSignificativo.setNit(EBillingAppConfig.NIT.longValue());
        solicitudEventoSignificativo.setCuis(this.cuisService.getCuis(request.getCodigoSucursal(), request.getCodigoPuntoVenta()).getCodigo());
        solicitudEventoSignificativo.setCufd(respuestaCufd.getCodigo());
        solicitudEventoSignificativo.setCodigoSucursal(request.getCodigoSucursal().intValue());
        solicitudEventoSignificativo.setCodigoPuntoVenta(factory.createSolicitudConsultaEventoCodigoPuntoVenta(request.getCodigoPuntoVenta()));
        solicitudEventoSignificativo.setCufdEvento(request.getCufd());
        solicitudEventoSignificativo.setFechaHoraInicioEvento(Util.convert((GregorianCalendar)request.getStartEvent()));
        solicitudEventoSignificativo.setFechaHoraFinEvento(Util.convert((GregorianCalendar)request.getEndEvent()));
        solicitudEventoSignificativo.setCodigoMotivoEvento(request.getEventCode().intValue());
        solicitudEventoSignificativo.setDescripcion(request.getDescription());
        logger.debug("Invoking registroEventoSignificativo...");
        logger.debug("StartDate: {}", (Object)solicitudEventoSignificativo.getFechaHoraInicioEvento());
        logger.debug("EndDate: {}", (Object)solicitudEventoSignificativo.getFechaHoraFinEvento());
        RespuestaListaEventos response = this.getPort().registroEventoSignificativo(solicitudEventoSignificativo);
        logger.debug("registroEventoSignificativo.result=" + response.isTransaccion());
        return response;
    }

    private ServicioFacturacionOperaciones getPort() {
        URL wsdlURL = ServicioFacturacionOperaciones_Service.WSDL_LOCATION;
        ServicioFacturacionOperaciones_Service ss = new ServicioFacturacionOperaciones_Service(wsdlURL, SERVICE_NAME);
        ServicioFacturacionOperaciones port = ss.getServicioFacturacionOperacionesPort();
        Map req_ctx = ((BindingProvider)port).getRequestContext();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("apikey", Collections.singletonList("TokenApi " + this.eBillingAppConfig.getToken()));
        req_ctx.put("javax.xml.ws.http.request.headers", headers);
        return port;
    }
}

