/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.signature.service;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.zip.CRC32;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HashService {
    private static final Logger logger = LoggerFactory.getLogger(HashService.class);

    public String sha256Hash(byte[] data) {
        return this.hash(data, "SHA-256");
    }

    public String md5Hash(byte[] data) {
        return this.hash(data, "MD5");
    }

    public String calCrc32(byte[] data) {
        CRC32 checksum = new CRC32();
        checksum.update(data, 0, data.length);
        long checksumValue = checksum.getValue();
        StringBuilder hex = new StringBuilder(Long.toHexString(checksumValue).toUpperCase());
        while (hex.length() < 8) {
            hex.insert(0, "0");
        }
        return hex.toString();
    }

    private String hash(byte[] data, String algorithm) {
        String hashValue = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            messageDigest.update(data);
            byte[] digestedBytes = messageDigest.digest();
            hashValue = DatatypeConverter.printHexBinary((byte[])digestedBytes).toLowerCase();
        }
        catch (Exception e) {
            logger.debug("Error in Hash generation: " + algorithm);
        }
        return hashValue;
    }

    public String completeZero(String pString, int pMaxChar) {
        StringBuilder vNewString = new StringBuilder(pString);
        if (pString.length() < pMaxChar) {
            for (int i = pString.length(); i < pMaxChar; ++i) {
                vNewString.insert(0, "0");
            }
        }
        return vNewString.toString();
    }

    public String base16(String pString) {
        BigInteger vValor = new BigInteger(pString);
        return vValor.toString(16).toUpperCase();
    }

    public String base10(String pString) {
        BigInteger vValor = new BigInteger(pString, 16);
        return vValor.toString();
    }

    public String mod11(String cadena, int numDig, int limMult, boolean x10) {
        if (!x10) {
            numDig = 1;
        }
        StringBuilder cadenaBuilder = new StringBuilder(cadena);
        for (int n = 1; n <= numDig; ++n) {
            int suma = 0;
            int mult = 2;
            for (int i = cadenaBuilder.length() - 1; i >= 0; --i) {
                suma += mult * Integer.parseInt(cadenaBuilder.substring(i, i + 1));
                if (++mult <= limMult) continue;
                mult = 2;
            }
            int dig = x10 ? suma * 10 % 11 % 10 : suma % 11;
            if (dig == 10) {
                cadenaBuilder.append("1");
            }
            if (dig == 11) {
                cadenaBuilder.append("0");
            }
            if (dig >= 10) continue;
            cadenaBuilder.append(dig);
        }
        cadena = cadenaBuilder.toString();
        return cadena.substring(cadena.length() - numDig);
    }
}

