/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.signature.service;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import ninja.theteam.yubusin.ebilling.config.EBillingAppConfig;
import org.apache.commons.codec.binary.Base64;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Service
public class SignerService {
    private EBillingAppConfig eBillingAppConfig;

    public SignerService(EBillingAppConfig eBillingAppConfig) {
        this.eBillingAppConfig = eBillingAppConfig;
        Init.init();
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public byte[] sign(byte[] data, PrivateKey priv, X509Certificate ... cert) throws ParserConfigurationException, IOException, SAXException, XMLSecurityException {
        ElementProxy.setDefaultPrefix((String)"http://www.w3.org/2000/09/xmldsig#", (String)"");
        Document document = this.readXML(data);
        Element root = (Element)document.getFirstChild();
        document.setXmlStandalone(false);
        XMLSignature signature = new XMLSignature(document, null, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        root.appendChild(signature.getElement());
        Transforms transforms = new Transforms(document);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        signature.addDocument("", transforms, "http://www.w3.org/2001/04/xmlenc#sha256");
        if (cert != null) {
            signature.addKeyInfo(cert[0]);
        }
        signature.sign((Key)priv);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLUtils.outputDOMc14nWithComments((Node)document, (OutputStream)baos);
        return baos.toString().getBytes();
    }

    public Document readXML(byte[] data) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(data));
    }

    private String getKey(String filename) throws IOException {
        String line;
        StringBuilder strKeyPEM = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(filename));
        while ((line = br.readLine()) != null) {
            strKeyPEM.append(line).append("\n");
        }
        br.close();
        return strKeyPEM.toString();
    }

    public RSAPrivateKey getPrivateKey(String filename) throws IOException, GeneralSecurityException {
        String privateKeyPEM = this.getKey(filename);
        return this.getPrivateKeyFromString(privateKeyPEM);
    }

    public RSAPrivateKey getPrivateKeyFromString(String key) throws GeneralSecurityException {
        String privateKeyPEM = key;
        privateKeyPEM = privateKeyPEM.replace("-----BEGIN PRIVATE KEY-----\n", "");
        privateKeyPEM = privateKeyPEM.replace("-----END PRIVATE KEY-----", "");
        byte[] encoded = Base64.decodeBase64((String)privateKeyPEM);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        return (RSAPrivateKey)kf.generatePrivate(keySpec);
    }

    public RSAPublicKey getPublicKeyFromString(String key) throws GeneralSecurityException {
        String publicKeyPEM = key;
        publicKeyPEM = publicKeyPEM.replace("-----BEGIN PUBLIC KEY-----\n", "");
        publicKeyPEM = publicKeyPEM.replace("-----END PUBLIC KEY-----", "");
        byte[] encoded = Base64.decodeBase64((String)publicKeyPEM);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return (RSAPublicKey)kf.generatePublic(new X509EncodedKeySpec(encoded));
    }

    public X509Certificate getX509Certificate(String filename) throws IOException, CertificateException {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        FileInputStream is = new FileInputStream(filename);
        X509Certificate cer = (X509Certificate)fact.generateCertificate(is);
        PublicKey key = cer.getPublicKey();
        return cer;
    }

    public PrivateKey getPrivateKey2() throws IOException, GeneralSecurityException {
        String path = this.eBillingAppConfig.getCertsPath();
        String privateKeyFile = this.eBillingAppConfig.getPrivateKey();
        if (privateKeyFile.endsWith("p12")) {
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            char[] pkcsPasswd = this.eBillingAppConfig.getPkcs12Passwd().toCharArray();
            keystore.load(new FileInputStream(path + "/" + privateKeyFile), pkcsPasswd);
            return (PrivateKey)keystore.getKey(this.eBillingAppConfig.getPkcs12Alias(), pkcsPasswd);
        }
        return this.getPrivateKey(path + "/" + privateKeyFile);
    }

    public X509Certificate getCertificate() throws IOException, CertificateException {
        return this.getX509Certificate(this.eBillingAppConfig.getCertsPath() + "/" + this.eBillingAppConfig.getCertificate());
    }
}

