/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.signature.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.springframework.stereotype.Service;

@Service
public class TarService {
    public byte[] tarCompress(List<String> dataList) {
        byte[] tarData = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            TarOutputStream tos = new TarOutputStream((OutputStream)byteArrayOutputStream);
            this.tarCompress(dataList, tos);
            tos.close();
            tarData = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tarData;
    }

    private void tarCompress(List<String> dataList, TarOutputStream tos) throws IOException {
        int buffersize = 1024;
        byte[] buf = new byte[buffersize];
        for (String data : dataList) {
            byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(dataBytes);
            TarEntry te = new TarEntry(UUID.randomUUID().toString());
            te.setSize((long)dataBytes.length);
            tos.setLongFileMode(2);
            tos.putNextEntry(te);
            int count = 0;
            while ((count = byteArrayInputStream.read(buf, 0, buffersize)) != -1) {
                tos.write(buf, 0, count);
            }
            tos.closeEntry();
            byteArrayInputStream.close();
        }
    }
}

