/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.synchronization.controller;

import ninja.theteam.yubusin.ebilling.soap.synchronization.RespuestaComunicacion;
import ninja.theteam.yubusin.ebilling.soap.synchronization.RespuestaFechaHora;
import ninja.theteam.yubusin.ebilling.soap.synchronization.RespuestaListaActividades;
import ninja.theteam.yubusin.ebilling.soap.synchronization.RespuestaListaActividadesDocumentoSector;
import ninja.theteam.yubusin.ebilling.soap.synchronization.RespuestaListaParametricas;
import ninja.theteam.yubusin.ebilling.soap.synchronization.RespuestaListaParametricasLeyendas;
import ninja.theteam.yubusin.ebilling.soap.synchronization.RespuestaListaProductos;
import ninja.theteam.yubusin.ebilling.synchronization.dto.SyncRequest;
import ninja.theteam.yubusin.ebilling.synchronization.service.SyncService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sync"})
public class SyncRestController {
    private SyncService syncService;

    public SyncRestController(SyncService syncService) {
        this.syncService = syncService;
    }

    @GetMapping(value={"/ping"})
    public RespuestaComunicacion ping() {
        return this.syncService.ping();
    }

    @PostMapping(value={"/activities"})
    public RespuestaListaActividades syncActivities(@RequestBody SyncRequest request) {
        return this.syncService.syncActivities(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/date-time"})
    public RespuestaFechaHora syncDateTime(@RequestBody SyncRequest request) {
        return this.syncService.syncDateTime(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/activities-per-document-sector"})
    public RespuestaListaActividadesDocumentoSector syncActivitiesPerDocumentSector(@RequestBody SyncRequest request) {
        return this.syncService.syncActivitiesPerDocumentSector(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/bill-legends"})
    public RespuestaListaParametricasLeyendas syncBillLegends(@RequestBody SyncRequest request) {
        return this.syncService.syncBillLegends(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/service-message-codes"})
    public RespuestaListaParametricas syncServiceMessageCodes(@RequestBody SyncRequest request) {
        return this.syncService.syncServiceMessageCodes(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/products-and-services"})
    public RespuestaListaProductos syncProductsAndServices(@RequestBody SyncRequest request) {
        return this.syncService.syncProductsAndServices(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/significant-events"})
    public RespuestaListaParametricas syncSignificantEvents(@RequestBody SyncRequest request) {
        return this.syncService.syncSignificantEvents(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/cancellation-reasons"})
    public RespuestaListaParametricas syncCancellationReasons(@RequestBody SyncRequest request) {
        return this.syncService.syncCancellationReasons(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/origin-countries"})
    public RespuestaListaParametricas syncOriginCountries(@RequestBody SyncRequest request) {
        return this.syncService.syncOriginCountries(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/identity-document-types"})
    public RespuestaListaParametricas syncIdentityDocumentTypes(@RequestBody SyncRequest request) {
        return this.syncService.syncIdentityDocumentTypes(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/sector-document-types"})
    public RespuestaListaParametricas syncSectorDocumentTypes(@RequestBody SyncRequest request) {
        return this.syncService.syncSectorDocumentTypes(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/emission-types"})
    public RespuestaListaParametricas syncEmissionTypes(@RequestBody SyncRequest request) {
        return this.syncService.syncEmissionTypes(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/room-types"})
    public RespuestaListaParametricas syncRoomTypes(@RequestBody SyncRequest request) {
        return this.syncService.syncRoomTypes(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/payment-method-types"})
    public RespuestaListaParametricas syncPaymentMethodTypes(@RequestBody SyncRequest request) {
        return this.syncService.syncPaymentMethodTypes(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/currency-types"})
    public RespuestaListaParametricas syncCurrencyTypes(@RequestBody SyncRequest request) {
        return this.syncService.syncCurrencyTypes(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/point-of-sale-types"})
    public RespuestaListaParametricas syncPointOfSaleTypes(@RequestBody SyncRequest request) {
        return this.syncService.syncPointOfSaleTypes(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/bill-types"})
    public RespuestaListaParametricas syncBillTypes(@RequestBody SyncRequest request) {
        return this.syncService.syncBillTypes(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }

    @PostMapping(value={"/measure-units"})
    public RespuestaListaParametricas getListMeasureUnits(@RequestBody SyncRequest request) {
        return this.syncService.syncMeasureUnits(request.getCodigoSucursal(), request.getCodigoPuntoVenta());
    }
}

