/*
 * Decompiled with CFR 0.152.
 */
package ninja.theteam.yubusin.ebilling.synchronization.service;

import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import ninja.theteam.yubusin.ebilling.codes.service.CuisService;
import ninja.theteam.yubusin.ebilling.common.exception.SiatNotRespondingException;
import ninja.theteam.yubusin.ebilling.common.model.Util;
import ninja.theteam.yubusin.ebilling.config.EBillingAppConfig;
import ninja.theteam.yubusin.ebilling.soap.synchronization.ActividadesDocumentoSectorDto;
import ninja.theteam.yubusin.ebilling.soap.synchronization.ActividadesDto;
import ninja.theteam.yubusin.ebilling.soap.synchronization.ObjectFactory;
import ninja.theteam.yubusin.ebilling.soap.synchronization.ParametricaLeyendasDto;
import ninja.theteam.yubusin.ebilling.soap.synchronization.ParametricasDto;
import ninja.theteam.yubusin.ebilling.soap.synchronization.ProductosDto;
import ninja.theteam.yubusin.ebilling.soap.synchronization.RespuestaComunicacion;
import ninja.theteam.yubusin.ebilling.soap.synchronization.RespuestaFechaHora;
import ninja.theteam.yubusin.ebilling.soap.synchronization.RespuestaListaActividades;
import ninja.theteam.yubusin.ebilling.soap.synchronization.RespuestaListaActividadesDocumentoSector;
import ninja.theteam.yubusin.ebilling.soap.synchronization.RespuestaListaParametricas;
import ninja.theteam.yubusin.ebilling.soap.synchronization.RespuestaListaParametricasLeyendas;
import ninja.theteam.yubusin.ebilling.soap.synchronization.RespuestaListaProductos;
import ninja.theteam.yubusin.ebilling.soap.synchronization.ServicioFacturacionSincronizacion;
import ninja.theteam.yubusin.ebilling.soap.synchronization.ServicioFacturacionSincronizacion_Service;
import ninja.theteam.yubusin.ebilling.soap.synchronization.SolicitudSincronizacion;
import ninja.theteam.yubusin.ebilling.synchronization.model.Activity;
import ninja.theteam.yubusin.ebilling.synchronization.model.ActivityPerDocumentSector;
import ninja.theteam.yubusin.ebilling.synchronization.model.BillLegend;
import ninja.theteam.yubusin.ebilling.synchronization.model.BillType;
import ninja.theteam.yubusin.ebilling.synchronization.model.CancellationReason;
import ninja.theteam.yubusin.ebilling.synchronization.model.CurrencyType;
import ninja.theteam.yubusin.ebilling.synchronization.model.DateTime;
import ninja.theteam.yubusin.ebilling.synchronization.model.EmissionType;
import ninja.theteam.yubusin.ebilling.synchronization.model.IdentityDocumentType;
import ninja.theteam.yubusin.ebilling.synchronization.model.MeasureUnit;
import ninja.theteam.yubusin.ebilling.synchronization.model.OriginCountry;
import ninja.theteam.yubusin.ebilling.synchronization.model.PaymentMethodType;
import ninja.theteam.yubusin.ebilling.synchronization.model.PointOfSaleType;
import ninja.theteam.yubusin.ebilling.synchronization.model.ProductAndService;
import ninja.theteam.yubusin.ebilling.synchronization.model.RoomType;
import ninja.theteam.yubusin.ebilling.synchronization.model.SectorDocumentType;
import ninja.theteam.yubusin.ebilling.synchronization.model.ServiceMessageCode;
import ninja.theteam.yubusin.ebilling.synchronization.model.SignificantEvent;
import ninja.theteam.yubusin.ebilling.synchronization.repository.ActivityPerDocumentSectorRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.ActivityRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.BillLegendRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.BillTypeRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.CancellationReasonRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.CurrencyTypeRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.DateTimeRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.EmissionTypeRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.IdentityDocumentTypeRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.MeasureUnitRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.OriginCountryRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.PaymentMethodTypeRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.PointOfSaleTypeRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.ProductAndServiceRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.RoomTypeRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.SectorDocumentTypeRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.ServiceMessageCodeRepository;
import ninja.theteam.yubusin.ebilling.synchronization.repository.SignificantEventRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SyncService {
    private static final Logger logger = LoggerFactory.getLogger(SyncService.class);
    private static final QName SERVICE_NAME = new QName("https://siat.impuestos.gob.bo/FacturacionSincronizacion", "ServicioFacturacionSincronizacion");
    private final EBillingAppConfig eBillingAppConfig;
    private final CuisService cuisService;
    private final ActivityPerDocumentSectorRepository activityPerDocumentSectorRepository;
    private final ActivityRepository activityRepository;
    private final BillLegendRepository billLegendRepository;
    private final BillTypeRepository billTypeRepository;
    private final CancellationReasonRepository cancellationReasonRepository;
    private final CurrencyTypeRepository currencyTypeRepository;
    private final DateTimeRepository dateTimeRepository;
    private final EmissionTypeRepository emissionTypeRepository;
    private final IdentityDocumentTypeRepository identityDocumentTypeRepository;
    private final MeasureUnitRepository measureUnitRepository;
    private final OriginCountryRepository originCountryRepository;
    private final PaymentMethodTypeRepository paymentMethodTypeRepository;
    private final PointOfSaleTypeRepository pointOfSaleTypeRepository;
    private final ProductAndServiceRepository productAndServiceRepository;
    private final RoomTypeRepository roomTypeRepository;
    private final SectorDocumentTypeRepository sectorDocumentTypeRepository;
    private final ServiceMessageCodeRepository serviceMessageCodeRepository;
    private final SignificantEventRepository significantEventRepository;

    public SyncService(EBillingAppConfig eBillingAppConfig, CuisService cuisService, ActivityPerDocumentSectorRepository activityPerDocumentSectorRepository, ActivityRepository activityRepository, BillLegendRepository billLegendRepository, BillTypeRepository billTypeRepository, CancellationReasonRepository cancellationReasonRepository, CurrencyTypeRepository currencyTypeRepository, DateTimeRepository dateTimeRepository, EmissionTypeRepository emissionTypeRepository, IdentityDocumentTypeRepository identityDocumentTypeRepository, MeasureUnitRepository measureUnitRepository, OriginCountryRepository originCountryRepository, PaymentMethodTypeRepository paymentMethodTypeRepository, PointOfSaleTypeRepository pointOfSaleTypeRepository, ProductAndServiceRepository productAndServiceRepository, RoomTypeRepository roomTypeRepository, SectorDocumentTypeRepository sectorDocumentTypeRepository, ServiceMessageCodeRepository serviceMessageCodeRepository, SignificantEventRepository significantEventRepository) {
        this.eBillingAppConfig = eBillingAppConfig;
        this.cuisService = cuisService;
        this.activityPerDocumentSectorRepository = activityPerDocumentSectorRepository;
        this.activityRepository = activityRepository;
        this.billLegendRepository = billLegendRepository;
        this.billTypeRepository = billTypeRepository;
        this.cancellationReasonRepository = cancellationReasonRepository;
        this.currencyTypeRepository = currencyTypeRepository;
        this.dateTimeRepository = dateTimeRepository;
        this.emissionTypeRepository = emissionTypeRepository;
        this.identityDocumentTypeRepository = identityDocumentTypeRepository;
        this.measureUnitRepository = measureUnitRepository;
        this.originCountryRepository = originCountryRepository;
        this.paymentMethodTypeRepository = paymentMethodTypeRepository;
        this.pointOfSaleTypeRepository = pointOfSaleTypeRepository;
        this.productAndServiceRepository = productAndServiceRepository;
        this.roomTypeRepository = roomTypeRepository;
        this.sectorDocumentTypeRepository = sectorDocumentTypeRepository;
        this.serviceMessageCodeRepository = serviceMessageCodeRepository;
        this.significantEventRepository = significantEventRepository;
    }

    public RespuestaComunicacion ping() {
        try {
            logger.debug("Invoking ping...");
            RespuestaComunicacion response = this.getPort(this.eBillingAppConfig.getToken()).verificarComunicacion();
            logger.debug("pong");
            return response;
        }
        catch (Exception e) {
            logger.error("SIAT is not responding. Dying gracefully.");
            throw new SiatNotRespondingException("SIAT is not responding. It is recommended to change to offline mode.");
        }
    }

    public RespuestaListaActividades syncActivities(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarActividades...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaActividades response = this.syncActivitiesFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncActivitiesFromSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaActividades syncActivitiesFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.activityRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List activities = this.activityRepository.getActivitiesByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaActividades response = new ObjectFactory().createRespuestaListaActividades();
            response.setTransaccion(Boolean.valueOf(false));
            for (Activity activity : activities) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), activity.isExpired()));
                ActividadesDto actividadesDto = new ObjectFactory().createActividadesDto();
                actividadesDto.setCodigoCaeb(activity.getCode());
                actividadesDto.setTipoActividad(activity.getActivityType());
                actividadesDto.setDescripcion(activity.getDescription());
                response.getListaActividades().add(actividadesDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaActividades syncActivitiesFromSiat(Integer branchOffice, Integer posCode, RespuestaListaActividades expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaActividades response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarActividades(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ActividadesDto actividadesDto : response.getListaActividades()) {
                Activity activity = new Activity();
                activity.setCode(actividadesDto.getCodigoCaeb());
                activity.setActivityType(actividadesDto.getTipoActividad());
                activity.setDescription(actividadesDto.getDescripcion());
                activity.setExpirationDate(calendar.getTime());
                activity.setBranchOffice(branchOffice);
                activity.setPosCode(posCode);
                this.activityRepository.save((Object)activity);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaFechaHora syncDateTime(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarFechaHora...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaFechaHora response = this.syncDateTimeFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncDateTimeFromSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaFechaHora syncDateTimeFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.dateTimeRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            DateTime dateTime = this.dateTimeRepository.getDateTimeByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaFechaHora response = new ObjectFactory().createRespuestaFechaHora();
            isExpiredCache.set(dateTime.isExpired());
            response.setTransaccion(Boolean.valueOf(false));
            response.setFechaHora(dateTime.getDate());
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaFechaHora syncDateTimeFromSiat(Integer branchOffice, Integer posCode, RespuestaFechaHora expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaFechaHora response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarFechaHora(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            DateTime dateTime = new DateTime();
            dateTime.setDate(response.getFechaHora());
            dateTime.setExpirationDate(calendar.getTime());
            dateTime.setBranchOffice(branchOffice);
            dateTime.setPosCode(posCode);
            this.dateTimeRepository.save((Object)dateTime);
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaActividadesDocumentoSector syncActivitiesPerDocumentSector(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarListaActividadesDocumentoSector...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaActividadesDocumentoSector response = this.syncActivitiesPerDocumentSectorFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncActivitiesPerDocumentSectorSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaActividadesDocumentoSector syncActivitiesPerDocumentSectorFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.activityPerDocumentSectorRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List activitiesPDocumentSector = this.activityPerDocumentSectorRepository.getActivityPerDocumentSectorsByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaActividadesDocumentoSector response = new ObjectFactory().createRespuestaListaActividadesDocumentoSector();
            response.setTransaccion(Boolean.valueOf(false));
            for (ActivityPerDocumentSector activityPDS : activitiesPDocumentSector) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), activityPDS.isExpired()));
                ActividadesDocumentoSectorDto actividadesDocumentoSectorDto = new ObjectFactory().createActividadesDocumentoSectorDto();
                actividadesDocumentoSectorDto.setCodigoDocumentoSector(activityPDS.getDocumentSectorCode());
                actividadesDocumentoSectorDto.setTipoDocumentoSector(activityPDS.getSectorDocumentType());
                actividadesDocumentoSectorDto.setCodigoActividad(activityPDS.getActivityCode());
                response.getListaActividadesDocumentoSector().add(actividadesDocumentoSectorDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaActividadesDocumentoSector syncActivitiesPerDocumentSectorSiat(Integer branchOffice, Integer posCode, RespuestaListaActividadesDocumentoSector expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaActividadesDocumentoSector response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarListaActividadesDocumentoSector(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ActividadesDocumentoSectorDto actividadesDSDto : response.getListaActividadesDocumentoSector()) {
                ActivityPerDocumentSector activitiesPDS = new ActivityPerDocumentSector();
                activitiesPDS.setActivityCode(actividadesDSDto.getCodigoActividad());
                activitiesPDS.setDocumentSectorCode(actividadesDSDto.getCodigoDocumentoSector());
                activitiesPDS.setSectorDocumentType(actividadesDSDto.getTipoDocumentoSector());
                activitiesPDS.setExpirationDate(calendar.getTime());
                activitiesPDS.setBranchOffice(branchOffice);
                activitiesPDS.setPosCode(posCode);
                this.activityPerDocumentSectorRepository.save((Object)activitiesPDS);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaParametricasLeyendas syncBillLegends(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarListaLeyendasFactura...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaParametricasLeyendas response = this.syncBillLegendsFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncBillLegendsSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaParametricasLeyendas syncBillLegendsFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.billLegendRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List billLegends = this.billLegendRepository.getBillLegendsByBranchOfficeEqualsAndAndPosCodeEqualsAndAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaParametricasLeyendas response = new ObjectFactory().createRespuestaListaParametricasLeyendas();
            response.setTransaccion(Boolean.valueOf(false));
            for (BillLegend billLegend : billLegends) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), billLegend.isExpired()));
                ParametricaLeyendasDto parametricaLeyendasDto = new ObjectFactory().createParametricaLeyendasDto();
                parametricaLeyendasDto.setCodigoActividad(billLegend.getCode());
                parametricaLeyendasDto.setDescripcionLeyenda(billLegend.getDescription());
                response.getListaLeyendas().add(parametricaLeyendasDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaParametricasLeyendas syncBillLegendsSiat(Integer branchOffice, Integer posCode, RespuestaListaParametricasLeyendas expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaParametricasLeyendas response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarListaLeyendasFactura(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ParametricaLeyendasDto parametricaLeyendasDto : response.getListaLeyendas()) {
                BillLegend billLegend = new BillLegend();
                billLegend.setCode(parametricaLeyendasDto.getCodigoActividad());
                billLegend.setDescription(parametricaLeyendasDto.getDescripcionLeyenda());
                billLegend.setExpirationDate(calendar.getTime());
                billLegend.setBranchOffice(branchOffice);
                billLegend.setPosCode(posCode);
                this.billLegendRepository.save((Object)billLegend);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaParametricas syncServiceMessageCodes(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarListaMensajesServicios...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaParametricas response = this.syncServiceMessageCodesFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncServiceMessageCodesSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaParametricas syncServiceMessageCodesFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.serviceMessageCodeRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List serviceMessageCodes = this.serviceMessageCodeRepository.getServiceMessageCodeByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaParametricas response = new ObjectFactory().createRespuestaListaParametricas();
            response.setTransaccion(Boolean.valueOf(false));
            for (ServiceMessageCode serviceMessageCode : serviceMessageCodes) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), serviceMessageCode.isExpired()));
                ParametricasDto parametricasDto = new ObjectFactory().createParametricasDto();
                parametricasDto.setDescripcion(serviceMessageCode.getDescription());
                parametricasDto.setCodigoClasificador(serviceMessageCode.getCode());
                response.getListaCodigos().add(parametricasDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaParametricas syncServiceMessageCodesSiat(Integer branchOffice, Integer posCode, RespuestaListaParametricas expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaParametricas response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarListaMensajesServicios(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ParametricasDto parametricasDto : response.getListaCodigos()) {
                ServiceMessageCode serviceMessageCode = new ServiceMessageCode();
                serviceMessageCode.setCode(parametricasDto.getCodigoClasificador());
                serviceMessageCode.setDescription(parametricasDto.getDescripcion());
                serviceMessageCode.setExpirationDate(calendar.getTime());
                serviceMessageCode.setBranchOffice(branchOffice);
                serviceMessageCode.setPosCode(posCode);
                this.serviceMessageCodeRepository.save((Object)serviceMessageCode);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaProductos syncProductsAndServices(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarListaProductosServicios...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaProductos response = this.syncProductsAndServicesFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncProductsAndServicesSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaProductos syncProductsAndServicesFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.productAndServiceRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List productAndServices = this.productAndServiceRepository.getProductAndServicesByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaProductos response = new ObjectFactory().createRespuestaListaProductos();
            response.setTransaccion(Boolean.valueOf(false));
            for (ProductAndService productAndService : productAndServices) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), productAndService.isExpired()));
                ProductosDto productosDto = new ObjectFactory().createProductosDto();
                productosDto.setCodigoActividad(productAndService.getActivityCode());
                productosDto.setCodigoProducto(productAndService.getCode());
                productosDto.setDescripcionProducto(productAndService.getDescription());
                response.getListaCodigos().add(productosDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaProductos syncProductsAndServicesSiat(Integer branchOffice, Integer posCode, RespuestaListaProductos expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaProductos response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarListaProductosServicios(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ProductosDto productosDto : response.getListaCodigos()) {
                ProductAndService productAndService = new ProductAndService();
                productAndService.setCode(productosDto.getCodigoProducto());
                productAndService.setActivityCode(productosDto.getCodigoActividad());
                productAndService.setDescription(productosDto.getDescripcionProducto());
                productAndService.setExpirationDate(calendar.getTime());
                productAndService.setBranchOffice(branchOffice);
                productAndService.setPosCode(posCode);
                this.productAndServiceRepository.save((Object)productAndService);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaParametricas syncSignificantEvents(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarParametricaEventosSignificativos...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaParametricas response = this.syncSignificantEventsFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncSignificantEventsSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaParametricas syncSignificantEventsFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.significantEventRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List significantEvents = this.significantEventRepository.getSignificantEventByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaParametricas response = new ObjectFactory().createRespuestaListaParametricas();
            response.setTransaccion(Boolean.valueOf(false));
            for (SignificantEvent significantEvent : significantEvents) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), significantEvent.isExpired()));
                ParametricasDto parametricasDto = new ObjectFactory().createParametricasDto();
                parametricasDto.setCodigoClasificador(significantEvent.getCode());
                parametricasDto.setDescripcion(significantEvent.getDescription());
                response.getListaCodigos().add(parametricasDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaParametricas syncSignificantEventsSiat(Integer branchOffice, Integer posCode, RespuestaListaParametricas expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaParametricas response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarParametricaEventosSignificativos(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ParametricasDto parametricasDto : response.getListaCodigos()) {
                SignificantEvent significantEvent = new SignificantEvent();
                significantEvent.setCode(parametricasDto.getCodigoClasificador());
                significantEvent.setDescription(parametricasDto.getDescripcion());
                significantEvent.setExpirationDate(calendar.getTime());
                significantEvent.setBranchOffice(branchOffice);
                significantEvent.setPosCode(posCode);
                this.significantEventRepository.save((Object)significantEvent);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaParametricas syncCancellationReasons(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarParametricaMotivoAnulacion...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaParametricas response = this.syncCancellationReasonsFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncCancellationReasonsSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaParametricas syncCancellationReasonsFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.cancellationReasonRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List cancellationReasons = this.cancellationReasonRepository.getCancellationReasonByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaParametricas response = new ObjectFactory().createRespuestaListaParametricas();
            response.setTransaccion(Boolean.valueOf(false));
            for (CancellationReason cancellationReason : cancellationReasons) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), cancellationReason.isExpired()));
                ParametricasDto parametricasDto = new ObjectFactory().createParametricasDto();
                parametricasDto.setCodigoClasificador(cancellationReason.getCode());
                parametricasDto.setDescripcion(cancellationReason.getDescription());
                response.getListaCodigos().add(parametricasDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaParametricas syncCancellationReasonsSiat(Integer branchOffice, Integer posCode, RespuestaListaParametricas expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaParametricas response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarParametricaMotivoAnulacion(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ParametricasDto parametricasDto : response.getListaCodigos()) {
                CancellationReason cancellationReason = new CancellationReason();
                cancellationReason.setCode(parametricasDto.getCodigoClasificador());
                cancellationReason.setDescription(parametricasDto.getDescripcion());
                cancellationReason.setExpirationDate(calendar.getTime());
                cancellationReason.setBranchOffice(branchOffice);
                cancellationReason.setPosCode(posCode);
                this.cancellationReasonRepository.save((Object)cancellationReason);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaParametricas syncOriginCountries(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarParametricaPaisOrigen...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaParametricas response = this.syncOriginCountriesFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncOriginCountriesSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaParametricas syncOriginCountriesFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.originCountryRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List originCountries = this.originCountryRepository.getOriginCountryByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaParametricas response = new ObjectFactory().createRespuestaListaParametricas();
            response.setTransaccion(Boolean.valueOf(false));
            for (OriginCountry originCountry : originCountries) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), originCountry.isExpired()));
                ParametricasDto parametricasDto = new ObjectFactory().createParametricasDto();
                parametricasDto.setCodigoClasificador(originCountry.getCode());
                parametricasDto.setDescripcion(originCountry.getDescription());
                response.getListaCodigos().add(parametricasDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaParametricas syncOriginCountriesSiat(Integer branchOffice, Integer posCode, RespuestaListaParametricas expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaParametricas response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarParametricaPaisOrigen(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ParametricasDto parametricasDto : response.getListaCodigos()) {
                OriginCountry originCountry = new OriginCountry();
                originCountry.setCode(parametricasDto.getCodigoClasificador());
                originCountry.setDescription(parametricasDto.getDescripcion());
                originCountry.setExpirationDate(calendar.getTime());
                originCountry.setBranchOffice(branchOffice);
                originCountry.setPosCode(posCode);
                this.originCountryRepository.save((Object)originCountry);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaParametricas syncIdentityDocumentTypes(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarParametricaTipoDocumentoIdentidad...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaParametricas response = this.syncIdentityDocumentTypesFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncIdentityDocumentTypesSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaParametricas syncIdentityDocumentTypesFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.identityDocumentTypeRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List identityDocumentTypes = this.identityDocumentTypeRepository.getIdentityDocumentTypeByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaParametricas response = new ObjectFactory().createRespuestaListaParametricas();
            response.setTransaccion(Boolean.valueOf(false));
            for (IdentityDocumentType identityDocumentType : identityDocumentTypes) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), identityDocumentType.isExpired()));
                ParametricasDto parametricasDto = new ObjectFactory().createParametricasDto();
                parametricasDto.setCodigoClasificador(identityDocumentType.getCode());
                parametricasDto.setDescripcion(identityDocumentType.getDescription());
                response.getListaCodigos().add(parametricasDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaParametricas syncIdentityDocumentTypesSiat(Integer branchOffice, Integer posCode, RespuestaListaParametricas expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaParametricas response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarParametricaTipoDocumentoIdentidad(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ParametricasDto parametricasDto : response.getListaCodigos()) {
                IdentityDocumentType identityDocumentType = new IdentityDocumentType();
                identityDocumentType.setCode(parametricasDto.getCodigoClasificador());
                identityDocumentType.setDescription(parametricasDto.getDescripcion());
                identityDocumentType.setExpirationDate(calendar.getTime());
                identityDocumentType.setBranchOffice(branchOffice);
                identityDocumentType.setPosCode(posCode);
                this.identityDocumentTypeRepository.save((Object)identityDocumentType);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaParametricas syncSectorDocumentTypes(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarParametricaTipoDocumentoSector...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaParametricas response = this.syncSectorDocumentTypesFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncSectorDocumentTypesSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaParametricas syncSectorDocumentTypesFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.sectorDocumentTypeRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List sectorDocumentTypes = this.sectorDocumentTypeRepository.getSectorDocumentTypeByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaParametricas response = new ObjectFactory().createRespuestaListaParametricas();
            response.setTransaccion(Boolean.valueOf(false));
            for (SectorDocumentType sectorDocumentType : sectorDocumentTypes) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), sectorDocumentType.isExpired()));
                ParametricasDto parametricasDto = new ObjectFactory().createParametricasDto();
                parametricasDto.setCodigoClasificador(sectorDocumentType.getCode());
                parametricasDto.setDescripcion(sectorDocumentType.getDescription());
                response.getListaCodigos().add(parametricasDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaParametricas syncSectorDocumentTypesSiat(Integer branchOffice, Integer posCode, RespuestaListaParametricas expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaParametricas response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarParametricaTipoDocumentoSector(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ParametricasDto parametricasDto : response.getListaCodigos()) {
                SectorDocumentType sectorDocumentType = new SectorDocumentType();
                sectorDocumentType.setCode(parametricasDto.getCodigoClasificador());
                sectorDocumentType.setDescription(parametricasDto.getDescripcion());
                sectorDocumentType.setExpirationDate(calendar.getTime());
                sectorDocumentType.setBranchOffice(branchOffice);
                sectorDocumentType.setPosCode(posCode);
                this.sectorDocumentTypeRepository.save((Object)sectorDocumentType);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaParametricas syncEmissionTypes(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarParametricaTipoEmision...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaParametricas response = this.syncEmissionTypesFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncEmissionTypesSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaParametricas syncEmissionTypesFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.emissionTypeRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List emissionTypes = this.emissionTypeRepository.getEmissionTypeByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaParametricas response = new ObjectFactory().createRespuestaListaParametricas();
            response.setTransaccion(Boolean.valueOf(false));
            for (EmissionType emissionType : emissionTypes) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), emissionType.isExpired()));
                ParametricasDto parametricasDto = new ObjectFactory().createParametricasDto();
                parametricasDto.setCodigoClasificador(emissionType.getCode());
                parametricasDto.setDescripcion(emissionType.getDescription());
                response.getListaCodigos().add(parametricasDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaParametricas syncEmissionTypesSiat(Integer branchOffice, Integer posCode, RespuestaListaParametricas expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaParametricas response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarParametricaTipoEmision(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ParametricasDto parametricasDto : response.getListaCodigos()) {
                EmissionType emissionType = new EmissionType();
                emissionType.setCode(parametricasDto.getCodigoClasificador());
                emissionType.setDescription(parametricasDto.getDescripcion());
                emissionType.setExpirationDate(calendar.getTime());
                emissionType.setBranchOffice(branchOffice);
                emissionType.setPosCode(posCode);
                this.emissionTypeRepository.save((Object)emissionType);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaParametricas syncRoomTypes(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarParametricaTipoHabitacion...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaParametricas response = this.syncRoomTypesFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncRoomTypesSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaParametricas syncRoomTypesFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.roomTypeRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List roomTypes = this.roomTypeRepository.getRoomTypeByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaParametricas response = new ObjectFactory().createRespuestaListaParametricas();
            response.setTransaccion(Boolean.valueOf(false));
            for (RoomType roomType : roomTypes) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), roomType.isExpired()));
                ParametricasDto parametricasDto = new ObjectFactory().createParametricasDto();
                parametricasDto.setCodigoClasificador(roomType.getCode());
                parametricasDto.setDescripcion(roomType.getDescription());
                response.getListaCodigos().add(parametricasDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaParametricas syncRoomTypesSiat(Integer branchOffice, Integer posCode, RespuestaListaParametricas expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaParametricas response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarParametricaTipoHabitacion(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ParametricasDto parametricasDto : response.getListaCodigos()) {
                RoomType roomType = new RoomType();
                roomType.setCode(parametricasDto.getCodigoClasificador());
                roomType.setDescription(parametricasDto.getDescripcion());
                roomType.setExpirationDate(calendar.getTime());
                roomType.setBranchOffice(branchOffice);
                roomType.setPosCode(posCode);
                this.roomTypeRepository.save((Object)roomType);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaParametricas syncPaymentMethodTypes(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarParametricaTipoMetodoPago...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaParametricas response = this.syncPaymentMethodTypesFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncPaymentMethodTypesSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaParametricas syncPaymentMethodTypesFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.paymentMethodTypeRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List paymentMethodTypes = this.paymentMethodTypeRepository.getPaymentMethodTypeByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaParametricas response = new ObjectFactory().createRespuestaListaParametricas();
            response.setTransaccion(Boolean.valueOf(false));
            for (PaymentMethodType paymentMethodType : paymentMethodTypes) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), paymentMethodType.isExpired()));
                ParametricasDto parametricasDto = new ObjectFactory().createParametricasDto();
                parametricasDto.setCodigoClasificador(paymentMethodType.getCode());
                parametricasDto.setDescripcion(paymentMethodType.getDescription());
                response.getListaCodigos().add(parametricasDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaParametricas syncPaymentMethodTypesSiat(Integer branchOffice, Integer posCode, RespuestaListaParametricas expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaParametricas response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarParametricaTipoMetodoPago(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ParametricasDto parametricasDto : response.getListaCodigos()) {
                PaymentMethodType paymentMethodType = new PaymentMethodType();
                paymentMethodType.setCode(parametricasDto.getCodigoClasificador());
                paymentMethodType.setDescription(parametricasDto.getDescripcion());
                paymentMethodType.setExpirationDate(calendar.getTime());
                paymentMethodType.setBranchOffice(branchOffice);
                paymentMethodType.setPosCode(posCode);
                this.paymentMethodTypeRepository.save((Object)paymentMethodType);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaParametricas syncCurrencyTypes(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarParametricaTipoMoneda...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaParametricas response = this.syncCurrencyTypesFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncCurrencyTypesSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaParametricas syncCurrencyTypesFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.currencyTypeRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List currencyTypes = this.currencyTypeRepository.getCurrencyTypeByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaParametricas response = new ObjectFactory().createRespuestaListaParametricas();
            response.setTransaccion(Boolean.valueOf(false));
            for (CurrencyType currencyType : currencyTypes) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), currencyType.isExpired()));
                ParametricasDto parametricasDto = new ObjectFactory().createParametricasDto();
                parametricasDto.setCodigoClasificador(currencyType.getCode());
                parametricasDto.setDescripcion(currencyType.getDescription());
                response.getListaCodigos().add(parametricasDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaParametricas syncCurrencyTypesSiat(Integer branchOffice, Integer posCode, RespuestaListaParametricas expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaParametricas response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarParametricaTipoMoneda(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ParametricasDto parametricasDto : response.getListaCodigos()) {
                CurrencyType currencyType = new CurrencyType();
                currencyType.setCode(parametricasDto.getCodigoClasificador());
                currencyType.setDescription(parametricasDto.getDescripcion());
                currencyType.setExpirationDate(calendar.getTime());
                currencyType.setBranchOffice(branchOffice);
                currencyType.setPosCode(posCode);
                this.currencyTypeRepository.save((Object)currencyType);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaParametricas syncPointOfSaleTypes(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarParametricaTipoPuntoVenta...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaParametricas response = this.syncPointOfSaleTypesFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncPointOfSaleTypesSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaParametricas syncPointOfSaleTypesFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.pointOfSaleTypeRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List pointOfSaleTypes = this.pointOfSaleTypeRepository.getPointOfSaleTypesByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaParametricas response = new ObjectFactory().createRespuestaListaParametricas();
            response.setTransaccion(Boolean.valueOf(false));
            for (PointOfSaleType pointOfSaleType : pointOfSaleTypes) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), pointOfSaleType.isExpired()));
                ParametricasDto parametricasDto = new ObjectFactory().createParametricasDto();
                parametricasDto.setCodigoClasificador(pointOfSaleType.getCode());
                parametricasDto.setDescripcion(pointOfSaleType.getDescription());
                response.getListaCodigos().add(parametricasDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaParametricas syncPointOfSaleTypesSiat(Integer branchOffice, Integer posCode, RespuestaListaParametricas expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaParametricas response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarParametricaTipoPuntoVenta(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ParametricasDto parametricasDto : response.getListaCodigos()) {
                PointOfSaleType pointOfSaleType = new PointOfSaleType();
                pointOfSaleType.setCode(parametricasDto.getCodigoClasificador());
                pointOfSaleType.setDescription(parametricasDto.getDescripcion());
                pointOfSaleType.setExpirationDate(calendar.getTime());
                pointOfSaleType.setBranchOffice(branchOffice);
                pointOfSaleType.setPosCode(posCode);
                this.pointOfSaleTypeRepository.save((Object)pointOfSaleType);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaParametricas syncBillTypes(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarParametricaTiposFactura...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaParametricas response = this.syncBillTypesFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncBillTypesSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaParametricas syncBillTypesFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.billTypeRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List billTypes = this.billTypeRepository.getBillTypeByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaParametricas response = new ObjectFactory().createRespuestaListaParametricas();
            response.setTransaccion(Boolean.valueOf(false));
            for (BillType billType : billTypes) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), billType.isExpired()));
                ParametricasDto parametricasDto = new ObjectFactory().createParametricasDto();
                parametricasDto.setCodigoClasificador(billType.getCode());
                parametricasDto.setDescripcion(billType.getDescription());
                response.getListaCodigos().add(parametricasDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaParametricas syncBillTypesSiat(Integer branchOffice, Integer posCode, RespuestaListaParametricas expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaParametricas response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarParametricaTiposFactura(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ParametricasDto parametricasDto : response.getListaCodigos()) {
                BillType billType = new BillType();
                billType.setCode(parametricasDto.getCodigoClasificador());
                billType.setDescription(parametricasDto.getDescripcion());
                billType.setExpirationDate(calendar.getTime());
                billType.setBranchOffice(branchOffice);
                billType.setPosCode(posCode);
                this.billTypeRepository.save((Object)billType);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    public RespuestaListaParametricas syncMeasureUnits(Integer branchOffice, Integer posCode) {
        logger.debug("Invoking sincronizarParametricaTiposFactura...");
        AtomicBoolean isExpiredCache = new AtomicBoolean(false);
        RespuestaListaParametricas response = this.syncMeasureUnitsFromCache(branchOffice, posCode, isExpiredCache);
        if (response == null || isExpiredCache.get()) {
            response = this.syncMeasureUnitsSiat(branchOffice, posCode, response);
        }
        return response;
    }

    private RespuestaListaParametricas syncMeasureUnitsFromCache(Integer branchOffice, Integer posCode, AtomicBoolean isExpiredCache) {
        List cacheDates = this.measureUnitRepository.getCacheDates(branchOffice, posCode);
        if (cacheDates.size() > 0) {
            Date maxCacheDate = (Date)cacheDates.get(0);
            List measureUnits = this.measureUnitRepository.getMeasureUnitByBranchOfficeEqualsAndPosCodeEqualsAndExpirationDateEquals(branchOffice, posCode, maxCacheDate);
            RespuestaListaParametricas response = new ObjectFactory().createRespuestaListaParametricas();
            response.setTransaccion(Boolean.valueOf(false));
            for (MeasureUnit measureUnit : measureUnits) {
                isExpiredCache.set(Boolean.logicalOr(isExpiredCache.get(), measureUnit.isExpired()));
                ParametricasDto parametricasDto = new ObjectFactory().createParametricasDto();
                parametricasDto.setCodigoClasificador(measureUnit.getCode());
                parametricasDto.setDescripcion(measureUnit.getDescription());
                response.getListaCodigos().add(parametricasDto);
            }
            logger.debug("Cache expired = {}", (Object)isExpiredCache.get());
            return response;
        }
        return null;
    }

    private RespuestaListaParametricas syncMeasureUnitsSiat(Integer branchOffice, Integer posCode, RespuestaListaParametricas expiredResponse) {
        try {
            SolicitudSincronizacion request = this.buildRequest(branchOffice, posCode);
            RespuestaListaParametricas response = this.getPort(this.eBillingAppConfig.getToken()).sincronizarParametricaUnidadMedida(request);
            GregorianCalendar calendar = Util.getNewGregorianCalendar();
            calendar.add(10, 24);
            for (ParametricasDto parametricasDto : response.getListaCodigos()) {
                MeasureUnit measureUnit = new MeasureUnit();
                measureUnit.setCode(parametricasDto.getCodigoClasificador());
                measureUnit.setDescription(parametricasDto.getDescripcion());
                measureUnit.setExpirationDate(calendar.getTime());
                measureUnit.setBranchOffice(branchOffice);
                measureUnit.setPosCode(posCode);
                this.measureUnitRepository.save((Object)measureUnit);
            }
            logger.debug("Result from service, cache was updated.");
            return response;
        }
        catch (Exception e) {
            if (expiredResponse == null) {
                logger.error("SIAT is not responding. Dying gracefully.");
                throw new SiatNotRespondingException("SIAT is not responding. Dying gracefully.");
            }
            logger.error("SIAT is not responding. Result from old cache.");
            return expiredResponse;
        }
    }

    private ServicioFacturacionSincronizacion getPort(String token) {
        URL wsdlURL = ServicioFacturacionSincronizacion_Service.WSDL_LOCATION;
        ServicioFacturacionSincronizacion_Service ss = new ServicioFacturacionSincronizacion_Service(wsdlURL, SERVICE_NAME);
        ServicioFacturacionSincronizacion port = ss.getServicioFacturacionSincronizacionPort();
        Map req_ctx = ((BindingProvider)port).getRequestContext();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("apikey", Collections.singletonList("TokenApi " + token));
        req_ctx.put("javax.xml.ws.http.request.headers", headers);
        return port;
    }

    private SolicitudSincronizacion buildRequest(Integer branchOffice, Integer posCode) {
        ObjectFactory factory = new ObjectFactory();
        SolicitudSincronizacion request = factory.createSolicitudSincronizacion();
        request.setCodigoAmbiente(this.eBillingAppConfig.getEnvironmentCode().intValue());
        request.setCodigoSistema("6D23688410B63B72FBD7EC6");
        request.setNit(EBillingAppConfig.NIT.longValue());
        request.setCuis(this.cuisService.getCuis(branchOffice, posCode).getCodigo());
        request.setCodigoSucursal(branchOffice.intValue());
        request.setCodigoPuntoVenta(factory.createSolicitudSincronizacionCodigoPuntoVenta(posCode));
        return request;
    }
}

