<?php
/**
 * Counter
 *
 * @author WolfThemes
 * @category Core
 * @package WolfWPBakeryPageBuilderExtension/Elements
 * @version 3.2.8
 */

defined( 'ABSPATH' ) || exit;

// inspired by js_composer/conifg/buttons/shortcode-vc-button.php
$icons_params = vc_map_integrate_shortcode( wvc_icon_params(), 'i_', '', array(
	'include_only_regex' => '/^(type|icon_\w*)/',
) );

// populate integrated vc_icons params.
if ( is_array( $icons_params ) && ! empty( $icons_params ) ) {
	foreach ( $icons_params as $key => $param ) {
		if ( is_array( $param ) && ! empty( $param ) ) {

			if ( 'i_type' == $param['param_name'] ) {
				// force dependency
				$icons_params[ $key ]['dependency'] = array(
					'element' => 'add_icon',
					'value' => 'true',
				);
			}
		}
	}
}

// Counter
vc_map(
	array(
		'name' => esc_html__( 'Counter', 'wolf-visual-composer' ),
		'description' => esc_html__( 'Animated numerical data', 'wolf-visual-composer' ),
		'base' => 'wvc_counter',
		'category' => esc_html__( 'Content' , 'wolf-visual-composer' ),
		'icon' => 'fa fa-tachometer',
		'params' => array_merge(
			array(
				array(
					'type' => 'wvc_textfield',
					'heading' => esc_html__( 'Number', 'wolf-visual-composer' ),
					'param_name' => 'number',
					'description' => esc_html__( 'It can be a shortcode that generates a number in this case paste your shortcode without the brackets and check the option below.', 'wolf-visual-composer' ),
					'admin_label' => true,
				),

				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Is your number generated by a shortcode?', 'wolf-visual-composer' ),
					'param_name' => 'shortcode',
				),

				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Text Alignment', 'wolf-visual-composer' ),
					'param_name' => 'text_alignment',
					'value' => array(
						esc_html__( 'Center', 'wolf-visual-composer' ) => 'center',
						esc_html__( 'Left', 'wolf-visual-composer' ) => 'left',
						esc_html__( 'Right', 'wolf-visual-composer' ) => 'right',
					),
				),

				array(
					'type' => 'wvc_textfield',
					'heading' => esc_html__( 'Font Size', 'wolf-visual-composer' ),
					'param_name' => 'font_size',
					'std' => 36,
				),

				array(
					'type' => 'wvc_textfield',
					'heading' => esc_html__( 'Font Weight', 'wolf-visual-composer' ),
					'param_name' => 'font_weight',
					'placeholder' => 400,
				),

				// array(
				// 	'type' => 'wvc_textfield',
				// 	'heading' => esc_html__( 'Duration (in ms)', 'wolf-visual-composer' ),
				// 	'param_name' => 'duration',
				// 	'placeholder' => 1000,
				// 	'display' => true,
				// ),

				// array(
				// 	'type' => 'wvc_textfield',
				// 	'heading' => esc_html__( 'Delay (in ms)', 'wolf-visual-composer' ),
				// 	'param_name' => 'delay',
				// 	'placeholder' => 10,
				// 	'display' => true,
				// ),

				array(
					'type' => 'wvc_textfield',
					'heading' => esc_html__( 'Text', 'wolf-visual-composer' ),
					'param_name' => 'text',
					'admin_label' => true,
				),

				array(
					'type' => 'wvc_font_family',
					'heading' => esc_html__( 'Font', 'wolf-visual-composer' ),
					'param_name' => 'font_family',
					'admin_label' => true,
				),

				array(
					'type' => 'wvc_textfield',
					'heading' => esc_html__( 'Prefix', 'wolf-visual-composer' ),
					'param_name' => 'prefix',
					'admin_label' => true,
				),

				array(
					'type' => 'wvc_textfield',
					'heading' => esc_html__( 'Suffix', 'wolf-visual-composer' ),
					'param_name' => 'suffix',
					'admin_label' => true,
				),

				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Add Icon', 'wolf-visual-composer' ),
					'param_name' => 'add_icon',
				),

				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Number Color', 'wolf-visual-composer' ),
					'param_name' => 'number_color',
					'value' => array_merge( wvc_get_shared_colors(), array(
							esc_html__( 'Default color', 'wolf-visual-composer' ) => 'default',
							esc_html__( 'Gradient Red', 'wolf-visual-composer' ) => 'gradient-red',
							esc_html__( 'Gradient Green', 'wolf-visual-composer' ) => 'gradient-green',
							esc_html__( 'Custom color', 'wolf-visual-composer' ) => 'custom',
						)
					),
					'std' => 'default',
					'description' => esc_html__( 'Select a number color.', 'wolf-visual-composer' ),
					'param_holder_class' => 'wvc_colored-dropdown',
					'group' => esc_html__( 'Colors', 'wolf-visual-composer' ),
				),

				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( 'Number Color', 'wolf-visual-composer' ),
					'param_name' => 'number_custom_color',
					'dependency' => array(
						'element' => 'number_color',
						'value' => 'custom',
					),
					'group' => esc_html__( 'Colors', 'wolf-visual-composer' ),
				),

				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Text Color', 'wolf-visual-composer' ),
					'param_name' => 'text_color',
					'value' => array_merge( wvc_get_shared_colors(), array(
							esc_html__( 'Default color', 'wolf-visual-composer' ) => 'default',
							esc_html__( 'Gradient Red', 'wolf-visual-composer' ) => 'gradient-red',
							esc_html__( 'Gradient Green', 'wolf-visual-composer' ) => 'gradient-green',
							esc_html__( 'Custom color', 'wolf-visual-composer' ) => 'custom',
						)
					),
					'std' => 'default',
					'description' => esc_html__( 'Select a text color.', 'wolf-visual-composer' ),
					'param_holder_class' => 'wvc_colored-dropdown',
					'group' => esc_html__( 'Colors', 'wolf-visual-composer' ),
				),

				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( 'Text Color', 'wolf-visual-composer' ),
					'param_name' => 'text_custom_color',
					'dependency' => array(
						'element' => 'text_color',
						'value' => 'custom',
					),
					'group' => esc_html__( 'Colors', 'wolf-visual-composer' ),
				),

				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Icon Color', 'wolf-visual-composer' ),
					'param_name' => 'icon_color',
					'value' => array_merge( wvc_get_shared_colors(), array(
							esc_html__( 'Default color', 'wolf-visual-composer' ) => 'default',
							esc_html__( 'Gradient Red', 'wolf-visual-composer' ) => 'gradient-red',
							esc_html__( 'Gradient Green', 'wolf-visual-composer' ) => 'gradient-green',
							esc_html__( 'Custom color', 'wolf-visual-composer' ) => 'custom',
						)
					),
					'std' => 'default',
					'description' => esc_html__( 'Select a text color.', 'wolf-visual-composer' ),
					'param_holder_class' => 'wvc_colored-dropdown',
					'group' => esc_html__( 'Colors', 'wolf-visual-composer' ),
				),

				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( 'Icon Color', 'wolf-visual-composer' ),
					'param_name' => 'icon_custom_color',
					'dependency' => array(
						'element' => 'icon_color',
						'value' => 'custom',
					),
					'group' => esc_html__( 'Colors', 'wolf-visual-composer' ),
				),

				// array(
				// 	'type' => 'dropdown',
				// 	'heading' => esc_html__( 'Prefix Color', 'wolf-visual-composer' ),
				// 	'param_name' => 'prefix_color',
				// 	'value' => array_merge( wvc_get_shared_colors(), array(
				// 			esc_html__( 'Default color', 'wolf-visual-composer' ) => 'default',
				// 			esc_html__( 'Custom color', 'wolf-visual-composer' ) => 'custom',
				// 		)
				// 	),
				// 	'std' => 'default',
				// 	'description' => esc_html__( 'Select a color.', 'wolf-visual-composer' ),
				// 	'param_holder_class' => 'wvc_colored-dropdown',
				// 	'group' => esc_html__( 'Colors', 'wolf-visual-composer' ),
				// ),

				// array(
				// 	'type' => 'colorpicker',
				// 	'heading' => esc_html__( 'Prefix Custom Color', 'wolf-visual-composer' ),
				// 	'param_name' => 'prefix_custom_color',
				// 	'dependency' => array(
				// 		'element' => 'prefix_color',
				// 		'value' => 'custom',
				// 	),
				// 	'group' => esc_html__( 'Colors', 'wolf-visual-composer' ),
				// ),

				// array(
				// 	'type' => 'dropdown',
				// 	'heading' => esc_html__( 'Suffix Color', 'wolf-visual-composer' ),
				// 	'param_name' => 'suffix_color',
				// 	'value' => array_merge( wvc_get_shared_colors(), array(
				// 			esc_html__( 'Default color', 'wolf-visual-composer' ) => 'default',
				// 			esc_html__( 'Custom color', 'wolf-visual-composer' ) => 'custom',
				// 		)
				// 	),
				// 	'std' => 'default',
				// 	'description' => esc_html__( 'Select a color.', 'wolf-visual-composer' ),
				// 	'param_holder_class' => 'wvc_colored-dropdown',
				// 	'group' => esc_html__( 'Colors', 'wolf-visual-composer' ),
				// ),

				// array(
				// 	'type' => 'colorpicker',
				// 	'heading' => esc_html__( 'Suffix Custom Color', 'wolf-visual-composer' ),
				// 	'param_name' => 'suffix_custom_color',
				// 	'dependency' => array(
				// 		'element' => 'suffix_color',
				// 		'value' => 'custom',
				// 	),
				// 	'group' => esc_html__( 'Colors', 'wolf-visual-composer' ),
				// ),
			),
			$icons_params
		),
	)
);

class WPBakeryShortCode_Wvc_Counter extends WPBakeryShortCode {}