<?php
/**
 * WPBakery Page Builder Extension Add cutom icon libraries
 *
 * Set default setttings values for in-built elements
 *
 * @author WolfThemes
 * @category Core
 * @package WolfWPBakeryPageBuilderExtension/Core
 * @version 3.2.8
 */

defined( 'ABSPATH' ) || exit;

/**
 * Add icon choice styles
 */
function wvc_icon_element_fonts_enqueue( $font ) {
	switch ( $font ) {
		case 'linea-icons':
			wp_enqueue_style( 'linea-icons' );
			break;
		case 'linearicons':
			wp_enqueue_style( 'linearicons' );
			break;
		case 'socicon':
			wp_enqueue_style( 'socicon' );
			break;
		case 'wolficons':
			wp_enqueue_style( 'wolficons' );
			break;
		case 'elegant-icons':
			wp_enqueue_style( 'elegant-icons' );
			break;
		case 'ionicons':
			wp_enqueue_style( 'ionicons' );
			break;
		case 'dripicons':
			wp_enqueue_style( 'dripicons' );
			break;
		case 'iconmonstr-iconic-font':
			wp_enqueue_style( 'iconmonstr-iconic-font' );
			break;
	}
}
add_action( 'vc_enqueue_font_icon_element', 'wvc_icon_element_fonts_enqueue' );

/**
 * Add Linea Icons
 *
 * @param $icons
 * @return array
 */
function wvc_add_linea_icons_font( $icons ) {

	$linea_icons = array(
		'Arrows' => array(
			array( 'linea-arrows-anticlockwise' => 'Arrows anticlockwise' ),
			array( 'linea-arrows-anticlockwise-dashed' => 'Arrows anticlockwise dashed' ),
			array( 'linea-arrows-button-down' => 'Arrows button down' ),
			array( 'linea-arrows-button-off' => 'Arrows button off' ),
			array( 'linea-arrows-button-on' => 'Arrows button on' ),
			array( 'linea-arrows-button-up' => 'Arrows button up' ),
			array( 'linea-arrows-check' => 'Arrows check' ),
			array( 'linea-arrows-circle-check' => 'Arrows circle check' ),
			array( 'linea-arrows-circle-down' => 'Arrows circle down' ),
			array( 'linea-arrows-circle-downleft' => 'Arrows circle downleft' ),
			array( 'linea-arrows-circle-downright' => 'Arrows circle downright' ),
			array( 'linea-arrows-circle-left' => 'Arrows circle left' ),
			array( 'linea-arrows-circle-minus' => 'Arrows circle minus' ),
			array( 'linea-arrows-circle-plus' => 'Arrows circle plus' ),
			array( 'linea-arrows-circle-remove' => 'Arrows circle remove' ),
			array( 'linea-arrows-circle-right' => 'Arrows circle right' ),
			array( 'linea-arrows-circle-up' => 'Arrows circle up' ),
			array( 'linea-arrows-circle-upleft' => 'Arrows circle upleft' ),
			array( 'linea-arrows-circle-upright' => 'Arrows circle upright' ),
			array( 'linea-arrows-clockwise' => 'Arrows clockwise' ),
			array( 'linea-arrows-clockwise-dashed' => 'Arrows clockwise dashed' ),
			array( 'linea-arrows-compress' => 'Arrows compress' ),
			array( 'linea-arrows-deny' => 'Arrows deny' ),
			array( 'linea-arrows-diagonal' => 'Arrows diagonal' ),
			array( 'linea-arrows-diagonal2' => 'Arrows diagonal2' ),
			array( 'linea-arrows-down' => 'Arrows down' ),
			array( 'linea-arrows-down-double' => 'Arrows down double' ),
			array( 'linea-arrows-downleft' => 'Arrows downleft' ),
			array( 'linea-arrows-downright' => 'Arrows downright' ),
			array( 'linea-arrows-drag-down' => 'Arrows drag down' ),
			array( 'linea-arrows-drag-down-dashed' => 'Arrows drag down dashed' ),
			array( 'linea-arrows-drag-horiz' => 'Arrows drag horiz' ),
			array( 'linea-arrows-drag-left' => 'Arrows drag left' ),
			array( 'linea-arrows-drag-left-dashed' => 'Arrows drag left dashed' ),
			array( 'linea-arrows-drag-right' => 'Arrows drag right' ),
			array( 'linea-arrows-drag-right-dashed' => 'Arrows drag right dashed' ),
			array( 'linea-arrows-drag-up' => 'Arrows drag up' ),
			array( 'linea-arrows-drag-up-dashed' => 'Arrows drag up dashed' ),
			array( 'linea-arrows-drag-vert' => 'Arrows drag vert' ),
			array( 'linea-arrows-exclamation' => 'Arrows exclamation' ),
			array( 'linea-arrows-expand' => 'Arrows expand' ),
			array( 'linea-arrows-expand-diagonal1' => 'Arrows expand diagonal1' ),
			array( 'linea-arrows-expand-horizontal1' => 'Arrows expand horizontal1' ),
			array( 'linea-arrows-expand-vertical1' => 'Arrows expand vertical1' ),
			array( 'linea-arrows-fit-horizontal' => 'Arrows fit horizontal' ),
			array( 'linea-arrows-fit-vertical' => 'Arrows fit vertical' ),
			array( 'linea-arrows-glide' => 'Arrows glide' ),
			array( 'linea-arrows-glide-horizontal' => 'Arrows glide horizontal' ),
			array( 'linea-arrows-glide-vertical' => 'Arrows glide vertical' ),
			array( 'linea-arrows-hamburger1' => 'Arrows hamburger1' ),
			array( 'linea-arrows-hamburger-2' => 'Arrows hamburger 2' ),
			array( 'linea-arrows-horizontal' => 'Arrows horizontal' ),
			array( 'linea-arrows-info' => 'Arrows info' ),
			array( 'linea-arrows-keyboard-alt' => 'Arrows keyboard alt' ),
			array( 'linea-arrows-keyboard-cmd' => 'Arrows keyboard cmd' ),
			array( 'linea-arrows-keyboard-delete' => 'Arrows keyboard delete' ),
			array( 'linea-arrows-keyboard-down' => 'Arrows keyboard down' ),
			array( 'linea-arrows-keyboard-left' => 'Arrows keyboard left' ),
			array( 'linea-arrows-keyboard-return' => 'Arrows keyboard return' ),
			array( 'linea-arrows-keyboard-right' => 'Arrows keyboard right' ),
			array( 'linea-arrows-keyboard-shift' => 'Arrows keyboard shift' ),
			array( 'linea-arrows-keyboard-tab' => 'Arrows keyboard tab' ),
			array( 'linea-arrows-keyboard-up' => 'Arrows keyboard up' ),
			array( 'linea-arrows-left' => 'Arrows left' ),
			array( 'linea-arrows-left-double-32' => 'Arrows left double 32' ),
			array( 'linea-arrows-minus' => 'Arrows minus' ),
			array( 'linea-arrows-move' => 'Arrows move' ),
			array( 'linea-arrows-move2' => 'Arrows move2' ),
			array( 'linea-arrows-move-bottom' => 'Arrows move bottom' ),
			array( 'linea-arrows-move-left' => 'Arrows move left' ),
			array( 'linea-arrows-move-right' => 'Arrows move right' ),
			array( 'linea-arrows-move-top' => 'Arrows move top' ),
			array( 'linea-arrows-plus' => 'Arrows plus' ),
			array( 'linea-arrows-question' => 'Arrows question' ),
			array( 'linea-arrows-remove' => 'Arrows remove' ),
			array( 'linea-arrows-right' => 'Arrows right' ),
			array( 'linea-arrows-right-double' => 'Arrows right double' ),
			array( 'linea-arrows-rotate' => 'Arrows rotate' ),
			array( 'linea-arrows-rotate-anti' => 'Arrows rotate anti' ),
			array( 'linea-arrows-rotate-anti-dashed' => 'Arrows rotate anti dashed' ),
			array( 'linea-arrows-rotate-dashed' => 'Arrows rotate dashed' ),
			array( 'linea-arrows-shrink' => 'Arrows shrink' ),
			array( 'linea-arrows-shrink-diagonal1' => 'Arrows shrink diagonal1' ),
			array( 'linea-arrows-shrink-diagonal2' => 'Arrows shrink diagonal2' ),
			array( 'linea-arrows-shrink-horizonal2' => 'Arrows shrink horizonal2' ),
			array( 'linea-arrows-shrink-horizontal1' => 'Arrows shrink horizontal1' ),
			array( 'linea-arrows-shrink-vertical1' => 'Arrows shrink vertical1' ),
			array( 'linea-arrows-shrink-vertical2' => 'Arrows shrink vertical2' ),
			array( 'linea-arrows-sign-down' => 'Arrows sign down' ),
			array( 'linea-arrows-sign-left' => 'Arrows sign left' ),
			array( 'linea-arrows-sign-right' => 'Arrows sign right' ),
			array( 'linea-arrows-sign-up' => 'Arrows sign up' ),
			array( 'linea-arrows-slide-down1' => 'Arrows slide down1' ),
			array( 'linea-arrows-slide-down2' => 'Arrows slide down2' ),
			array( 'linea-arrows-slide-left1' => 'Arrows slide left1' ),
			array( 'linea-arrows-slide-left2' => 'Arrows slide left2' ),
			array( 'linea-arrows-slide-right1' => 'Arrows slide right1' ),
			array( 'linea-arrows-slide-right2' => 'Arrows slide right2' ),
			array( 'linea-arrows-slide-up1' => 'Arrows slide up1' ),
			array( 'linea-arrows-slide-up2' => 'Arrows slide up2' ),
			array( 'linea-arrows-slim-down' => 'Arrows slim down' ),
			array( 'linea-arrows-slim-down-dashed' => 'Arrows slim down dashed' ),
			array( 'linea-arrows-slim-left' => 'Arrows slim left' ),
			array( 'linea-arrows-slim-left-dashed' => 'Arrows slim left dashed' ),
			array( 'linea-arrows-slim-right' => 'Arrows slim right' ),
			array( 'linea-arrows-slim-right-dashed' => 'Arrows slim right dashed' ),
			array( 'linea-arrows-slim-up' => 'Arrows slim up' ),
			array( 'linea-arrows-slim-up-dashed' => 'Arrows slim up dashed' ),
			array( 'linea-arrows-square-check' => 'Arrows square check' ),
			array( 'linea-arrows-square-down' => 'Arrows square down' ),
			array( 'linea-arrows-square-downleft' => 'Arrows square downleft' ),
			array( 'linea-arrows-square-downright' => 'Arrows square downright' ),
			array( 'linea-arrows-square-left' => 'Arrows square left' ),
			array( 'linea-arrows-square-minus' => 'Arrows square minus' ),
			array( 'linea-arrows-square-plus' => 'Arrows square plus' ),
			array( 'linea-arrows-square-remove' => 'Arrows square remove' ),
			array( 'linea-arrows-square-right' => 'Arrows square right' ),
			array( 'linea-arrows-square-up' => 'Arrows square up' ),
			array( 'linea-arrows-square-upleft' => 'Arrows square upleft' ),
			array( 'linea-arrows-square-upright' => 'Arrows square upright' ),
			array( 'linea-arrows-squares' => 'Arrows squares' ),
			array( 'linea-arrows-stretch-diagonal1' => 'Arrows stretch diagonal1' ),
			array( 'linea-arrows-stretch-diagonal2' => 'Arrows stretch diagonal2' ),
			array( 'linea-arrows-stretch-diagonal3' => 'Arrows stretch diagonal3' ),
			array( 'linea-arrows-stretch-diagonal4' => 'Arrows stretch diagonal4' ),
			array( 'linea-arrows-stretch-horizontal1' => 'Arrows stretch horizontal1' ),
			array( 'linea-arrows-stretch-horizontal2' => 'Arrows stretch horizontal2' ),
			array( 'linea-arrows-stretch-vertical1' => 'Arrows stretch vertical1' ),
			array( 'linea-arrows-stretch-vertical2' => 'Arrows stretch vertical2' ),
			array( 'linea-arrows-switch-horizontal' => 'Arrows switch horizontal' ),
			array( 'linea-arrows-switch-vertical' => 'Arrows switch vertical' ),
			array( 'linea-arrows-up' => 'Arrows up' ),
			array( 'linea-arrows-up-double-33' => 'Arrows up double 33' ),
			array( 'linea-arrows-upleft' => 'Arrows upleft' ),
			array( 'linea-arrows-upright' => 'Arrows upright' ),
			array( 'linea-arrows-vertical' => 'Arrows vertical' ),
		),
		'Basic' => array(
			array( 'linea-basic-accelerator' => 'Basic accelerator' ),
			array( 'linea-basic-alarm' => 'Basic alarm' ),
			array( 'linea-basic-anchor' => 'Basic anchor' ),
			array( 'linea-basic-anticlockwise' => 'Basic anticlockwise' ),
			array( 'linea-basic-archive' => 'Basic archive' ),
			array( 'linea-basic-archive-full' => 'Basic archive full' ),
			array( 'linea-basic-ban' => 'Basic ban' ),
			array( 'linea-basic-battery-charge' => 'Basic battery charge' ),
			array( 'linea-basic-battery-empty' => 'Basic battery empty' ),
			array( 'linea-basic-battery-full' => 'Basic battery full' ),
			array( 'linea-basic-battery-half' => 'Basic battery half' ),
			array( 'linea-basic-bolt' => 'Basic bolt' ),
			array( 'linea-basic-book' => 'Basic book' ),
			array( 'linea-basic-book-pen' => 'Basic book pen' ),
			array( 'linea-basic-book-pencil' => 'Basic book pencil' ),
			array( 'linea-basic-bookmark' => 'Basic bookmark' ),
			array( 'linea-basic-calculator' => 'Basic calculator' ),
			array( 'linea-basic-calendar' => 'Basic calendar' ),
			array( 'linea-basic-cards-diamonds' => 'Basic cards diamonds' ),
			array( 'linea-basic-cards-hearts' => 'Basic cards hearts' ),
			array( 'linea-basic-case' => 'Basic case' ),
			array( 'linea-basic-chronometer' => 'Basic chronometer' ),
			array( 'linea-basic-clessidre' => 'Basic clessidre' ),
			array( 'linea-basic-clock' => 'Basic clock' ),
			array( 'linea-basic-clockwise' => 'Basic clockwise' ),
			array( 'linea-basic-cloud' => 'Basic cloud' ),
			array( 'linea-basic-clubs' => 'Basic clubs' ),
			array( 'linea-basic-compass' => 'Basic compass' ),
			array( 'linea-basic-cup' => 'Basic cup' ),
			array( 'linea-basic-diamonds' => 'Basic diamonds' ),
			array( 'linea-basic-display' => 'Basic display' ),
			array( 'linea-basic-download' => 'Basic download' ),
			array( 'linea-basic-exclamation' => 'Basic exclamation' ),
			array( 'linea-basic-eye' => 'Basic eye' ),
			array( 'linea-basic-eye-closed' => 'Basic eye closed' ),
			array( 'linea-basic-female' => 'Basic female' ),
			array( 'linea-basic-flag1' => 'Basic flag1' ),
			array( 'linea-basic-flag2' => 'Basic flag2' ),
			array( 'linea-basic-floppydisk' => 'Basic floppydisk' ),
			array( 'linea-basic-folder' => 'Basic folder' ),
			array( 'linea-basic-folder-multiple' => 'Basic folder multiple' ),
			array( 'linea-basic-gear' => 'Basic gear' ),
			array( 'linea-basic-geolocalize-01' => 'Basic geolocalize 01' ),
			array( 'linea-basic-geolocalize-05' => 'Basic geolocalize 05' ),
			array( 'linea-basic-globe' => 'Basic globe' ),
			array( 'linea-basic-gunsight' => 'Basic gunsight' ),
			array( 'linea-basic-hammer' => 'Basic hammer' ),
			array( 'linea-basic-headset' => 'Basic headset' ),
			array( 'linea-basic-heart' => 'Basic heart' ),
			array( 'linea-basic-heart-broken' => 'Basic heart broken' ),
			array( 'linea-basic-helm' => 'Basic helm' ),
			array( 'linea-basic-home' => 'Basic home' ),
			array( 'linea-basic-info' => 'Basic info' ),
			array( 'linea-basic-ipod' => 'Basic ipod' ),
			array( 'linea-basic-joypad' => 'Basic joypad' ),
			array( 'linea-basic-key' => 'Basic key' ),
			array( 'linea-basic-keyboard' => 'Basic keyboard' ),
			array( 'linea-basic-laptop' => 'Basic laptop' ),
			array( 'linea-basic-life-buoy' => 'Basic life buoy' ),
			array( 'linea-basic-lightbulb' => 'Basic lightbulb' ),
			array( 'linea-basic-link' => 'Basic link' ),
			array( 'linea-basic-lock' => 'Basic lock' ),
			array( 'linea-basic-lock-open' => 'Basic lock open' ),
			array( 'linea-basic-magic-mouse' => 'Basic magic mouse' ),
			array( 'linea-basic-magnifier' => 'Basic magnifier' ),
			array( 'linea-basic-magnifier-minus' => 'Basic magnifier minus' ),
			array( 'linea-basic-magnifier-plus' => 'Basic magnifier plus' ),
			array( 'linea-basic-mail' => 'Basic mail' ),
			array( 'linea-basic-mail-multiple' => 'Basic mail multiple' ),
			array( 'linea-basic-mail-open' => 'Basic mail open' ),
			array( 'linea-basic-mail-open-text' => 'Basic mail open text' ),
			array( 'linea-basic-male' => 'Basic male' ),
			array( 'linea-basic-map' => 'Basic map' ),
			array( 'linea-basic-message' => 'Basic message' ),
			array( 'linea-basic-message-multiple' => 'Basic message multiple' ),
			array( 'linea-basic-message-txt' => 'Basic message txt' ),
			array( 'linea-basic-mixer2' => 'Basic mixer2' ),
			array( 'linea-basic-mouse' => 'Basic mouse' ),
			array( 'linea-basic-notebook' => 'Basic notebook' ),
			array( 'linea-basic-notebook-pen' => 'Basic notebook pen' ),
			array( 'linea-basic-notebook-pencil' => 'Basic notebook pencil' ),
			array( 'linea-basic-paperplane' => 'Basic paperplane' ),
			array( 'linea-basic-pencil-ruler' => 'Basic pencil ruler' ),
			array( 'linea-basic-pencil-ruler-pen' => 'Basic pencil ruler pen' ),
			array( 'linea-basic-photo' => 'Basic photo' ),
			array( 'linea-basic-picture' => 'Basic picture' ),
			array( 'linea-basic-picture-multiple' => 'Basic picture multiple' ),
			array( 'linea-basic-pin1' => 'Basic pin1' ),
			array( 'linea-basic-pin2' => 'Basic pin2' ),
			array( 'linea-basic-postcard' => 'Basic postcard' ),
			array( 'linea-basic-postcard-multiple' => 'Basic postcard multiple' ),
			array( 'linea-basic-printer' => 'Basic printer' ),
			array( 'linea-basic-question' => 'Basic question' ),
			array( 'linea-basic-rss' => 'Basic rss' ),
			array( 'linea-basic-server' => 'Basic server' ),
			array( 'linea-basic-server2' => 'Basic server2' ),
			array( 'linea-basic-server-cloud' => 'Basic server cloud' ),
			array( 'linea-basic-server-download' => 'Basic server download' ),
			array( 'linea-basic-server-upload' => 'Basic server upload' ),
			array( 'linea-basic-settings' => 'Basic settings' ),
			array( 'linea-basic-share' => 'Basic share' ),
			array( 'linea-basic-sheet' => 'Basic sheet' ),
			array( 'linea-basic-sheet-multiple' => 'Basic sheet multiple' ),
			array( 'linea-basic-sheet-pen' => 'Basic sheet pen' ),
			array( 'linea-basic-sheet-pencil' => 'Basic sheet pencil' ),
			array( 'linea-basic-sheet-txt' => 'Basic sheet txt' ),
			array( 'linea-basic-signs' => 'Basic signs' ),
			array( 'linea-basic-smartphone' => 'Basic smartphone' ),
			array( 'linea-basic-spades' => 'Basic spades' ),
			array( 'linea-basic-spread' => 'Basic spread' ),
			array( 'linea-basic-spread-bookmark' => 'Basic spread bookmark' ),
			array( 'linea-basic-spread-text' => 'Basic spread text' ),
			array( 'linea-basic-spread-text-bookmark' => 'Basic spread text bookmark' ),
			array( 'linea-basic-star' => 'Basic star' ),
			array( 'linea-basic-tablet' => 'Basic tablet' ),
			array( 'linea-basic-target' => 'Basic target' ),
			array( 'linea-basic-todo' => 'Basic todo' ),
			array( 'linea-basic-todo-pen' => 'Basic todo pen' ),
			array( 'linea-basic-todo-pencil' => 'Basic todo pencil' ),
			array( 'linea-basic-todo-txt' => 'Basic todo txt' ),
			array( 'linea-basic-todolist-pen' => 'Basic todolist pen' ),
			array( 'linea-basic-todolist-pencil' => 'Basic todolist pencil' ),
			array( 'linea-basic-trashcan' => 'Basic trashcan' ),
			array( 'linea-basic-trashcan-full' => 'Basic trashcan full' ),
			array( 'linea-basic-trashcan-refresh' => 'Basic trashcan refresh' ),
			array( 'linea-basic-trashcan-remove' => 'Basic trashcan remove' ),
			array( 'linea-basic-upload' => 'Basic upload' ),
			array( 'linea-basic-usb' => 'Basic usb' ),
			array( 'linea-basic-video' => 'Basic video' ),
			array( 'linea-basic-watch' => 'Basic watch' ),
			array( 'linea-basic-webpage' => 'Basic webpage' ),
			array( 'linea-basic-webpage-img-txt' => 'Basic webpage img txt' ),
			array( 'linea-basic-webpage-multiple' => 'Basic webpage multiple' ),
			array( 'linea-basic-webpage-txt' => 'Basic webpage txt' ),
			array( 'linea-basic-world' => 'Basic world' ),
		),
		'Elaboration' => array(
			array( 'linea-basic-elaboration-bookmark-checck' => 'Basic elaboration bookmark checck' ),
			array( 'linea-basic-elaboration-bookmark-minus' => 'Basic elaboration bookmark minus' ),
			array( 'linea-basic-elaboration-bookmark-plus' => 'Basic elaboration bookmark plus' ),
			array( 'linea-basic-elaboration-bookmark-remove' => 'Basic elaboration bookmark remove' ),
			array( 'linea-basic-elaboration-briefcase-check' => 'Basic elaboration briefcase check' ),
			array( 'linea-basic-elaboration-briefcase-download' => 'Basic elaboration briefcase download' ),
			array( 'linea-basic-elaboration-briefcase-flagged' => 'Basic elaboration briefcase flagged' ),
			array( 'linea-basic-elaboration-briefcase-minus' => 'Basic elaboration briefcase minus' ),
			array( 'linea-basic-elaboration-briefcase-plus' => 'Basic elaboration briefcase plus' ),
			array( 'linea-basic-elaboration-briefcase-refresh' => 'Basic elaboration briefcase refresh' ),
			array( 'linea-basic-elaboration-briefcase-remove' => 'Basic elaboration briefcase remove' ),
			array( 'linea-basic-elaboration-briefcase-search' => 'Basic elaboration briefcase search' ),
			array( 'linea-basic-elaboration-briefcase-star' => 'Basic elaboration briefcase star' ),
			array( 'linea-basic-elaboration-briefcase-upload' => 'Basic elaboration briefcase upload' ),
			array( 'linea-basic-elaboration-browser-check' => 'Basic elaboration browser check' ),
			array( 'linea-basic-elaboration-browser-download' => 'Basic elaboration browser download' ),
			array( 'linea-basic-elaboration-browser-minus' => 'Basic elaboration browser minus' ),
			array( 'linea-basic-elaboration-browser-plus' => 'Basic elaboration browser plus' ),
			array( 'linea-basic-elaboration-browser-refresh' => 'Basic elaboration browser refresh' ),
			array( 'linea-basic-elaboration-browser-remove' => 'Basic elaboration browser remove' ),
			array( 'linea-basic-elaboration-browser-search' => 'Basic elaboration browser search' ),
			array( 'linea-basic-elaboration-browser-star' => 'Basic elaboration browser star' ),
			array( 'linea-basic-elaboration-browser-upload' => 'Basic elaboration browser upload' ),
			array( 'linea-basic-elaboration-calendar-check' => 'Basic elaboration calendar check' ),
			array( 'linea-basic-elaboration-calendar-cloud' => 'Basic elaboration calendar cloud' ),
			array( 'linea-basic-elaboration-calendar-download' => 'Basic elaboration calendar download' ),
			array( 'linea-basic-elaboration-calendar-empty' => 'Basic elaboration calendar empty' ),
			array( 'linea-basic-elaboration-calendar-flagged' => 'Basic elaboration calendar flagged' ),
			array( 'linea-basic-elaboration-calendar-heart' => 'Basic elaboration calendar heart' ),
			array( 'linea-basic-elaboration-calendar-minus' => 'Basic elaboration calendar minus' ),
			array( 'linea-basic-elaboration-calendar-next' => 'Basic elaboration calendar next' ),
			array( 'linea-basic-elaboration-calendar-noaccess' => 'Basic elaboration calendar noaccess' ),
			array( 'linea-basic-elaboration-calendar-pencil' => 'Basic elaboration calendar pencil' ),
			array( 'linea-basic-elaboration-calendar-plus' => 'Basic elaboration calendar plus' ),
			array( 'linea-basic-elaboration-calendar-previous' => 'Basic elaboration calendar previous' ),
			array( 'linea-basic-elaboration-calendar-refresh' => 'Basic elaboration calendar refresh' ),
			array( 'linea-basic-elaboration-calendar-remove' => 'Basic elaboration calendar remove' ),
			array( 'linea-basic-elaboration-calendar-search' => 'Basic elaboration calendar search' ),
			array( 'linea-basic-elaboration-calendar-star' => 'Basic elaboration calendar star' ),
			array( 'linea-basic-elaboration-calendar-upload' => 'Basic elaboration calendar upload' ),
			array( 'linea-basic-elaboration-cloud-check' => 'Basic elaboration cloud check' ),
			array( 'linea-basic-elaboration-cloud-download' => 'Basic elaboration cloud download' ),
			array( 'linea-basic-elaboration-cloud-minus' => 'Basic elaboration cloud minus' ),
			array( 'linea-basic-elaboration-cloud-noaccess' => 'Basic elaboration cloud noaccess' ),
			array( 'linea-basic-elaboration-cloud-plus' => 'Basic elaboration cloud plus' ),
			array( 'linea-basic-elaboration-cloud-refresh' => 'Basic elaboration cloud refresh' ),
			array( 'linea-basic-elaboration-cloud-remove' => 'Basic elaboration cloud remove' ),
			array( 'linea-basic-elaboration-cloud-search' => 'Basic elaboration cloud search' ),
			array( 'linea-basic-elaboration-cloud-upload' => 'Basic elaboration cloud upload' ),
			array( 'linea-basic-elaboration-document-check' => 'Basic elaboration document check' ),
			array( 'linea-basic-elaboration-document-cloud' => 'Basic elaboration document cloud' ),
			array( 'linea-basic-elaboration-document-download' => 'Basic elaboration document download' ),
			array( 'linea-basic-elaboration-document-flagged' => 'Basic elaboration document flagged' ),
			array( 'linea-basic-elaboration-document-graph' => 'Basic elaboration document graph' ),
			array( 'linea-basic-elaboration-document-heart' => 'Basic elaboration document heart' ),
			array( 'linea-basic-elaboration-document-minus' => 'Basic elaboration document minus' ),
			array( 'linea-basic-elaboration-document-next' => 'Basic elaboration document next' ),
			array( 'linea-basic-elaboration-document-noaccess' => 'Basic elaboration document noaccess' ),
			array( 'linea-basic-elaboration-document-note' => 'Basic elaboration document note' ),
			array( 'linea-basic-elaboration-document-pencil' => 'Basic elaboration document pencil' ),
			array( 'linea-basic-elaboration-document-picture' => 'Basic elaboration document picture' ),
			array( 'linea-basic-elaboration-document-plus' => 'Basic elaboration document plus' ),
			array( 'linea-basic-elaboration-document-previous' => 'Basic elaboration document previous' ),
			array( 'linea-basic-elaboration-document-refresh' => 'Basic elaboration document refresh' ),
			array( 'linea-basic-elaboration-document-remove' => 'Basic elaboration document remove' ),
			array( 'linea-basic-elaboration-document-search' => 'Basic elaboration document search' ),
			array( 'linea-basic-elaboration-document-star' => 'Basic elaboration document star' ),
			array( 'linea-basic-elaboration-document-upload' => 'Basic elaboration document upload' ),
			array( 'linea-basic-elaboration-folder-check' => 'Basic elaboration folder check' ),
			array( 'linea-basic-elaboration-folder-cloud' => 'Basic elaboration folder cloud' ),
			array( 'linea-basic-elaboration-folder-document' => 'Basic elaboration folder document' ),
			array( 'linea-basic-elaboration-folder-download' => 'Basic elaboration folder download' ),
			array( 'linea-basic-elaboration-folder-flagged' => 'Basic elaboration folder flagged' ),
			array( 'linea-basic-elaboration-folder-graph' => 'Basic elaboration folder graph' ),
			array( 'linea-basic-elaboration-folder-heart' => 'Basic elaboration folder heart' ),
			array( 'linea-basic-elaboration-folder-minus' => 'Basic elaboration folder minus' ),
			array( 'linea-basic-elaboration-folder-next' => 'Basic elaboration folder next' ),
			array( 'linea-basic-elaboration-folder-noaccess' => 'Basic elaboration folder noaccess' ),
			array( 'linea-basic-elaboration-folder-note' => 'Basic elaboration folder note' ),
			array( 'linea-basic-elaboration-folder-pencil' => 'Basic elaboration folder pencil' ),
			array( 'linea-basic-elaboration-folder-picture' => 'Basic elaboration folder picture' ),
			array( 'linea-basic-elaboration-folder-plus' => 'Basic elaboration folder plus' ),
			array( 'linea-basic-elaboration-folder-previous' => 'Basic elaboration folder previous' ),
			array( 'linea-basic-elaboration-folder-refresh' => 'Basic elaboration folder refresh' ),
			array( 'linea-basic-elaboration-folder-remove' => 'Basic elaboration folder remove' ),
			array( 'linea-basic-elaboration-folder-search' => 'Basic elaboration folder search' ),
			array( 'linea-basic-elaboration-folder-star' => 'Basic elaboration folder star' ),
			array( 'linea-basic-elaboration-folder-upload' => 'Basic elaboration folder upload' ),
			array( 'linea-basic-elaboration-mail-check' => 'Basic elaboration mail check' ),
			array( 'linea-basic-elaboration-mail-cloud' => 'Basic elaboration mail cloud' ),
			array( 'linea-basic-elaboration-mail-document' => 'Basic elaboration mail document' ),
			array( 'linea-basic-elaboration-mail-download' => 'Basic elaboration mail download' ),
			array( 'linea-basic-elaboration-mail-flagged' => 'Basic elaboration mail flagged' ),
			array( 'linea-basic-elaboration-mail-heart' => 'Basic elaboration mail heart' ),
			array( 'linea-basic-elaboration-mail-next' => 'Basic elaboration mail next' ),
			array( 'linea-basic-elaboration-mail-noaccess' => 'Basic elaboration mail noaccess' ),
			array( 'linea-basic-elaboration-mail-note' => 'Basic elaboration mail note' ),
			array( 'linea-basic-elaboration-mail-pencil' => 'Basic elaboration mail pencil' ),
			array( 'linea-basic-elaboration-mail-picture' => 'Basic elaboration mail picture' ),
			array( 'linea-basic-elaboration-mail-previous' => 'Basic elaboration mail previous' ),
			array( 'linea-basic-elaboration-mail-refresh' => 'Basic elaboration mail refresh' ),
			array( 'linea-basic-elaboration-mail-remove' => 'Basic elaboration mail remove' ),
			array( 'linea-basic-elaboration-mail-search' => 'Basic elaboration mail search' ),
			array( 'linea-basic-elaboration-mail-star' => 'Basic elaboration mail star' ),
			array( 'linea-basic-elaboration-mail-upload' => 'Basic elaboration mail upload' ),
			array( 'linea-basic-elaboration-message-check' => 'Basic elaboration message check' ),
			array( 'linea-basic-elaboration-message-dots' => 'Basic elaboration message dots' ),
			array( 'linea-basic-elaboration-message-happy' => 'Basic elaboration message happy' ),
			array( 'linea-basic-elaboration-message-heart' => 'Basic elaboration message heart' ),
			array( 'linea-basic-elaboration-message-minus' => 'Basic elaboration message minus' ),
			array( 'linea-basic-elaboration-message-note' => 'Basic elaboration message note' ),
			array( 'linea-basic-elaboration-message-plus' => 'Basic elaboration message plus' ),
			array( 'linea-basic-elaboration-message-refresh' => 'Basic elaboration message refresh' ),
			array( 'linea-basic-elaboration-message-remove' => 'Basic elaboration message remove' ),
			array( 'linea-basic-elaboration-message-sad' => 'Basic elaboration message sad' ),
			array( 'linea-basic-elaboration-smartphone-cloud' => 'Basic elaboration smartphone cloud' ),
			array( 'linea-basic-elaboration-smartphone-heart' => 'Basic elaboration smartphone heart' ),
			array( 'linea-basic-elaboration-smartphone-noaccess' => 'Basic elaboration smartphone noaccess' ),
			array( 'linea-basic-elaboration-smartphone-note' => 'Basic elaboration smartphone note' ),
			array( 'linea-basic-elaboration-smartphone-pencil' => 'Basic elaboration smartphone pencil' ),
			array( 'linea-basic-elaboration-smartphone-picture' => 'Basic elaboration smartphone picture' ),
			array( 'linea-basic-elaboration-smartphone-refresh' => 'Basic elaboration smartphone refresh' ),
			array( 'linea-basic-elaboration-smartphone-search' => 'Basic elaboration smartphone search' ),
			array( 'linea-basic-elaboration-tablet-cloud' => 'Basic elaboration tablet cloud' ),
			array( 'linea-basic-elaboration-tablet-heart' => 'Basic elaboration tablet heart' ),
			array( 'linea-basic-elaboration-tablet-noaccess' => 'Basic elaboration tablet noaccess' ),
			array( 'linea-basic-elaboration-tablet-note' => 'Basic elaboration tablet note' ),
			array( 'linea-basic-elaboration-tablet-pencil' => 'Basic elaboration tablet pencil' ),
			array( 'linea-basic-elaboration-tablet-picture' => 'Basic elaboration tablet picture' ),
			array( 'linea-basic-elaboration-tablet-refresh' => 'Basic elaboration tablet refresh' ),
			array( 'linea-basic-elaboration-tablet-search' => 'Basic elaboration tablet search' ),
			array( 'linea-basic-elaboration-todolist-2' => 'Basic elaboration todolist 2' ),
			array( 'linea-basic-elaboration-todolist-check' => 'Basic elaboration todolist check' ),
			array( 'linea-basic-elaboration-todolist-cloud' => 'Basic elaboration todolist cloud' ),
			array( 'linea-basic-elaboration-todolist-download' => 'Basic elaboration todolist download' ),
			array( 'linea-basic-elaboration-todolist-flagged' => 'Basic elaboration todolist flagged' ),
			array( 'linea-basic-elaboration-todolist-minus' => 'Basic elaboration todolist minus' ),
			array( 'linea-basic-elaboration-todolist-noaccess' => 'Basic elaboration todolist noaccess' ),
			array( 'linea-basic-elaboration-todolist-pencil' => 'Basic elaboration todolist pencil' ),
			array( 'linea-basic-elaboration-todolist-plus' => 'Basic elaboration todolist plus' ),
			array( 'linea-basic-elaboration-todolist-refresh' => 'Basic elaboration todolist refresh' ),
			array( 'linea-basic-elaboration-todolist-remove' => 'Basic elaboration todolist remove' ),
			array( 'linea-basic-elaboration-todolist-search' => 'Basic elaboration todolist search' ),
			array( 'linea-basic-elaboration-todolist-star' => 'Basic elaboration todolist star' ),
			array( 'linea-basic-elaboration-todolist-upload' => 'Basic elaboration todolist upload' ),
		),
		'Ecommerce' => array(
			array( 'linea-ecommerce-bag' => 'Ecommerce bag' ),
			array( 'linea-ecommerce-bag-check' => 'Ecommerce bag check' ),
			array( 'linea-ecommerce-bag-cloud' => 'Ecommerce bag cloud' ),
			array( 'linea-ecommerce-bag-download' => 'Ecommerce bag download' ),
			array( 'linea-ecommerce-bag-minus' => 'Ecommerce bag minus' ),
			array( 'linea-ecommerce-bag-plus' => 'Ecommerce bag plus' ),
			array( 'linea-ecommerce-bag-refresh' => 'Ecommerce bag refresh' ),
			array( 'linea-ecommerce-bag-remove' => 'Ecommerce bag remove' ),
			array( 'linea-ecommerce-bag-search' => 'Ecommerce bag search' ),
			array( 'linea-ecommerce-bag-upload' => 'Ecommerce bag upload' ),
			array( 'linea-ecommerce-banknote' => 'Ecommerce banknote' ),
			array( 'linea-ecommerce-banknotes' => 'Ecommerce banknotes' ),
			array( 'linea-ecommerce-basket' => 'Ecommerce basket' ),
			array( 'linea-ecommerce-basket-check' => 'Ecommerce basket check' ),
			array( 'linea-ecommerce-basket-cloud' => 'Ecommerce basket cloud' ),
			array( 'linea-ecommerce-basket-download' => 'Ecommerce basket download' ),
			array( 'linea-ecommerce-basket-minus' => 'Ecommerce basket minus' ),
			array( 'linea-ecommerce-basket-plus' => 'Ecommerce basket plus' ),
			array( 'linea-ecommerce-basket-refresh' => 'Ecommerce basket refresh' ),
			array( 'linea-ecommerce-basket-remove' => 'Ecommerce basket remove' ),
			array( 'linea-ecommerce-basket-search' => 'Ecommerce basket search' ),
			array( 'linea-ecommerce-basket-upload' => 'Ecommerce basket upload' ),
			array( 'linea-ecommerce-bath' => 'Ecommerce bath' ),
			array( 'linea-ecommerce-cart' => 'Ecommerce cart' ),
			array( 'linea-ecommerce-cart-check' => 'Ecommerce cart check' ),
			array( 'linea-ecommerce-cart-cloud' => 'Ecommerce cart cloud' ),
			array( 'linea-ecommerce-cart-content' => 'Ecommerce cart content' ),
			array( 'linea-ecommerce-cart-download' => 'Ecommerce cart download' ),
			array( 'linea-ecommerce-cart-minus' => 'Ecommerce cart minus' ),
			array( 'linea-ecommerce-cart-plus' => 'Ecommerce cart plus' ),
			array( 'linea-ecommerce-cart-refresh' => 'Ecommerce cart refresh' ),
			array( 'linea-ecommerce-cart-remove' => 'Ecommerce cart remove' ),
			array( 'linea-ecommerce-cart-search' => 'Ecommerce cart search' ),
			array( 'linea-ecommerce-cart-upload' => 'Ecommerce cart upload' ),
			array( 'linea-ecommerce-cent' => 'Ecommerce cent' ),
			array( 'linea-ecommerce-colon' => 'Ecommerce colon' ),
			array( 'linea-ecommerce-creditcard' => 'Ecommerce creditcard' ),
			array( 'linea-ecommerce-diamond' => 'Ecommerce diamond' ),
			array( 'linea-ecommerce-dollar' => 'Ecommerce dollar' ),
			array( 'linea-ecommerce-euro' => 'Ecommerce euro' ),
			array( 'linea-ecommerce-franc' => 'Ecommerce franc' ),
			array( 'linea-ecommerce-gift' => 'Ecommerce gift' ),
			array( 'linea-ecommerce-graph1' => 'Ecommerce graph1' ),
			array( 'linea-ecommerce-graph2' => 'Ecommerce graph2' ),
			array( 'linea-ecommerce-graph3' => 'Ecommerce graph3' ),
			array( 'linea-ecommerce-graph-decrease' => 'Ecommerce graph decrease' ),
			array( 'linea-ecommerce-graph-increase' => 'Ecommerce graph increase' ),
			array( 'linea-ecommerce-guarani' => 'Ecommerce guarani' ),
			array( 'linea-ecommerce-kips' => 'Ecommerce kips' ),
			array( 'linea-ecommerce-lira' => 'Ecommerce lira' ),
			array( 'linea-ecommerce-megaphone' => 'Ecommerce megaphone' ),
			array( 'linea-ecommerce-money' => 'Ecommerce money' ),
			array( 'linea-ecommerce-naira' => 'Ecommerce naira' ),
			array( 'linea-ecommerce-pesos' => 'Ecommerce pesos' ),
			array( 'linea-ecommerce-pound' => 'Ecommerce pound' ),
			array( 'linea-ecommerce-receipt' => 'Ecommerce receipt' ),
			array( 'linea-ecommerce-receipt-bath' => 'Ecommerce receipt bath' ),
			array( 'linea-ecommerce-receipt-cent' => 'Ecommerce receipt cent' ),
			array( 'linea-ecommerce-receipt-dollar' => 'Ecommerce receipt dollar' ),
			array( 'linea-ecommerce-receipt-euro' => 'Ecommerce receipt euro' ),
			array( 'linea-ecommerce-receipt-franc' => 'Ecommerce receipt franc' ),
			array( 'linea-ecommerce-receipt-guarani' => 'Ecommerce receipt guarani' ),
			array( 'linea-ecommerce-receipt-kips' => 'Ecommerce receipt kips' ),
			array( 'linea-ecommerce-receipt-lira' => 'Ecommerce receipt lira' ),
			array( 'linea-ecommerce-receipt-naira' => 'Ecommerce receipt naira' ),
			array( 'linea-ecommerce-receipt-pesos' => 'Ecommerce receipt pesos' ),
			array( 'linea-ecommerce-receipt-pound' => 'Ecommerce receipt pound' ),
			array( 'linea-ecommerce-receipt-rublo' => 'Ecommerce receipt rublo' ),
			array( 'linea-ecommerce-receipt-rupee' => 'Ecommerce receipt rupee' ),
			array( 'linea-ecommerce-receipt-tugrik' => 'Ecommerce receipt tugrik' ),
			array( 'linea-ecommerce-receipt-won' => 'Ecommerce receipt won' ),
			array( 'linea-ecommerce-receipt-yen' => 'Ecommerce receipt yen' ),
			array( 'linea-ecommerce-receipt-yen2' => 'Ecommerce receipt yen2' ),
			array( 'linea-ecommerce-recept-colon' => 'Ecommerce recept colon' ),
			array( 'linea-ecommerce-rublo' => 'Ecommerce rublo' ),
			array( 'linea-ecommerce-rupee' => 'Ecommerce rupee' ),
			array( 'linea-ecommerce-safe' => 'Ecommerce safe' ),
			array( 'linea-ecommerce-sale' => 'Ecommerce sale' ),
			array( 'linea-ecommerce-sales' => 'Ecommerce sales' ),
			array( 'linea-ecommerce-ticket' => 'Ecommerce ticket' ),
			array( 'linea-ecommerce-tugriks' => 'Ecommerce tugriks' ),
			array( 'linea-ecommerce-wallet' => 'Ecommerce wallet' ),
			array( 'linea-ecommerce-won' => 'Ecommerce won' ),
			array( 'linea-ecommerce-yen' => 'Ecommerce yen' ),
			array( 'linea-ecommerce-yen2' => 'Ecommerce yen2' ),
		),
		'Music' => array(
			array( 'linea-music-beginning-button' => 'Music beginning button' ),
			array( 'linea-music-bell' => 'Music bell' ),
			array( 'linea-music-cd' => 'Music cd' ),
			array( 'linea-music-diapason' => 'Music diapason' ),
			array( 'linea-music-eject-button' => 'Music eject button' ),
			array( 'linea-music-end-button' => 'Music end button' ),
			array( 'linea-music-fastforward-button' => 'Music fastforward button' ),
			array( 'linea-music-headphones' => 'Music headphones' ),
			array( 'linea-music-ipod' => 'Music ipod' ),
			array( 'linea-music-loudspeaker' => 'Music loudspeaker' ),
			array( 'linea-music-microphone' => 'Music microphone' ),
			array( 'linea-music-microphone-old' => 'Music microphone old' ),
			array( 'linea-music-mixer' => 'Music mixer' ),
			array( 'linea-music-mute' => 'Music mute' ),
			array( 'linea-music-note-multiple' => 'Music note multiple' ),
			array( 'linea-music-note-single' => 'Music note single' ),
			array( 'linea-music-pause-button' => 'Music pause button' ),
			array( 'linea-music-play-button' => 'Music play button' ),
			array( 'linea-music-playlist' => 'Music playlist' ),
			array( 'linea-music-radio-ghettoblaster' => 'Music radio ghettoblaster' ),
			array( 'linea-music-radio-portable' => 'Music radio portable' ),
			array( 'linea-music-record' => 'Music record' ),
			array( 'linea-music-recordplayer' => 'Music recordplayer' ),
			array( 'linea-music-repeat-button' => 'Music repeat button' ),
			array( 'linea-music-rewind-button' => 'Music rewind button' ),
			array( 'linea-music-shuffle-button' => 'Music shuffle button' ),
			array( 'linea-music-stop-button' => 'Music stop button' ),
			array( 'linea-music-tape' => 'Music tape' ),
			array( 'linea-music-volume-down' => 'Music volume down' ),
			array( 'linea-music-volume-up' => 'Music volume up' ),
		),
		'Software' => array(
			array( 'linea-software-add-vectorpoint' => 'Software add vectorpoint' ),
			array( 'linea-software-box-oval' => 'Software box oval' ),
			array( 'linea-software-box-polygon' => 'Software box polygon' ),
			array( 'linea-software-box-rectangle' => 'Software box rectangle' ),
			array( 'linea-software-box-roundedrectangle' => 'Software box roundedrectangle' ),
			array( 'linea-software-character' => 'Software character' ),
			array( 'linea-software-crop' => 'Software crop' ),
			array( 'linea-software-eyedropper' => 'Software eyedropper' ),
			array( 'linea-software-font-allcaps' => 'Software font allcaps' ),
			array( 'linea-software-font-baseline-shift' => 'Software font baseline shift' ),
			array( 'linea-software-font-horizontal-scale' => 'Software font horizontal scale' ),
			array( 'linea-software-font-kerning' => 'Software font kerning' ),
			array( 'linea-software-font-leading' => 'Software font leading' ),
			array( 'linea-software-font-size' => 'Software font size' ),
			array( 'linea-software-font-smallcapital' => 'Software font smallcapital' ),
			array( 'linea-software-font-smallcaps' => 'Software font smallcaps' ),
			array( 'linea-software-font-strikethrough' => 'Software font strikethrough' ),
			array( 'linea-software-font-tracking' => 'Software font tracking' ),
			array( 'linea-software-font-underline' => 'Software font underline' ),
			array( 'linea-software-font-vertical-scale' => 'Software font vertical scale' ),
			array( 'linea-software-horizontal-align-center' => 'Software horizontal align center' ),
			array( 'linea-software-horizontal-align-left' => 'Software horizontal align left' ),
			array( 'linea-software-horizontal-align-right' => 'Software horizontal align right' ),
			array( 'linea-software-horizontal-distribute-center' => 'Software horizontal distribute center' ),
			array( 'linea-software-horizontal-distribute-left' => 'Software horizontal distribute left' ),
			array( 'linea-software-horizontal-distribute-right' => 'Software horizontal distribute right' ),
			array( 'linea-software-indent-firstline' => 'Software indent firstline' ),
			array( 'linea-software-indent-left' => 'Software indent left' ),
			array( 'linea-software-indent-right' => 'Software indent right' ),
			array( 'linea-software-lasso' => 'Software lasso' ),
			array( 'linea-software-layers1' => 'Software layers1' ),
			array( 'linea-software-layers2' => 'Software layers2' ),
			array( 'linea-software-layout' => 'Software layout' ),
			array( 'linea-software-layout-2columns' => 'Software layout 2columns' ),
			array( 'linea-software-layout-3columns' => 'Software layout 3columns' ),
			array( 'linea-software-layout-4boxes' => 'Software layout 4boxes' ),
			array( 'linea-software-layout-4columns' => 'Software layout 4columns' ),
			array( 'linea-software-layout-4lines' => 'Software layout 4lines' ),
			array( 'linea-software-layout-8boxes' => 'Software layout 8boxes' ),
			array( 'linea-software-layout-header' => 'Software layout header' ),
			array( 'linea-software-layout-header-2columns' => 'Software layout header 2columns' ),
			array( 'linea-software-layout-header-3columns' => 'Software layout header 3columns' ),
			array( 'linea-software-layout-header-4boxes' => 'Software layout header 4boxes' ),
			array( 'linea-software-layout-header-4columns' => 'Software layout header 4columns' ),
			array( 'linea-software-layout-header-complex' => 'Software layout header complex' ),
			array( 'linea-software-layout-header-complex2' => 'Software layout header complex2' ),
			array( 'linea-software-layout-header-complex3' => 'Software layout header complex3' ),
			array( 'linea-software-layout-header-complex4' => 'Software layout header complex4' ),
			array( 'linea-software-layout-header-sideleft' => 'Software layout header sideleft' ),
			array( 'linea-software-layout-header-sideright' => 'Software layout header sideright' ),
			array( 'linea-software-layout-sidebar-left' => 'Software layout sidebar left' ),
			array( 'linea-software-layout-sidebar-right' => 'Software layout sidebar right' ),
			array( 'linea-software-magnete' => 'Software magnete' ),
			array( 'linea-software-pages' => 'Software pages' ),
			array( 'linea-software-paintbrush' => 'Software paintbrush' ),
			array( 'linea-software-paintbucket' => 'Software paintbucket' ),
			array( 'linea-software-paintroller' => 'Software paintroller' ),
			array( 'linea-software-paragraph' => 'Software paragraph' ),
			array( 'linea-software-paragraph-align-left' => 'Software paragraph align left' ),
			array( 'linea-software-paragraph-align-right' => 'Software paragraph align right' ),
			array( 'linea-software-paragraph-center' => 'Software paragraph center' ),
			array( 'linea-software-paragraph-justify-all' => 'Software paragraph justify all' ),
			array( 'linea-software-paragraph-justify-center' => 'Software paragraph justify center' ),
			array( 'linea-software-paragraph-justify-left' => 'Software paragraph justify left' ),
			array( 'linea-software-paragraph-justify-right' => 'Software paragraph justify right' ),
			array( 'linea-software-paragraph-space-after' => 'Software paragraph space after' ),
			array( 'linea-software-paragraph-space-before' => 'Software paragraph space before' ),
			array( 'linea-software-pathfinder-exclude' => 'Software pathfinder exclude' ),
			array( 'linea-software-pathfinder-intersect' => 'Software pathfinder intersect' ),
			array( 'linea-software-pathfinder-subtract' => 'Software pathfinder subtract' ),
			array( 'linea-software-pathfinder-unite' => 'Software pathfinder unite' ),
			array( 'linea-software-pen' => 'Software pen' ),
			array( 'linea-software-pen-add' => 'Software pen add' ),
			array( 'linea-software-pen-remove' => 'Software pen remove' ),
			array( 'linea-software-pencil' => 'Software pencil' ),
			array( 'linea-software-polygonallasso' => 'Software polygonallasso' ),
			array( 'linea-software-reflect-horizontal' => 'Software reflect horizontal' ),
			array( 'linea-software-reflect-vertical' => 'Software reflect vertical' ),
			array( 'linea-software-remove-vectorpoint' => 'Software remove vectorpoint' ),
			array( 'linea-software-scale-expand' => 'Software scale expand' ),
			array( 'linea-software-scale-reduce' => 'Software scale reduce' ),
			array( 'linea-software-selection-oval' => 'Software selection oval' ),
			array( 'linea-software-selection-polygon' => 'Software selection polygon' ),
			array( 'linea-software-selection-rectangle' => 'Software selection rectangle' ),
			array( 'linea-software-selection-roundedrectangle' => 'Software selection roundedrectangle' ),
			array( 'linea-software-shape-oval' => 'Software shape oval' ),
			array( 'linea-software-shape-polygon' => 'Software shape polygon' ),
			array( 'linea-software-shape-rectangle' => 'Software shape rectangle' ),
			array( 'linea-software-shape-roundedrectangle' => 'Software shape roundedrectangle' ),
			array( 'linea-software-slice' => 'Software slice' ),
			array( 'linea-software-transform-bezier' => 'Software transform bezier' ),
			array( 'linea-software-vector-box' => 'Software vector box' ),
			array( 'linea-software-vector-composite' => 'Software vector composite' ),
			array( 'linea-software-vector-line' => 'Software vector line' ),
			array( 'linea-software-vertical-align-bottom' => 'Software vertical align bottom' ),
			array( 'linea-software-vertical-align-center' => 'Software vertical align center' ),
			array( 'linea-software-vertical-align-top' => 'Software vertical align top' ),
			array( 'linea-software-vertical-distribute-bottom' => 'Software vertical distribute bottom' ),
			array( 'linea-software-vertical-distribute-center' => 'Software vertical distribute center' ),
			array( 'linea-software-vertical-distribute-top' => 'Software vertical distribute top' ),
		),
		'Weather' => array(
			array( 'linea-weather-aquarius' => 'Weather aquarius' ),
			array( 'linea-weather-aries' => 'Weather aries' ),
			array( 'linea-weather-cancer' => 'Weather cancer' ),
			array( 'linea-weather-capricorn' => 'Weather capricorn' ),
			array( 'linea-weather-cloud' => 'Weather cloud' ),
			array( 'linea-weather-cloud-drop' => 'Weather cloud drop' ),
			array( 'linea-weather-cloud-lightning' => 'Weather cloud lightning' ),
			array( 'linea-weather-cloud-snowflake' => 'Weather cloud snowflake' ),
			array( 'linea-weather-downpour-fullmoon' => 'Weather downpour fullmoon' ),
			array( 'linea-weather-downpour-halfmoon' => 'Weather downpour halfmoon' ),
			array( 'linea-weather-downpour-sun' => 'Weather downpour sun' ),
			array( 'linea-weather-drop' => 'Weather drop' ),
			array( 'linea-weather-first-quarter' => 'Weather first quarter' ),
			array( 'linea-weather-fog' => 'Weather fog' ),
			array( 'linea-weather-fog-fullmoon' => 'Weather fog fullmoon' ),
			array( 'linea-weather-fog-halfmoon' => 'Weather fog halfmoon' ),
			array( 'linea-weather-fog-sun' => 'Weather fog sun' ),
			array( 'linea-weather-fullmoon' => 'Weather fullmoon' ),
			array( 'linea-weather-gemini' => 'Weather gemini' ),
			array( 'linea-weather-hail' => 'Weather hail' ),
			array( 'linea-weather-hail-fullmoon' => 'Weather hail fullmoon' ),
			array( 'linea-weather-hail-halfmoon' => 'Weather hail halfmoon' ),
			array( 'linea-weather-hail-sun' => 'Weather hail sun' ),
			array( 'linea-weather-last-quarter' => 'Weather last quarter' ),
			array( 'linea-weather-leo' => 'Weather leo' ),
			array( 'linea-weather-libra' => 'Weather libra' ),
			array( 'linea-weather-lightning' => 'Weather lightning' ),
			array( 'linea-weather-mistyrain' => 'Weather mistyrain' ),
			array( 'linea-weather-mistyrain-fullmoon' => 'Weather mistyrain fullmoon' ),
			array( 'linea-weather-mistyrain-halfmoon' => 'Weather mistyrain halfmoon' ),
			array( 'linea-weather-mistyrain-sun' => 'Weather mistyrain sun' ),
			array( 'linea-weather-moon' => 'Weather moon' ),
			array( 'linea-weather-moondown-full' => 'Weather moondown full' ),
			array( 'linea-weather-moondown-half' => 'Weather moondown half' ),
			array( 'linea-weather-moonset-full' => 'Weather moonset full' ),
			array( 'linea-weather-moonset-half' => 'Weather moonset half' ),
			array( 'linea-weather-move2' => 'Weather move2' ),
			array( 'linea-weather-newmoon' => 'Weather newmoon' ),
			array( 'linea-weather-pisces' => 'Weather pisces' ),
			array( 'linea-weather-rain' => 'Weather rain' ),
			array( 'linea-weather-rain-fullmoon' => 'Weather rain fullmoon' ),
			array( 'linea-weather-rain-halfmoon' => 'Weather rain halfmoon' ),
			array( 'linea-weather-rain-sun' => 'Weather rain sun' ),
			array( 'linea-weather-sagittarius' => 'Weather sagittarius' ),
			array( 'linea-weather-scorpio' => 'Weather scorpio' ),
			array( 'linea-weather-snow' => 'Weather snow' ),
			array( 'linea-weather-snow-fullmoon' => 'Weather snow fullmoon' ),
			array( 'linea-weather-snow-halfmoon' => 'Weather snow halfmoon' ),
			array( 'linea-weather-snow-sun' => 'Weather snow sun' ),
			array( 'linea-weather-snowflake' => 'Weather snowflake' ),
			array( 'linea-weather-star' => 'Weather star' ),
			array( 'linea-weather-storm-11' => 'Weather storm 11' ),
			array( 'linea-weather-storm-32' => 'Weather storm 32' ),
			array( 'linea-weather-storm-fullmoon' => 'Weather storm fullmoon' ),
			array( 'linea-weather-storm-halfmoon' => 'Weather storm halfmoon' ),
			array( 'linea-weather-storm-sun' => 'Weather storm sun' ),
			array( 'linea-weather-sun' => 'Weather sun' ),
			array( 'linea-weather-sundown' => 'Weather sundown' ),
			array( 'linea-weather-sunset' => 'Weather sunset' ),
			array( 'linea-weather-taurus' => 'Weather taurus' ),
			array( 'linea-weather-tempest' => 'Weather tempest' ),
			array( 'linea-weather-tempest-fullmoon' => 'Weather tempest fullmoon' ),
			array( 'linea-weather-tempest-halfmoon' => 'Weather tempest halfmoon' ),
			array( 'linea-weather-tempest-sun' => 'Weather tempest sun' ),
			array( 'linea-weather-variable-fullmoon' => 'Weather variable fullmoon' ),
			array( 'linea-weather-variable-halfmoon' => 'Weather variable halfmoon' ),
			array( 'linea-weather-variable-sun' => 'Weather variable sun' ),
			array( 'linea-weather-virgo' => 'Weather virgo' ),
			array( 'linea-weather-waning-cresent' => 'Weather waning cresent' ),
			array( 'linea-weather-waning-gibbous' => 'Weather waning gibbous' ),
			array( 'linea-weather-waxing-cresent' => 'Weather waxing cresent' ),
			array( 'linea-weather-waxing-gibbous' => 'Weather waxing gibbous' ),
			array( 'linea-weather-wind' => 'Weather wind' ),
			array( 'linea-weather-wind-e' => 'Weather wind e' ),
			array( 'linea-weather-wind-fullmoon' => 'Weather wind fullmoon' ),
			array( 'linea-weather-wind-halfmoon' => 'Weather wind halfmoon' ),
			array( 'linea-weather-wind-n' => 'Weather wind n' ),
			array( 'linea-weather-wind-ne' => 'Weather wind ne' ),
			array( 'linea-weather-wind-nw' => 'Weather wind nw' ),
			array( 'linea-weather-wind-s' => 'Weather wind s' ),
			array( 'linea-weather-wind-se' => 'Weather wind se' ),
			array( 'linea-weather-wind-sun' => 'Weather wind sun' ),
			array( 'linea-weather-wind-sw' => 'Weather wind sw' ),
			array( 'linea-weather-wind-w' => 'Weather wind w' ),
			array( 'linea-weather-windgust' => 'Weather windgust' ),
		),
	);

	return $linea_icons;
}
add_filter( 'vc_iconpicker-type-linea-icons', 'wvc_add_linea_icons_font' );

/**
 * Add Linearicons
 *
 * @param $icons
 * @return array
 */
function wvc_add_linearicons_font( $icons ) {

	$linearicons = array(
		array( 'lnr-home' => 'Home' ),
		array( 'lnr-apartment' => 'Apartment' ),
		array( 'lnr-pencil' => 'Pencil' ),
		array( 'lnr-magic-wand' => 'Magic wand' ),
		array( 'lnr-drop' => 'Drop' ),
		array( 'lnr-lighter' => 'Lighter' ),
		array( 'lnr-poop' => 'Poop' ),
		array( 'lnr-sun' => 'Sun' ),
		array( 'lnr-moon' => 'Moon' ),
		array( 'lnr-cloud' => 'Cloud' ),
		array( 'lnr-cloud-upload' => 'Cloud upload' ),
		array( 'lnr-cloud-download' => 'Cloud download' ),
		array( 'lnr-cloud-sync' => 'Cloud sync' ),
		array( 'lnr-cloud-check' => 'Cloud check' ),
		array( 'lnr-database' => 'Database' ),
		array( 'lnr-lock' => 'Lock' ),
		array( 'lnr-cog' => 'Cog' ),
		array( 'lnr-trash' => 'Trash' ),
		array( 'lnr-dice' => 'Dice' ),
		array( 'lnr-heart' => 'Heart' ),
		array( 'lnr-star' => 'Star' ),
		array( 'lnr-star-half' => 'Star half' ),
		array( 'lnr-star-empty' => 'Star empty' ),
		array( 'lnr-flag' => 'Flag' ),
		array( 'lnr-envelope' => 'Envelope' ),
		array( 'lnr-paperclip' => 'Paperclip' ),
		array( 'lnr-inbox' => 'Inbox' ),
		array( 'lnr-eye' => 'Eye' ),
		array( 'lnr-printer' => 'Printer' ),
		array( 'lnr-file-empty' => 'File empty' ),
		array( 'lnr-file-add' => 'File add' ),
		array( 'lnr-enter' => 'Enter' ),
		array( 'lnr-exit' => 'Exit' ),
		array( 'lnr-graduation-hat' => 'Graduation hat' ),
		array( 'lnr-license' => 'License' ),
		array( 'lnr-music-note' => 'Music note' ),
		array( 'lnr-film-play' => 'Film play' ),
		array( 'lnr-camera-video' => 'Camera video' ),
		array( 'lnr-camera' => 'Camera' ),
		array( 'lnr-picture' => 'Picture' ),
		array( 'lnr-book' => 'Book' ),
		array( 'lnr-bookmark' => 'Bookmark' ),
		array( 'lnr-user' => 'User' ),
		array( 'lnr-users' => 'Users' ),
		array( 'lnr-shirt' => 'Shirt' ),
		array( 'lnr-store' => 'Store' ),
		array( 'lnr-cart' => 'Cart' ),
		array( 'lnr-tag' => 'Tag' ),
		array( 'lnr-phone-handset' => 'Phone handset' ),
		array( 'lnr-phone' => 'Phone' ),
		array( 'lnr-pushpin' => 'Pushpin' ),
		array( 'lnr-map-marker' => 'Map marker' ),
		array( 'lnr-map' => 'Map' ),
		array( 'lnr-location' => 'Location' ),
		array( 'lnr-calendar-full' => 'Calendar full' ),
		array( 'lnr-keyboard' => 'Keyboard' ),
		array( 'lnr-spell-check' => 'Spell check' ),
		array( 'lnr-screen' => 'Screen' ),
		array( 'lnr-smartphone' => 'Smartphone' ),
		array( 'lnr-tablet' => 'Tablet' ),
		array( 'lnr-laptop' => 'Laptop' ),
		array( 'lnr-laptop-phone' => 'Laptop phone' ),
		array( 'lnr-power-switch' => 'Power switch' ),
		array( 'lnr-bubble' => 'Bubble' ),
		array( 'lnr-heart-pulse' => 'Heart pulse' ),
		array( 'lnr-construction' => 'Construction' ),
		array( 'lnr-pie-chart' => 'Pie chart' ),
		array( 'lnr-chart-bars' => 'Chart bars' ),
		array( 'lnr-gift' => 'Gift' ),
		array( 'lnr-diamond' => 'Diamond' ),
		array( 'lnr-linearicons' => 'Linearicons' ),
		array( 'lnr-dinner' => 'Dinner' ),
		array( 'lnr-coffee-cup' => 'Coffee cup' ),
		array( 'lnr-leaf' => 'Leaf' ),
		array( 'lnr-paw' => 'Paw' ),
		array( 'lnr-rocket' => 'Rocket' ),
		array( 'lnr-briefcase' => 'Briefcase' ),
		array( 'lnr-bus' => 'Bus' ),
		array( 'lnr-car' => 'Car' ),
		array( 'lnr-train' => 'Train' ),
		array( 'lnr-bicycle' => 'Bicycle' ),
		array( 'lnr-wheelchair' => 'Wheelchair' ),
		array( 'lnr-select' => 'Select' ),
		array( 'lnr-earth' => 'Earth' ),
		array( 'lnr-smile' => 'Smile' ),
		array( 'lnr-sad' => 'Sad' ),
		array( 'lnr-neutral' => 'Neutral' ),
		array( 'lnr-mustache' => 'Mustache' ),
		array( 'lnr-alarm' => 'Alarm' ),
		array( 'lnr-bullhorn' => 'Bullhorn' ),
		array( 'lnr-volume-high' => 'Volume high' ),
		array( 'lnr-volume-medium' => 'Volume medium' ),
		array( 'lnr-volume-low' => 'Volume low' ),
		array( 'lnr-volume' => 'Volume' ),
		array( 'lnr-mic' => 'Mic' ),
		array( 'lnr-hourglass' => 'Hourglass' ),
		array( 'lnr-undo' => 'Undo' ),
		array( 'lnr-redo' => 'Redo' ),
		array( 'lnr-sync' => 'Sync' ),
		array( 'lnr-history' => 'History' ),
		array( 'lnr-clock' => 'Clock' ),
		array( 'lnr-download' => 'Download' ),
		array( 'lnr-upload' => 'Upload' ),
		array( 'lnr-enter-down' => 'Enter down' ),
		array( 'lnr-exit-up' => 'Exit up' ),
		array( 'lnr-bug' => 'Bug' ),
		array( 'lnr-code' => 'Code' ),
		array( 'lnr-link' => 'Link' ),
		array( 'lnr-unlink' => 'Unlink' ),
		array( 'lnr-thumbs-up' => 'Thumbs up' ),
		array( 'lnr-thumbs-down' => 'Thumbs down' ),
		array( 'lnr-magnifier' => 'Magnifier' ),
		array( 'lnr-cross' => 'Cross' ),
		array( 'lnr-menu' => 'Menu' ),
		array( 'lnr-list' => 'List' ),
		array( 'lnr-chevron-up' => 'Chevron up' ),
		array( 'lnr-chevron-down' => 'Chevron down' ),
		array( 'lnr-chevron-left' => 'Chevron left' ),
		array( 'lnr-chevron-right' => 'Chevron right' ),
		array( 'lnr-arrow-up' => 'Arrow up' ),
		array( 'lnr-arrow-down' => 'Arrow down' ),
		array( 'lnr-arrow-left' => 'Arrow left' ),
		array( 'lnr-arrow-right' => 'Arrow right' ),
		array( 'lnr-move' => 'Move' ),
		array( 'lnr-warning' => 'Warning' ),
		array( 'lnr-question-circle' => 'Question circle' ),
		array( 'lnr-menu-circle' => 'Menu circle' ),
		array( 'lnr-checkmark-circle' => 'Checkmark circle' ),
		array( 'lnr-cross-circle' => 'Cross circle' ),
		array( 'lnr-plus-circle' => 'Plus circle' ),
		array( 'lnr-circle-minus' => 'Circle minus' ),
		array( 'lnr-arrow-up-circle' => 'Arrow up circle' ),
		array( 'lnr-arrow-down-circle' => 'Arrow down circle' ),
		array( 'lnr-arrow-left-circle' => 'Arrow left circle' ),
		array( 'lnr-arrow-right-circle' => 'Arrow right circle' ),
		array( 'lnr-chevron-up-circle' => 'Chevron up circle' ),
		array( 'lnr-chevron-down-circle' => 'Chevron down circle' ),
		array( 'lnr-chevron-left-circle' => 'Chevron left circle' ),
		array( 'lnr-chevron-right-circle' => 'Chevron right circle' ),
		array( 'lnr-crop' => 'Crop' ),
		array( 'lnr-frame-expand' => 'Frame expand' ),
		array( 'lnr-frame-contract' => 'Frame contract' ),
		array( 'lnr-layers' => 'Layers' ),
		array( 'lnr-funnel' => 'Funnel' ),
		array( 'lnr-text-format' => 'Text format' ),
		array( 'lnr-text-format-remove' => 'Text format remove' ),
		array( 'lnr-text-size' => 'Text size' ),
		array( 'lnr-bold' => 'Bold' ),
		array( 'lnr-italic' => 'Italic' ),
		array( 'lnr-underline' => 'Underline' ),
		array( 'lnr-strikethrough' => 'Strikethrough' ),
		array( 'lnr-highlight' => 'Highlight' ),
		array( 'lnr-text-align-left' => 'Text align left' ),
		array( 'lnr-text-align-center' => 'Text align center' ),
		array( 'lnr-text-align-right' => 'Text align right' ),
		array( 'lnr-text-align-justify' => 'Text align justify' ),
		array( 'lnr-line-spacing' => 'Line spacing' ),
		array( 'lnr-indent-increase' => 'Indent increase' ),
		array( 'lnr-indent-decrease' => 'Indent decrease' ),
		array( 'lnr-pilcrow' => 'Pilcrow' ),
		array( 'lnr-direction-ltr' => 'Direction ltr' ),
		array( 'lnr-direction-rtl' => 'Direction rtl' ),
		array( 'lnr-page-break' => 'Page break' ),
		array( 'lnr-sort-alpha-asc' => 'Sort alpha asc' ),
		array( 'lnr-sort-amount-asc' => 'Sort amount asc' ),
		array( 'lnr-hand' => 'Hand' ),
		array( 'lnr-pointer-up' => 'Pointer up' ),
		array( 'lnr-pointer-right' => 'Pointer right' ),
		array( 'lnr-pointer-down' => 'Pointer down' ),
		array( 'lnr-pointer-left' => 'Pointer left' ),
	);

	return $linearicons;
}
add_filter( 'vc_iconpicker-type-linearicons', 'wvc_add_linearicons_font' );

/**
 * Add Socicon
 *
 * @param $icons
 * @return array
 */
function wvc_add_socicon_font( $icons ) {

	$socicons = array(
		array( 'socicon-internet' => 'Internet' ),
		array( 'socicon-moddb' => 'Moddb' ),
		array( 'socicon-indiedb' => 'Indiedb' ),
		array( 'socicon-traxsource' => 'Traxsource' ),
		array( 'socicon-gamefor' => 'Gamefor' ),
		array( 'socicon-pixiv' => 'Pixiv' ),
		array( 'socicon-myanimelist' => 'Myanimelist' ),
		array( 'socicon-blackberry' => 'Blackberry' ),
		array( 'socicon-wickr' => 'Wickr' ),
		array( 'socicon-spip' => 'Spip' ),
		array( 'socicon-napster' => 'Napster' ),
		array( 'socicon-beatport' => 'Beatport' ),
		array( 'socicon-hackerone' => 'Hackerone' ),
		array( 'socicon-hackernews' => 'Hackernews' ),
		array( 'socicon-smashwords' => 'Smashwords' ),
		array( 'socicon-kobo' => 'Kobo' ),
		array( 'socicon-bookbub' => 'Bookbub' ),
		array( 'socicon-mailru' => 'Mailru' ),
		array( 'socicon-gitlab' => 'Gitlab' ),
		array( 'socicon-instructables' => 'Instructables' ),
		array( 'socicon-portfolio' => 'Portfolio' ),
		array( 'socicon-codered' => 'Codered' ),
		array( 'socicon-origin' => 'Origin' ),
		array( 'socicon-nextdoor' => 'Nextdoor' ),
		array( 'socicon-udemy' => 'Udemy' ),
		array( 'socicon-livemaster' => 'Livemaster' ),
		array( 'socicon-crunchbase' => 'Crunchbase' ),
		array( 'socicon-homefy' => 'Homefy' ),
		array( 'socicon-calendly' => 'Calendly' ),
		array( 'socicon-realtor' => 'Realtor' ),
		array( 'socicon-tidal' => 'Tidal' ),
		array( 'socicon-qobuz' => 'Qobuz' ),
		array( 'socicon-natgeo' => 'Natgeo' ),
		array( 'socicon-mastodon' => 'Mastodon' ),
		array( 'socicon-unsplash' => 'Unsplash' ),
		array( 'socicon-homeadvisor' => 'Homeadvisor' ),
		array( 'socicon-angieslist' => 'Angieslist' ),
		array( 'socicon-codepen' => 'Codepen' ),
		array( 'socicon-slack' => 'Slack' ),
		array( 'socicon-openaigym' => 'Openaigym' ),
		array( 'socicon-logmein' => 'Logmein' ),
		array( 'socicon-fiverr' => 'Fiverr' ),
		array( 'socicon-gotomeeting' => 'Gotomeeting' ),
		array( 'socicon-aliexpress' => 'Aliexpress' ),
		array( 'socicon-guru' => 'Guru' ),
		array( 'socicon-appstore' => 'Appstore' ),
		array( 'socicon-homes' => 'Homes' ),
		array( 'socicon-zoom' => 'Zoom' ),
		array( 'socicon-alibaba' => 'Alibaba' ),
		array( 'socicon-craigslist' => 'Craigslist' ),
		array( 'socicon-wix' => 'Wix' ),
		array( 'socicon-redfin' => 'Redfin' ),
		array( 'socicon-googlecalendar' => 'Googlecalendar' ),
		array( 'socicon-shopify' => 'Shopify' ),
		array( 'socicon-freelancer' => 'Freelancer' ),
		array( 'socicon-seedrs' => 'Seedrs' ),
		array( 'socicon-bing' => 'Bing' ),
		array( 'socicon-doodle' => 'Doodle' ),
		array( 'socicon-bonanza' => 'Bonanza' ),
		array( 'socicon-squarespace' => 'Squarespace' ),
		array( 'socicon-toptal' => 'Toptal' ),
		array( 'socicon-gust' => 'Gust' ),
		array( 'socicon-ask' => 'Ask' ),
		array( 'socicon-trulia' => 'Trulia' ),
		array( 'socicon-loomly' => 'Loomly' ),
		array( 'socicon-ghost' => 'Ghost' ),
		array( 'socicon-upwork' => 'Upwork' ),
		array( 'socicon-fundable' => 'Fundable' ),
		array( 'socicon-booking' => 'Booking' ),
		array( 'socicon-googlemaps' => 'Googlemaps' ),
		array( 'socicon-zillow' => 'Zillow' ),
		array( 'socicon-niconico' => 'Niconico' ),
		array( 'socicon-toneden' => 'Toneden' ),
		array( 'socicon-augment' => 'Augment' ),
		array( 'socicon-bitbucket' => 'Bitbucket' ),
		array( 'socicon-fyuse' => 'Fyuse' ),
		array( 'socicon-yt-gaming' => 'Yt gaming' ),
		array( 'socicon-sketchfab' => 'Sketchfab' ),
		array( 'socicon-mobcrush' => 'Mobcrush' ),
		array( 'socicon-microsoft' => 'Microsoft' ),
		array( 'socicon-pandora' => 'Pandora' ),
		array( 'socicon-messenger' => 'Messenger' ),
		array( 'socicon-gamewisp' => 'Gamewisp' ),
		array( 'socicon-bloglovin' => 'Bloglovin' ),
		array( 'socicon-tunein' => 'Tunein' ),
		array( 'socicon-gamejolt' => 'Gamejolt' ),
		array( 'socicon-trello' => 'Trello' ),
		array( 'socicon-spreadshirt' => 'Spreadshirt' ),
		array( 'socicon-500px' => '500px' ),
		array( 'socicon-8tracks' => '8tracks' ),
		array( 'socicon-airbnb' => 'Airbnb' ),
		array( 'socicon-alliance' => 'Alliance' ),
		array( 'socicon-amazon' => 'Amazon' ),
		array( 'socicon-amplement' => 'Amplement' ),
		array( 'socicon-android' => 'Android' ),
		array( 'socicon-angellist' => 'Angellist' ),
		array( 'socicon-apple' => 'Apple' ),
		array( 'socicon-appnet' => 'Appnet' ),
		array( 'socicon-baidu' => 'Baidu' ),
		array( 'socicon-bandcamp' => 'Bandcamp' ),
		array( 'socicon-battlenet' => 'Battlenet' ),
		array( 'socicon-mixer' => 'Mixer' ),
		array( 'socicon-bebee' => 'Bebee' ),
		array( 'socicon-bebo' => 'Bebo' ),
		array( 'socicon-behance' => 'Behance' ),
		array( 'socicon-blizzard' => 'Blizzard' ),
		array( 'socicon-blogger' => 'Blogger' ),
		array( 'socicon-buffer' => 'Buffer' ),
		array( 'socicon-chrome' => 'Chrome' ),
		array( 'socicon-coderwall' => 'Coderwall' ),
		array( 'socicon-curse' => 'Curse' ),
		array( 'socicon-dailymotion' => 'Dailymotion' ),
		array( 'socicon-deezer' => 'Deezer' ),
		array( 'socicon-delicious' => 'Delicious' ),
		array( 'socicon-deviantart' => 'Deviantart' ),
		array( 'socicon-diablo' => 'Diablo' ),
		array( 'socicon-digg' => 'Digg' ),
		array( 'socicon-discord' => 'Discord' ),
		array( 'socicon-disqus' => 'Disqus' ),
		array( 'socicon-douban' => 'Douban' ),
		array( 'socicon-draugiem' => 'Draugiem' ),
		array( 'socicon-dribbble' => 'Dribbble' ),
		array( 'socicon-drupal' => 'Drupal' ),
		array( 'socicon-ebay' => 'Ebay' ),
		array( 'socicon-ello' => 'Ello' ),
		array( 'socicon-endomodo' => 'Endomodo' ),
		array( 'socicon-envato' => 'Envato' ),
		array( 'socicon-etsy' => 'Etsy' ),
		array( 'socicon-facebook' => 'Facebook' ),
		array( 'socicon-feedburner' => 'Feedburner' ),
		array( 'socicon-filmweb' => 'Filmweb' ),
		array( 'socicon-firefox' => 'Firefox' ),
		array( 'socicon-flattr' => 'Flattr' ),
		array( 'socicon-flickr' => 'Flickr' ),
		array( 'socicon-formulr' => 'Formulr' ),
		array( 'socicon-forrst' => 'Forrst' ),
		array( 'socicon-foursquare' => 'Foursquare' ),
		array( 'socicon-friendfeed' => 'Friendfeed' ),
		array( 'socicon-github' => 'Github' ),
		array( 'socicon-goodreads' => 'Goodreads' ),
		array( 'socicon-google' => 'Google' ),
		array( 'socicon-googlescholar' => 'Googlescholar' ),
		array( 'socicon-googlegroups' => 'Googlegroups' ),
		array( 'socicon-googlephotos' => 'Googlephotos' ),
		array( 'socicon-googleplus' => 'Googleplus' ),
		array( 'socicon-grooveshark' => 'Grooveshark' ),
		array( 'socicon-hackerrank' => 'Hackerrank' ),
		array( 'socicon-hearthstone' => 'Hearthstone' ),
		array( 'socicon-hellocoton' => 'Hellocoton' ),
		array( 'socicon-heroes' => 'Heroes' ),
		array( 'socicon-smashcast' => 'Smashcast' ),
		array( 'socicon-horde' => 'Horde' ),
		array( 'socicon-houzz' => 'Houzz' ),
		array( 'socicon-icq' => 'Icq' ),
		array( 'socicon-identica' => 'Identica' ),
		array( 'socicon-imdb' => 'Imdb' ),
		array( 'socicon-instagram' => 'Instagram' ),
		array( 'socicon-issuu' => 'Issuu' ),
		array( 'socicon-istock' => 'Istock' ),
		array( 'socicon-itunes' => 'Itunes' ),
		array( 'socicon-keybase' => 'Keybase' ),
		array( 'socicon-lanyrd' => 'Lanyrd' ),
		array( 'socicon-lastfm' => 'Lastfm' ),
		array( 'socicon-line' => 'Line' ),
		array( 'socicon-linkedin' => 'Linkedin' ),
		array( 'socicon-livejournal' => 'Livejournal' ),
		array( 'socicon-lyft' => 'Lyft' ),
		array( 'socicon-macos' => 'Macos' ),
		array( 'socicon-mail' => 'Mail' ),
		array( 'socicon-medium' => 'Medium' ),
		array( 'socicon-meetup' => 'Meetup' ),
		array( 'socicon-mixcloud' => 'Mixcloud' ),
		array( 'socicon-modelmayhem' => 'Modelmayhem' ),
		array( 'socicon-mumble' => 'Mumble' ),
		array( 'socicon-myspace' => 'Myspace' ),
		array( 'socicon-newsvine' => 'Newsvine' ),
		array( 'socicon-nintendo' => 'Nintendo' ),
		array( 'socicon-npm' => 'Npm' ),
		array( 'socicon-odnoklassniki' => 'Odnoklassniki' ),
		array( 'socicon-openid' => 'Openid' ),
		array( 'socicon-opera' => 'Opera' ),
		array( 'socicon-outlook' => 'Outlook' ),
		array( 'socicon-overwatch' => 'Overwatch' ),
		array( 'socicon-patreon' => 'Patreon' ),
		array( 'socicon-paypal' => 'Paypal' ),
		array( 'socicon-periscope' => 'Periscope' ),
		array( 'socicon-persona' => 'Persona' ),
		array( 'socicon-pinterest' => 'Pinterest' ),
		array( 'socicon-play' => 'Play' ),
		array( 'socicon-player' => 'Player' ),
		array( 'socicon-playstation' => 'Playstation' ),
		array( 'socicon-pocket' => 'Pocket' ),
		array( 'socicon-qq' => 'Qq' ),
		array( 'socicon-quora' => 'Quora' ),
		array( 'socicon-raidcall' => 'Raidcall' ),
		array( 'socicon-ravelry' => 'Ravelry' ),
		array( 'socicon-reddit' => 'Reddit' ),
		array( 'socicon-renren' => 'Renren' ),
		array( 'socicon-researchgate' => 'Researchgate' ),
		array( 'socicon-residentadvisor' => 'Residentadvisor' ),
		array( 'socicon-reverbnation' => 'Reverbnation' ),
		array( 'socicon-rss' => 'Rss' ),
		array( 'socicon-sharethis' => 'Sharethis' ),
		array( 'socicon-skype' => 'Skype' ),
		array( 'socicon-slideshare' => 'Slideshare' ),
		array( 'socicon-smugmug' => 'Smugmug' ),
		array( 'socicon-snapchat' => 'Snapchat' ),
		array( 'socicon-songkick' => 'Songkick' ),
		array( 'socicon-soundcloud' => 'Soundcloud' ),
		array( 'socicon-spotify' => 'Spotify' ),
		array( 'socicon-stackexchange' => 'Stackexchange' ),
		array( 'socicon-stackoverflow' => 'Stackoverflow' ),
		array( 'socicon-starcraft' => 'Starcraft' ),
		array( 'socicon-stayfriends' => 'Stayfriends' ),
		array( 'socicon-steam' => 'Steam' ),
		array( 'socicon-storehouse' => 'Storehouse' ),
		array( 'socicon-strava' => 'Strava' ),
		array( 'socicon-streamjar' => 'Streamjar' ),
		array( 'socicon-stumbleupon' => 'Stumbleupon' ),
		array( 'socicon-swarm' => 'Swarm' ),
		array( 'socicon-teamspeak' => 'Teamspeak' ),
		array( 'socicon-teamviewer' => 'Teamviewer' ),
		array( 'socicon-technorati' => 'Technorati' ),
		array( 'socicon-telegram' => 'Telegram' ),
		array( 'socicon-tripadvisor' => 'Tripadvisor' ),
		array( 'socicon-tripit' => 'Tripit' ),
		array( 'socicon-triplej' => 'Triplej' ),
		array( 'socicon-tumblr' => 'Tumblr' ),
		array( 'socicon-twitch' => 'Twitch' ),
		array( 'socicon-twitter' => 'Twitter' ),
		array( 'socicon-uber' => 'Uber' ),
		array( 'socicon-ventrilo' => 'Ventrilo' ),
		array( 'socicon-viadeo' => 'Viadeo' ),
		array( 'socicon-viber' => 'Viber' ),
		array( 'socicon-viewbug' => 'Viewbug' ),
		array( 'socicon-vimeo' => 'Vimeo' ),
		array( 'socicon-vine' => 'Vine' ),
		array( 'socicon-vkontakte' => 'Vkontakte' ),
		array( 'socicon-warcraft' => 'Warcraft' ),
		array( 'socicon-wechat' => 'Wechat' ),
		array( 'socicon-weibo' => 'Weibo' ),
		array( 'socicon-whatsapp' => 'Whatsapp' ),
		array( 'socicon-wikipedia' => 'Wikipedia' ),
		array( 'socicon-windows' => 'Windows' ),
		array( 'socicon-wordpress' => 'Wordpress' ),
		array( 'socicon-wykop' => 'Wykop' ),
		array( 'socicon-xbox' => 'Xbox' ),
		array( 'socicon-xing' => 'Xing' ),
		array( 'socicon-yahoo' => 'Yahoo' ),
		array( 'socicon-yammer' => 'Yammer' ),
		array( 'socicon-yandex' => 'Yandex' ),
		array( 'socicon-yelp' => 'Yelp' ),
		array( 'socicon-younow' => 'Younow' ),
		array( 'socicon-youtube' => 'Youtube' ),
		array( 'socicon-zapier' => 'Zapier' ),
		array( 'socicon-zerply' => 'Zerply' ),
		array( 'socicon-zomato' => 'Zomato' ),
		array( 'socicon-zynga' => 'Zynga' ),
	);

	return $socicons;
}
add_filter( 'vc_iconpicker-type-socicon', 'wvc_add_socicon_font' );

/**
 * Add Wolf Icons
 *
 * @param $icons
 * @return array
 */
function wvc_add_wolficons_font( $icons ) {

	$wolf_icons = array(
		array( 'wolficon-mailchimp' => 'Mailchimp' ),
		array( 'wolficon-bandsintown' => 'Bandsintown' ),
		array( 'wolficon-wolfthemes' => 'Wolfthemes' ),
		array( 'wolficon-ampersand' => 'Ampersand' ),
		array( 'wolficon2-tiktok' => 'tiktok' ),
	);

	return $wolf_icons;
}
add_filter( 'vc_iconpicker-type-wolficons', 'wvc_add_wolficons_font' );

/**
 * Add Elegant Icons
 *
 * @param $icons
 * @return array
 */
function wvc_add_elegant_icons_font( $icons ) {

	$elegant_icons = array(
		array( 'ei-social_youtube_square' => 'Social_youtube_square' ),
		array( 'ei-social_youtube_circle' => 'Social_youtube_circle' ),
		array( 'ei-social_youtube' => 'Social_youtube' ),
		array( 'ei-social_wordpress_square' => 'Social_wordpress_square' ),
		array( 'ei-social_wordpress_circle' => 'Social_wordpress_circle' ),
		array( 'ei-social_wordpress' => 'Social_wordpress' ),
		array( 'ei-social_vimeo_square' => 'Social_vimeo_square' ),
		array( 'ei-social_vimeo_circle' => 'Social_vimeo_circle' ),
		array( 'ei-social_vimeo' => 'Social_vimeo' ),
		array( 'ei-social_twitter_square' => 'Social_twitter_square' ),
		array( 'ei-social_twitter_circle' => 'Social_twitter_circle' ),
		array( 'ei-social_twitter' => 'Social_twitter' ),
		array( 'ei-social_tumblr_square' => 'Social_tumblr_square' ),
		array( 'ei-social_tumblr_circle' => 'Social_tumblr_circle' ),
		array( 'ei-social_tumblr' => 'Social_tumblr' ),
		array( 'ei-social_tumbleupon' => 'Social_tumbleupon' ),
		array( 'ei-social_stumbleupon_square' => 'Social_stumbleupon_square' ),
		array( 'ei-social_stumbleupon_circle' => 'Social_stumbleupon_circle' ),
		array( 'ei-social_spotify_square' => 'Social_spotify_square' ),
		array( 'ei-social_spotify_circle' => 'Social_spotify_circle' ),
		array( 'ei-social_spotify' => 'Social_spotify' ),
		array( 'ei-social_skype_square' => 'Social_skype_square' ),
		array( 'ei-social_skype_circle' => 'Social_skype_circle' ),
		array( 'ei-social_skype' => 'Social_skype' ),
		array( 'ei-social_share_square' => 'Social_share_square' ),
		array( 'ei-social_share_circle' => 'Social_share_circle' ),
		array( 'ei-social_share' => 'Social_share' ),
		array( 'ei-social_rss_square' => 'Social_rss_square' ),
		array( 'ei-social_rss_circle' => 'Social_rss_circle' ),
		array( 'ei-social_rss' => 'Social_rss' ),
		array( 'ei-social_pinterest_square' => 'Social_pinterest_square' ),
		array( 'ei-social_pinterest_circle' => 'Social_pinterest_circle' ),
		array( 'ei-social_pinterest' => 'Social_pinterest' ),
		array( 'ei-social_picassa_square' => 'Social_picassa_square' ),
		array( 'ei-social_picassa_circle' => 'Social_picassa_circle' ),
		array( 'ei-social_picassa' => 'Social_picassa' ),
		array( 'ei-social_myspace_square' => 'Social_myspace_square' ),
		array( 'ei-social_myspace_circle' => 'Social_myspace_circle' ),
		array( 'ei-social_myspace' => 'Social_myspace' ),
		array( 'ei-social_linkedin_square' => 'Social_linkedin_square' ),
		array( 'ei-social_linkedin_circle' => 'Social_linkedin_circle' ),
		array( 'ei-social_linkedin' => 'Social_linkedin' ),
		array( 'ei-social_instagram_square' => 'Social_instagram_square' ),
		array( 'ei-social_instagram_circle' => 'Social_instagram_circle' ),
		array( 'ei-social_instagram' => 'Social_instagram' ),
		array( 'ei-social_googleplus_square' => 'Social_googleplus_square' ),
		array( 'ei-social_googleplus_circle' => 'Social_googleplus_circle' ),
		array( 'ei-social_googleplus' => 'Social_googleplus' ),
		array( 'ei-social_googledrive_square' => 'Social_googledrive_square' ),
		array( 'ei-social_googledrive_alt2' => 'Social_googledrive_alt2' ),
		array( 'ei-social_googledrive' => 'Social_googledrive' ),
		array( 'ei-social_flickr_square' => 'Social_flickr_square' ),
		array( 'ei-social_flickr_circle' => 'Social_flickr_circle' ),
		array( 'ei-social_flickr' => 'Social_flickr' ),
		array( 'ei-social_facebook_square' => 'Social_facebook_square' ),
		array( 'ei-social_facebook_circle' => 'Social_facebook_circle' ),
		array( 'ei-social_facebook' => 'Social_facebook' ),
		array( 'ei-social_dribbble_square' => 'Social_dribbble_square' ),
		array( 'ei-social_dribbble_circle' => 'Social_dribbble_circle' ),
		array( 'ei-social_dribbble' => 'Social_dribbble' ),
		array( 'ei-social_deviantart_square' => 'Social_deviantart_square' ),
		array( 'ei-social_deviantart_circle' => 'Social_deviantart_circle' ),
		array( 'ei-social_deviantart' => 'Social_deviantart' ),
		array( 'ei-social_delicious_square' => 'Social_delicious_square' ),
		array( 'ei-social_delicious_circle' => 'Social_delicious_circle' ),
		array( 'ei-social_delicious' => 'Social_delicious' ),
		array( 'ei-social_blogger_square' => 'Social_blogger_square' ),
		array( 'ei-social_blogger_circle' => 'Social_blogger_circle' ),
		array( 'ei-social_blogger' => 'Social_blogger' ),
		array( 'ei-upload' => 'Upload' ),
		array( 'ei-trash' => 'Trash' ),
		array( 'ei-toolbox' => 'Toolbox' ),
		array( 'ei-tags' => 'Tags' ),
		array( 'ei-tag' => 'Tag' ),
		array( 'ei-ribbon' => 'Ribbon' ),
		array( 'ei-quotations_alt' => 'Quotations_alt' ),
		array( 'ei-pushpin' => 'Pushpin' ),
		array( 'ei-profile' => 'Profile' ),
		array( 'ei-pin' => 'Pin' ),
		array( 'ei-phone' => 'Phone' ),
		array( 'ei-pause_alt' => 'Pause_alt' ),
		array( 'ei-music' => 'Music' ),
		array( 'ei-mic' => 'Mic' ),
		array( 'ei-map' => 'Map' ),
		array( 'ei-mail' => 'Mail' ),
		array( 'ei-lock-open' => 'Lock open' ),
		array( 'ei-lock' => 'Lock' ),
		array( 'ei-lightbulb' => 'Lightbulb' ),
		array( 'ei-key' => 'Key' ),
		array( 'ei-house' => 'House' ),
		array( 'ei-heart' => 'Heart' ),
		array( 'ei-group' => 'Group' ),
		array( 'ei-grid-3x3' => 'Grid 3x3' ),
		array( 'ei-grid-2x2' => 'Grid 2x2' ),
		array( 'ei-gift' => 'Gift' ),
		array( 'ei-drawer' => 'Drawer' ),
		array( 'ei-download' => 'Download' ),
		array( 'ei-cursor' => 'Cursor' ),
		array( 'ei-contacts' => 'Contacts' ),
		array( 'ei-cone' => 'Cone' ),
		array( 'ei-compass' => 'Compass' ),
		array( 'ei-cloud-upload' => 'Cloud upload' ),
		array( 'ei-cloud-download' => 'Cloud download' ),
		array( 'ei-cloud' => 'Cloud' ),
		array( 'ei-clock' => 'Clock' ),
		array( 'ei-cart' => 'Cart' ),
		array( 'ei-camera' => 'Camera' ),
		array( 'ei-book' => 'Book' ),
		array( 'ei-bag' => 'Bag' ),
		array( 'ei-archive' => 'Archive' ),
		array( 'ei-zoom-out' => 'Zoom out' ),
		array( 'ei-zoom-in' => 'Zoom in' ),
		array( 'ei-volume-low_alt' => 'Volume low_alt' ),
		array( 'ei-volume-low' => 'Volume low' ),
		array( 'ei-volume-high_alt' => 'Volume high_alt' ),
		array( 'ei-volume-high' => 'Volume high' ),
		array( 'ei-vol-mute_alt' => 'Vol mute_alt' ),
		array( 'ei-vol-mute' => 'Vol mute' ),
		array( 'ei-trash_alt' => 'Trash_alt' ),
		array( 'ei-tools' => 'Tools' ),
		array( 'ei-toolbox_alt' => 'Toolbox_alt' ),
		array( 'ei-tool' => 'Tool' ),
		array( 'ei-tags_alt' => 'Tags_alt' ),
		array( 'ei-tag_alt' => 'Tag_alt' ),
		array( 'ei-tablet' => 'Tablet' ),
		array( 'ei-table' => 'Table' ),
		array( 'ei-stop_alt' => 'Stop_alt' ),
		array( 'ei-star-half_alt' => 'Star half_alt' ),
		array( 'ei-star-half' => 'Star half' ),
		array( 'ei-star_alt' => 'Star_alt' ),
		array( 'ei-star' => 'Star' ),
		array( 'ei-ribbon_alt' => 'Ribbon_alt' ),
		array( 'ei-refresh' => 'Refresh' ),
		array( 'ei-quotations_alt2' => 'Quotations_alt2' ),
		array( 'ei-quotations' => 'Quotations' ),
		array( 'ei-question_alt2' => 'Question_alt2' ),
		array( 'ei-question_alt' => 'Question_alt' ),
		array( 'ei-question' => 'Question' ),
		array( 'ei-pushpin_alt' => 'Pushpin_alt' ),
		array( 'ei-plus_alt' => 'Plus_alt' ),
		array( 'ei-pin_alt' => 'Pin_alt' ),
		array( 'ei-piechart' => 'Piechart' ),
		array( 'ei-pencil_alt' => 'Pencil_alt' ),
		array( 'ei-paperclip' => 'Paperclip' ),
		array( 'ei-mobile' => 'Mobile' ),
		array( 'ei-minus_alt' => 'Minus_alt' ),
		array( 'ei-mic_alt' => 'Mic_alt' ),
		array( 'ei-menu-square_alt' => 'Menu square_alt' ),
		array( 'ei-menu-circle_alt' => 'Menu circle_alt' ),
		array( 'ei-map_alt' => 'Map_alt' ),
		array( 'ei-mail_alt' => 'Mail_alt' ),
		array( 'ei-lock-open_alt' => 'Lock open_alt' ),
		array( 'ei-lock_alt' => 'Lock_alt' ),
		array( 'ei-loading' => 'Loading' ),
		array( 'ei-link_alt' => 'Link_alt' ),
		array( 'ei-link' => 'Link' ),
		array( 'ei-lightbulb_alt' => 'Lightbulb_alt' ),
		array( 'ei-lifesaver' => 'Lifesaver' ),
		array( 'ei-laptop' => 'Laptop' ),
		array( 'ei-key_alt' => 'Key_alt' ),
		array( 'ei-info' => 'Info' ),
		array( 'ei-images' => 'Images' ),
		array( 'ei-image' => 'Image' ),
		array( 'ei-house_alt' => 'House_alt' ),
		array( 'ei-heart_alt' => 'Heart_alt' ),
		array( 'ei-headphones' => 'Headphones' ),
		array( 'ei-gift_alt' => 'Gift_alt' ),
		array( 'ei-genius' => 'Genius' ),
		array( 'ei-folder-open' => 'Folder open' ),
		array( 'ei-folder-add' => 'Folder add' ),
		array( 'ei-folder_upload' => 'Folder_upload' ),
		array( 'ei-folder_download' => 'Folder_download' ),
		array( 'ei-folder' => 'Folder' ),
		array( 'ei-film' => 'Film' ),
		array( 'ei-error-triangle_alt' => 'Error triangle_alt' ),
		array( 'ei-error-triangle' => 'Error triangle' ),
		array( 'ei-error-oct' => 'Error oct' ),
		array( 'ei-error-circle' => 'Error circle' ),
		array( 'ei-drawer_alt' => 'Drawer_alt' ),
		array( 'ei-documents' => 'Documents' ),
		array( 'ei-document' => 'Document' ),
		array( 'ei-desktop' => 'Desktop' ),
		array( 'ei-cursor_alt' => 'Cursor_alt' ),
		array( 'ei-creditcard' => 'Creditcard' ),
		array( 'ei-contacts_alt' => 'Contacts_alt' ),
		array( 'ei-cone_alt' => 'Cone_alt' ),
		array( 'ei-compass_alt' => 'Compass_alt' ),
		array( 'ei-comment_alt' => 'Comment_alt' ),
		array( 'ei-comment' => 'Comment' ),
		array( 'ei-cogs' => 'Cogs' ),
		array( 'ei-cog' => 'Cog' ),
		array( 'ei-cloud-upload_alt' => 'Cloud upload_alt' ),
		array( 'ei-cloud-download_alt' => 'Cloud download_alt' ),
		array( 'ei-cloud_alt' => 'Cloud_alt' ),
		array( 'ei-close_alt' => 'Close_alt' ),
		array( 'ei-clock_alt' => 'Clock_alt' ),
		array( 'ei-check_alt' => 'Check_alt' ),
		array( 'ei-chat_alt' => 'Chat_alt' ),
		array( 'ei-chat' => 'Chat' ),
		array( 'ei-cart_alt' => 'Cart_alt' ),
		array( 'ei-camera_alt' => 'Camera_alt' ),
		array( 'ei-calendar' => 'Calendar' ),
		array( 'ei-book_alt' => 'Book_alt' ),
		array( 'ei-blocked' => 'Blocked' ),
		array( 'ei-bag_alt' => 'Bag_alt' ),
		array( 'ei-archive_alt' => 'Archive_alt' ),
		array( 'ei-arrow_up_alt' => 'Arrow_up_alt' ),
		array( 'ei-arrow_triangle-up_alt' => 'Arrow_triangle up_alt' ),
		array( 'ei-arrow_triangle-right_alt' => 'Arrow_triangle right_alt' ),
		array( 'ei-arrow_triangle-left_alt' => 'Arrow_triangle left_alt' ),
		array( 'ei-arrow_triangle-down_alt' => 'Arrow_triangle down_alt' ),
		array( 'ei-arrow_right-up_alt' => 'Arrow_right up_alt' ),
		array( 'ei-arrow_right-down_alt' => 'Arrow_right down_alt' ),
		array( 'ei-arrow_right_alt' => 'Arrow_right_alt' ),
		array( 'ei-arrow_left-up_alt' => 'Arrow_left up_alt' ),
		array( 'ei-arrow_left-down_alt' => 'Arrow_left down_alt' ),
		array( 'ei-arrow_left_alt' => 'Arrow_left_alt' ),
		array( 'ei-arrow_expand_alt3' => 'Arrow_expand_alt3' ),
		array( 'ei-arrow_down_alt' => 'Arrow_down_alt' ),
		array( 'ei-arrow_condense_alt' => 'Arrow_condense_alt' ),
		array( 'ei-arrow_carrot-right_alt' => 'Arrow_carrot right_alt' ),
		array( 'ei-arrow_carrot-left_alt' => 'Arrow_carrot left_alt' ),
		array( 'ei-arrow_carrot-down_alt' => 'Arrow_carrot down_alt' ),
		array( 'ei-arrow_carrot-2up_alt' => 'Arrow_carrot 2up_alt' ),
		array( 'ei-arrow_carrot-2right_alt' => 'Arrow_carrot 2right_alt' ),
		array( 'ei-arrow_carrot-2left_alt' => 'Arrow_carrot 2left_alt' ),
		array( 'ei-arrow_carrot-2dwnn_alt' => 'Arrow_carrot 2dwnn_alt' ),
		array( 'ei-arrow_carrot_up_alt' => 'Arrow_carrot_up_alt' ),
		array( 'ei-zoom-out_alt' => 'Zoom out_alt' ),
		array( 'ei-zoom-in_alt' => 'Zoom in_alt' ),
		array( 'ei-wallet' => 'Wallet' ),
		array( 'ei-ul' => 'Ul' ),
		array( 'ei-target' => 'Target' ),
		array( 'ei-stop_alt2' => 'Stop_alt2' ),
		array( 'ei-stop' => 'Stop' ),
		array( 'ei-shield' => 'Shield' ),
		array( 'ei-search2' => 'Search2' ),
		array( 'ei-search_alt' => 'Search_alt' ),
		array( 'ei-search' => 'Search' ),
		array( 'ei-rook' => 'Rook' ),
		array( 'ei-puzzle_alt' => 'Puzzle_alt' ),
		array( 'ei-puzzle' => 'Puzzle' ),
		array( 'ei-printer-alt' => 'Printer alt' ),
		array( 'ei-printer' => 'Printer' ),
		array( 'ei-plus-box' => 'Plus box' ),
		array( 'ei-plus_alt2' => 'Plus_alt2' ),
		array( 'ei-plus' => 'Plus' ),
		array( 'ei-percent' => 'Percent' ),
		array( 'ei-pens' => 'Pens' ),
		array( 'ei-pencil-edit_alt' => 'Pencil edit_alt' ),
		array( 'ei-pencil-edit' => 'Pencil edit' ),
		array( 'ei-pencil' => 'Pencil' ),
		array( 'ei-pause_alt2' => 'Pause_alt2' ),
		array( 'ei-pause' => 'Pause' ),
		array( 'ei-ol' => 'Ol' ),
		array( 'ei-mug' => 'Mug' ),
		array( 'ei-minus-box' => 'Minus box' ),
		array( 'ei-minus-06' => 'Minus 06' ),
		array( 'ei-minus_alt2' => 'Minus_alt2' ),
		array( 'ei-menu-square_alt2' => 'Menu square_alt2' ),
		array( 'ei-menu-circle_alt2' => 'Menu circle_alt2' ),
		array( 'ei-menu' => 'Menu' ),
		array( 'ei-like' => 'Like' ),
		array( 'ei-info_alt' => 'Info_alt' ),
		array( 'ei-id-2_alt' => 'Id 2_alt' ),
		array( 'ei-id-2' => 'Id 2' ),
		array( 'ei-id_alt' => 'Id_alt' ),
		array( 'ei-id' => 'Id' ),
		array( 'ei-hourglass' => 'Hourglass' ),
		array( 'ei-globe-2' => 'Globe 2' ),
		array( 'ei-globe' => 'Globe' ),
		array( 'ei-folder-open_alt' => 'Folder open_alt' ),
		array( 'ei-folder-alt' => 'Folder alt' ),
		array( 'ei-folder-add_alt' => 'Folder add_alt' ),
		array( 'ei-flowchart' => 'Flowchart' ),
		array( 'ei-floppy_alt' => 'Floppy_alt' ),
		array( 'ei-floppy' => 'Floppy' ),
		array( 'ei-error-oct_alt' => 'Error oct_alt' ),
		array( 'ei-error-circle_alt' => 'Error circle_alt' ),
		array( 'ei-easel' => 'Easel' ),
		array( 'ei-drive_alt' => 'Drive_alt' ),
		array( 'ei-drive' => 'Drive' ),
		array( 'ei-documents_alt' => 'Documents_alt' ),
		array( 'ei-document_alt' => 'Document_alt' ),
		array( 'ei-dislike_alt' => 'Dislike_alt' ),
		array( 'ei-dislike' => 'Dislike' ),
		array( 'ei-datareport_alt' => 'Datareport_alt' ),
		array( 'ei-datareport' => 'Datareport' ),
		array( 'ei-currency_alt' => 'Currency_alt' ),
		array( 'ei-currency' => 'Currency' ),
		array( 'ei-close_alt2' => 'Close_alt2' ),
		array( 'ei-close' => 'Close' ),
		array( 'ei-clipboard' => 'Clipboard' ),
		array( 'ei-circle-selected' => 'Circle selected' ),
		array( 'ei-circle-empty' => 'Circle empty' ),
		array( 'ei-check_alt2' => 'Check_alt2' ),
		array( 'ei-check' => 'Check' ),
		array( 'ei-calulator' => 'Calulator' ),
		array( 'ei-calculator_alt' => 'Calculator_alt' ),
		array( 'ei-building_alt' => 'Building_alt' ),
		array( 'ei-building' => 'Building' ),
		array( 'ei-briefcase_alt' => 'Briefcase_alt' ),
		array( 'ei-briefcase' => 'Briefcase' ),
		array( 'ei-box-selected' => 'Box selected' ),
		array( 'ei-box-empty' => 'Box empty' ),
		array( 'ei-box-checked' => 'Box checked' ),
		array( 'ei-balance' => 'Balance' ),
		array( 'ei-adjust-vert' => 'Adjust vert' ),
		array( 'ei-adjust-horiz' => 'Adjust horiz' ),
		array( 'ei-arrow-up-down' => 'Arrow up down' ),
		array( 'ei-arrow_up-down_alt' => 'Arrow_up down_alt' ),
		array( 'ei-arrow_up' => 'Arrow_up' ),
		array( 'ei-arrow_triangle-up_alt2' => 'Arrow_triangle up_alt2' ),
		array( 'ei-arrow_triangle-up' => 'Arrow_triangle up' ),
		array( 'ei-arrow_triangle-right_alt2' => 'Arrow_triangle right_alt2' ),
		array( 'ei-arrow_triangle-right' => 'Arrow_triangle right' ),
		array( 'ei-arrow_triangle-left_alt2' => 'Arrow_triangle left_alt2' ),
		array( 'ei-arrow_triangle-left' => 'Arrow_triangle left' ),
		array( 'ei-arrow_triangle-down_alt2' => 'Arrow_triangle down_alt2' ),
		array( 'ei-arrow_triangle-down' => 'Arrow_triangle down' ),
		array( 'ei-arrow_right-up' => 'Arrow_right up' ),
		array( 'ei-arrow_right-down' => 'Arrow_right down' ),
		array( 'ei-arrow_right' => 'Arrow_right' ),
		array( 'ei-arrow_move' => 'Arrow_move' ),
		array( 'ei-arrow_left-up' => 'Arrow_left up' ),
		array( 'ei-arrow_left-right_alt' => 'Arrow_left right_alt' ),
		array( 'ei-arrow_left-right' => 'Arrow_left right' ),
		array( 'ei-arrow_left-down' => 'Arrow_left down' ),
		array( 'ei-arrow_left' => 'Arrow_left' ),
		array( 'ei-arrow_expand_alt2' => 'Arrow_expand_alt2' ),
		array( 'ei-arrow_expand_alt' => 'Arrow_expand_alt' ),
		array( 'ei-arrow_expand' => 'Arrow_expand' ),
		array( 'ei-arrow_down' => 'Arrow_down' ),
		array( 'ei-arrow_condense' => 'Arrow_condense' ),
		array( 'ei-arrow_carrot-up_alt2' => 'Arrow_carrot up_alt2' ),
		array( 'ei-arrow_carrot-up' => 'Arrow_carrot up' ),
		array( 'ei-arrow_carrot-right_alt2' => 'Arrow_carrot right_alt2' ),
		array( 'ei-arrow_carrot-right' => 'Arrow_carrot right' ),
		array( 'ei-arrow_carrot-left_alt2' => 'Arrow_carrot left_alt2' ),
		array( 'ei-arrow_carrot-left' => 'Arrow_carrot left' ),
		array( 'ei-arrow_carrot-down_alt2' => 'Arrow_carrot down_alt2' ),
		array( 'ei-arrow_carrot-down' => 'Arrow_carrot down' ),
		array( 'ei-arrow_carrot-2up_alt2' => 'Arrow_carrot 2up_alt2' ),
		array( 'ei-arrow_carrot-2up' => 'Arrow_carrot 2up' ),
		array( 'ei-arrow_carrot-2right_alt2' => 'Arrow_carrot 2right_alt2' ),
		array( 'ei-arrow_carrot-2right' => 'Arrow_carrot 2right' ),
		array( 'ei-arrow_carrot-2left_alt2' => 'Arrow_carrot 2left_alt2' ),
		array( 'ei-arrow_carrot-2left' => 'Arrow_carrot 2left' ),
		array( 'ei-arrow_carrot-2down_alt2' => 'Arrow_carrot 2down_alt2' ),
		array( 'ei-arrow_carrot-2down' => 'Arrow_carrot 2down' ),
		array( 'ei-arrow_back' => 'Arrow_back' ),
		array( 'ei-wallet_alt' => 'Wallet_alt' ),
		array( 'ei-shield_alt' => 'Shield_alt' ),
		array( 'ei-percent_alt' => 'Percent_alt' ),
		array( 'ei-pens_alt' => 'Pens_alt' ),
		array( 'ei-mug_alt' => 'Mug_alt' ),
		array( 'ei-like_alt' => 'Like_alt' ),
		array( 'ei-globe_alt' => 'Globe_alt' ),
		array( 'ei-flowchart_alt' => 'Flowchart_alt' ),
		array( 'ei-easel_alt' => 'Easel_alt' ),
	);

	return $elegant_icons;
}
add_filter( 'vc_iconpicker-type-elegant-icons', 'wvc_add_elegant_icons_font' );

/**
 * Add Ionicons
 *
 * @param $icons
 * @return array
 */
function wvc_add_ionicons_font( $icons ) {

	$ionicons = array(
		array( 'ion-alert' => 'Alert' ),
		array( 'ion-alert-circled' => 'Alert circled' ),
		array( 'ion-android-add' => 'Android add' ),
		array( 'ion-android-add-circle' => 'Android add circle' ),
		array( 'ion-android-alarm-clock' => 'Android alarm clock' ),
		array( 'ion-android-alert' => 'Android alert' ),
		array( 'ion-android-apps' => 'Android apps' ),
		array( 'ion-android-archive' => 'Android archive' ),
		array( 'ion-android-arrow-back' => 'Android arrow back' ),
		array( 'ion-android-arrow-down' => 'Android arrow down' ),
		array( 'ion-android-arrow-dropdown' => 'Android arrow dropdown' ),
		array( 'ion-android-arrow-dropdown-circle' => 'Android arrow dropdown circle' ),
		array( 'ion-android-arrow-dropleft' => 'Android arrow dropleft' ),
		array( 'ion-android-arrow-dropleft-circle' => 'Android arrow dropleft circle' ),
		array( 'ion-android-arrow-dropright' => 'Android arrow dropright' ),
		array( 'ion-android-arrow-dropright-circle' => 'Android arrow dropright circle' ),
		array( 'ion-android-arrow-dropup' => 'Android arrow dropup' ),
		array( 'ion-android-arrow-dropup-circle' => 'Android arrow dropup circle' ),
		array( 'ion-android-arrow-forward' => 'Android arrow forward' ),
		array( 'ion-android-arrow-up' => 'Android arrow up' ),
		array( 'ion-android-attach' => 'Android attach' ),
		array( 'ion-android-bar' => 'Android bar' ),
		array( 'ion-android-bicycle' => 'Android bicycle' ),
		array( 'ion-android-boat' => 'Android boat' ),
		array( 'ion-android-bookmark' => 'Android bookmark' ),
		array( 'ion-android-bulb' => 'Android bulb' ),
		array( 'ion-android-bus' => 'Android bus' ),
		array( 'ion-android-calendar' => 'Android calendar' ),
		array( 'ion-android-call' => 'Android call' ),
		array( 'ion-android-camera' => 'Android camera' ),
		array( 'ion-android-cancel' => 'Android cancel' ),
		array( 'ion-android-car' => 'Android car' ),
		array( 'ion-android-cart' => 'Android cart' ),
		array( 'ion-android-chat' => 'Android chat' ),
		array( 'ion-android-checkbox' => 'Android checkbox' ),
		array( 'ion-android-checkbox-blank' => 'Android checkbox blank' ),
		array( 'ion-android-checkbox-outline' => 'Android checkbox outline' ),
		array( 'ion-android-checkbox-outline-blank' => 'Android checkbox outline blank' ),
		array( 'ion-android-checkmark-circle' => 'Android checkmark circle' ),
		array( 'ion-android-clipboard' => 'Android clipboard' ),
		array( 'ion-android-close' => 'Android close' ),
		array( 'ion-android-cloud' => 'Android cloud' ),
		array( 'ion-android-cloud-circle' => 'Android cloud circle' ),
		array( 'ion-android-cloud-done' => 'Android cloud done' ),
		array( 'ion-android-cloud-outline' => 'Android cloud outline' ),
		array( 'ion-android-color-palette' => 'Android color palette' ),
		array( 'ion-android-compass' => 'Android compass' ),
		array( 'ion-android-contact' => 'Android contact' ),
		array( 'ion-android-contacts' => 'Android contacts' ),
		array( 'ion-android-contract' => 'Android contract' ),
		array( 'ion-android-create' => 'Android create' ),
		array( 'ion-android-delete' => 'Android delete' ),
		array( 'ion-android-desktop' => 'Android desktop' ),
		array( 'ion-android-document' => 'Android document' ),
		array( 'ion-android-done' => 'Android done' ),
		array( 'ion-android-done-all' => 'Android done all' ),
		array( 'ion-android-download' => 'Android download' ),
		array( 'ion-android-drafts' => 'Android drafts' ),
		array( 'ion-android-exit' => 'Android exit' ),
		array( 'ion-android-expand' => 'Android expand' ),
		array( 'ion-android-favorite' => 'Android favorite' ),
		array( 'ion-android-favorite-outline' => 'Android favorite outline' ),
		array( 'ion-android-film' => 'Android film' ),
		array( 'ion-android-folder' => 'Android folder' ),
		array( 'ion-android-folder-open' => 'Android folder open' ),
		array( 'ion-android-funnel' => 'Android funnel' ),
		array( 'ion-android-globe' => 'Android globe' ),
		array( 'ion-android-hand' => 'Android hand' ),
		array( 'ion-android-hangout' => 'Android hangout' ),
		array( 'ion-android-happy' => 'Android happy' ),
		array( 'ion-android-home' => 'Android home' ),
		array( 'ion-android-image' => 'Android image' ),
		array( 'ion-android-laptop' => 'Android laptop' ),
		array( 'ion-android-list' => 'Android list' ),
		array( 'ion-android-locate' => 'Android locate' ),
		array( 'ion-android-lock' => 'Android lock' ),
		array( 'ion-android-mail' => 'Android mail' ),
		array( 'ion-android-map' => 'Android map' ),
		array( 'ion-android-menu' => 'Android menu' ),
		array( 'ion-android-microphone' => 'Android microphone' ),
		array( 'ion-android-microphone-off' => 'Android microphone off' ),
		array( 'ion-android-more-horizontal' => 'Android more horizontal' ),
		array( 'ion-android-more-vertical' => 'Android more vertical' ),
		array( 'ion-android-navigate' => 'Android navigate' ),
		array( 'ion-android-notifications' => 'Android notifications' ),
		array( 'ion-android-notifications-none' => 'Android notifications none' ),
		array( 'ion-android-notifications-off' => 'Android notifications off' ),
		array( 'ion-android-open' => 'Android open' ),
		array( 'ion-android-options' => 'Android options' ),
		array( 'ion-android-people' => 'Android people' ),
		array( 'ion-android-person' => 'Android person' ),
		array( 'ion-android-person-add' => 'Android person add' ),
		array( 'ion-android-phone-landscape' => 'Android phone landscape' ),
		array( 'ion-android-phone-portrait' => 'Android phone portrait' ),
		array( 'ion-android-pin' => 'Android pin' ),
		array( 'ion-android-plane' => 'Android plane' ),
		array( 'ion-android-playstore' => 'Android playstore' ),
		array( 'ion-android-print' => 'Android print' ),
		array( 'ion-android-radio-button-off' => 'Android radio button off' ),
		array( 'ion-android-radio-button-on' => 'Android radio button on' ),
		array( 'ion-android-refresh' => 'Android refresh' ),
		array( 'ion-android-remove' => 'Android remove' ),
		array( 'ion-android-remove-circle' => 'Android remove circle' ),
		array( 'ion-android-restaurant' => 'Android restaurant' ),
		array( 'ion-android-sad' => 'Android sad' ),
		array( 'ion-android-search' => 'Android search' ),
		array( 'ion-android-send' => 'Android send' ),
		array( 'ion-android-settings' => 'Android settings' ),
		array( 'ion-android-share' => 'Android share' ),
		array( 'ion-android-share-alt' => 'Android share alt' ),
		array( 'ion-android-star' => 'Android star' ),
		array( 'ion-android-star-half' => 'Android star half' ),
		array( 'ion-android-star-outline' => 'Android star outline' ),
		array( 'ion-android-stopwatch' => 'Android stopwatch' ),
		array( 'ion-android-subway' => 'Android subway' ),
		array( 'ion-android-sunny' => 'Android sunny' ),
		array( 'ion-android-sync' => 'Android sync' ),
		array( 'ion-android-textsms' => 'Android textsms' ),
		array( 'ion-android-time' => 'Android time' ),
		array( 'ion-android-train' => 'Android train' ),
		array( 'ion-android-unlock' => 'Android unlock' ),
		array( 'ion-android-upload' => 'Android upload' ),
		array( 'ion-android-volume-down' => 'Android volume down' ),
		array( 'ion-android-volume-mute' => 'Android volume mute' ),
		array( 'ion-android-volume-off' => 'Android volume off' ),
		array( 'ion-android-volume-up' => 'Android volume up' ),
		array( 'ion-android-walk' => 'Android walk' ),
		array( 'ion-android-warning' => 'Android warning' ),
		array( 'ion-android-watch' => 'Android watch' ),
		array( 'ion-android-wifi' => 'Android wifi' ),
		array( 'ion-aperture' => 'Aperture' ),
		array( 'ion-archive' => 'Archive' ),
		array( 'ion-arrow-down-a' => 'Arrow down a' ),
		array( 'ion-arrow-down-b' => 'Arrow down b' ),
		array( 'ion-arrow-down-c' => 'Arrow down c' ),
		array( 'ion-arrow-expand' => 'Arrow expand' ),
		array( 'ion-arrow-graph-down-left' => 'Arrow graph down left' ),
		array( 'ion-arrow-graph-down-right' => 'Arrow graph down right' ),
		array( 'ion-arrow-graph-up-left' => 'Arrow graph up left' ),
		array( 'ion-arrow-graph-up-right' => 'Arrow graph up right' ),
		array( 'ion-arrow-left-a' => 'Arrow left a' ),
		array( 'ion-arrow-left-b' => 'Arrow left b' ),
		array( 'ion-arrow-left-c' => 'Arrow left c' ),
		array( 'ion-arrow-move' => 'Arrow move' ),
		array( 'ion-arrow-resize' => 'Arrow resize' ),
		array( 'ion-arrow-return-left' => 'Arrow return left' ),
		array( 'ion-arrow-return-right' => 'Arrow return right' ),
		array( 'ion-arrow-right-a' => 'Arrow right a' ),
		array( 'ion-arrow-right-b' => 'Arrow right b' ),
		array( 'ion-arrow-right-c' => 'Arrow right c' ),
		array( 'ion-arrow-shrink' => 'Arrow shrink' ),
		array( 'ion-arrow-swap' => 'Arrow swap' ),
		array( 'ion-arrow-up-a' => 'Arrow up a' ),
		array( 'ion-arrow-up-b' => 'Arrow up b' ),
		array( 'ion-arrow-up-c' => 'Arrow up c' ),
		array( 'ion-asterisk' => 'Asterisk' ),
		array( 'ion-at' => 'At' ),
		array( 'ion-backspace' => 'Backspace' ),
		array( 'ion-backspace-outline' => 'Backspace outline' ),
		array( 'ion-bag' => 'Bag' ),
		array( 'ion-battery-charging' => 'Battery charging' ),
		array( 'ion-battery-empty' => 'Battery empty' ),
		array( 'ion-battery-full' => 'Battery full' ),
		array( 'ion-battery-half' => 'Battery half' ),
		array( 'ion-battery-low' => 'Battery low' ),
		array( 'ion-beaker' => 'Beaker' ),
		array( 'ion-beer' => 'Beer' ),
		array( 'ion-bluetooth' => 'Bluetooth' ),
		array( 'ion-bonfire' => 'Bonfire' ),
		array( 'ion-bookmark' => 'Bookmark' ),
		array( 'ion-bowtie' => 'Bowtie' ),
		array( 'ion-briefcase' => 'Briefcase' ),
		array( 'ion-bug' => 'Bug' ),
		array( 'ion-calculator' => 'Calculator' ),
		array( 'ion-calendar' => 'Calendar' ),
		array( 'ion-camera' => 'Camera' ),
		array( 'ion-card' => 'Card' ),
		array( 'ion-cash' => 'Cash' ),
		array( 'ion-chatbox' => 'Chatbox' ),
		array( 'ion-chatbox-working' => 'Chatbox working' ),
		array( 'ion-chatboxes' => 'Chatboxes' ),
		array( 'ion-chatbubble' => 'Chatbubble' ),
		array( 'ion-chatbubble-working' => 'Chatbubble working' ),
		array( 'ion-chatbubbles' => 'Chatbubbles' ),
		array( 'ion-checkmark' => 'Checkmark' ),
		array( 'ion-checkmark-circled' => 'Checkmark circled' ),
		array( 'ion-checkmark-round' => 'Checkmark round' ),
		array( 'ion-chevron-down' => 'Chevron down' ),
		array( 'ion-chevron-left' => 'Chevron left' ),
		array( 'ion-chevron-right' => 'Chevron right' ),
		array( 'ion-chevron-up' => 'Chevron up' ),
		array( 'ion-clipboard' => 'Clipboard' ),
		array( 'ion-clock' => 'Clock' ),
		array( 'ion-close' => 'Close' ),
		array( 'ion-close-circled' => 'Close circled' ),
		array( 'ion-close-round' => 'Close round' ),
		array( 'ion-closed-captioning' => 'Closed captioning' ),
		array( 'ion-cloud' => 'Cloud' ),
		array( 'ion-code' => 'Code' ),
		array( 'ion-code-download' => 'Code download' ),
		array( 'ion-code-working' => 'Code working' ),
		array( 'ion-coffee' => 'Coffee' ),
		array( 'ion-compass' => 'Compass' ),
		array( 'ion-compose' => 'Compose' ),
		array( 'ion-connection-bars' => 'Connection bars' ),
		array( 'ion-contrast' => 'Contrast' ),
		array( 'ion-crop' => 'Crop' ),
		array( 'ion-cube' => 'Cube' ),
		array( 'ion-disc' => 'Disc' ),
		array( 'ion-document' => 'Document' ),
		array( 'ion-document-text' => 'Document text' ),
		array( 'ion-drag' => 'Drag' ),
		array( 'ion-earth' => 'Earth' ),
		array( 'ion-easel' => 'Easel' ),
		array( 'ion-edit' => 'Edit' ),
		array( 'ion-egg' => 'Egg' ),
		array( 'ion-eject' => 'Eject' ),
		array( 'ion-email' => 'Email' ),
		array( 'ion-email-unread' => 'Email unread' ),
		array( 'ion-erlenmeyer-flask' => 'Erlenmeyer flask' ),
		array( 'ion-erlenmeyer-flask-bubbles' => 'Erlenmeyer flask bubbles' ),
		array( 'ion-eye' => 'Eye' ),
		array( 'ion-eye-disabled' => 'Eye disabled' ),
		array( 'ion-female' => 'Female' ),
		array( 'ion-filing' => 'Filing' ),
		array( 'ion-film-marker' => 'Film marker' ),
		array( 'ion-fireball' => 'Fireball' ),
		array( 'ion-flag' => 'Flag' ),
		array( 'ion-flame' => 'Flame' ),
		array( 'ion-flash' => 'Flash' ),
		array( 'ion-flash-off' => 'Flash off' ),
		array( 'ion-folder' => 'Folder' ),
		array( 'ion-fork' => 'Fork' ),
		array( 'ion-fork-repo' => 'Fork repo' ),
		array( 'ion-forward' => 'Forward' ),
		array( 'ion-funnel' => 'Funnel' ),
		array( 'ion-gear-a' => 'Gear a' ),
		array( 'ion-gear-b' => 'Gear b' ),
		array( 'ion-grid' => 'Grid' ),
		array( 'ion-hammer' => 'Hammer' ),
		array( 'ion-happy' => 'Happy' ),
		array( 'ion-happy-outline' => 'Happy outline' ),
		array( 'ion-headphone' => 'Headphone' ),
		array( 'ion-heart' => 'Heart' ),
		array( 'ion-heart-broken' => 'Heart broken' ),
		array( 'ion-help' => 'Help' ),
		array( 'ion-help-buoy' => 'Help buoy' ),
		array( 'ion-help-circled' => 'Help circled' ),
		array( 'ion-home' => 'Home' ),
		array( 'ion-icecream' => 'Icecream' ),
		array( 'ion-image' => 'Image' ),
		array( 'ion-images' => 'Images' ),
		array( 'ion-information' => 'Information' ),
		array( 'ion-information-circled' => 'Information circled' ),
		array( 'ion-ionic' => 'Ionic' ),
		array( 'ion-ios-alarm' => 'Ios alarm' ),
		array( 'ion-ios-alarm-outline' => 'Ios alarm outline' ),
		array( 'ion-ios-albums' => 'Ios albums' ),
		array( 'ion-ios-albums-outline' => 'Ios albums outline' ),
		array( 'ion-ios-americanfootball' => 'Ios americanfootball' ),
		array( 'ion-ios-americanfootball-outline' => 'Ios americanfootball outline' ),
		array( 'ion-ios-analytics' => 'Ios analytics' ),
		array( 'ion-ios-analytics-outline' => 'Ios analytics outline' ),
		array( 'ion-ios-arrow-back' => 'Ios arrow back' ),
		array( 'ion-ios-arrow-down' => 'Ios arrow down' ),
		array( 'ion-ios-arrow-forward' => 'Ios arrow forward' ),
		array( 'ion-ios-arrow-left' => 'Ios arrow left' ),
		array( 'ion-ios-arrow-right' => 'Ios arrow right' ),
		array( 'ion-ios-arrow-thin-down' => 'Ios arrow thin down' ),
		array( 'ion-ios-arrow-thin-left' => 'Ios arrow thin left' ),
		array( 'ion-ios-arrow-thin-right' => 'Ios arrow thin right' ),
		array( 'ion-ios-arrow-thin-up' => 'Ios arrow thin up' ),
		array( 'ion-ios-arrow-up' => 'Ios arrow up' ),
		array( 'ion-ios-at' => 'Ios at' ),
		array( 'ion-ios-at-outline' => 'Ios at outline' ),
		array( 'ion-ios-barcode' => 'Ios barcode' ),
		array( 'ion-ios-barcode-outline' => 'Ios barcode outline' ),
		array( 'ion-ios-baseball' => 'Ios baseball' ),
		array( 'ion-ios-baseball-outline' => 'Ios baseball outline' ),
		array( 'ion-ios-basketball' => 'Ios basketball' ),
		array( 'ion-ios-basketball-outline' => 'Ios basketball outline' ),
		array( 'ion-ios-bell' => 'Ios bell' ),
		array( 'ion-ios-bell-outline' => 'Ios bell outline' ),
		array( 'ion-ios-body' => 'Ios body' ),
		array( 'ion-ios-body-outline' => 'Ios body outline' ),
		array( 'ion-ios-bolt' => 'Ios bolt' ),
		array( 'ion-ios-bolt-outline' => 'Ios bolt outline' ),
		array( 'ion-ios-book' => 'Ios book' ),
		array( 'ion-ios-book-outline' => 'Ios book outline' ),
		array( 'ion-ios-bookmarks' => 'Ios bookmarks' ),
		array( 'ion-ios-bookmarks-outline' => 'Ios bookmarks outline' ),
		array( 'ion-ios-box' => 'Ios box' ),
		array( 'ion-ios-box-outline' => 'Ios box outline' ),
		array( 'ion-ios-briefcase' => 'Ios briefcase' ),
		array( 'ion-ios-briefcase-outline' => 'Ios briefcase outline' ),
		array( 'ion-ios-browsers' => 'Ios browsers' ),
		array( 'ion-ios-browsers-outline' => 'Ios browsers outline' ),
		array( 'ion-ios-calculator' => 'Ios calculator' ),
		array( 'ion-ios-calculator-outline' => 'Ios calculator outline' ),
		array( 'ion-ios-calendar' => 'Ios calendar' ),
		array( 'ion-ios-calendar-outline' => 'Ios calendar outline' ),
		array( 'ion-ios-camera' => 'Ios camera' ),
		array( 'ion-ios-camera-outline' => 'Ios camera outline' ),
		array( 'ion-ios-cart' => 'Ios cart' ),
		array( 'ion-ios-cart-outline' => 'Ios cart outline' ),
		array( 'ion-ios-chatboxes' => 'Ios chatboxes' ),
		array( 'ion-ios-chatboxes-outline' => 'Ios chatboxes outline' ),
		array( 'ion-ios-chatbubble' => 'Ios chatbubble' ),
		array( 'ion-ios-chatbubble-outline' => 'Ios chatbubble outline' ),
		array( 'ion-ios-checkmark' => 'Ios checkmark' ),
		array( 'ion-ios-checkmark-empty' => 'Ios checkmark empty' ),
		array( 'ion-ios-checkmark-outline' => 'Ios checkmark outline' ),
		array( 'ion-ios-circle-filled' => 'Ios circle filled' ),
		array( 'ion-ios-circle-outline' => 'Ios circle outline' ),
		array( 'ion-ios-clock' => 'Ios clock' ),
		array( 'ion-ios-clock-outline' => 'Ios clock outline' ),
		array( 'ion-ios-close' => 'Ios close' ),
		array( 'ion-ios-close-empty' => 'Ios close empty' ),
		array( 'ion-ios-close-outline' => 'Ios close outline' ),
		array( 'ion-ios-cloud' => 'Ios cloud' ),
		array( 'ion-ios-cloud-download' => 'Ios cloud download' ),
		array( 'ion-ios-cloud-download-outline' => 'Ios cloud download outline' ),
		array( 'ion-ios-cloud-outline' => 'Ios cloud outline' ),
		array( 'ion-ios-cloud-upload' => 'Ios cloud upload' ),
		array( 'ion-ios-cloud-upload-outline' => 'Ios cloud upload outline' ),
		array( 'ion-ios-cloudy' => 'Ios cloudy' ),
		array( 'ion-ios-cloudy-night' => 'Ios cloudy night' ),
		array( 'ion-ios-cloudy-night-outline' => 'Ios cloudy night outline' ),
		array( 'ion-ios-cloudy-outline' => 'Ios cloudy outline' ),
		array( 'ion-ios-cog' => 'Ios cog' ),
		array( 'ion-ios-cog-outline' => 'Ios cog outline' ),
		array( 'ion-ios-color-filter' => 'Ios color filter' ),
		array( 'ion-ios-color-filter-outline' => 'Ios color filter outline' ),
		array( 'ion-ios-color-wand' => 'Ios color wand' ),
		array( 'ion-ios-color-wand-outline' => 'Ios color wand outline' ),
		array( 'ion-ios-compose' => 'Ios compose' ),
		array( 'ion-ios-compose-outline' => 'Ios compose outline' ),
		array( 'ion-ios-contact' => 'Ios contact' ),
		array( 'ion-ios-contact-outline' => 'Ios contact outline' ),
		array( 'ion-ios-copy' => 'Ios copy' ),
		array( 'ion-ios-copy-outline' => 'Ios copy outline' ),
		array( 'ion-ios-crop' => 'Ios crop' ),
		array( 'ion-ios-crop-strong' => 'Ios crop strong' ),
		array( 'ion-ios-download' => 'Ios download' ),
		array( 'ion-ios-download-outline' => 'Ios download outline' ),
		array( 'ion-ios-drag' => 'Ios drag' ),
		array( 'ion-ios-email' => 'Ios email' ),
		array( 'ion-ios-email-outline' => 'Ios email outline' ),
		array( 'ion-ios-eye' => 'Ios eye' ),
		array( 'ion-ios-eye-outline' => 'Ios eye outline' ),
		array( 'ion-ios-fastforward' => 'Ios fastforward' ),
		array( 'ion-ios-fastforward-outline' => 'Ios fastforward outline' ),
		array( 'ion-ios-filing' => 'Ios filing' ),
		array( 'ion-ios-filing-outline' => 'Ios filing outline' ),
		array( 'ion-ios-film' => 'Ios film' ),
		array( 'ion-ios-film-outline' => 'Ios film outline' ),
		array( 'ion-ios-flag' => 'Ios flag' ),
		array( 'ion-ios-flag-outline' => 'Ios flag outline' ),
		array( 'ion-ios-flame' => 'Ios flame' ),
		array( 'ion-ios-flame-outline' => 'Ios flame outline' ),
		array( 'ion-ios-flask' => 'Ios flask' ),
		array( 'ion-ios-flask-outline' => 'Ios flask outline' ),
		array( 'ion-ios-flower' => 'Ios flower' ),
		array( 'ion-ios-flower-outline' => 'Ios flower outline' ),
		array( 'ion-ios-folder' => 'Ios folder' ),
		array( 'ion-ios-folder-outline' => 'Ios folder outline' ),
		array( 'ion-ios-football' => 'Ios football' ),
		array( 'ion-ios-football-outline' => 'Ios football outline' ),
		array( 'ion-ios-game-controller-a' => 'Ios game controller a' ),
		array( 'ion-ios-game-controller-a-outline' => 'Ios game controller a outline' ),
		array( 'ion-ios-game-controller-b' => 'Ios game controller b' ),
		array( 'ion-ios-game-controller-b-outline' => 'Ios game controller b outline' ),
		array( 'ion-ios-gear' => 'Ios gear' ),
		array( 'ion-ios-gear-outline' => 'Ios gear outline' ),
		array( 'ion-ios-glasses' => 'Ios glasses' ),
		array( 'ion-ios-glasses-outline' => 'Ios glasses outline' ),
		array( 'ion-ios-grid-view' => 'Ios grid view' ),
		array( 'ion-ios-grid-view-outline' => 'Ios grid view outline' ),
		array( 'ion-ios-heart' => 'Ios heart' ),
		array( 'ion-ios-heart-outline' => 'Ios heart outline' ),
		array( 'ion-ios-help' => 'Ios help' ),
		array( 'ion-ios-help-empty' => 'Ios help empty' ),
		array( 'ion-ios-help-outline' => 'Ios help outline' ),
		array( 'ion-ios-home' => 'Ios home' ),
		array( 'ion-ios-home-outline' => 'Ios home outline' ),
		array( 'ion-ios-infinite' => 'Ios infinite' ),
		array( 'ion-ios-infinite-outline' => 'Ios infinite outline' ),
		array( 'ion-ios-information' => 'Ios information' ),
		array( 'ion-ios-information-empty' => 'Ios information empty' ),
		array( 'ion-ios-information-outline' => 'Ios information outline' ),
		array( 'ion-ios-ionic-outline' => 'Ios ionic outline' ),
		array( 'ion-ios-keypad' => 'Ios keypad' ),
		array( 'ion-ios-keypad-outline' => 'Ios keypad outline' ),
		array( 'ion-ios-lightbulb' => 'Ios lightbulb' ),
		array( 'ion-ios-lightbulb-outline' => 'Ios lightbulb outline' ),
		array( 'ion-ios-list' => 'Ios list' ),
		array( 'ion-ios-list-outline' => 'Ios list outline' ),
		array( 'ion-ios-location' => 'Ios location' ),
		array( 'ion-ios-location-outline' => 'Ios location outline' ),
		array( 'ion-ios-locked' => 'Ios locked' ),
		array( 'ion-ios-locked-outline' => 'Ios locked outline' ),
		array( 'ion-ios-loop' => 'Ios loop' ),
		array( 'ion-ios-loop-strong' => 'Ios loop strong' ),
		array( 'ion-ios-medical' => 'Ios medical' ),
		array( 'ion-ios-medical-outline' => 'Ios medical outline' ),
		array( 'ion-ios-medkit' => 'Ios medkit' ),
		array( 'ion-ios-medkit-outline' => 'Ios medkit outline' ),
		array( 'ion-ios-mic' => 'Ios mic' ),
		array( 'ion-ios-mic-off' => 'Ios mic off' ),
		array( 'ion-ios-mic-outline' => 'Ios mic outline' ),
		array( 'ion-ios-minus' => 'Ios minus' ),
		array( 'ion-ios-minus-empty' => 'Ios minus empty' ),
		array( 'ion-ios-minus-outline' => 'Ios minus outline' ),
		array( 'ion-ios-monitor' => 'Ios monitor' ),
		array( 'ion-ios-monitor-outline' => 'Ios monitor outline' ),
		array( 'ion-ios-moon' => 'Ios moon' ),
		array( 'ion-ios-moon-outline' => 'Ios moon outline' ),
		array( 'ion-ios-more' => 'Ios more' ),
		array( 'ion-ios-more-outline' => 'Ios more outline' ),
		array( 'ion-ios-musical-note' => 'Ios musical note' ),
		array( 'ion-ios-musical-notes' => 'Ios musical notes' ),
		array( 'ion-ios-navigate' => 'Ios navigate' ),
		array( 'ion-ios-navigate-outline' => 'Ios navigate outline' ),
		array( 'ion-ios-nutrition' => 'Ios nutrition' ),
		array( 'ion-ios-nutrition-outline' => 'Ios nutrition outline' ),
		array( 'ion-ios-paper' => 'Ios paper' ),
		array( 'ion-ios-paper-outline' => 'Ios paper outline' ),
		array( 'ion-ios-paperplane' => 'Ios paperplane' ),
		array( 'ion-ios-paperplane-outline' => 'Ios paperplane outline' ),
		array( 'ion-ios-partlysunny' => 'Ios partlysunny' ),
		array( 'ion-ios-partlysunny-outline' => 'Ios partlysunny outline' ),
		array( 'ion-ios-pause' => 'Ios pause' ),
		array( 'ion-ios-pause-outline' => 'Ios pause outline' ),
		array( 'ion-ios-paw' => 'Ios paw' ),
		array( 'ion-ios-paw-outline' => 'Ios paw outline' ),
		array( 'ion-ios-people' => 'Ios people' ),
		array( 'ion-ios-people-outline' => 'Ios people outline' ),
		array( 'ion-ios-person' => 'Ios person' ),
		array( 'ion-ios-person-outline' => 'Ios person outline' ),
		array( 'ion-ios-personadd' => 'Ios personadd' ),
		array( 'ion-ios-personadd-outline' => 'Ios personadd outline' ),
		array( 'ion-ios-photos' => 'Ios photos' ),
		array( 'ion-ios-photos-outline' => 'Ios photos outline' ),
		array( 'ion-ios-pie' => 'Ios pie' ),
		array( 'ion-ios-pie-outline' => 'Ios pie outline' ),
		array( 'ion-ios-pint' => 'Ios pint' ),
		array( 'ion-ios-pint-outline' => 'Ios pint outline' ),
		array( 'ion-ios-play' => 'Ios play' ),
		array( 'ion-ios-play-outline' => 'Ios play outline' ),
		array( 'ion-ios-plus' => 'Ios plus' ),
		array( 'ion-ios-plus-empty' => 'Ios plus empty' ),
		array( 'ion-ios-plus-outline' => 'Ios plus outline' ),
		array( 'ion-ios-pricetag' => 'Ios pricetag' ),
		array( 'ion-ios-pricetag-outline' => 'Ios pricetag outline' ),
		array( 'ion-ios-pricetags' => 'Ios pricetags' ),
		array( 'ion-ios-pricetags-outline' => 'Ios pricetags outline' ),
		array( 'ion-ios-printer' => 'Ios printer' ),
		array( 'ion-ios-printer-outline' => 'Ios printer outline' ),
		array( 'ion-ios-pulse' => 'Ios pulse' ),
		array( 'ion-ios-pulse-strong' => 'Ios pulse strong' ),
		array( 'ion-ios-rainy' => 'Ios rainy' ),
		array( 'ion-ios-rainy-outline' => 'Ios rainy outline' ),
		array( 'ion-ios-recording' => 'Ios recording' ),
		array( 'ion-ios-recording-outline' => 'Ios recording outline' ),
		array( 'ion-ios-redo' => 'Ios redo' ),
		array( 'ion-ios-redo-outline' => 'Ios redo outline' ),
		array( 'ion-ios-refresh' => 'Ios refresh' ),
		array( 'ion-ios-refresh-empty' => 'Ios refresh empty' ),
		array( 'ion-ios-refresh-outline' => 'Ios refresh outline' ),
		array( 'ion-ios-reload' => 'Ios reload' ),
		array( 'ion-ios-reverse-camera' => 'Ios reverse camera' ),
		array( 'ion-ios-reverse-camera-outline' => 'Ios reverse camera outline' ),
		array( 'ion-ios-rewind' => 'Ios rewind' ),
		array( 'ion-ios-rewind-outline' => 'Ios rewind outline' ),
		array( 'ion-ios-rose' => 'Ios rose' ),
		array( 'ion-ios-rose-outline' => 'Ios rose outline' ),
		array( 'ion-ios-search' => 'Ios search' ),
		array( 'ion-ios-search-strong' => 'Ios search strong' ),
		array( 'ion-ios-settings' => 'Ios settings' ),
		array( 'ion-ios-settings-strong' => 'Ios settings strong' ),
		array( 'ion-ios-shuffle' => 'Ios shuffle' ),
		array( 'ion-ios-shuffle-strong' => 'Ios shuffle strong' ),
		array( 'ion-ios-skipbackward' => 'Ios skipbackward' ),
		array( 'ion-ios-skipbackward-outline' => 'Ios skipbackward outline' ),
		array( 'ion-ios-skipforward' => 'Ios skipforward' ),
		array( 'ion-ios-skipforward-outline' => 'Ios skipforward outline' ),
		array( 'ion-ios-snowy' => 'Ios snowy' ),
		array( 'ion-ios-speedometer' => 'Ios speedometer' ),
		array( 'ion-ios-speedometer-outline' => 'Ios speedometer outline' ),
		array( 'ion-ios-star' => 'Ios star' ),
		array( 'ion-ios-star-half' => 'Ios star half' ),
		array( 'ion-ios-star-outline' => 'Ios star outline' ),
		array( 'ion-ios-stopwatch' => 'Ios stopwatch' ),
		array( 'ion-ios-stopwatch-outline' => 'Ios stopwatch outline' ),
		array( 'ion-ios-sunny' => 'Ios sunny' ),
		array( 'ion-ios-sunny-outline' => 'Ios sunny outline' ),
		array( 'ion-ios-telephone' => 'Ios telephone' ),
		array( 'ion-ios-telephone-outline' => 'Ios telephone outline' ),
		array( 'ion-ios-tennisball' => 'Ios tennisball' ),
		array( 'ion-ios-tennisball-outline' => 'Ios tennisball outline' ),
		array( 'ion-ios-thunderstorm' => 'Ios thunderstorm' ),
		array( 'ion-ios-thunderstorm-outline' => 'Ios thunderstorm outline' ),
		array( 'ion-ios-time' => 'Ios time' ),
		array( 'ion-ios-time-outline' => 'Ios time outline' ),
		array( 'ion-ios-timer' => 'Ios timer' ),
		array( 'ion-ios-timer-outline' => 'Ios timer outline' ),
		array( 'ion-ios-toggle' => 'Ios toggle' ),
		array( 'ion-ios-toggle-outline' => 'Ios toggle outline' ),
		array( 'ion-ios-trash' => 'Ios trash' ),
		array( 'ion-ios-trash-outline' => 'Ios trash outline' ),
		array( 'ion-ios-undo' => 'Ios undo' ),
		array( 'ion-ios-undo-outline' => 'Ios undo outline' ),
		array( 'ion-ios-unlocked' => 'Ios unlocked' ),
		array( 'ion-ios-unlocked-outline' => 'Ios unlocked outline' ),
		array( 'ion-ios-upload' => 'Ios upload' ),
		array( 'ion-ios-upload-outline' => 'Ios upload outline' ),
		array( 'ion-ios-videocam' => 'Ios videocam' ),
		array( 'ion-ios-videocam-outline' => 'Ios videocam outline' ),
		array( 'ion-ios-volume-high' => 'Ios volume high' ),
		array( 'ion-ios-volume-low' => 'Ios volume low' ),
		array( 'ion-ios-wineglass' => 'Ios wineglass' ),
		array( 'ion-ios-wineglass-outline' => 'Ios wineglass outline' ),
		array( 'ion-ios-world' => 'Ios world' ),
		array( 'ion-ios-world-outline' => 'Ios world outline' ),
		array( 'ion-ipad' => 'Ipad' ),
		array( 'ion-iphone' => 'Iphone' ),
		array( 'ion-ipod' => 'Ipod' ),
		array( 'ion-jet' => 'Jet' ),
		array( 'ion-key' => 'Key' ),
		array( 'ion-knife' => 'Knife' ),
		array( 'ion-laptop' => 'Laptop' ),
		array( 'ion-leaf' => 'Leaf' ),
		array( 'ion-levels' => 'Levels' ),
		array( 'ion-lightbulb' => 'Lightbulb' ),
		array( 'ion-link' => 'Link' ),
		array( 'ion-load-a' => 'Load a' ),
		array( 'ion-load-b' => 'Load b' ),
		array( 'ion-load-c' => 'Load c' ),
		array( 'ion-load-d' => 'Load d' ),
		array( 'ion-location' => 'Location' ),
		array( 'ion-lock-combination' => 'Lock combination' ),
		array( 'ion-locked' => 'Locked' ),
		array( 'ion-log-in' => 'Log in' ),
		array( 'ion-log-out' => 'Log out' ),
		array( 'ion-loop' => 'Loop' ),
		array( 'ion-magnet' => 'Magnet' ),
		array( 'ion-male' => 'Male' ),
		array( 'ion-man' => 'Man' ),
		array( 'ion-map' => 'Map' ),
		array( 'ion-medkit' => 'Medkit' ),
		array( 'ion-merge' => 'Merge' ),
		array( 'ion-mic-a' => 'Mic a' ),
		array( 'ion-mic-b' => 'Mic b' ),
		array( 'ion-mic-c' => 'Mic c' ),
		array( 'ion-minus' => 'Minus' ),
		array( 'ion-minus-circled' => 'Minus circled' ),
		array( 'ion-minus-round' => 'Minus round' ),
		array( 'ion-model-s' => 'Model s' ),
		array( 'ion-monitor' => 'Monitor' ),
		array( 'ion-more' => 'More' ),
		array( 'ion-mouse' => 'Mouse' ),
		array( 'ion-music-note' => 'Music note' ),
		array( 'ion-navicon' => 'Navicon' ),
		array( 'ion-navicon-round' => 'Navicon round' ),
		array( 'ion-navigate' => 'Navigate' ),
		array( 'ion-network' => 'Network' ),
		array( 'ion-no-smoking' => 'No smoking' ),
		array( 'ion-nuclear' => 'Nuclear' ),
		array( 'ion-outlet' => 'Outlet' ),
		array( 'ion-paintbrush' => 'Paintbrush' ),
		array( 'ion-paintbucket' => 'Paintbucket' ),
		array( 'ion-paper-airplane' => 'Paper airplane' ),
		array( 'ion-paperclip' => 'Paperclip' ),
		array( 'ion-pause' => 'Pause' ),
		array( 'ion-person' => 'Person' ),
		array( 'ion-person-add' => 'Person add' ),
		array( 'ion-person-stalker' => 'Person stalker' ),
		array( 'ion-pie-graph' => 'Pie graph' ),
		array( 'ion-pin' => 'Pin' ),
		array( 'ion-pinpoint' => 'Pinpoint' ),
		array( 'ion-pizza' => 'Pizza' ),
		array( 'ion-plane' => 'Plane' ),
		array( 'ion-planet' => 'Planet' ),
		array( 'ion-play' => 'Play' ),
		array( 'ion-playstation' => 'Playstation' ),
		array( 'ion-plus' => 'Plus' ),
		array( 'ion-plus-circled' => 'Plus circled' ),
		array( 'ion-plus-round' => 'Plus round' ),
		array( 'ion-podium' => 'Podium' ),
		array( 'ion-pound' => 'Pound' ),
		array( 'ion-power' => 'Power' ),
		array( 'ion-pricetag' => 'Pricetag' ),
		array( 'ion-pricetags' => 'Pricetags' ),
		array( 'ion-printer' => 'Printer' ),
		array( 'ion-pull-request' => 'Pull request' ),
		array( 'ion-qr-scanner' => 'Qr scanner' ),
		array( 'ion-quote' => 'Quote' ),
		array( 'ion-radio-waves' => 'Radio waves' ),
		array( 'ion-record' => 'Record' ),
		array( 'ion-refresh' => 'Refresh' ),
		array( 'ion-reply' => 'Reply' ),
		array( 'ion-reply-all' => 'Reply all' ),
		array( 'ion-ribbon-a' => 'Ribbon a' ),
		array( 'ion-ribbon-b' => 'Ribbon b' ),
		array( 'ion-sad' => 'Sad' ),
		array( 'ion-sad-outline' => 'Sad outline' ),
		array( 'ion-scissors' => 'Scissors' ),
		array( 'ion-search' => 'Search' ),
		array( 'ion-settings' => 'Settings' ),
		array( 'ion-share' => 'Share' ),
		array( 'ion-shuffle' => 'Shuffle' ),
		array( 'ion-skip-backward' => 'Skip backward' ),
		array( 'ion-skip-forward' => 'Skip forward' ),
		array( 'ion-social-android' => 'Social android' ),
		array( 'ion-social-android-outline' => 'Social android outline' ),
		array( 'ion-social-angular' => 'Social angular' ),
		array( 'ion-social-angular-outline' => 'Social angular outline' ),
		array( 'ion-social-apple' => 'Social apple' ),
		array( 'ion-social-apple-outline' => 'Social apple outline' ),
		array( 'ion-social-bitcoin' => 'Social bitcoin' ),
		array( 'ion-social-bitcoin-outline' => 'Social bitcoin outline' ),
		array( 'ion-social-buffer' => 'Social buffer' ),
		array( 'ion-social-buffer-outline' => 'Social buffer outline' ),
		array( 'ion-social-chrome' => 'Social chrome' ),
		array( 'ion-social-chrome-outline' => 'Social chrome outline' ),
		array( 'ion-social-codepen' => 'Social codepen' ),
		array( 'ion-social-codepen-outline' => 'Social codepen outline' ),
		array( 'ion-social-css3' => 'Social css3' ),
		array( 'ion-social-css3-outline' => 'Social css3 outline' ),
		array( 'ion-social-designernews' => 'Social designernews' ),
		array( 'ion-social-designernews-outline' => 'Social designernews outline' ),
		array( 'ion-social-dribbble' => 'Social dribbble' ),
		array( 'ion-social-dribbble-outline' => 'Social dribbble outline' ),
		array( 'ion-social-dropbox' => 'Social dropbox' ),
		array( 'ion-social-dropbox-outline' => 'Social dropbox outline' ),
		array( 'ion-social-euro' => 'Social euro' ),
		array( 'ion-social-euro-outline' => 'Social euro outline' ),
		array( 'ion-social-facebook' => 'Social facebook' ),
		array( 'ion-social-facebook-outline' => 'Social facebook outline' ),
		array( 'ion-social-foursquare' => 'Social foursquare' ),
		array( 'ion-social-foursquare-outline' => 'Social foursquare outline' ),
		array( 'ion-social-freebsd-devil' => 'Social freebsd devil' ),
		array( 'ion-social-github' => 'Social github' ),
		array( 'ion-social-github-outline' => 'Social github outline' ),
		array( 'ion-social-google' => 'Social google' ),
		array( 'ion-social-google-outline' => 'Social google outline' ),
		array( 'ion-social-googleplus' => 'Social googleplus' ),
		array( 'ion-social-googleplus-outline' => 'Social googleplus outline' ),
		array( 'ion-social-hackernews' => 'Social hackernews' ),
		array( 'ion-social-hackernews-outline' => 'Social hackernews outline' ),
		array( 'ion-social-html5' => 'Social html5' ),
		array( 'ion-social-html5-outline' => 'Social html5 outline' ),
		array( 'ion-social-instagram' => 'Social instagram' ),
		array( 'ion-social-instagram-outline' => 'Social instagram outline' ),
		array( 'ion-social-javascript' => 'Social javascript' ),
		array( 'ion-social-javascript-outline' => 'Social javascript outline' ),
		array( 'ion-social-linkedin' => 'Social linkedin' ),
		array( 'ion-social-linkedin-outline' => 'Social linkedin outline' ),
		array( 'ion-social-markdown' => 'Social markdown' ),
		array( 'ion-social-nodejs' => 'Social nodejs' ),
		array( 'ion-social-octocat' => 'Social octocat' ),
		array( 'ion-social-pinterest' => 'Social pinterest' ),
		array( 'ion-social-pinterest-outline' => 'Social pinterest outline' ),
		array( 'ion-social-python' => 'Social python' ),
		array( 'ion-social-reddit' => 'Social reddit' ),
		array( 'ion-social-reddit-outline' => 'Social reddit outline' ),
		array( 'ion-social-rss' => 'Social rss' ),
		array( 'ion-social-rss-outline' => 'Social rss outline' ),
		array( 'ion-social-sass' => 'Social sass' ),
		array( 'ion-social-skype' => 'Social skype' ),
		array( 'ion-social-skype-outline' => 'Social skype outline' ),
		array( 'ion-social-snapchat' => 'Social snapchat' ),
		array( 'ion-social-snapchat-outline' => 'Social snapchat outline' ),
		array( 'ion-social-tumblr' => 'Social tumblr' ),
		array( 'ion-social-tumblr-outline' => 'Social tumblr outline' ),
		array( 'ion-social-tux' => 'Social tux' ),
		array( 'ion-social-twitch' => 'Social twitch' ),
		array( 'ion-social-twitch-outline' => 'Social twitch outline' ),
		array( 'ion-social-twitter' => 'Social twitter' ),
		array( 'ion-social-twitter-outline' => 'Social twitter outline' ),
		array( 'ion-social-usd' => 'Social usd' ),
		array( 'ion-social-usd-outline' => 'Social usd outline' ),
		array( 'ion-social-vimeo' => 'Social vimeo' ),
		array( 'ion-social-vimeo-outline' => 'Social vimeo outline' ),
		array( 'ion-social-whatsapp' => 'Social whatsapp' ),
		array( 'ion-social-whatsapp-outline' => 'Social whatsapp outline' ),
		array( 'ion-social-windows' => 'Social windows' ),
		array( 'ion-social-windows-outline' => 'Social windows outline' ),
		array( 'ion-social-wordpress' => 'Social wordpress' ),
		array( 'ion-social-wordpress-outline' => 'Social wordpress outline' ),
		array( 'ion-social-yahoo' => 'Social yahoo' ),
		array( 'ion-social-yahoo-outline' => 'Social yahoo outline' ),
		array( 'ion-social-yen' => 'Social yen' ),
		array( 'ion-social-yen-outline' => 'Social yen outline' ),
		array( 'ion-social-youtube' => 'Social youtube' ),
		array( 'ion-social-youtube-outline' => 'Social youtube outline' ),
		array( 'ion-soup-can' => 'Soup can' ),
		array( 'ion-soup-can-outline' => 'Soup can outline' ),
		array( 'ion-speakerphone' => 'Speakerphone' ),
		array( 'ion-speedometer' => 'Speedometer' ),
		array( 'ion-spoon' => 'Spoon' ),
		array( 'ion-star' => 'Star' ),
		array( 'ion-stats-bars' => 'Stats bars' ),
		array( 'ion-steam' => 'Steam' ),
		array( 'ion-stop' => 'Stop' ),
		array( 'ion-thermometer' => 'Thermometer' ),
		array( 'ion-thumbsdown' => 'Thumbsdown' ),
		array( 'ion-thumbsup' => 'Thumbsup' ),
		array( 'ion-toggle' => 'Toggle' ),
		array( 'ion-toggle-filled' => 'Toggle filled' ),
		array( 'ion-transgender' => 'Transgender' ),
		array( 'ion-trash-a' => 'Trash a' ),
		array( 'ion-trash-b' => 'Trash b' ),
		array( 'ion-trophy' => 'Trophy' ),
		array( 'ion-tshirt' => 'Tshirt' ),
		array( 'ion-tshirt-outline' => 'Tshirt outline' ),
		array( 'ion-umbrella' => 'Umbrella' ),
		array( 'ion-university' => 'University' ),
		array( 'ion-unlocked' => 'Unlocked' ),
		array( 'ion-upload' => 'Upload' ),
		array( 'ion-usb' => 'Usb' ),
		array( 'ion-videocamera' => 'Videocamera' ),
		array( 'ion-volume-high' => 'Volume high' ),
		array( 'ion-volume-low' => 'Volume low' ),
		array( 'ion-volume-medium' => 'Volume medium' ),
		array( 'ion-volume-mute' => 'Volume mute' ),
		array( 'ion-wand' => 'Wand' ),
		array( 'ion-waterdrop' => 'Waterdrop' ),
		array( 'ion-wifi' => 'Wifi' ),
		array( 'ion-wineglass' => 'Wineglass' ),
		array( 'ion-woman' => 'Woman' ),
		array( 'ion-wrench' => 'Wrench' ),
		array( 'ion-xbox' => 'Xbox' ),
	);

	return $ionicons;
}
add_filter( 'vc_iconpicker-type-ionicons', 'wvc_add_ionicons_font' );

/**
 * Add Dripicons
 *
 * @param $icons
 * @return array
 */
function wvc_add_dripicons_font( $icons ) {

	$dripicons = array(
array( 'dripicons-alarm' => 'Alarm' ),
array( 'dripicons-align-center' => 'Align center' ),
array( 'dripicons-align-justify' => 'Align justify' ),
array( 'dripicons-align-left' => 'Align left' ),
array( 'dripicons-align-right' => 'Align right' ),
array( 'dripicons-anchor' => 'Anchor' ),
array( 'dripicons-archive' => 'Archive' ),
array( 'dripicons-arrow-down' => 'Arrow down' ),
array( 'dripicons-arrow-left' => 'Arrow left' ),
array( 'dripicons-arrow-right' => 'Arrow right' ),
array( 'dripicons-arrow-thin-down' => 'Arrow thin down' ),
array( 'dripicons-arrow-thin-left' => 'Arrow thin left' ),
array( 'dripicons-arrow-thin-right' => 'Arrow thin right' ),
array( 'dripicons-arrow-thin-up' => 'Arrow thin up' ),
array( 'dripicons-arrow-up' => 'Arrow up' ),
array( 'dripicons-article' => 'Article' ),
array( 'dripicons-backspace' => 'Backspace' ),
array( 'dripicons-basket' => 'Basket' ),
array( 'dripicons-basketball' => 'Basketball' ),
array( 'dripicons-battery-empty' => 'Battery empty' ),
array( 'dripicons-battery-full' => 'Battery full' ),
array( 'dripicons-battery-low' => 'Battery low' ),
array( 'dripicons-battery-medium' => 'Battery medium' ),
array( 'dripicons-bell' => 'Bell' ),
array( 'dripicons-blog' => 'Blog' ),
array( 'dripicons-bluetooth' => 'Bluetooth' ),
array( 'dripicons-bold' => 'Bold' ),
array( 'dripicons-bookmark' => 'Bookmark' ),
array( 'dripicons-bookmarks' => 'Bookmarks' ),
array( 'dripicons-box' => 'Box' ),
array( 'dripicons-briefcase' => 'Briefcase' ),
array( 'dripicons-brightness-low' => 'Brightness low' ),
array( 'dripicons-brightness-max' => 'Brightness max' ),
array( 'dripicons-brightness-medium' => 'Brightness medium' ),
array( 'dripicons-broadcast' => 'Broadcast' ),
array( 'dripicons-browser' => 'Browser' ),
array( 'dripicons-browser-upload' => 'Browser upload' ),
array( 'dripicons-brush' => 'Brush' ),
array( 'dripicons-calendar' => 'Calendar' ),
array( 'dripicons-camcorder' => 'Camcorder' ),
array( 'dripicons-camera' => 'Camera' ),
array( 'dripicons-card' => 'Card' ),
array( 'dripicons-cart' => 'Cart' ),
array( 'dripicons-checklist' => 'Checklist' ),
array( 'dripicons-checkmark' => 'Checkmark' ),
array( 'dripicons-chevron-down' => 'Chevron down' ),
array( 'dripicons-chevron-left' => 'Chevron left' ),
array( 'dripicons-chevron-right' => 'Chevron right' ),
array( 'dripicons-chevron-up' => 'Chevron up' ),
array( 'dripicons-clipboard' => 'Clipboard' ),
array( 'dripicons-clock' => 'Clock' ),
array( 'dripicons-clockwise' => 'Clockwise' ),
array( 'dripicons-cloud' => 'Cloud' ),
array( 'dripicons-cloud-download' => 'Cloud download' ),
array( 'dripicons-cloud-upload' => 'Cloud upload' ),
array( 'dripicons-code' => 'Code' ),
array( 'dripicons-contract' => 'Contract' ),
array( 'dripicons-contract-2' => 'Contract 2' ),
array( 'dripicons-conversation' => 'Conversation' ),
array( 'dripicons-copy' => 'Copy' ),
array( 'dripicons-crop' => 'Crop' ),
array( 'dripicons-cross' => 'Cross' ),
array( 'dripicons-crosshair' => 'Crosshair' ),
array( 'dripicons-cutlery' => 'Cutlery' ),
array( 'dripicons-device-desktop' => 'Device desktop' ),
array( 'dripicons-device-mobile' => 'Device mobile' ),
array( 'dripicons-device-tablet' => 'Device tablet' ),
array( 'dripicons-direction' => 'Direction' ),
array( 'dripicons-disc' => 'Disc' ),
array( 'dripicons-document' => 'Document' ),
array( 'dripicons-document-delete' => 'Document delete' ),
array( 'dripicons-document-edit' => 'Document edit' ),
array( 'dripicons-document-new' => 'Document new' ),
array( 'dripicons-document-remove' => 'Document remove' ),
array( 'dripicons-dot' => 'Dot' ),
array( 'dripicons-dots-2' => 'Dots 2' ),
array( 'dripicons-dots-3' => 'Dots 3' ),
array( 'dripicons-download' => 'Download' ),
array( 'dripicons-duplicate' => 'Duplicate' ),
array( 'dripicons-enter' => 'Enter' ),
array( 'dripicons-exit' => 'Exit' ),
array( 'dripicons-expand' => 'Expand' ),
array( 'dripicons-expand-2' => 'Expand 2' ),
array( 'dripicons-experiment' => 'Experiment' ),
array( 'dripicons-export' => 'Export' ),
array( 'dripicons-feed' => 'Feed' ),
array( 'dripicons-flag' => 'Flag' ),
array( 'dripicons-flashlight' => 'Flashlight' ),
array( 'dripicons-folder' => 'Folder' ),
array( 'dripicons-folder-open' => 'Folder open' ),
array( 'dripicons-forward' => 'Forward' ),
array( 'dripicons-gaming' => 'Gaming' ),
array( 'dripicons-gear' => 'Gear' ),
array( 'dripicons-graduation' => 'Graduation' ),
array( 'dripicons-graph-bar' => 'Graph bar' ),
array( 'dripicons-graph-line' => 'Graph line' ),
array( 'dripicons-graph-pie' => 'Graph pie' ),
array( 'dripicons-headset' => 'Headset' ),
array( 'dripicons-heart' => 'Heart' ),
array( 'dripicons-help' => 'Help' ),
array( 'dripicons-home' => 'Home' ),
array( 'dripicons-hourglass' => 'Hourglass' ),
array( 'dripicons-inbox' => 'Inbox' ),
array( 'dripicons-information' => 'Information' ),
array( 'dripicons-italic' => 'Italic' ),
array( 'dripicons-jewel' => 'Jewel' ),
array( 'dripicons-lifting' => 'Lifting' ),
array( 'dripicons-lightbulb' => 'Lightbulb' ),
array( 'dripicons-link' => 'Link' ),
array( 'dripicons-link-broken' => 'Link broken' ),
array( 'dripicons-list' => 'List' ),
array( 'dripicons-loading' => 'Loading' ),
array( 'dripicons-location' => 'Location' ),
array( 'dripicons-lock' => 'Lock' ),
array( 'dripicons-lock-open' => 'Lock open' ),
array( 'dripicons-mail' => 'Mail' ),
array( 'dripicons-map' => 'Map' ),
array( 'dripicons-media-loop' => 'Media loop' ),
array( 'dripicons-media-next' => 'Media next' ),
array( 'dripicons-media-pause' => 'Media pause' ),
array( 'dripicons-media-play' => 'Media play' ),
array( 'dripicons-media-previous' => 'Media previous' ),
array( 'dripicons-media-record' => 'Media record' ),
array( 'dripicons-media-shuffle' => 'Media shuffle' ),
array( 'dripicons-media-stop' => 'Media stop' ),
array( 'dripicons-medical' => 'Medical' ),
array( 'dripicons-menu' => 'Menu' ),
array( 'dripicons-message' => 'Message' ),
array( 'dripicons-meter' => 'Meter' ),
array( 'dripicons-microphone' => 'Microphone' ),
array( 'dripicons-minus' => 'Minus' ),
array( 'dripicons-monitor' => 'Monitor' ),
array( 'dripicons-move' => 'Move' ),
array( 'dripicons-music' => 'Music' ),
array( 'dripicons-network-1' => 'Network 1' ),
array( 'dripicons-network-2' => 'Network 2' ),
array( 'dripicons-network-3' => 'Network 3' ),
array( 'dripicons-network-4' => 'Network 4' ),
array( 'dripicons-network-5' => 'Network 5' ),
array( 'dripicons-pamphlet' => 'Pamphlet' ),
array( 'dripicons-paperclip' => 'Paperclip' ),
array( 'dripicons-pencil' => 'Pencil' ),
array( 'dripicons-phone' => 'Phone' ),
array( 'dripicons-photo' => 'Photo' ),
array( 'dripicons-photo-group' => 'Photo group' ),
array( 'dripicons-pill' => 'Pill' ),
array( 'dripicons-pin' => 'Pin' ),
array( 'dripicons-plus' => 'Plus' ),
array( 'dripicons-power' => 'Power' ),
array( 'dripicons-preview' => 'Preview' ),
array( 'dripicons-print' => 'Print' ),
array( 'dripicons-pulse' => 'Pulse' ),
array( 'dripicons-question' => 'Question' ),
array( 'dripicons-reply' => 'Reply' ),
array( 'dripicons-reply-all' => 'Reply all' ),
array( 'dripicons-return' => 'Return' ),
array( 'dripicons-retweet' => 'Retweet' ),
array( 'dripicons-rocket' => 'Rocket' ),
array( 'dripicons-scale' => 'Scale' ),
array( 'dripicons-search' => 'Search' ),
array( 'dripicons-shopping-bag' => 'Shopping bag' ),
array( 'dripicons-skip' => 'Skip' ),
array( 'dripicons-stack' => 'Stack' ),
array( 'dripicons-star' => 'Star' ),
array( 'dripicons-stopwatch' => 'Stopwatch' ),
array( 'dripicons-store' => 'Store' ),
array( 'dripicons-suitcase' => 'Suitcase' ),
array( 'dripicons-swap' => 'Swap' ),
array( 'dripicons-tag' => 'Tag' ),
array( 'dripicons-tag-delete' => 'Tag delete' ),
array( 'dripicons-tags' => 'Tags' ),
array( 'dripicons-thumbs-down' => 'Thumbs down' ),
array( 'dripicons-thumbs-up' => 'Thumbs up' ),
array( 'dripicons-ticket' => 'Ticket' ),
array( 'dripicons-time-reverse' => 'Time reverse' ),
array( 'dripicons-to-do' => 'To do' ),
array( 'dripicons-toggles' => 'Toggles' ),
array( 'dripicons-trash' => 'Trash' ),
array( 'dripicons-trophy' => 'Trophy' ),
array( 'dripicons-upload' => 'Upload' ),
array( 'dripicons-user' => 'User' ),
array( 'dripicons-user-group' => 'User group' ),
array( 'dripicons-user-id' => 'User id' ),
array( 'dripicons-vibrate' => 'Vibrate' ),
array( 'dripicons-view-apps' => 'View apps' ),
array( 'dripicons-view-list' => 'View list' ),
array( 'dripicons-view-list-large' => 'View list large' ),
array( 'dripicons-view-thumb' => 'View thumb' ),
array( 'dripicons-volume-full' => 'Volume full' ),
array( 'dripicons-volume-low' => 'Volume low' ),
array( 'dripicons-volume-medium' => 'Volume medium' ),
array( 'dripicons-volume-off' => 'Volume off' ),
array( 'dripicons-wallet' => 'Wallet' ),
array( 'dripicons-warning' => 'Warning' ),
array( 'dripicons-web' => 'Web' ),
array( 'dripicons-weight' => 'Weight' ),
array( 'dripicons-wifi' => 'Wifi' ),
array( 'dripicons-wrong' => 'Wrong' ),
array( 'dripicons-zoom-in' => 'Zoom in' ),
array( 'dripicons-zoom-out' => 'Zoom out' ),
	);

	return $dripicons;
}
add_filter( 'vc_iconpicker-type-dripicons', 'wvc_add_dripicons_font' );

/**
 * Add Iconic font
 *
 * @param $icons
 * @return array
 */
function wvc_add_iconmonstr_iconic_font_font( $icons ) {

	$iconic_font = array(
		array( 'im-angle-right' => 'Angle right' ),
array( 'im-angle-left' => 'Angle left' ),
array( 'im-angle-down' => 'Angle down' ),
array( 'im-angle-up' => 'Angle up' ),
array( 'im-angle-right-circle' => 'Angle right circle' ),
array( 'im-angle-left-circle' => 'Angle left circle' ),
array( 'im-angle-down-circle' => 'Angle down circle' ),
array( 'im-angle-up-circle' => 'Angle up circle' ),
array( 'im-arrow-right' => 'Arrow right' ),
array( 'im-arrow-left' => 'Arrow left' ),
array( 'im-arrow-down' => 'Arrow down' ),
array( 'im-arrow-up' => 'Arrow up' ),
array( 'im-arrow-right-circle' => 'Arrow right circle' ),
array( 'im-arrow-left-circle' => 'Arrow left circle' ),
array( 'im-arrow-down-circle' => 'Arrow down circle' ),
array( 'im-arrow-up-circle' => 'Arrow up circle' ),
array( 'im-care-right' => 'Care right' ),
array( 'im-care-left' => 'Care left' ),
array( 'im-care-down' => 'Care down' ),
array( 'im-care-up' => 'Care up' ),
array( 'im-forbidden' => 'Forbidden' ),
array( 'im-printer' => 'Printer' ),
array( 'im-menu' => 'Menu' ),
array( 'im-menu-list' => 'Menu list' ),
array( 'im-quote-left' => 'Quote left' ),
array( 'im-quote-right' => 'Quote right' ),
array( 'im-bell' => 'Bell' ),
array( 'im-bell-off' => 'Bell off' ),
array( 'im-bookmark' => 'Bookmark' ),
array( 'im-briefcase' => 'Briefcase' ),
array( 'im-calendar' => 'Calendar' ),
array( 'im-photo-camera' => 'Photo camera' ),
array( 'im-video-camera' => 'Video camera' ),
array( 'im-microphone' => 'Microphone' ),
array( 'im-check-mark' => 'Check mark' ),
array( 'im-check-mark-circle' => 'Check mark circle' ),
array( 'im-check-square-o' => 'Check square o' ),
array( 'im-check-square' => 'Check square' ),
array( 'im-check-square-i' => 'Check square i' ),
array( 'im-square-o' => 'Square o' ),
array( 'im-radio-button-circle-o' => 'Radio button circle o' ),
array( 'im-radio-button-circle' => 'Radio button circle' ),
array( 'im-circle-o' => 'Circle o' ),
array( 'im-clock-o' => 'Clock o' ),
array( 'im-cloud' => 'Cloud' ),
array( 'im-cloud-download' => 'Cloud download' ),
array( 'im-cloud-upload' => 'Cloud upload' ),
array( 'im-code' => 'Code' ),
array( 'im-speech-bubble' => 'Speech bubble' ),
array( 'im-speech-bubble-comment' => 'Speech bubble comment' ),
array( 'im-speech-bubble-comments' => 'Speech bubble comments' ),
array( 'im-copy' => 'Copy' ),
array( 'im-credit-card' => 'Credit card' ),
array( 'im-crown' => 'Crown' ),
array( 'im-database' => 'Database' ),
array( 'im-computer' => 'Computer' ),
array( 'im-download' => 'Download' ),
array( 'im-upload' => 'Upload' ),
array( 'im-pencil' => 'Pencil' ),
array( 'im-edit-off' => 'Edit off' ),
array( 'im-play' => 'Play' ),
array( 'im-pause' => 'Pause' ),
array( 'im-stop' => 'Stop' ),
array( 'im-eject' => 'Eject' ),
array( 'im-previous' => 'Previous' ),
array( 'im-next' => 'Next' ),
array( 'im-loop' => 'Loop' ),
array( 'im-random' => 'Random' ),
array( 'im-menu-dot-h' => 'Menu dot h' ),
array( 'im-menu-dot-v' => 'Menu dot v' ),
array( 'im-mail' => 'Mail' ),
array( 'im-info' => 'Info' ),
array( 'im-warning' => 'Warning' ),
array( 'im-question' => 'Question' ),
array( 'im-link' => 'Link' ),
array( 'im-unlink' => 'Unlink' ),
array( 'im-external-link' => 'External link' ),
array( 'im-eye' => 'Eye' ),
array( 'im-eye-off' => 'Eye off' ),
array( 'im-file' => 'File' ),
array( 'im-file-o' => 'File o' ),
array( 'im-files-o' => 'Files o' ),
array( 'im-video' => 'Video' ),
array( 'im-audio' => 'Audio' ),
array( 'im-picture-o' => 'Picture o' ),
array( 'im-flag' => 'Flag' ),
array( 'im-folder' => 'Folder' ),
array( 'im-folder-open' => 'Folder open' ),
array( 'im-smiley-o' => 'Smiley o' ),
array( 'im-frown-o' => 'Frown o' ),
array( 'im-gear' => 'Gear' ),
array( 'im-globe' => 'Globe' ),
array( 'im-heart' => 'Heart' ),
array( 'im-home' => 'Home' ),
array( 'im-inbox' => 'Inbox' ),
array( 'im-key' => 'Key' ),
array( 'im-lock' => 'Lock' ),
array( 'im-lock-open' => 'Lock open' ),
array( 'im-task-o' => 'Task o' ),
array( 'im-filter' => 'Filter' ),
array( 'im-light-bulb' => 'Light bulb' ),
array( 'im-flash' => 'Flash' ),
array( 'im-map-o' => 'Map o' ),
array( 'im-location' => 'Location' ),
array( 'im-maximize' => 'Maximize' ),
array( 'im-minimize' => 'Minimize' ),
array( 'im-fullscreen' => 'Fullscreen' ),
array( 'im-mobile' => 'Mobile' ),
array( 'im-phone' => 'Phone' ),
array( 'im-coin' => 'Coin' ),
array( 'im-banknote' => 'Banknote' ),
array( 'im-paper-clip' => 'Paper clip' ),
array( 'im-bar-chart' => 'Bar chart' ),
array( 'im-plus' => 'Plus' ),
array( 'im-minus' => 'Minus' ),
array( 'im-plus-circle' => 'Plus circle' ),
array( 'im-minus-circle' => 'Minus circle' ),
array( 'im-undo' => 'Undo' ),
array( 'im-redo' => 'Redo' ),
array( 'im-rocket' => 'Rocket' ),
array( 'im-rss' => 'Rss' ),
array( 'im-magnifier' => 'Magnifier' ),
array( 'im-magnifier-plus' => 'Magnifier plus' ),
array( 'im-magnifier-minus' => 'Magnifier minus' ),
array( 'im-share' => 'Share' ),
array( 'im-shield' => 'Shield' ),
array( 'im-shopping-cart' => 'Shopping cart' ),
array( 'im-sign-in' => 'Sign in' ),
array( 'im-sign-out' => 'Sign out' ),
array( 'im-spinner' => 'Spinner' ),
array( 'im-star' => 'Star' ),
array( 'im-star-half' => 'Star half' ),
array( 'im-star-o' => 'Star o' ),
array( 'im-sync' => 'Sync' ),
array( 'im-table' => 'Table' ),
array( 'im-window-o' => 'Window o' ),
array( 'im-windows-o' => 'Windows o' ),
array( 'im-thumb-up' => 'Thumb up' ),
array( 'im-thumb-down' => 'Thumb down' ),
array( 'im-x-mark' => 'X mark' ),
array( 'im-x-mark-circle' => 'X mark circle' ),
array( 'im-trash-can' => 'Trash can' ),
array( 'im-user-male' => 'User male' ),
array( 'im-user-female' => 'User female' ),
array( 'im-user-circle' => 'User circle' ),
array( 'im-users' => 'Users' ),
array( 'im-volume' => 'Volume' ),
array( 'im-volume-off' => 'Volume off' ),
array( 'im-wifi' => 'Wifi' ),
array( 'im-tools' => 'Tools' ),
array( 'im-dashboard' => 'Dashboard' ),
array( 'im-archive' => 'Archive' ),
array( 'im-save' => 'Save' ),
array( 'im-floppy-disk' => 'Floppy disk' ),
array( 'im-sitemap' => 'Sitemap' ),
array( 'im-toggle' => 'Toggle' ),
array( 'im-tag' => 'Tag' ),
array( 'im-tags' => 'Tags' ),
array( 'im-wizard' => 'Wizard' ),
array( 'im-book' => 'Book' ),
array( 'im-fire' => 'Fire' ),
array( 'im-id-card' => 'Id card' ),
array( 'im-note-o' => 'Note o' ),
array( 'im-control-panel' => 'Control panel' ),
array( 'im-facebook' => 'Facebook' ),
array( 'im-facebook-like' => 'Facebook like' ),
array( 'im-twitter' => 'Twitter' ),
array( 'im-amazon' => 'Amazon' ),
array( 'im-android-os' => 'Android os' ),
array( 'im-apple-os' => 'Apple os' ),
array( 'im-windows-os' => 'Windows os' ),
array( 'im-linux-os' => 'Linux os' ),
array( 'im-chrome' => 'Chrome' ),
array( 'im-ie' => 'Ie' ),
array( 'im-edge' => 'Edge' ),
array( 'im-firefox' => 'Firefox' ),
array( 'im-safari' => 'Safari' ),
array( 'im-opera' => 'Opera' ),
array( 'im-behance' => 'Behance' ),
array( 'im-blogger' => 'Blogger' ),
array( 'im-flickr' => 'Flickr' ),
array( 'im-github' => 'Github' ),
array( 'im-google-plus' => 'Google plus' ),
array( 'im-instagram' => 'Instagram' ),
array( 'im-linkedin' => 'Linkedin' ),
array( 'im-pinterest' => 'Pinterest' ),
array( 'im-skype' => 'Skype' ),
array( 'im-snapchat' => 'Snapchat' ),
array( 'im-soundcloud' => 'Soundcloud' ),
array( 'im-stackoverflow' => 'Stackoverflow' ),
array( 'im-stumbleupon' => 'Stumbleupon' ),
array( 'im-tumblr' => 'Tumblr' ),
array( 'im-xing' => 'Xing' ),
array( 'im-youtube' => 'Youtube' ),
array( 'im-reddit' => 'Reddit' ),
array( 'im-vimeo' => 'Vimeo' ),
array( 'im-vk' => 'Vk' ),
array( 'im-whatsapp' => 'Whatsapp' ),
array( 'im-paypal' => 'Paypal' ),
array( 'im-twitch' => 'Twitch' ),
array( 'im-drop' => 'Drop' ),
array( 'im-sun' => 'Sun' ),
array( 'im-certificate-o' => 'Certificate o' ),
array( 'im-graduation-hat' => 'Graduation hat' ),
array( 'im-store' => 'Store' ),
array( 'im-pin' => 'Pin' ),
array( 'im-navigation' => 'Navigation' ),
array( 'im-keyboard' => 'Keyboard' ),
array( 'im-cursor' => 'Cursor' ),
array( 'im-monitor-o' => 'Monitor o' ),
array( 'im-laptop-o' => 'Laptop o' ),
array( 'im-power' => 'Power' ),
array( 'im-pie-chart' => 'Pie chart' ),
array( 'im-line-chart-up' => 'Line chart up' ),
array( 'im-clock' => 'Clock' ),
array( 'im-flip-chart-o' => 'Flip chart o' ),
array( 'im-gift' => 'Gift' ),
array( 'im-leaf' => 'Leaf' ),
array( 'im-bug' => 'Bug' ),
array( 'im-coffee' => 'Coffee' ),
array( 'im-diamond-o' => 'Diamond o' ),
array( 'im-bell-active' => 'Bell active' ),
array( 'im-history' => 'History' ),
array( 'im-gamepad' => 'Gamepad' ),
array( 'im-binoculars' => 'Binoculars' ),
array( 'im-paperplane' => 'Paperplane' ),
array( 'im-wrench' => 'Wrench' ),
array( 'im-newspaper-o' => 'Newspaper o' ),
array( 'im-lifebuoy' => 'Lifebuoy' ),
array( 'im-fingerprint' => 'Fingerprint' ),
array( 'im-date-o' => 'Date o' ),
array( 'im-network' => 'Network' ),
array( 'im-target' => 'Target' ),
array( 'im-user-settings' => 'User settings' ),
array( 'im-radio' => 'Radio' ),
array( 'im-bank' => 'Bank' ),
array( 'im-calculator' => 'Calculator' ),
array( 'im-battery-empty' => 'Battery empty' ),
array( 'im-battery' => 'Battery' ),
array( 'im-battery-full' => 'Battery full' ),
array( 'im-check-mark-circle-o' => 'Check mark circle o' ),
array( 'im-x-mark-circle-o' => 'X mark circle o' ),
array( 'im-cube' => 'Cube' ),
array( 'im-cubes' => 'Cubes' ),
array( 'im-warning-circle' => 'Warning circle' ),
array( 'im-timer' => 'Timer' ),
array( 'im-hashtag' => 'Hashtag' ),
array( 'im-pointer' => 'Pointer' ),
array( 'im-paintbrush' => 'Paintbrush' ),
array( 'im-server' => 'Server' ),
array( 'im-car' => 'Car' ),
array( 'im-edit' => 'Edit' ),
array( 'im-flask' => 'Flask' ),
array( 'im-language' => 'Language' ),
array( 'im-anchor' => 'Anchor' ),
array( 'im-trophy' => 'Trophy' ),
array( 'im-umbrella' => 'Umbrella' ),
array( 'im-cc-amex' => 'Cc amex' ),
array( 'im-cc-visa' => 'Cc visa' ),
array( 'im-cc-mastercard' => 'Cc mastercard' ),
array( 'im-cc-paypal' => 'Cc paypal' ),
array( 'im-cc-amazon' => 'Cc amazon' ),
array( 'im-cc-bitcoin' => 'Cc bitcoin' ),
array( 'im-direction' => 'Direction' ),
array( 'im-gift-card' => 'Gift card' ),
array( 'im-newsletter' => 'Newsletter' ),
array( 'im-ribbon' => 'Ribbon' ),
array( 'im-award' => 'Award' ),
array( 'im-first-aid' => 'First aid' ),
array( 'im-cookie' => 'Cookie' ),
array( 'im-data' => 'Data' ),
array( 'im-data-delete' => 'Data delete' ),
array( 'im-data-validate' => 'Data validate' ),
array( 'im-import' => 'Import' ),
array( 'im-export' => 'Export' ),
array( 'im-reset' => 'Reset' ),
array( 'im-radar' => 'Radar' ),
array( 'im-idea' => 'Idea' ),
array( 'im-pizza' => 'Pizza' ),
array( 'im-truck' => 'Truck' ),
array( 'im-support' => 'Support' ),
array( 'im-color-fan' => 'Color fan' ),
array( 'im-layer' => 'Layer' ),
array( 'im-factory' => 'Factory' ),
array( 'im-apartment' => 'Apartment' ),
array( 'im-plane' => 'Plane' ),
array( 'im-headphones' => 'Headphones' ),
array( 'im-megaphone' => 'Megaphone' ),
array( 'im-folder-add' => 'Folder add' ),
array( 'im-barcode' => 'Barcode' ),
array( 'im-accessibility' => 'Accessibility' ),
array( 'im-plugin' => 'Plugin' ),
array( 'im-pulse' => 'Pulse' ),
array( 'im-spotify' => 'Spotify' ),
array( 'im-dribbble' => 'Dribbble' ),
array( 'im-google-play' => 'Google play' ),
array( 'im-facebook-messenger' => 'Facebook messenger' ),
array( 'im-wechat' => 'Wechat' ),
array( 'im-line' => 'Line' ),
array( 'im-git' => 'Git' ),
	);

	return $iconic_font;
}
add_filter( 'vc_iconpicker-type-iconmonstr-iconic-font', 'wvc_add_iconmonstr_iconic_font_font' );
