<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $values
 * @var $units
 * @var $bgcolor
 * @var $custombgcolor
 * @var $customtxtcolor
 * @var $options
 * @var $el_class
 * @var $el_id
 * @var $css
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Progress_Bar
 */
$title = $values = $units = $bgcolor = $css = $custombgcolor = $customtxtcolor = $options = $el_class = $el_id = $css_animation = $css_animation_delay = $inline_style = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
$atts = $this->convertAttributesToNewProgressBar( $atts );

extract( $atts );

wp_enqueue_script( 'waypoints' );
wp_enqueue_script( 'countup' );
wp_enqueue_script( 'wvc-progress-bar' );

$output = '';

$class = $el_class;
$inline_style = wvc_sanitize_css_field( $inline_style );
$inline_style .= wvc_shortcode_custom_style( $css );

/*Animate */
if ( ! wvc_is_new_animation( $css_animation ) ) {
	$class .= wvc_get_css_animation( $css_animation );
	$inline_style .= wvc_get_css_animation_delay( $css_animation_delay );
}

$bar_options = array();
$options = explode( ',', $options );
if ( in_array( 'animated', $options ) ) {
	$bar_options[] = 'animated';
}
if ( in_array( 'striped', $options ) ) {
	$bar_options[] = 'striped';
}

if ( 'custom' === $bgcolor && '' !== $custombgcolor ) {
	$custombgcolor = ' style="' . vc_get_css_color( 'background-color', $custombgcolor ) . '"';
	if ( '' !== $customtxtcolor ) {
		$customtxtcolor = ' style="' . vc_get_css_color( 'color', $customtxtcolor ) . '"';
	}
	$bgcolor = '';
} else {
	$custombgcolor = '';
	$customtxtcolor = '';
	$bgcolor = 'wvc-background-color-' . esc_attr( $bgcolor );
	//$el_class .= ' ' . $bgcolor;
}

//$class_to_filter = 'vc_progress_bar wpb_content_element';
//$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $class );
//$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts );
// $wrapper_attributes = array();
// if ( ! empty( $el_id ) ) {
// 	$wrapper_attributes[] = '';
// }

$el_id = ( $el_id ) ? $el_id : 'wvc-progress-bar-' . rand( 0, 999 );

$output .= '<div id="' . esc_attr( $el_id ) . '" class="vc_progress_bar wvc-progress-bar wpb_content_element ' . wvc_sanitize_html_classes( $class ) . '" style="' . wvc_esc_style_attr( $inline_style ) . '"';

$output .= wvc_element_aos_animation_data_attr( $atts );

$output .= '>';

$output .= wpb_widget_title( array( 'title' => $title, 'extraclass' => 'wpb_progress_bar_heading' ) );

$values = (array) vc_param_group_parse_atts( $values );
$max_value = 0.0;
$graph_lines_data = array();
foreach ( $values as $data ) {
	$new_line = $data;
	$new_line['value'] = isset( $data['value'] ) ? $data['value'] : 0;
	$new_line['label'] = isset( $data['label'] ) ? $data['label'] : '';
	$new_line['bgcolor'] = isset( $data['bgcolor'] ) && 'custom' !== $data['bgcolor'] ? '' : $custombgcolor;
	$new_line['txtcolor'] = isset( $data['txtcolor'] ) && 'custom' !== $data['txtcolor'] ? '' : $customtxtcolor;

	if ( isset( $data['customcolor'] ) && ( ! isset( $data['bgcolor'] ) || 'custom' === $data['bgcolor'] ) ) {
		$new_line['bgcolor'] = ' style="background-color: ' . esc_attr( $data['customcolor'] ) . ';"';
	}
	if ( isset( $data['customtxtcolor'] ) && ( ! isset( $data['txtcolor'] ) || 'custom' === $data['txtcolor'] ) ) {
		$new_line['txtcolor'] = ' style="color: ' . esc_attr( $data['customtxtcolor'] ) . ';"';
	}

	if ( $max_value < (float) $new_line['value'] ) {
		$max_value = $new_line['value'];
	}
	$graph_lines_data[] = $new_line;
}

foreach ( $graph_lines_data as $line ) {

	$rand_id = rand( 0,999 );

	$unit = ( '' !== $units ) ? ' <span data-percent="' . $line['value'] . '" data-unit="' . $units . '" id="wvc-progress-bar-' . absint( $rand_id ) .'" class="vc_label_units"></span>' : '';

	$output .= '<div class="vc_label">' . $line['label'] . $unit . '</div>';

	$output .= '<div class="vc_general wvc_single_bar vc_single_bar' . ( ( isset( $line['color'] ) && 'custom' !== $line['color'] ) ?
			' vc_progress-bar-color-' . $line['color'] : '' )
		. '">';
	if ( $max_value > 100.00 ) {
		$percentage_value = (float) $line['value'] > 0 && $max_value > 100.00 ? round( (float) $line['value'] / $max_value * 100, 4 ) : 0;
	} else {
		$percentage_value = $line['value'];
	}


	$output .= '<span class="'. esc_attr( $bgcolor ) . ' vc_bar wvc_bar ' . esc_attr( implode( ' ', $bar_options ) ) . '" data-percentage-value="' . esc_attr( $percentage_value ) . '" data-value="' . esc_attr( $line['value'] ) . '"' . $line['bgcolor'] . '>';

	//debug( $line );

	if ( isset( $line['color'] ) && 'default' !== $line['color'] ) {

		$bgcolor = 'wvc-background-color-' . $line['color'];

	}

	$output .= '<span class="wvc_bar_color_filler ' . $bgcolor . '"></span>';

	$output .= '</span></div>';
}

$output .= '</div>';

echo $output;
