<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class WOOCS_World_Currencies {

    protected $all_currencies = array();

    public function __construct() {
        $this->set_currencies();
    }

    public function get_all_currencies() {
        return $this->all_currencies;
    }

    public function get_currencies_title() {
        $titles = array();
        foreach ($this->all_currencies as $code => $data) {
            $titles[$code] = $code . " - (" . $data['symbol'] . ") " . $data['description'];
        }
        return $titles;
    }

    public function get_currencies_data($code_array) {
        if (!is_array($code_array)) {
            return array($code_array => $this->get_currency_data($code_array));
        }
        $currencies = array();
        foreach ($code_array as $code) {
            $cc = $this->get_currency_data($code);
            if ($cc) {
                $currencies[$code] = $cc;
            }
        }
        return $currencies;
    }

    public function get_currency_data($code) {

        if (isset($this->all_currencies[$code])) {
            return $this->all_currencies[$code];
        }
        return false;
    }

    private function set_currencies() {
        $this->all_currencies = array(
            'USD' =>
            array(
                'symbol' => '$',
                'description' => 'US Dollar',
                'symbol_native' => '$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'USD',
                'flag' => 'us',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'CAD' =>
            array(
                'symbol' => 'CA$',
                'description' => 'Canadian Dollar',
                'symbol_native' => '$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'CAD',
                'flag' => 'ca',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'EUR' =>
            array(
                'symbol' => '€',
                'description' => 'Euro',
                'symbol_native' => '€',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'EUR',
                'flag' => 'eu',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'AED' =>
            array(
                'symbol' => 'AED',
                'description' => 'United Arab Emirates Dirham',
                'symbol_native' => 'د.إ.‏',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'AED',
                'flag' => 'ae',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'AFN' =>
            array(
                'symbol' => 'Af',
                'description' => 'Afghan Afghani',
                'symbol_native' => '؋',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'AFN',
                'flag' => 'af',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'right_space',
                'hide_cents' => 0,
            ),
            'ALL' =>
            array(
                'symbol' => 'ALL',
                'description' => 'Albanian Lek',
                'symbol_native' => 'Lek',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'ALL',
                'flag' => 'al',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'AMD' =>
            array(
                'symbol' => 'AMD',
                'description' => 'Armenian Dram',
                'symbol_native' => 'դր.',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'AMD',
                'flag' => 'am',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'ARS' =>
            array(
                'symbol' => 'AR$',
                'description' => 'Argentine Peso',
                'symbol_native' => '$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'ARS',
                'flag' => 'ar',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'AUD' =>
            array(
                'symbol' => 'AU$',
                'description' => 'Australian Dollar',
                'symbol_native' => '$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'AUD',
                'flag' => 'au',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'AZN' =>
            array(
                'symbol' => 'man.',
                'description' => 'Azerbaijani Manat',
                'symbol_native' => 'ман.',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'AZN',
                'flag' => 'az',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'BAM' =>
            array(
                'symbol' => 'KM',
                'description' => 'Bosnia-Herzegovina Convertible Mark',
                'symbol_native' => 'KM',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'BAM',
                'flag' => 'ba',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'BDT' =>
            array(
                'symbol' => 'Tk',
                'description' => 'Bangladeshi Taka',
                'symbol_native' => '৳',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'BDT',
                'flag' => 'bd',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'BGN' =>
            array(
                'symbol' => 'BGN',
                'description' => 'Bulgarian Lev',
                'symbol_native' => 'лв.',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'BGN',
                'flag' => 'bg',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'BHD' =>
            array(
                'symbol' => 'BD',
                'description' => 'Bahraini Dinar',
                'symbol_native' => 'د.ب.‏',
                'decimals' => 3,
                'rate' => 1,
                'name' => 'BHD',
                'flag' => 'bh',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'BIF' =>
            array(
                'symbol' => 'FBu',
                'description' => 'Burundian Franc',
                'symbol_native' => 'FBu',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'BIF',
                'flag' => 'bi',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'BND' =>
            array(
                'symbol' => 'BN$',
                'description' => 'Brunei Dollar',
                'symbol_native' => '$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'BND',
                'flag' => 'bn',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'BOB' =>
            array(
                'symbol' => 'Bs',
                'description' => 'Bolivian Boliviano',
                'symbol_native' => 'Bs',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'BOB',
                'flag' => 'bo',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'BRL' =>
            array(
                'symbol' => 'R$',
                'description' => 'Brazilian Real',
                'symbol_native' => 'R$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'BRL',
                'flag' => 'br',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'BWP' =>
            array(
                'symbol' => 'BWP',
                'description' => 'Botswanan Pula',
                'symbol_native' => 'P',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'BWP',
                'flag' => 'bw',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'BYN' =>
            array(
                'symbol' => 'Br',
                'description' => 'Belarusian Ruble',
                'symbol_native' => 'руб.',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'BYN',
                'flag' => 'by',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'BZD' =>
            array(
                'symbol' => 'BZ$',
                'description' => 'Belize Dollar',
                'symbol_native' => '$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'BZD',
                'flag' => 'bz',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'CDF' =>
            array(
                'symbol' => 'CDF',
                'description' => 'Congolese Franc',
                'symbol_native' => 'FrCD',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'CDF',
                'flag' => 'cd',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'CHF' =>
            array(
                'symbol' => 'CHF',
                'description' => 'Swiss Franc',
                'symbol_native' => 'CHF',
                'decimals' => 2,
                'rounding' => 0.05,
                'name' => 'CHF',
                'flag' => 'ch',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'CLP' =>
            array(
                'symbol' => 'CL$',
                'description' => 'Chilean Peso',
                'symbol_native' => '$',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'CLP',
                'flag' => 'cl',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'CNY' =>
            array(
                'symbol' => 'CN¥',
                'description' => 'Chinese Yuan',
                'symbol_native' => 'CN¥',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'CNY',
                'flag' => 'cn',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'COP' =>
            array(
                'symbol' => 'CO$',
                'description' => 'Colombian Peso',
                'symbol_native' => '$',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'COP',
                'flag' => 'co',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'CRC' =>
            array(
                'symbol' => '₡',
                'description' => 'Costa Rican Colón',
                'symbol_native' => '₡',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'CRC',
                'flag' => 'cr',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'CVE' =>
            array(
                'symbol' => 'CV$',
                'description' => 'Cape Verdean Escudo',
                'symbol_native' => 'CV$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'CVE',
                'flag' => 'cv',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'CZK' =>
            array(
                'symbol' => 'Kč',
                'description' => 'Czech Republic Koruna',
                'symbol_native' => 'Kč',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'CZK',
                'flag' => 'cz',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'right_space',
                'hide_cents' => 0,
            ),
            'DJF' =>
            array(
                'symbol' => 'Fdj',
                'description' => 'Djiboutian Franc',
                'symbol_native' => 'Fdj',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'DJF',
                'flag' => 'dj',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'DKK' =>
            array(
                'symbol' => 'Dkr',
                'description' => 'Danish Krone',
                'symbol_native' => 'kr',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'DKK',
                'flag' => 'dk',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'DOP' =>
            array(
                'symbol' => 'RD$',
                'description' => 'Dominican Peso',
                'symbol_native' => 'RD$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'DOP',
                'flag' => 'do',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'DZD' =>
            array(
                'symbol' => 'DA',
                'description' => 'Algerian Dinar',
                'symbol_native' => 'د.ج.‏',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'DZD',
                'flag' => 'dz',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'EGP' =>
            array(
                'symbol' => 'EGP',
                'description' => 'Egyptian Pound',
                'symbol_native' => 'ج.م.‏',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'EGP',
                'flag' => 'eg',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'ERN' =>
            array(
                'symbol' => 'Nfk',
                'description' => 'Eritrean Nakfa',
                'symbol_native' => 'Nfk',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'ERN',
                'flag' => 'er',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'ETB' =>
            array(
                'symbol' => 'Br',
                'description' => 'Ethiopian Birr',
                'symbol_native' => 'Br',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'ETB',
                'flag' => 'et',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'GBP' =>
            array(
                'symbol' => '£',
                'description' => 'British Pound Sterling',
                'symbol_native' => '£',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'GBP',
                'flag' => 'gb',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'GEL' =>
            array(
                'symbol' => 'GEL',
                'description' => 'Georgian Lari',
                'symbol_native' => 'GEL',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'GEL',
                'flag' => 'ge',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'GHS' =>
            array(
                'symbol' => 'GH₵',
                'description' => 'Ghanaian Cedi',
                'symbol_native' => 'GH₵',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'GHS',
                'flag' => 'gh',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'GNF' =>
            array(
                'symbol' => 'FG',
                'description' => 'Guinean Franc',
                'symbol_native' => 'FG',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'GNF',
                'flag' => 'gn',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'GTQ' =>
            array(
                'symbol' => 'GTQ',
                'description' => 'Guatemalan Quetzal',
                'symbol_native' => 'Q',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'GTQ',
                'flag' => 'gt',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'HKD' =>
            array(
                'symbol' => 'HK$',
                'description' => 'Hong Kong Dollar',
                'symbol_native' => '$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'HKD',
                'flag' => 'hk',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'HNL' =>
            array(
                'symbol' => 'HNL',
                'description' => 'Honduran Lempira',
                'symbol_native' => 'L',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'HNL',
                'flag' => 'hn',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'HRK' =>
            array(
                'symbol' => 'kn',
                'description' => 'Croatian Kuna',
                'symbol_native' => 'kn',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'HRK',
                'flag' => 'hr',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'right_space',
                'hide_cents' => 0,
            ),
            'HUF' =>
            array(
                'symbol' => 'Ft',
                'description' => 'Hungarian Forint',
                'symbol_native' => 'Ft',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'HUF',
                'flag' => 'hu',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'right_space',
                'hide_cents' => 0,
            ),
            'IDR' =>
            array(
                'symbol' => 'Rp',
                'description' => 'Indonesian Rupiah',
                'symbol_native' => 'Rp',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'IDR',
                'flag' => 'id',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'ILS' =>
            array(
                'symbol' => '₪',
                'description' => 'Israeli New Sheqel',
                'symbol_native' => '₪',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'ILS',
                'flag' => 'il',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'right_space',
                'hide_cents' => 0,
            ),
            'INR' =>
            array(
                'symbol' => 'Rs',
                'description' => 'Indian Rupee',
                'symbol_native' => 'টকা',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'INR',
                'flag' => 'in',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'IQD' =>
            array(
                'symbol' => 'IQD',
                'description' => 'Iraqi Dinar',
                'symbol_native' => 'د.ع.‏',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'IQD',
                'flag' => 'iq',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'IRR' =>
            array(
                'symbol' => 'IRR',
                'description' => 'Iranian Rial',
                'symbol_native' => '﷼',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'IRR',
                'flag' => 'ir',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'ISK' =>
            array(
                'symbol' => 'Ikr',
                'description' => 'Icelandic Króna',
                'symbol_native' => 'kr',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'ISK',
                'flag' => 'is',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'JMD' =>
            array(
                'symbol' => 'J$',
                'description' => 'Jamaican Dollar',
                'symbol_native' => '$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'JMD',
                'flag' => 'jm',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'JOD' =>
            array(
                'symbol' => 'JD',
                'description' => 'Jordanian Dinar',
                'symbol_native' => 'د.أ.‏',
                'decimals' => 3,
                'rate' => 1,
                'name' => 'JOD',
                'flag' => 'jo',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'JPY' =>
            array(
                'symbol' => '¥',
                'description' => 'Japanese Yen',
                'symbol_native' => '￥',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'JPY',
                'flag' => 'jp',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'KES' =>
            array(
                'symbol' => 'Ksh',
                'description' => 'Kenyan Shilling',
                'symbol_native' => 'Ksh',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'KES',
                'flag' => 'ke',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'KHR' =>
            array(
                'symbol' => 'KHR',
                'description' => 'Cambodian Riel',
                'symbol_native' => '៛',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'KHR',
                'flag' => 'kh',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'KMF' =>
            array(
                'symbol' => 'CF',
                'description' => 'Comorian Franc',
                'symbol_native' => 'FC',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'KMF',
                'flag' => 'cm',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'KRW' =>
            array(
                'symbol' => '₩',
                'description' => 'South Korean Won',
                'symbol_native' => '₩',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'KRW',
                'flag' => 'kr',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'KWD' =>
            array(
                'symbol' => 'KD',
                'description' => 'Kuwaiti Dinar',
                'symbol_native' => 'د.ك.‏',
                'decimals' => 3,
                'rate' => 1,
                'name' => 'KWD',
                'flag' => 'kw',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'KZT' =>
            array(
                'symbol' => 'KZT',
                'description' => 'Kazakhstani Tenge',
                'symbol_native' => 'тңг.',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'KZT',
                'flag' => 'kz',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'LBP' =>
            array(
                'symbol' => 'L.L.',
                'description' => 'Lebanese Pound',
                'symbol_native' => 'ل.ل.‏',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'LBP',
                'flag' => 'lb',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'LKR' =>
            array(
                'symbol' => 'SLRs',
                'description' => 'Sri Lankan Rupee',
                'symbol_native' => 'SL Re',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'LKR',
                'flag' => 'lk',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'LTL' =>
            array(
                'symbol' => 'Lt',
                'description' => 'Lithuanian Litas',
                'symbol_native' => 'Lt',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'LTL',
                'flag' => 'lt',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'LVL' =>
            array(
                'symbol' => 'Ls',
                'description' => 'Latvian Lats',
                'symbol_native' => 'Ls',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'LVL',
                'flag' => 'lv',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'LYD' =>
            array(
                'symbol' => 'LD',
                'description' => 'Libyan Dinar',
                'symbol_native' => 'د.ل.‏',
                'decimals' => 3,
                'rate' => 1,
                'name' => 'LYD',
                'flag' => 'ly',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'MAD' =>
            array(
                'symbol' => 'MAD',
                'description' => 'Moroccan Dirham',
                'symbol_native' => 'د.م.‏',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'MAD',
                'flag' => 'ma',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'MDL' =>
            array(
                'symbol' => 'MDL',
                'description' => 'Moldovan Leu',
                'symbol_native' => 'MDL',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'MDL',
                'flag' => 'md',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'right_space',
                'hide_cents' => 0,
            ),
            'MGA' =>
            array(
                'symbol' => 'MGA',
                'description' => 'Malagasy Ariary',
                'symbol_native' => 'MGA',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'MGA',
                'flag' => 'my',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'MKD' =>
            array(
                'symbol' => 'MKD',
                'description' => 'Macedonian Denar',
                'symbol_native' => 'MKD',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'MKD',
                'flag' => 'mk',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'MMK' =>
            array(
                'symbol' => 'MMK',
                'description' => 'Myanma Kyat',
                'symbol_native' => 'K',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'MMK',
                'flag' => 'mm',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'MOP' =>
            array(
                'symbol' => 'MOP$',
                'description' => 'Macanese Pataca',
                'symbol_native' => 'MOP$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'MOP',
                'flag' => 'mo',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'MUR' =>
            array(
                'symbol' => 'MURs',
                'description' => 'Mauritian Rupee',
                'symbol_native' => 'MURs',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'MUR',
                'flag' => 'mr',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'MXN' =>
            array(
                'symbol' => 'MX$',
                'description' => 'Mexican Peso',
                'symbol_native' => '$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'MXN',
                'flag' => 'mx',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'MYR' =>
            array(
                'symbol' => 'RM',
                'description' => 'Malaysian Ringgit',
                'symbol_native' => 'RM',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'MYR',
                'flag' => 'my',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'MZN' =>
            array(
                'symbol' => 'MTn',
                'description' => 'Mozambican Metical',
                'symbol_native' => 'MTn',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'MZN',
                'flag' => 'mz',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'NAD' =>
            array(
                'symbol' => 'N$',
                'description' => 'Namibian Dollar',
                'symbol_native' => 'N$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'NAD',
                'flag' => 'na',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'NGN' =>
            array(
                'symbol' => '₦',
                'description' => 'Nigerian Naira',
                'symbol_native' => '₦',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'NGN',
                'flag' => 'ng',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'NIO' =>
            array(
                'symbol' => 'C$',
                'description' => 'Nicaraguan Córdoba',
                'symbol_native' => 'C$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'NIO',
                'flag' => 'ni',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'NOK' =>
            array(
                'symbol' => 'Nkr',
                'description' => 'Norwegian Krone',
                'symbol_native' => 'kr',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'NOK',
                'flag' => 'no',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'NPR' =>
            array(
                'symbol' => 'NPRs',
                'description' => 'Nepalese Rupee',
                'symbol_native' => 'नेरू',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'NPR',
                'flag' => 'np',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'NZD' =>
            array(
                'symbol' => 'NZ$',
                'description' => 'New Zealand Dollar',
                'symbol_native' => '$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'NZD',
                'flag' => 'nz',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'OMR' =>
            array(
                'symbol' => 'OMR',
                'description' => 'Omani Rial',
                'symbol_native' => 'ر.ع.‏',
                'decimals' => 3,
                'rate' => 1,
                'name' => 'OMR',
                'flag' => 'om',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'PAB' =>
            array(
                'symbol' => 'B/.',
                'description' => 'Panamanian Balboa',
                'symbol_native' => 'B/.',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'PAB',
                'flag' => 'pa',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'PEN' =>
            array(
                'symbol' => 'S/.',
                'description' => 'Peruvian Nuevo Sol',
                'symbol_native' => 'S/.',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'PEN',
                'flag' => 'pe',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'PHP' =>
            array(
                'symbol' => '₱',
                'description' => 'Philippine Peso',
                'symbol_native' => '₱',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'PHP',
                'flag' => 'ph',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'PKR' =>
            array(
                'symbol' => 'PKRs',
                'description' => 'Pakistani Rupee',
                'symbol_native' => '₨',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'PKR',
                'flag' => 'pk',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'PLN' =>
            array(
                'symbol' => 'zł',
                'description' => 'Polish Zloty',
                'symbol_native' => 'zł',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'PLN',
                'flag' => 'pl',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'right_space',
                'hide_cents' => 0,
            ),
            'PYG' =>
            array(
                'symbol' => '₲',
                'description' => 'Paraguayan Guarani',
                'symbol_native' => '₲',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'PYG',
                'flag' => 'py',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'QAR' =>
            array(
                'symbol' => 'QR',
                'description' => 'Qatari Rial',
                'symbol_native' => 'ر.ق.‏',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'QAR',
                'flag' => 'qa',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'RON' =>
            array(
                'symbol' => 'RON',
                'description' => 'Romanian Leu',
                'symbol_native' => 'RON',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'RON',
                'flag' => 'ro',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'right_space',
                'hide_cents' => 0,
            ),
            'RSD' =>
            array(
                'symbol' => 'din.',
                'description' => 'Serbian Dinar',
                'symbol_native' => 'дин.',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'RSD',
                'flag' => 'rs',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'right_space',
                'hide_cents' => 0,
            ),
            'RUB' =>
            array(
                'symbol' => 'RUB',
                'description' => 'Russian Ruble',
                'symbol_native' => '₽.',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'RUB',
                'flag' => 'ru',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'RWF' =>
            array(
                'symbol' => 'RWF',
                'description' => 'Rwandan Franc',
                'symbol_native' => 'FR',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'RWF',
                'flag' => 'rw',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'SAR' =>
            array(
                'symbol' => 'SR',
                'description' => 'Saudi Riyal',
                'symbol_native' => 'ر.س.‏',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'SAR',
                'flag' => 'sa',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'SDG' =>
            array(
                'symbol' => 'SDG',
                'description' => 'Sudanese Pound',
                'symbol_native' => 'SDG',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'SDG',
                'flag' => 'sd',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'SEK' =>
            array(
                'symbol' => 'Skr',
                'description' => 'Swedish Krona',
                'symbol_native' => 'kr',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'SEK',
                'flag' => 'se',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'right_space',
                'hide_cents' => 0,
            ),
            'SGD' =>
            array(
                'symbol' => 'S$',
                'description' => 'Singapore Dollar',
                'symbol_native' => '$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'SGD',
                'flag' => 'sg',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'SOS' =>
            array(
                'symbol' => 'Ssh',
                'description' => 'Somali Shilling',
                'symbol_native' => 'Ssh',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'SOS',
                'flag' => 'so',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'SYP' =>
            array(
                'symbol' => 'SY£',
                'description' => 'Syrian Pound',
                'symbol_native' => 'ل.س.‏',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'SYP',
                'flag' => 'sy',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'THB' =>
            array(
                'symbol' => '฿',
                'description' => 'Thai Baht',
                'symbol_native' => '฿',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'THB',
                'flag' => 'th',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'TND' =>
            array(
                'symbol' => 'DT',
                'description' => 'Tunisian Dinar',
                'symbol_native' => 'د.ت.‏',
                'decimals' => 3,
                'rate' => 1,
                'name' => 'TND',
                'flag' => 'tn',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'TOP' =>
            array(
                'symbol' => 'T$',
                'description' => 'Tongan Paʻanga',
                'symbol_native' => 'T$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'TOP',
                'flag' => 'to',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'TRY' =>
            array(
                'symbol' => 'TL',
                'description' => 'Turkish Lira',
                'symbol_native' => 'TL',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'TRY',
                'flag' => 'tr',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'TTD' =>
            array(
                'symbol' => 'TT$',
                'description' => 'Trinidad and Tobago Dollar',
                'symbol_native' => '$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'TTD',
                'flag' => 'tt',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'TWD' =>
            array(
                'symbol' => 'NT$',
                'description' => 'New Taiwan Dollar',
                'symbol_native' => 'NT$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'TWD',
                'flag' => 'tw',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'TZS' =>
            array(
                'symbol' => 'TSh',
                'description' => 'Tanzanian Shilling',
                'symbol_native' => 'TSh',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'TZS',
                'flag' => 'tz',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'UAH' =>
            array(
                'symbol' => '₴',
                'description' => 'Ukrainian Hryvnia',
                'symbol_native' => '₴',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'UAH',
                'flag' => 'ua',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'UGX' =>
            array(
                'symbol' => 'USh',
                'description' => 'Ugandan Shilling',
                'symbol_native' => 'USh',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'UGX',
                'flag' => 'ug',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'UYU' =>
            array(
                'symbol' => '$U',
                'description' => 'Uruguayan Peso',
                'symbol_native' => '$',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'UYU',
                'flag' => 'uy',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'UZS' =>
            array(
                'symbol' => 'UZS',
                'description' => 'Uzbekistan Som',
                'symbol_native' => 'UZS',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'UZS',
                'flag' => 'uz',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'VEF' =>
            array(
                'symbol' => 'Bs.F.',
                'description' => 'Venezuelan Bolívar',
                'symbol_native' => 'Bs.F.',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'VEF',
                'flag' => 've',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'VND' =>
            array(
                'symbol' => '₫',
                'description' => 'Vietnamese Dong',
                'symbol_native' => '₫',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'VND',
                'flag' => 'vn',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'XAF' =>
            array(
                'symbol' => 'FCFA',
                'description' => 'CFA Franc BEAC',
                'symbol_native' => 'FCFA',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'XAF',
                'flag' => '',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'XOF' =>
            array(
                'symbol' => 'CFA',
                'description' => 'CFA Franc BCEAO',
                'symbol_native' => 'CFA',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'XOF',
                'flag' => '',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'YER' =>
            array(
                'symbol' => 'YR',
                'description' => 'Yemeni Rial',
                'symbol_native' => 'ر.ي.‏',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'YER',
                'flag' => 'ye',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'ZAR' =>
            array(
                'symbol' => 'R',
                'description' => 'South African Rand',
                'symbol_native' => 'R',
                'decimals' => 2,
                'rate' => 1,
                'name' => 'ZAR',
                'flag' => 'za',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'ZMK' =>
            array(
                'symbol' => 'ZK',
                'description' => 'Zambian Kwacha',
                'symbol_native' => 'ZK',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'ZMK',
                'flag' => 'zm',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
            'ZWL' =>
            array(
                'symbol' => 'ZWL$',
                'description' => 'Zimbabwean Dollar',
                'symbol_native' => 'ZWL$',
                'decimals' => 0,
                'rate' => 1,
                'name' => 'ZWL',
                'flag' => 'zw',
                'rate_plus' => '',
                'is_etalon' => 0,
                'position' => 'left',
                'hide_cents' => 0,
            ),
        );
    }

}
