/*!
 * Additional Theme Methods
 *
 * Decibel 3.3.2
 */
/* jshint -W062 */

/* global DecibelParams, DecibelUi, WVC, Cookies, Event, WVCParams, CountUp */
var Decibel = (function ($) {
	"use strict";

	return {
		initFlag: false,
		isEdge: navigator.userAgent.match(/(Edge)/i) ? true : false,
		isWVC: "undefined" !== typeof WVC,
		isMobile: navigator.userAgent.match(
			/(iPad)|(iPhone)|(iPod)|(Android)|(PlayBook)|(BB10)|(BlackBerry)|(Opera Mini)|(IEMobile)|(webOS)|(MeeGo)/i
		)
			? true
			: false,
		loaded: false,
		hasScrolled: false,
		menuSkin: "light",
		debounceTimer: null,
		debounceTime: 400,

		/**
		 * Init all functions
		 */
		init: function () {
			if (this.initFlag) {
				return;
			}

			//WVC.fireAnimation = false,

			//this.startPercent();

			var _this = this;

			$(".site-content")
				.find(".wvc-parent-row:first-of-type")
				.addClass("first-section");

			this.offGridReleasesParallax();
			this.quickView();
			this.loginPopup();
			this.stickyProductDetails();
			//this.transitionCosmetic();
			this.WCQuantity();
			//this.stickyElements();
			this.singlePostNav();
			//this.tooltipsy();
			//this.interactiveLinks();
			this.releaseAnimatedCoverAnimationDelay();

			this.WcReviewLink();

			this.isMobile = DecibelParams.isMobile;
			this.menuSkin = DecibelParams.menuSkin;

			$(window).scroll(function () {
				var scrollTop = $(window).scrollTop();
				_this.backToTopSkin(scrollTop);
				//_this.transparentStickyMenuSkin( scrollTop );
			});

			this.initFlag = true;
		},

		/**
		 * Off-grid releases parallax
		 */
		offGridReleasesParallax: function () {
			if (!this.isWVC) {
				return;
			}

			$(".entry-offgrid").each(function (index) {
				var y = -120,
					marginTop = 60,
					smoothness = 50;

				if (index % 2 === 0) {
					y = 120;
					marginTop = -60;
				}

				$(this)
					.attr(
						"data-parallax",
						'{"y":' + y + ', "smoothness":' + smoothness + "}"
					)
					.css({
						top: 60,
					})
					.removeClass("wow");
			});
		},

		/**
		 * Tooltip
		 */
		tooltipsy: function () {
			if (!this.isMobile) {
				var $tipspan,
					selectors =
						".product-quickview-button, .wolf_add_to_wishlist, .quickview-product-add-to-cart-icon";

				$(selectors).tooltipsy();

				$(document).on("added_to_cart", function (
					event,
					fragments,
					cart_hash,
					$button
				) {
					if (
						$button.hasClass("wvc-ati-add-to-cart-button") ||
						$button.hasClass("wpm-add-to-cart-button") ||
						$button.hasClass("wolf-release-add-to-cart") ||
						$button.hasClass("product-add-to-cart")
					) {
						$tipspan = $button.find("span");

						$tipspan.data("tooltipsy").hide();
						$tipspan.data("tooltipsy").destroy();

						$tipspan.attr(
							"title",
							DecibelParams.l10n.addedToCart
						);

						$tipspan.tooltipsy();
						$tipspan.data("tooltipsy").show();

						setTimeout(function () {
							$tipspan.data("tooltipsy").hide();
							$tipspan.data("tooltipsy").destroy();
							$tipspan.attr(
								"title",
								DecibelParams.l10n.addToCart
							);
							$tipspan.tooltipsy();

							$button.removeClass("added");
						}, 4000);
					}
				});
			}
		},

		/**
		 * Product quickview
		 */
		quickView: function () {
			$(document).on("added_to_cart", function (
				event,
				fragments,
				cart_hash,
				$button
			) {
				if ($button.hasClass("product-add-to-cart")) {
					//console.log( 'good?' );
					$button.attr("href", DecibelParams.WooCommerceCartUrl);
					$button
						.find("span")
						.attr("title", DecibelParams.l10n.viewCart);
					$button.removeClass("ajax_add_to_cart");
				}
			});
		},

		/**
		 * Sticky product layout
		 */
		stickyProductDetails: function () {
			if ($.isFunction($.fn.stick_in_parent)) {
				if ($("body").hasClass("sticky-product-details")) {
					$(".entry-single-product .summary").stick_in_parent({
						offset_top:
							parseInt(
								DecibelParams.portfolioSidebarOffsetTop,
								10
							) + 40,
					});
				}
			}
		},

		/**
		 * WC login popup
		 */
		loginPopup: function () {
			var $body = $("body"),
				clicked = false;

			$(document).on(
				"click",
				".account-item-icon-user-not-logged-in, .close-loginform-button",
				function (event) {
					event.preventDefault();

					if ($body.hasClass("loginform-popup-toggle")) {

						$body.removeClass("loginform-popup-toggle");

					} else {

						$body.removeClass("overlay-menu-toggle");

						if ( $(".wvc-login-form").length || $(".wolf-core-login-form").length ) {

							$body.addClass("loginform-popup-toggle");

						} else if ( ! clicked ) {
							/* AJAX call */
							$.post(
								DecibelParams.ajaxUrl,
								{ action: "decibel_ajax_get_wc_login_form" },
								function (response) {
									console.log(response);

									if (response) {
										$("#loginform-overlay-content").append(
											response
										);

										$body.addClass(
											"loginform-popup-toggle"
										);
									}
								}
							);
						}
					}
				}
			);

			if (!this.isMobile) {
				$(document).mouseup(function (event) {
					if (1 !== event.which) {
						return;
					}

					var $container = $("#loginform-overlay-content");

					if (
						!$container.is(event.target) &&
						$container.has(event.target).length === 0
					) {
						$body.removeClass("loginform-popup-toggle");
					}
				});
			}
		},

		/**
		 * Custom product quantity styling
		 *
		 * https://stackoverflow.com/questions/48953897/create-a-custom-quantity-field-in-woocommerce
		 */
		WCQuantity: function () {
			$(document).on("click", ".wt-quantity-minus", function (event) {
				event.preventDefault();
				var $input = $(this).parent().find("input.qty"),
					val = $input.val(),
					step = $input.attr("step");
				step = "undefined" !== typeof step ? parseInt(step) : 1;

				if (val > 1) {
					$input.val(val - step).change();
				} else {
					$input.val(0);
				}
			} );

			$(document).on("click", ".wt-quantity-plus", function (event) {
				event.preventDefault();

				var $input = $(this).parent().find("input.qty"),
					val = $input.val() ? parseInt($input.val(), 10) : 0,
					step = $input.attr("step");
				step = "undefined" !== typeof step ? parseInt(step) : 1;

				if ( "undefined" === typeof step || "" === step ) {
					step = 1;
				}

				$input.val(val + step).change();
			} );
		},

		/**
		 * Sticky Portfolio Sidebar
		 */
		stickyElements: function () {
			if ($.isFunction($.fn.stick_in_parent)) {
				if (
					$("body").hasClass("wolf-share") ||
					($("body").hasClass("single-post") &&
						!this.isMobile &&
						1300 > $(window).width())
				) {
					$(".wolf-share-buttons-container").stick_in_parent({
						offset_top: 66,
					});
				}
			}
		},

		/**
		 * Overlay transition
		 */
		transitionCosmetic: function () {
			$(document).on("click", ".internal-link:not(.disabled)", function (
				event
			) {
				if (!event.ctrlKey) {
					event.preventDefault();

					var $link = $(this);

					$("body").removeClass(
						"mobile-menu-toggle overlay-menu-toggle offcanvas-menu-toggle loginform-popup-toggle lateral-menu-toggle"
					);
					$("body").addClass("loading transitioning");

					Cookies.set(
						DecibelParams.themeSlug + "_session_loaded",
						true,
						{ expires: null }
					);

					if ($("#decibel-loading-logo").length) {
						$("#decibel-loading-logo").one(
							DecibelUi.transitionEventEnd(),
							function () {
								Cookies.remove(
									DecibelParams.themeSlug +
										"_session_loaded"
								);
								window.location = $link.attr("href");
							}
						);
					} else if ($("#decibel-loading-spinner").length) {
						$("#decibel-loading-spinner").one(
							DecibelUi.transitionEventEnd(),
							function () {
								Cookies.remove(
									DecibelParams.themeSlug +
										"_session_loaded"
								);
								window.location = $link.attr("href");
							}
						);
					} else if ($(".decibel-loader-overlay").length) {
						$(".decibel-loader-overlay").one(
							DecibelUi.transitionEventEnd(),
							function () {
								Cookies.remove(
									DecibelParams.themeSlug +
										"_session_loaded"
								);
								window.location = $link.attr("href");
							}
						);
					} else {
						window.location = $link.attr("href");
					}
				}
			});
		},

		singlePostNav: function () {
			$(".post-nav-link-overlay").on("mouseover", function () {
				$(this).parent().addClass("nav-hover");
			});

			$(".post-nav-link-overlay").on("mouseout", function () {
				$(this).parent().removeClass("nav-hover");
			});
		},

		/**
		 * Release animated cover transition delay
		 */
		releaseAnimatedCoverAnimationDelay: function () {
			var delay = 400;

			$(".release-display-animated_cover")
				.find(".entry-release")
				.each(function () {
					$(this)
						.find(".wvc-ad-disc-container")
						.css({
							"transition-delay": delay / 1000 + "s",
						});

					delay = delay + 200;
				});
		},

		transparentStickyMenuSkin: function (scrollTop) {
			if (
				scrollTop < DecibelParams.stickyMenuScrollPoint ||
				"none" === DecibelParams.stickyMenuType
			) {
				return;
			}

			var $body = $("body");

			if ($(".wvc-row-visible").first().hasClass("wvc-font-light")) {
				$body.addClass("menu-skin-dark");
			} else {
				$body.removeClass("menu-skin-dark");
			}
		},

		/**
		 * Check back to top color
		 */
		backToTopSkin: function (scrollTop) {
			var $button = $("#back-to-top"),
				$body = $("body");

			if (
				!$button.length ||
				$("body").hasClass("wvc-scrolling") ||
				$("body").hasClass("scrolling")
			) {
				return;
			}

			if (scrollTop < 550 || this.isMobile) {
				$button.removeClass("back-to-top-light");
				return;
			}

			if ($(".wvc-row-visible").last().hasClass("wvc-font-light")) {
				$button.addClass("back-to-top-light");
			} else {
				$button.removeClass("back-to-top-light");
			}
		},

		/**
		 * IL carousel
		 */
		interactiveLinks: function () {
			var $carousel = $(".wvc-interactive-links-content");

			$carousel
				.flickity({
					freeScroll: true,
					prevNextButtons: false,
					pageDots: false,
					groupCells: true,
					//wrapAround: true,
					cellSelector: ".wvc-interactive-link-item",

					// Disable lightbox on drag
				})
				.on("dragStart.flickity", function () {
					$carousel.find("a").addClass("wvc-disabled");
				})
				.on("dragEnd.flickity", function () {
					setTimeout(function () {
						$carousel.find("a").removeClass("wvc-disabled");
					}, 1000); // wait before re-enabling link
				});
		},

		WcReviewLink : function () {
			$(".woocommerce-review-link").on("click", function () {
				$( '.review-accordion-link' ).trigger( 'click' );
				DecibelUi.smoothScroll('#wvc-wc-accordion');
			});
		},

		reveal: function () {
			var _this = this;

			$("body").addClass("loaded reveal");
			_this.fireContent();
		},

		/**
		 * Page Load
		 */
		loadingAnimation: function () {
			var _this = this,
				delay = 50;

			if (
				$("#decibel-loading-spinner").length ||
				$("#decibel-loading-logo").length
			) {
				return;
			}

			setTimeout(function () {
				$("body").addClass("loaded");

				if ($(".decibel-loader-overlay").length) {
					$("body").addClass("reveal");

					$(".decibel-loader-overlay").one(
						DecibelUi.transitionEventEnd(),
						function () {
							_this.fireContent();

							setTimeout(function () {
								$("body").addClass("one-sec-loaded");
							}, 100);
						}
					);
				} else {
					$("body").addClass("reveal");

					_this.fireContent();

					setTimeout(function () {
						$("body").addClass("one-sec-loaded");
					}, 100);
				}
			}, delay);
		},

		fireContent: function () {
			var _this = this;

			// Animate
			$(window).trigger("page_loaded");
			DecibelUi.wowAnimate();

			//console.log( 'page_loaded' );

			window.dispatchEvent(new Event("resize"));
			window.dispatchEvent(new Event("scroll")); // Force WOW effect
			$(window).trigger("just_loaded");
			$("body").addClass("one-sec-loaded");
		},
	};
})(jQuery);

(function ($) {
	"use strict";

	$(document).ready(function () {
		Decibel.init();
	});

	$(window).on('pageshow', function() {
		//Decibel.loadingAnimation();
	});

	$(window).on("wolf_ajax_loaded", function () {
		//Decibel.loadingAnimation();
	});
})(jQuery);
