<?php
/**
 * Theme configuration file
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Default Google fonts option
 */
function decibel_set_default_google_font() {
	return 'Lato:400,700,900|Open+Sans:400,700,900|Montserrat:400,500,600,700,900|Oswald';
}
add_filter( 'decibel_default_google_fonts', 'decibel_set_default_google_font' );

/**
 * Set color scheme
 *
 * Add csutom color scheme
 *
 * @param array $color_scheme
 * @param array $color_scheme
 */
function decibel_set_color_schemes( $color_scheme ) {

	//unset( $color_scheme['default'] );

	$color_scheme['light'] = array(
		'label'  => esc_html__( 'Light', 'decibel' ),
		'colors' => array(
			'#000000', // body_bg
			'#fff', // page_bg
			'#f7f7f7', // submenu_background_color
			'#0d0d0d', // submenu_font_color
			'#c74735', // '#c3ac6d', // accent
			'#444444', // main_text_color
			'#4c4c4c', // secondary_text_color
			'#0d0d0d', // strong_text_color
			'#999289', // secondary accent
		)
	);

	$color_scheme['dark'] = array(
		'label'  => esc_html__( 'Dark', 'decibel' ),
		'colors' => array(
			'#000000', // body_bg
			'#000000', // page_bg
			'#000000', // submenu_background_color
			'#ffffff', // submenu_font_color
			'#c74735', // accent
			'#f4f4f4', // main_text_color
			'#ffffff', // secondary_text_color
			'#ffffff', // strong_text_color
			'#999289', // secondary accent
		)
	);

	return $color_scheme;
}
add_filter( 'decibel_color_schemes', 'decibel_set_color_schemes' );

/**
 * Add additional theme support
 */
function decibel_additional_theme_support() {

	/**
	 * Enable WooCommerce support
	 */
	add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'decibel_additional_theme_support' );

/**
 * Set default WordPress option
 */
function decibel_set_default_wp_options() {

	update_option( 'thumbnail_size_w', 260 );
	update_option( 'thumbnail_size_h', 260 );
	update_option( 'thumbnail_crop', 1 );

	update_option( 'medium_size_w', 600 );
	update_option( 'medium_size_h', 600 );

	update_option( 'large_size_w', 1200 );
	update_option( 'large_size_h', 1024 );

	update_option( 'thread_comments_depth', 2 );
}
add_action( 'decibel_default_wp_options_init', 'decibel_set_default_wp_options' );

/**
 * Set mod files to include
 */
function decibel_customizer_set_mod_files( $mod_files ) {
	$mod_files = array(
		'loading',
		'logo',
		'layout',
		'colors',
		'navigation',
		'socials',
		'fonts',
		'header',
		'header-image',
		'blog',
		'events',
		'discography',
		'albums',
		'videos',
		'shop',
		'background-image',
		'footer',
		'footer-bg',
		'wvc',
	);

	return $mod_files;
}
add_filter( 'decibel_customizer_mod_files', 'decibel_customizer_set_mod_files' );
