<?php
/**
 * Decibel metaboxes
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Register metaboxes
 *
 * Pass a metabox array to generate metabox with the  Wolf Metaboxes plugin
 */
function decibel_register_metabox() {

	$body_metaboxes = array(
		'site_settings' => array(
			'title'      => esc_html__( 'Layout', 'decibel' ),
			'page'       => apply_filters( 'decibel_site_settings_post_types', array( 'post', 'page', 'plugin', 'video', 'product', 'gallery', 'theme', 'work', 'show', 'release', 'wpm_playlist', 'event', 'artist', 'mp-event' ) ),

			'metafields' => array(

				array(
					'label' => '',
					'id'    => '_post_subheading',
					'type'  => 'text',
				),

				array(
					'label' => esc_html__( 'Content Background Color', 'decibel' ),
					'id'    => '_post_content_inner_bg_color',
					'type'  => 'colorpicker',
					'desc'  => esc_html__( 'If you use the page builder and set your row background setting to "no background", you may want to change the overall content background color.', 'decibel' ),
				),

				array(
					'label'   => esc_html__( 'Loading Animation Type', 'decibel' ),
					'id'      => '_post_loading_animation_type',
					'type'    => 'select',
					'choices' => array(
						''                 => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'none'             => esc_html__( 'None', 'decibel' ),
						'overlay'          => esc_html__( 'Simple Overlay', 'decibel' ),
						'logo'             => esc_html__( 'Overlay with Logo', 'decibel' ),
						'spinner-loader1'  => esc_html__( 'Rotating plane', 'decibel' ),
						'spinner-loader2'  => esc_html__( 'Double Pulse', 'decibel' ),
						'spinner-loader3'  => esc_html__( 'Wave', 'decibel' ),
						'spinner-loader4'  => esc_html__( 'Wandering cubes', 'decibel' ),
						'spinner-loader5'  => esc_html__( 'Pulse', 'decibel' ),
						'spinner-loader6'  => esc_html__( 'Chasing dots', 'decibel' ),
						'spinner-loader7'  => esc_html__( 'Three bounce', 'decibel' ),
						'spinner-loader8'  => esc_html__( 'Circle', 'decibel' ),
						'spinner-loader9'  => esc_html__( 'Cube grid', 'decibel' ),
						'spinner-loader10' => esc_html__( 'Classic Loader', 'decibel' ),
						'spinner-loader11' => esc_html__( 'Folding cube', 'decibel' ),
						'spinner-loader12' => esc_html__( 'Ball Pulse', 'decibel' ),
						'spinner-loader13' => esc_html__( 'Ball Grid Pulse', 'decibel' ),
						'spinner-loader15' => esc_html__( 'Ball Clip Rotate Pulse', 'decibel' ),
						'spinner-loader16' => esc_html__( 'Ball Clip Rotate Pulse Multiple', 'decibel' ),
						'spinner-loader17' => esc_html__( 'Ball Pulse Rise', 'decibel' ),
						'spinner-loader19' => esc_html__( 'Ball Zigzag', 'decibel' ),
						'spinner-loader20' => esc_html__( 'Ball Zigzag Deflect', 'decibel' ),
						'spinner-loader21' => esc_html__( 'Ball Triangle Path', 'decibel' ),
						'spinner-loader22' => esc_html__( 'Ball Scale', 'decibel' ),
						'spinner-loader23' => esc_html__( 'Ball Line Scale', 'decibel' ),
						'spinner-loader24' => esc_html__( 'Ball Line Scale Party', 'decibel' ),
						'spinner-loader25' => esc_html__( 'Ball Scale Multiple', 'decibel' ),
						'spinner-loader26' => esc_html__( 'Ball Pulse Sync', 'decibel' ),
						'spinner-loader27' => esc_html__( 'Ball Beat', 'decibel' ),
						'spinner-loader28' => esc_html__( 'Ball Scale Ripple Multiple', 'decibel' ),
						'spinner-loader29' => esc_html__( 'Ball Spin Fade Loader', 'decibel' ),
						'spinner-loader30' => esc_html__( 'Line Spin Fade Loader', 'decibel' ),
						'spinner-loader31' => esc_html__( 'Pacman', 'decibel' ),
						'spinner-loader32' => esc_html__( 'Ball Grid Beat ', 'decibel' ),
					),
				),

				// array(
				// 'label' => esc_html__( 'Body Background', 'decibel' ),
				// 'id'    => '_post_body_background_img',
				// 'type'  => 'image',
				// ),

				// array(
				// 'label' => esc_html__( 'Body Background Position', 'decibel' ),
				// 'id'    => '_post_body_background_img_position',
				// 'type' => 'select',
				// 'choices' => array(
				// '' => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
				// 'center top' => esc_html__( 'center top', 'decibel' ),
				// 'center center' => esc_html__( 'center center', 'decibel' ),
				// 'left top'  => esc_html__( 'left top', 'decibel' ),
				// 'right top'  => esc_html__( 'right top', 'decibel' ),
				// 'center bottom' => esc_html__( 'center bottom', 'decibel' ),
				// 'left bottom'  => esc_html__( 'left bottom', 'decibel' ),
				// 'right bottom'  => esc_html__( 'right bottom', 'decibel' ),
				// 'left center'  => esc_html__( 'left center', 'decibel' ),
				// 'right center' => esc_html__( 'right center', 'decibel' ),
				// ),
				// ),
				// array(
				// 'label' => esc_html__( 'Body Background Attachment', 'decibel' ),
				// 'id'    => '_post_body_background_img_attachment',
				// 'type' => 'select',
				// 'choices' => array(
				// '' => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
				// 'scroll' => esc_html__( 'Scroll', 'decibel' ),
				// 'fixed' => esc_html__( 'Fixed', 'decibel' ),
				// ),
				// ),

				array(
					'label' => esc_html__( 'Accent Color', 'decibel' ),
					'id'    => '_post_accent_color',
					'type'  => 'colorpicker',
				),
			),
		),
	);

	$content_blocks = array(
		'' => '&mdash; ' . esc_html__( 'None', 'decibel' ) . ' &mdash;',
	);

	if ( class_exists( 'Wolf_Visual_Composer' ) && class_exists( 'Wolf_Vc_Content_Block' ) && defined( 'WPB_VC_VERSION' ) ) {
		// Content block option
		$content_block_posts = get_posts( 'post_type="wvc_content_block"&numberposts=-1' );

		$content_blocks = array(
			''     => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
			'none' => esc_html__( 'None', 'decibel' ),
		);
		if ( $content_block_posts ) {
			foreach ( $content_block_posts as $content_block_options ) {
				$content_blocks[ $content_block_options->ID ] = $content_block_options->post_title;
			}
		} else {
			$content_blocks[0] = esc_html__( 'No Content Block Yet', 'decibel' );
		}

		$body_metaboxes['site_settings']['metafields'][] = array(
			'label'   => esc_html__( 'Post-header Block', 'decibel' ),
			'id'      => '_post_after_header_block',
			'type'    => 'select',
			'choices' => $content_blocks,
		);

		$body_metaboxes['site_settings']['metafields'][] = array(
			'label'   => esc_html__( 'Pre-footer Block', 'decibel' ),
			'id'      => '_post_before_footer_block',
			'type'    => 'select',
			'choices' => $content_blocks,
		);

	}

	$header_metaboxes = array(
		'header_settings' => array(
			'title'      => esc_html__( 'Header', 'decibel' ),
			'page'       => apply_filters( 'decibel_header_settings_post_types', array( 'post', 'page', 'plugin', 'video', 'gallery', 'theme', 'work', 'show', 'release', 'wpm_playlist', 'event', 'artist', 'mp-event' ) ),

			'metafields' => array(

				array(
					'label'   => esc_html__( 'Header Layout', 'decibel' ),
					'id'      => '_post_hero_layout',
					'type'    => 'select',
					'choices' => array(
						''           => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'standard'   => esc_html__( 'Standard', 'decibel' ),
						'big'        => esc_html__( 'Big', 'decibel' ),
						'small'      => esc_html__( 'Small', 'decibel' ),
						'fullheight' => esc_html__( 'Full Height', 'decibel' ),
						'none'       => esc_html__( 'No Header', 'decibel' ),
					),
				),

				array(
					'label' => esc_html__( 'Title Font Family', 'decibel' ),
					'id'    => '_post_hero_title_font_family',
					'type'  => 'font_family',
				),

				array(
					'label'   => esc_html__( 'Font Transform', 'decibel' ),
					'id'      => '_post_hero_title_font_transform',
					'type'    => 'select',
					'choices' => array(
						''          => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'uppercase' => esc_html__( 'Uppercase', 'decibel' ),
						'none'      => esc_html__( 'None', 'decibel' ),
					),
				),

				array(
					'label' => esc_html__( 'Big Text', 'decibel' ),
					'id'    => '_post_hero_title_bigtext',
					'type'  => 'checkbox',
					'desc'  => esc_html__( 'Enable "Big Text" for the title?', 'decibel' ),
				),

				array(
					'label'   => esc_html__( 'Font Tone', 'decibel' ),
					'id'      => '_post_hero_font_tone',
					'type'    => 'select',
					'choices' => array(
						''      => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'light' => esc_html__( 'Light', 'decibel' ),
						'dark'  => esc_html__( 'Dark', 'decibel' ),
					),
				),

				array(
					'label'   => esc_html__( 'Background Type', 'decibel' ),
					'id'      => '_post_hero_background_type',
					'type'    => 'select',
					'choices' => array(
						'featured-image' => esc_html__( 'Featured Image', 'decibel' ),
						'image'          => esc_html__( 'Image', 'decibel' ),
						'video'          => esc_html__( 'Video', 'decibel' ),
						'slideshow'      => esc_html__( 'Slideshow', 'decibel' ),
					),
				),

				array(
					'label'      => esc_html__( 'Slideshow Images', 'decibel' ),
					'id'         => '_post_hero_slideshow_ids',
					'type'       => 'multiple_images',
					'dependency' => array(
						'element' => '_post_hero_background_type',
						'value'   => array( 'slideshow' ),
					),
				),

				array(
					'label'      => esc_html__( 'Background', 'decibel' ),
					'id'         => '_post_hero_background',
					'type'       => 'background',
					'dependency' => array(
						'element' => '_post_hero_background_type',
						'value'   => array( 'image' ),
					),
				),

				array(
					'label'      => esc_html__( 'Background Effect', 'decibel' ),
					'id'         => '_post_hero_background_effect',
					'type'       => 'select',
					'choices'    => array(
						''         => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'zoomin'   => esc_html__( 'Zoom', 'decibel' ),
						'parallax' => esc_html__( 'Parallax', 'decibel' ),
						'none'     => esc_html__( 'None', 'decibel' ),
					),
					'dependency' => array(
						'element' => '_post_hero_background_type',
						'value'   => array( 'image' ),
					),
				),

				array(
					'label'      => esc_html__( 'Video URL', 'decibel' ),
					'id'         => '_post_hero_background_video_url',
					'type'       => 'video',
					'dependency' => array(
						'element' => '_post_hero_background_type',
						'value'   => array( 'video' ),
					),
					'desc'       => esc_html__( 'A mp4 or YouTube URL. The featured image will be used as image fallback when the video cannot be displayed.', 'decibel' ),
				),

				array(
					'label'   => esc_html__( 'Overlay', 'decibel' ),
					'id'      => '_post_hero_overlay',
					'type'    => 'select',
					'choices' => array(
						''       => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'custom' => esc_html__( 'Custom', 'decibel' ),
						'none'   => esc_html__( 'None', 'decibel' ),
					),
				),

				array(
					'label'      => esc_html__( 'Overlay Color', 'decibel' ),
					'id'         => '_post_hero_overlay_color',
					'type'       => 'colorpicker',
					// 'value'   => '#000000',
					'dependency' => array(
						'element' => '_post_hero_overlay',
						'value'   => array( 'custom' ),
					),
				),

				array(
					'label'       => esc_html__( 'Overlay Opacity (in percent)', 'decibel' ),
					'id'          => '_post_hero_overlay_opacity',
					'desc'        => esc_html__( 'Adapt the header overlay opacity if needed', 'decibel' ),
					'type'        => 'int',
					'placeholder' => 40,
					'dependency'  => array(
						'element' => '_post_hero_overlay',
						'value'   => array( 'custom' ),
					),
				),

			),
		),
	);

	$menu_metaboxes = array(
		'menu_settings' => array(
			'title'      => esc_html__( 'Menu', 'decibel' ),
			'page'       => apply_filters( 'decibel_menu_settings_post_types', array( 'post', 'page', 'plugin', 'video', 'product', 'gallery', 'theme', 'work', 'show', 'release', 'wpm_playlist', 'event', 'artist', 'mp-event' ) ),

			'metafields' => array(
				array(
					'label'   => esc_html__( 'Menu Layout', 'decibel' ),
					'id'      => '_post_menu_layout',
					'type'    => 'select',
					'choices' => array(
						''                 => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						// 'top-logo' => esc_html__( 'Top Logo', 'decibel' ),
						'top-right'        => esc_html__( 'Top Right', 'decibel' ),
						'top-justify'      => esc_html__( 'Top Justify', 'decibel' ),
						'top-justify-left' => esc_html__( 'Top Justify Left', 'decibel' ),
						'centered-logo'    => esc_html__( 'Centered', 'decibel' ),
						'top-left'         => esc_html__( 'Top Left', 'decibel' ),
						// 'offcanvas' => esc_html__( 'Off Canvas', 'decibel' ),
						'overlay'          => esc_html__( 'Overlay', 'decibel' ),
						'lateral'          => esc_html__( 'Lateral', 'decibel' ),
						'none'             => esc_html__( 'No Menu', 'decibel' ),
					),
				),

				array(
					'label'   => esc_html__( 'Menu Width', 'decibel' ),
					'id'      => '_post_menu_width',
					'type'    => 'select',
					'choices' => array(
						''      => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'wide'  => esc_html__( 'Wide', 'decibel' ),
						'boxed' => esc_html__( 'Boxed', 'decibel' ),
					),
				),

				array(
					'label'   => esc_html__( 'Megamenu Width', 'decibel' ),
					'id'      => '_post_mega_menu_width',
					'type'    => 'select',
					'choices' => array(
						''          => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'boxed'     => esc_html__( 'Boxed', 'decibel' ),
						'wide'      => esc_html__( 'Wide', 'decibel' ),
						'fullwidth' => esc_html__( 'Full Width', 'decibel' ),
					),
				),

				array(
					'label'   => esc_html__( 'Menu Style', 'decibel' ),
					'id'      => '_post_menu_style',
					'type'    => 'select',
					'choices' => array(
						''                       => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'solid'                  => esc_html__( 'Solid', 'decibel' ),
						'semi-transparent-white' => esc_html__( 'Semi-transparent White', 'decibel' ),
						'semi-transparent-black' => esc_html__( 'Semi-transparent Black', 'decibel' ),
						'transparent'            => esc_html__( 'Transparent', 'decibel' ),
						// 'none' => esc_html__( 'No Menu', 'decibel' ),
					),
				),

				/*
				array(
					'label'	=> esc_html__( 'Menu Skin', 'decibel' ),
					'id'	=> '_post_menu_skin',
					'type'	=> 'select',
					'choices' => array(
						'' => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'light' => esc_html__( 'Light', 'decibel' ),
						'dark' => esc_html__( 'Dark', 'decibel' ),
						//'none' => esc_html__( 'No Menu', 'decibel' ),
					),
				),*/

				'menu_sticky_type'        => array(
					'id'      => '_post_menu_sticky_type',
					'label'   => esc_html__( 'Sticky Menu', 'decibel' ),
					'type'    => 'select',
					'choices' => array(
						''     => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'none' => esc_html__( 'Disabled', 'decibel' ),
						'soft' => esc_html__( 'Sticky on scroll up', 'decibel' ),
						'hard' => esc_html__( 'Always sticky', 'decibel' ),
					),
				),

				'sticky_menu_transparent' => array(
					'id'    => '_post_sticky_menu_transparent',
					'label' => esc_html__( 'Transparent Sticky Menu', 'decibel' ),
					'type'  => 'checkbox',
				),

				// array(
				// 'label' => esc_html__( 'Sticky Menu Skin', 'decibel' ),
				// 'id'    => '_post_menu_skin',
				// 'type'  => 'select',
				// 'choices' => array(
				// '' => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
				// 'light' => esc_html__( 'Light', 'decibel' ),
				// 'dark' => esc_html__( 'Dark', 'decibel' ),
				// 'none' => esc_html__( 'No Menu', 'decibel' ),
				// ),
				// ),

				array(
					'id'      => '_post_menu_cta_content_type',
					'label'   => esc_html__( 'Additional Content', 'decibel' ),
					'type'    => 'select',
					'default' => 'icons',
					'choices' => array_merge(
						array(
							'' => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						),
						apply_filters(
							'decibel_menu_cta_content_type_options',
							array(
								'search_icon'    => esc_html__( 'Search Icon', 'decibel' ),
								'secondary-menu' => esc_html__( 'Secondary Menu', 'decibel' ),
							)
						),
						array( 'none' => esc_html__( 'None', 'decibel' ) )
					),
				),

				array(
					'id'         => '_post_menu_socials',
					'label'      => esc_html__( 'Menu Socials', 'decibel' ),
					'type'       => 'text',
					'dependency' => array(
						'element' => '_post_menu_cta_content_type',
						'value'   => array( 'socials' ),
					),
					'desc'       => esc_html__( 'The list of social services to display in the menu. (eg: facebook,twitter,instagram).', 'decibel' ),
				),

				array(
					'id'      => '_post_show_nav_player',
					'label'   => esc_html__( 'Show Navigation Player', 'decibel' ),
					'type'    => 'select',
					'choices' => array(
						''    => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'yes' => esc_html__( 'Yes', 'decibel' ),
						'no'  => esc_html__( 'No', 'decibel' ),
					),
				),

				array(
					'id'      => '_post_side_panel_position',
					'label'   => esc_html__( 'Side Panel', 'decibel' ),
					'type'    => 'select',
					'choices' => array(
						''      => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'none'  => esc_html__( 'None', 'decibel' ),
						'right' => esc_html__( 'At Right', 'decibel' ),
						'left'  => esc_html__( 'At Left', 'decibel' ),
					),
					'desc'    => esc_html__( 'Note that it will be disable with a vertical menu layout (overlay, offcanvas etc...).', 'decibel' ),
				),

				array(
					'label' => esc_html__( 'Side Panel Background', 'decibel' ),
					'id'    => '_post_side_panel_bg_img',
					'type'  => 'image',
				),

				array(
					'id'      => '_post_logo_visibility',
					'label'   => esc_html__( 'Logo Visibility', 'decibel' ),
					'type'    => 'select',
					'choices' => array(
						''            => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'always'      => esc_html__( 'Always', 'decibel' ),
						'sticky_menu' => esc_html__( 'When menu is sticky only', 'decibel' ),
						'hidden'      => esc_html__( 'Hidden', 'decibel' ),
					),
				),

				array(
					'id'      => '_post_menu_items_visibility',
					'label'   => esc_html__( 'Menu Items Visibility', 'decibel' ),
					'type'    => 'select',
					'choices' => array(
						''       => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'show'   => esc_html__( 'Visible', 'decibel' ),
						'hidden' => esc_html__( 'Hidden', 'decibel' ),
					),
					'desc'    => esc_html__( 'If, for some reason, you need to hide the menu items but leave the logo, additional content and side panel.', 'decibel' ),
				),

				'menu_breakpoint'         => array(
					'id'    => '_post_menu_breakpoint',
					'label' => esc_html__( 'Mobile Menu Breakpoint', 'decibel' ),
					'type'  => 'text',
					'desc'  => esc_html__( 'Use this field if you want to overwrite the mobile menu breakpoint.', 'decibel' ),
				),
			),
		),
	);

	$footer_metaboxes = array(
		'footer_settings' => array(
			'title'      => esc_html__( 'Footer', 'decibel' ),
			'page'       => apply_filters( 'decibel_menu_settings_post_types', array( 'post', 'page', 'plugin', 'video', 'product', 'gallery', 'theme', 'work', 'show', 'release', 'wpm_playlist', 'event' ) ),

			'metafields' => array(
				array(
					'label'   => esc_html__( 'Page Footer', 'decibel' ),
					'id'      => '_post_footer_type',
					'type'    => 'select',
					'choices' => array(
						''       => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'hidden' => esc_html__( 'No Footer', 'decibel' ),
					),
				),

				array(
					'label'   => esc_html__( 'Hide Bottom Bar', 'decibel' ),
					'id'      => '_post_bottom_bar_hidden',
					'type'    => 'select',
					'choices' => array(
						''    => esc_html__( 'No', 'decibel' ),
						'yes' => esc_html__( 'Yes', 'decibel' ),
					),
				),
			),
		),
	);

	/************** Post options */

	$product_options   = array();
	$product_options[] = esc_html__( 'WooCommerce not installed', 'decibel' );

	if ( class_exists( 'WooCommerce' ) ) {
		$product_posts = get_posts( 'post_type="product"&numberposts=-1' );

		$product_options = array();
		if ( $product_posts ) {

			$product_options[] = esc_html__( 'Not linked', 'decibel' );

			foreach ( $product_posts as $product ) {
				$product_options[ $product->ID ] = $product->post_title;
			}
		} else {
			$product_options[ esc_html__( 'No product yet', 'decibel' ) ] = 0;
		}
	}

	$post_metaboxes = array(
		'post_settings' => array(
			'title'      => esc_html__( 'Post', 'decibel' ),
			'page'       => array( 'post' ),
			'metafields' => array(

				array(
					'label'   => esc_html__( 'Font Color Tone', 'decibel' ),
					'id'      => '_post_post_skin',
					'type'    => 'select',
					'choices' => array(
						''      => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'light' => esc_html__( 'Dark', 'decibel' ),
						'dark'  => esc_html__( 'Light', 'decibel' ),
					),
					'desc'    => esc_html__( 'The font color tone of the post in the loop.', 'decibel' ),
				),

				array(
					'label'   => esc_html__( 'Post Layout', 'decibel' ),
					'id'      => '_post_layout',
					'type'    => 'select',
					'choices' => array(
						''              => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'sidebar-right' => esc_html__( 'Sidebar Right', 'decibel' ),
						'sidebar-left'  => esc_html__( 'Sidebar Left', 'decibel' ),
						'no-sidebar'    => esc_html__( 'No Sidebar', 'decibel' ),
						'fullwidth'     => esc_html__( 'Full width', 'decibel' ),
					),
				),

				array(
					'label'   => esc_html__( 'Feature a Product', 'decibel' ),
					'id'      => '_post_wc_product_id',
					'type'    => 'select',
					'choices' => $product_options,
					'desc'    => esc_html__( 'A "Shop Now" buton will be displayed in the metro layout.', 'decibel' ),
				),

				array(
					'label' => esc_html__( 'Hide Featured Image in Post', 'decibel' ),
					'id'    => '_post_hide_single_post_featured_image',
					'type'  => 'checkbox',
				),
			),
		),
	);

	/************** Product options */
	$product_metaboxes = array(

		'product_options' => array(
			'title'      => esc_html__( 'Product', 'decibel' ),
			'page'       => array( 'product' ),
			'metafields' => array(

				/*
				array(
					'label'	=> esc_html__( 'Font Color Tone', 'decibel' ),
					'id'	=> '_post_product_skin',
					'type'	=> 'select',
					'choices' => array(
						'' => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'light' => esc_html__( 'Dark', 'decibel' ),
						'dark' => esc_html__( 'Light', 'decibel' ),
					),
					'desc'	=> esc_html__( 'The font color tone of the post in the loop.', 'decibel' ),
				),*/

				array(
					'label' => esc_html__( 'Background Color', 'decibel' ),
					'id'    => '_post_product_bg_color',
					'type'  => 'colorpicker',
					'desc'  => esc_html__( 'Background color of the post in the loop. You can use this option if your product image is a image in PNG format with a transparent background.', 'decibel' ),
				),

				array(
					'label'       => esc_html__( 'Label', 'decibel' ),
					'id'          => '_post_product_label',
					'type'        => 'text',
					'placeholder' => esc_html__( '-30%', 'decibel' ),
				),

				array(
					'label'   => esc_html__( 'Layout', 'decibel' ),
					'id'      => '_post_product_single_layout',
					'type'    => 'select',
					'choices' => array(
						''              => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'standard'      => esc_html__( 'Standard', 'decibel' ),
						'sidebar-right' => esc_html__( 'Sidebar Right', 'decibel' ),
						'sidebar-left'  => esc_html__( 'Sidebar Left', 'decibel' ),
						'fullwidth'     => esc_html__( 'Full Width', 'decibel' ),
					),
				),

				array(
					'label' => esc_html__( 'MP3', 'decibel' ),
					'id'    => '_post_product_mp3',
					'type'  => 'file',
					'desc'  => esc_html__( 'If you want to display a player for a song you want to sell, paste the mp3 URL here.', 'decibel' ),
				),

				array(
					'label' => esc_html__( 'MP3 Label', 'decibel' ),
					'id'    => '_post_product_mp3_label',
					'type'  => 'text',
					'desc'  => esc_html__( 'An optional label to describe the song.', 'decibel' ),
				),

				array(
					'label' => esc_html__( 'Hide Player on Single Product Page', 'decibel' ),
					'id'    => '_post_wc_product_hide_mp3_player',
					'type'  => 'checkbox',
				),

				array(
					'label' => esc_html__( 'Size Chart Image', 'decibel' ),
					'id'    => '_post_wc_product_size_chart_img',
					'type'  => 'image',
					'desc'  => esc_html__( 'You can set a size chart image in the product category options. You can overwrite the category size chart for this product by uploading another image here.', 'decibel' ),
				),

				array(
					'label' => esc_html__( 'Hide Size Chart Image', 'decibel' ),
					'id'    => '_post_wc_product_hide_size_chart_img',
					'type'  => 'checkbox',
				),

				array(
					'label'   => esc_html__( 'Menu Font Tone', 'decibel' ),
					'id'      => '_post_hero_font_tone',
					'type'    => 'select',
					'choices' => array(
						''      => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'light' => esc_html__( 'Light', 'decibel' ),
						'dark'  => esc_html__( 'Dark', 'decibel' ),
					),
					'desc'    => esc_html__( 'By default the menu style is set to "solid" on single product page. If you change the menu style, you may need to adujst the menu color tone here.', 'decibel' ),
				),

				'menu_sticky_type' => array(
					'id'      => '_post_product_sticky',
					'label'   => esc_html__( 'Stacked Images', 'decibel' ),
					'type'    => 'select',
					'choices' => array(
						''    => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'yes' => esc_html__( 'Yes', 'decibel' ),
						'no'  => esc_html__( 'No', 'decibel' ),
					),
				),

				array(
					'label' => esc_html__( 'Disable Image Zoom', 'decibel' ),
					'id'    => '_post_product_disable_easyzoom',
					'type'  => 'checkbox',
					'desc'  => esc_html__( 'Disable image zoom on this product if it\'s enabled in the customizer.', 'decibel' ),
				),
			),
		),
	);

	/************** Product options */

	$product_options   = array();
	$product_options[] = esc_html__( 'WooCommerce not installed', 'decibel' );

	if ( class_exists( 'WooCommerce' ) ) {
		$product_posts = get_posts( 'post_type="product"&numberposts=-1' );

		$product_options = array();
		if ( $product_posts ) {

			$product_options[] = esc_html__( 'Not linked', 'decibel' );

			foreach ( $product_posts as $product ) {
				$product_options[ $product->ID ] = $product->post_title;
			}
		} else {
			$product_options[ esc_html__( 'No product yet', 'decibel' ) ] = 0;
		}
	}

	// if ( class_exists( 'Wolf_Playlist_Manager' ) ) {
	// Player option
	// $playlist_posts = get_posts( 'post_type="wpm_playlist"&numberposts=-1' );

	// $playlist = array( '' => esc_html__( 'None', 'decibel' ) );
	// if ( $playlist_posts ) {
	// foreach ( $playlist_posts as $playlist_options ) {
	// $playlist[ $playlist_options->ID ] = $playlist_options->post_title;
	// }
	// } else {
	// $playlist[0] = esc_html__( 'No Playlist Yet', 'decibel' );
	// }

	// $product_metaboxes['product_options']['metafields'][] = array(
	// 'label' => esc_html__( 'Playlist', 'decibel' ),
	// 'id'    => '_post_product_playlist_id',
	// 'type'  => 'select',
	// 'choices' => $playlist,
	// 'desc' => esc_html__( 'It will overwrite the single player.', 'decibel' ),
	// );

	// $product_metaboxes['product_options']['metafields'][] = array(
	// 'label' => esc_html__( 'Playlist Skin', 'decibel' ),
	// 'id'    => '_post_product_playlist_skin',
	// 'type'  => 'select',
	// 'choices' => array(
	// 'dark' => esc_html__( 'Dark', 'decibel' ),
	// 'light' => esc_html__( 'Light', 'decibel' ),
	// ),
	// );
	// }

	/************** Portfolio options */
	$work_metaboxes = array(

		'work_options' => array(
			'title'      => esc_html__( 'Work', 'decibel' ),
			'page'       => array( 'work' ),
			'metafields' => array(

				array(
					'label'   => esc_html__( 'Font Color Tone', 'decibel' ),
					'id'      => '_post_work_skin',
					'type'    => 'select',
					'choices' => array(
						''      => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'light' => esc_html__( 'Dark', 'decibel' ),
						'dark'  => esc_html__( 'Light', 'decibel' ),
					),
					'desc'    => esc_html__( 'The font color tone of the post in the loop.', 'decibel' ),
				),

				array(
					'label' => esc_html__( 'Client', 'decibel' ),
					'id'    => '_work_client',
					'type'  => 'text',
				),

				array(
					'label' => esc_html__( 'Link', 'decibel' ),
					'id'    => '_work_link',
					'type'  => 'text',
				),

				array(
					'label'   => esc_html__( 'Width', 'decibel' ),
					'id'      => '_post_width',
					'type'    => 'select',
					'choices' => array(
						'standard'  => esc_html__( 'Standard', 'decibel' ),
						'wide'      => esc_html__( 'Wide', 'decibel' ),
						'fullwidth' => esc_html__( 'Full Width', 'decibel' ),
					),
				),

				array(
					'label'   => esc_html__( 'Layout', 'decibel' ),
					'id'      => '_post_layout',
					'type'    => 'select',
					'choices' => array(
						'centered'      => esc_html__( 'Centered', 'decibel' ),
						'sidebar-right' => esc_html__( 'Excerpt & Info at Right', 'decibel' ),
						'sidebar-left'  => esc_html__( 'Excerpt & Info at Left', 'decibel' ),
					),
				),

				array(
					'label'      => esc_html__( 'Excerpt & Info Position', 'decibel' ),
					'id'         => '_post_work_info_position',
					'type'       => 'select',
					'choices'    => array(
						'after'  => esc_html__( 'After Content', 'decibel' ),
						'before' => esc_html__( 'Before Content', 'decibel' ),
						'none'   => esc_html__( 'Hidden', 'decibel' ),
					),
					'dependency' => array(
						'element' => '_post_layout',
						'value'   => array( 'centered' ),
					),
				),

				// array(
				// 'label' => esc_html__( 'Featured', 'decibel' ),
				// 'id'    => '_post_featured',
				// 'type'  => 'checkbox',
				// 'desc'  => esc_html__( 'The featured image will be display bigger in the "metro" layout.', 'decibel' ),
				// ),
			),
		),
	);

	/************** Video options */
	$video_metaboxes = array(
		'video_settings' => array(
			'title'      => esc_html__( 'Video', 'decibel' ),
			'page'       => array( 'video' ),
			'metafields' => array(

				array(
					'label'   => esc_html__( 'Layout', 'decibel' ),
					'id'      => '_post_layout',
					'type'    => 'select',
					'choices' => array(
						''              => esc_html__( 'Default', 'decibel' ),
						'standard'      => esc_html__( 'Standard', 'decibel' ),
						'sidebar-right' => esc_html__( 'Sidebar Right', 'decibel' ),
						'sidebar-left'  => esc_html__( 'Sidebar Left', 'decibel' ),
						'fullwidth'     => esc_html__( 'Full Width', 'decibel' ),
					),
				),
			),
		),
	);

	/************** Events options */

	$event_metaboxes = array(
		'event_options' => array(
			'title'      => esc_html__( 'Event', 'decibel' ),
			'page'       => array( 'event' ),
			'metafields' => array(

				array(
					'label'   => esc_html__( 'Font Color Tone', 'decibel' ),
					'id'      => '_post_event_skin',
					'type'    => 'select',
					'choices' => array(
						''      => '&mdash; ' . esc_html__( 'Default', 'decibel' ) . ' &mdash;',
						'light' => esc_html__( 'Dark', 'decibel' ),
						'dark'  => esc_html__( 'Light', 'decibel' ),
					),
					'desc'    => esc_html__( 'The font color tone of the post in the loop.', 'decibel' ),
				),
			),
		),
	);

	$release_metaboxes = array(
		'release_options' => array(
			'title'      => esc_html__( 'Release', 'decibel' ),
			'page'       => array( 'release' ),
			'metafields' => array(

				array(
					'label' => esc_html__( 'Secondary Feature image', 'decibel' ),
					'id'    => '_release_secondary_featured_image',
					'type'  => 'image',

				),

				array(
					'label'   => esc_html__( 'Cover Type', 'decibel' ),
					'id'      => '_release_cover_type',
					'type'    => 'select',
					'choices' => array(
						'cd'    => esc_html__( 'CD', 'decibel' ),
						'vinyl' => esc_html__( 'Vinyl', 'decibel' ),
						// 'fullwidth' => esc_html__( 'Full Width', 'decibel' ),
					),
				),

				array(
					'label'   => esc_html__( 'Release Width', 'decibel' ),
					'id'      => '_post_width',
					'type'    => 'select',
					'choices' => array(
						'standard' => esc_html__( 'Standard', 'decibel' ),
						'wide'     => esc_html__( 'Wide', 'decibel' ),
						// 'fullwidth' => esc_html__( 'Full Width', 'decibel' ),
					),
				),

				array(
					'label'   => esc_html__( 'Release Layout', 'decibel' ),
					'id'      => '_post_layout',
					'type'    => 'select',
					'choices' => array(
						'sidebar-left'  => esc_html__( 'Content Right', 'decibel' ),
						'sidebar-right' => esc_html__( 'Content Left', 'decibel' ),
						// 'centered' => esc_html__( 'Centered', 'decibel' ),
					),
				),

				array(
					'label'   => esc_html__( 'WooCommerce Product ID', 'decibel' ),
					'id'      => '_post_wc_product_id',
					'type'    => 'select',
					'choices' => $product_options,
					'desc'    => esc_html__( 'You can link this release to a WooCommerce product to add an "Add to cart" button.', 'decibel' ),
				),

				array(
					'label' => esc_html__( 'Featured', 'decibel' ),
					'id'    => '_post_featured',
					'type'  => 'checkbox',
					'desc'  => esc_html__( 'May be used depending on layout option.', 'decibel' ),
				),
			),
		),
	);

	/************** One pager options */
	$one_page_metaboxes = array(
		'one_page_settings' => array(
			'title'      => esc_html__( 'One-Page', 'decibel' ),
			'page'       => array( 'post', 'page', 'work', 'product', 'release' ),
			'metafields' => array(
				array(
					'label'   => esc_html__( 'One-Page Navigation', 'decibel' ),
					'id'      => '_post_one_page_menu',
					'type'    => 'select',
					'choices' => array(
						''                 => esc_html__( 'No', 'decibel' ),
						'replace_main_nav' => esc_html__( 'Yes', 'decibel' ),
					),
					'desc'    => decibel_kses( __( 'Activate to replace the main menu by a one-page scroll navigation. <strong>NB: Every row must have a unique name set in the row settings "Advanced" tab.</strong>', 'decibel' ) ),
				),
				array(
					'label' => esc_html__( 'One-Page Bullet Navigation', 'decibel' ),
					'id'    => '_post_scroller',
					'type'  => 'checkbox',
					'desc'  => decibel_kses( __( 'Activate to create a section scroller navigation. <strong>NB: Every row must have a unique name set in the row settings "Advanced" tab.</strong>', 'decibel' ) ),
				),
				array(
					'label'   => sprintf( esc_html__( 'Enable %s animations', 'decibel' ), 'fullPage' ),
					'id'      => '_post_fullpage',
					'type'    => 'select',
					'choices' => array(
						''    => esc_html__( 'No', 'decibel' ),
						'yes' => esc_html__( 'Yes', 'decibel' ),
					),
					'desc'    => esc_html__( 'Activate to enable advanced scroll animations between sections. Some of your row setting may be disabled to suit the global page design.', 'decibel' ),
				),

				array(
					'label'      => sprintf( esc_html__( '%s animation transition', 'decibel' ), 'fullPage' ),
					'id'         => '_post_fullpage_transition',
					'type'       => 'select',
					'choices'    => array(
						'mix'      => esc_html__( 'Special', 'decibel' ),
						'parallax' => esc_html__( 'Parallax', 'decibel' ),
						'fade'     => esc_html__( 'Fade', 'decibel' ),
						'zoom'     => esc_html__( 'Zoom', 'decibel' ),
						'curtain'  => esc_html__( 'Curtain', 'decibel' ),
						'slide'    => esc_html__( 'Slide', 'decibel' ),
					),
					'dependency' => array(
						'element' => '_post_fullpage',
						'value'   => array( 'yes' ),
					),
				),

				array(
					'label'       => sprintf( esc_html__( '%s animation duration', 'decibel' ), 'fullPage' ),
					'id'          => '_post_fullpage_animtime',
					'type'        => 'text',
					'placeholder' => 1000,
					'dependency'  => array(
						'element' => '_post_fullpage',
						'value'   => array( 'yes' ),
					),
				),
			),
		),
	);

	$all_metaboxes = array_merge(
		apply_filters( 'decibel_body_metaboxes', $body_metaboxes ),
		apply_filters( 'decibel_post_metaboxes', $post_metaboxes ),
		apply_filters( 'decibel_product_metaboxes', $product_metaboxes ),
		apply_filters( 'decibel_release_metaboxes', $release_metaboxes ),
		apply_filters( 'decibel_event_metaboxes', $event_metaboxes ),
		apply_filters( 'decibel_work_metaboxes', $work_metaboxes ),
		apply_filters( 'decibel_video_metaboxes', $video_metaboxes ),
		apply_filters( 'decibel_header_metaboxes', $header_metaboxes ),
		apply_filters( 'decibel_menu_metaboxes', $menu_metaboxes ),
		apply_filters( 'decibel_footer_metaboxes', $footer_metaboxes )
	);

	if ( class_exists( 'Wolf_Visual_Composer' ) && defined( 'WPB_VC_VERSION' ) ) {
		$all_metaboxes = $all_metaboxes + apply_filters( 'decibel_one_page_metaboxes', $one_page_metaboxes );
	}

	if ( class_exists( 'Wolf_Metaboxes' ) ) {
		new Wolf_Metaboxes( apply_filters( 'decibel_metaboxes', $all_metaboxes ) );
	}
}
decibel_register_metabox();
