<?php
/**
 * Decibel recommended plugins
 *
 * @package WordPress
 * @subpackage Decibel
 * @since Decibel 3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// delete_user_meta( get_current_user_id(), 'tgmpa_dismissed_notice_tgmpa' );

/**
 * Add decibel updater plugins
 */
add_filter(
	'decibel_recommended_plugins',
	function( $plugins ) {

		if ( get_option( 'wolf_theme_options_decibel' ) ) {

			$plugins[] = array(
				'name'         => esc_html__( 'Wolf Decibel Version 3 Updater', 'decibel' ),
				'slug'         => 'wolf-decibel-v3-updater',
				'source'       => 'http://plugins.wolfthemes.com/wolf-decibel-v3-updater/wolf-decibel-v3-updater.zip',
				'external_url' => 'http://plugins.wolfthemes.com/wolf-decibel-v3-updater/wolf-decibel-v3-updater.zip',
			);

			$plugins[] = array(
				'name' => esc_html__( 'Force Regenerate Thumbnails', 'decibel' ),
				'slug' => 'force-regenerate-thumbnails',
			);

		}

		return $plugins;
	}
);

/* Require TGM Plugin Activation class */
require_once get_template_directory() . '/inc/admin/lib/class-tgm-plugin-activation.php';

function wolf_theme_register_required_plugins() {

	$plugins = apply_filters(
		'decibel_recommended_plugins',
		array(

			array(
				'name'     => esc_html__( 'WPBakery Page Builder', 'decibel' ),
				'slug'     => 'js_composer',
				'source'   => 'js_composer.zip',
				'required' => true,
			),

			array(
				'name'    => esc_html__( 'Slider Revolution', 'decibel' ),
				'slug'    => 'revslider',
				'source'  => 'revslider.zip',
				'version' => '6.2',
			),

			array(
				'name'         => esc_html__( 'WPBakery Page Builder Extension', 'decibel' ),
				'slug'         => 'wolf-visual-composer',
				'source'       => 'https://github.com/wolfthemes/wolf-visual-composer/archive/master.zip',
				'external_url' => 'https://github.com/wolfthemes/wolf-visual-composer/archive/master.zip',
				'required'     => true,
			),

			array(
				'name'         => esc_html__( 'WPBakery Page Builder Content Blocks', 'decibel' ),
				'slug'         => 'wolf-vc-content-block',
				'source'       => 'https://github.com/wolfthemes/wolf-vc-content-block/archive/master.zip',
				'external_url' => 'https://github.com/wolfthemes/wolf-vc-content-block/archive/master.zip',
			),

			array(
				'name'         => esc_html__( 'Playlist Manager', 'decibel' ),
				'slug'         => 'wolf-playlist-manager',
				'source'       => 'https://github.com/wolfthemes/wolf-playlist-manager/archive/master.zip',
				'external_url' => 'https://github.com/wolfthemes/wolf-playlist-manager/archive/master.zip',
			),

			array(
				'name'         => esc_html__( 'Discography', 'decibel' ),
				'slug'         => 'wolf-discography',
				'source'       => 'https://github.com/wolfthemes/wolf-discography/archive/master.zip',
				'external_url' => 'https://github.com/wolfthemes/wolf-discography/archive/master.zip',
			),

			array(
				'name'         => esc_html__( 'Events', 'decibel' ),
				'slug'         => 'wolf-events',
				'source'       => 'https://github.com/wolfthemes/wolf-events/archive/master.zip',
				'external_url' => 'https://github.com/wolfthemes/wolf-events/archive/master.zip',
			),

			array(
				'name'         => esc_html__( 'Videos', 'decibel' ),
				'slug'         => 'wolf-videos',
				'source'       => 'https://github.com/wolfthemes/wolf-videos/archive/master.zip',
				'external_url' => 'https://github.com/wolfthemes/wolf-videos/archive/master.zip',
			),

			array(
				'name'         => esc_html__( 'Photo Albums', 'decibel' ),
				'slug'         => 'wolf-albums',
				'source'       => 'https://github.com/wolfthemes/wolf-albums/archive/master.zip',
				'external_url' => 'https://github.com/wolfthemes/wolf-albums/archive/master.zip',
			),

			array(
				'name'         => esc_html__( 'Share Icons', 'decibel' ),
				'slug'         => 'wolf-share',
				'source'       => 'https://github.com/wolfthemes/wolf-share/archive/master.zip',
				'external_url' => 'https://github.com/wolfthemes/wolf-share/archive/master.zip',
			),

			array(
				'name'         => esc_html__( 'Custom Post Meta', 'decibel' ),
				'slug'         => 'wolf-custom-post-meta',
				'source'       => 'https://github.com/wolfthemes/wolf-custom-post-meta/archive/master.zip',
				'external_url' => 'https://github.com/wolfthemes/wolf-custom-post-meta/archive/master.zip',
			),

			array(
				'name'         => esc_html__( 'Metaboxes', 'decibel' ),
				'slug'         => 'wolf-metaboxes',
				'source'       => 'https://github.com/wolfthemes/wolf-metaboxes/archive/master.zip',
				'external_url' => 'https://github.com/wolfthemes/wolf-metaboxes/archive/master.zip',
			),

			array(
				'name'         => esc_html__( 'Twitter Feed', 'decibel' ),
				'slug'         => 'wolf-twitter',
				'source'       => 'https://github.com/wolfthemes/wolf-twitter/archive/master.zip',
				'external_url' => 'https://github.com/wolfthemes/wolf-twitter/archive/master.zip',
			),

			array(
				'name' => esc_html__( 'Instagram Feed (Smash Balloon)', 'decibel' ),
				'slug' => 'instagram-feed',
			),

			array(
				'name'         => esc_html__( 'Video Thumbnail Generator', 'decibel' ),
				'slug'         => 'wolf-video-thumbnail-generator',
				'source'       => 'https://github.com/wolfthemes/wolf-video-thumbnail-generator/archive/master.zip',
				'external_url' => 'https://github.com/wolfthemes/wolf-video-thumbnail-generator/archive/master.zip',
			),

			array(
				'name' => esc_html__( 'WooCommerce', 'decibel' ),
				'slug' => 'woocommerce',
			),

			array(
				'name' => esc_html__( 'WooCommerce Currency Switcher', 'decibel' ),
				'slug' => 'woocommerce-currency-switcher',
			),

			array(
				'name'         => esc_html__( 'WooCommerce Quickview', 'decibel' ),
				'slug'         => 'wolf-woocommerce-quickview',
				'source'       => 'https://github.com/wolfthemes/wolf-woocommerce-quickview/archive/master.zip',
				'external_url' => 'https://github.com/wolfthemes/wolf-woocommerce-quickview/archive/master.zip',
			),

			array(
				'name' => esc_html__( 'WooCommerce Variation Swatches', 'decibel' ),
				'slug' => 'variation-swatches-for-woocommerce',
			),

			array(
				'name'         => esc_html__( 'WooCommerce Wishlist', 'decibel' ),
				'slug'         => 'wolf-woocommerce-wishlist',
				'source'       => 'https://github.com/wolfthemes/wolf-woocommerce-wishlist/archive/master.zip',
				'external_url' => 'https://github.com/wolfthemes/wolf-woocommerce-wishlist/archive/master.zip',
			),

			array(
				'name' => esc_html__( 'Contact Form 7', 'decibel' ),
				'slug' => 'contact-form-7',
			),

			array(
				'name' => esc_html__( 'Widgets in Menu for WordPress', 'decibel' ),
				'slug' => 'widgets-in-menu',
			),

			array(
				'name' => esc_html__( 'Force Regenerate Thumbnails', 'decibel' ),
				'slug' => 'force-regenerate-thumbnails',
			),

			array(
				'name'         => esc_html__( 'Envato Market Items Updater', 'decibel' ),
				'slug'         => 'envato-market',
				'source'       => 'https://github.com/envato/wp-envato-market/archive/master.zip',
				'external_url' => 'https://github.com/envato/wp-envato-market/archive/master.zip',
			),

			array(
				'name' => esc_html__( 'Disable Gutenberg', 'decibel' ),
				'slug' => 'disable-gutenberg',
			),

			array(
				'name' => esc_html__( 'One Click Demo Import', 'decibel' ),
				'slug' => 'one-click-demo-import',
			),
		)
	);

	// Change this to your theme text domain, used for internationalising strings
	$theme_text_domain = 'decibel';

	/*
	 * Array of configuration settings. Amend each line as needed.
	 *
	 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
	 * strings available, please help us make TGMPA even better by giving us access to these translations or by
	 * sending in a pull-request with .po file(s) with the translations.
	 *
	 * Only uncomment the strings in the config array if you want to customize the strings.
	 */
	$config = array(
		'id'           => 'tgmpa',
		'default_path' => get_template_directory() . '/config/plugins/',
		'menu'         => 'tgmpa-install-plugins',
		'parent_slug'  => 'themes.php',
		'capability'   => 'edit_theme_options',
		'has_notices'  => true,
		'dismissable'  => true,
		'dismiss_msg'  => '',
		'is_automatic' => false,
		'message'      => '',
	);
	tgmpa( $plugins, $config );
}
add_action( 'tgmpa_register', 'wolf_theme_register_required_plugins' );
