<?php
/**
 * Decibel functions and definitions
 *
 * @link https://codex.wordpress.org/Theme_Development
 * @link https://codex.wordpress.org/Child_Themes
 *
 * Functions that are not pluggable (not wrapped in function_exists()) are
 * instead attached to a filter or action hook.
 *
 * For more information on hooks, actions, and filters,
 * {@link https://codex.wordpress.org/Plugin_API}
 *
 * @package    WordPress
 * @subpackage Decibel
 * @version    3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Sets up theme defaults and registers support for various WordPress features using the DECIBEL function
 *
 * @see inc/framework.php
 */
function decibel_setup_config() {
	/**
	 *  Require the wolf themes framework core file
	 */
	include_once get_template_directory() . '/inc/framework.php';

	/**
	 * Set theme main settings
	 *
	 * We this array to configure the main theme settings
	 */
	$decibel_settings = array(

		/* Menus */
		'menus'       => array(
			'primary'   => esc_html__( 'Primary Menu', 'decibel' ),
			'secondary' => esc_html__( 'Secondary Menu', 'decibel' ),
			'mobile'    => esc_html__( 'Mobile Menu (optional)', 'decibel' ),
		),

		/**
		 *  We define wordpress thumbnail sizes that we will use in our design
		 */
		'image_sizes' => array(

			/**
			 * Create custom image sizes if the Wolf WPBakery Page Builder extension plugin is not installed
			 * We will use the same image size names to avoid duplicated image sizes in the case the plugin is active
			 */
			'decibel-photo'         => array( 500, 500, false ),
			'decibel-metro'         => array( 550, 999, false ),
			'decibel-masonry'       => array( 500, 2000, false ),
			'decibel-masonry-small' => array( 400, 400, false ),
			'decibel-XL'            => array( 1920, 3000, false ),
		),
	);

	DECIBEL( $decibel_settings ); // let's go.
}
decibel_setup_config();
