<?php
/**
 * Decibel admin scripts
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Admin scripts
 */
function decibel_admin_scripts() {

	$suffix  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	$version = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? time() : decibel_get_theme_version();

	/* Admin styles */
	wp_enqueue_style( 'chosen', get_template_directory_uri() . '/assets/js/admin/chosen/chosen.min.css', array(), '1.1.0' );
	wp_enqueue_style( 'decibel-admin', get_template_directory_uri() . '/assets/css/admin/admin' . $suffix . '.css', array(), $version );

	/* Admins scripts */
	wp_enqueue_media();
	wp_enqueue_script( 'chosen', get_template_directory_uri() . '/assets/js/admin/chosen/chosen.jquery.min.js', array( 'jquery' ), '1.1.0', true );
	wp_enqueue_script( 'js-cookie', get_template_directory_uri() . '/assets/js/lib/js.cookie.min.js', array( 'jquery' ), '1.4.1', true );

	if ( isset( $_GET['page'] ) && ( esc_attr( wp_unslash( $_GET['page'] ) ) === decibel_get_theme_slug() . '-about' ) ) {
		wp_enqueue_script( 'decibel-tabs', get_template_directory_uri() . '/assets/js/admin/tabs.js', array( 'jquery' ), $version, true );
	}

	wp_enqueue_script( 'decibel-admin', get_template_directory_uri() . '/assets/js/admin/admin.js', array( 'jquery', 'jquery-ui-sortable', 'wp-color-picker' ), $version, true );

	/*
	* Check the uer capabilities to avoid enabling the customizer reset button in guest mod with Customizer Preview for Theme Demo plugin
	*/
	if ( current_user_can( 'manage_options' ) ) {
		wp_enqueue_script( 'decibel-reset-customizer-button', get_template_directory_uri() . '/assets/js/admin/reset-customizer-button' . $suffix . '.js', array( 'jquery' ), $version, true );
	}

	wp_localize_script(
		'decibel-admin',
		'DecibelAdminParams',
		array(
			'ajaxUrl'               => esc_url( admin_url( 'admin-ajax.php' ) ),
			'noResult'              => esc_html__( 'No result', 'decibel' ),
			'resetModsText'         => esc_html__( 'Reset', 'decibel' ),
			'subHeadingPlaceholder' => esc_html__( 'Subheading', 'decibel' ),
			'confirm'               => esc_html__( 'Are you sure to want to reset all mods to default? There is no way back.', 'decibel' ),
			'nonce'                 => array(
				'reset' => wp_create_nonce( 'decibel-customizer-reset' ),
			),
		)
	);
}
add_action( 'admin_enqueue_scripts', 'decibel_admin_scripts' );

/**
 * Additional custom CSS
 *
 * @see decibel_get_theme_uri
 */
function decibel_admin_custom_css() {

	$css = '';

	$accent = get_theme_mod( 'accent_color' );

	if ( $accent ) {
		$css .= "
			.accent{
				color:$accent;
			}

			.wvc_colored-dropdown .accent{
				background-color:$accent;
				color:#fff;
			}

			.wolf_core_colored-dropdown .accent{
				background-color:$accent;
				color:#fff;
			}
		";
	}

	if ( is_file( get_template_directory() . '/config/badge.png' ) ) {

		$badge_url = get_template_directory_uri() . '/config/badge.png';

		$css .= "
			.decibel-about-page-logo{
				background-image: url($badge_url)!important;
			}
		";
	}

	if ( ! SCRIPT_DEBUG ) {
		$css = decibel_compact_css( apply_filters( 'decibel_admin_custom_css', $css ) );
	}

	wp_add_inline_style( 'decibel-admin', $css );
}
add_action( 'admin_enqueue_scripts', 'decibel_admin_custom_css' );
