<?php
/**
 * Decibel albums
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Set gallery mods
 *
 * @param array $mods Array of mods.
 * @return array
 */
function decibel_set_gallery_mods( $mods ) {

	if ( class_exists( 'Wolf_Albums' ) ) {
		$mods['wolf_albums'] = array(
			'priority' => 45,
			'id'       => 'wolf_albums',
			'title'    => esc_html__( 'Albums', 'decibel' ),
			'icon'     => 'images-alt2',
			'options'  => array(

				'gallery_layout'       => array(
					'id'        => 'gallery_layout',
					'label'     => esc_html__( 'Layout', 'decibel' ),
					'type'      => 'select',
					'choices'   => array(
						'standard'  => esc_html__( 'Standard', 'decibel' ),
						'fullwidth' => esc_html__( 'Full width', 'decibel' ),
					),
					'transport' => 'postMessage',
				),

				'gallery_display'      => array(
					'id'      => 'gallery_display',
					'label'   => esc_html__( 'Albums Display', 'decibel' ),
					'type'    => 'select',
					'choices' => apply_filters(
						'decibel_gallery_display_options',
						array(
							'grid' => esc_html__( 'Grid', 'decibel' ),
						)
					),
				),

				'gallery_grid_padding' => array(
					'id'        => 'gallery_grid_padding',
					'label'     => esc_html__( 'Padding', 'decibel' ),
					'type'      => 'select',
					'choices'   => array(
						'yes' => esc_html__( 'Yes', 'decibel' ),
						'no'  => esc_html__( 'No', 'decibel' ),
					),
					'transport' => 'postMessage',
				),

				'gallery_pagination'   => array(
					'id'          => 'gallery_pagination',
					'label'       => esc_html__( 'Albums Archive Pagination', 'decibel' ),
					'type'        => 'select',
					'choices'     => array(
						'none'                => esc_html__( 'None', 'decibel' ),
						'standard_pagination' => esc_html__( 'Numeric Pagination', 'decibel' ),
						'load_more'           => esc_html__( 'Load More Button', 'decibel' ),
					),
					'description' => esc_html__( 'You must set a number of posts per page below. The category filter will not be disabled.', 'decibel' ),
				),

				'gallerys_per_page'    => array(
					'label'       => esc_html__( 'Albums per Page', 'decibel' ),
					'id'          => 'gallerys_per_page',
					'type'        => 'text',
					'placeholder' => 6,
				),
			),
		);
	}

	return $mods;
}
add_filter( 'decibel_customizer_mods', 'decibel_set_gallery_mods' );
