<?php
/**
 * Decibel events
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Set artists mods
 *
 * @param array $mods Array of mods.
 * @return array
 */
function decibel_set_artist_mods( $mods ) {

	if ( class_exists( 'Wolf_Artists' ) ) {
		$mods['wolf_artists'] = array(
			'priority' => 45,
			'id'       => 'wolf_artists',
			'title'    => esc_html__( 'Artists', 'decibel' ),
			'icon'     => 'admin-users',
			'options'  => array(

				'artist_layout'       => array(
					'id'          => 'artist_layout',
					'label'       => esc_html__( 'Layout', 'decibel' ),
					'type'        => 'select',
					'choices'     => array(
						'standard'      => esc_html__( 'Standard', 'decibel' ),
						'fullwidth'     => esc_html__( 'Full width', 'decibel' ),
						'sidebar-right' => esc_html__( 'Sidebar at right', 'decibel' ),
						'sidebar-left'  => esc_html__( 'Sidebar at left', 'decibel' ),
					),
					'transport'   => 'postMessage',
					'description' => esc_html__( 'For "Sidebar" layouts, the sidebar will be visible if it contains widgets.', 'decibel' ),
				),

				'artist_display'      => array(
					'id'      => 'artist_display',
					'label'   => esc_html__( 'Display', 'decibel' ),
					'type'    => 'select',
					'choices' => apply_filters(
						'decibel_artist_display_options',
						array(
							'list' => esc_html__( 'List', 'decibel' ),
						)
					),
				),

				'artist_grid_padding' => array(
					'id'        => 'artist_grid_padding',
					'label'     => esc_html__( 'Padding', 'decibel' ),
					'type'      => 'select',
					'choices'   => array(
						'yes' => esc_html__( 'Yes', 'decibel' ),
						'no'  => esc_html__( 'No', 'decibel' ),
					),
					'transport' => 'postMessage',
				),

				'artist_pagination'   => array(
					'id'          => 'artist_pagination',
					'label'       => esc_html__( 'Artists Archive Pagination', 'decibel' ),
					'type'        => 'select',
					'choices'     => array(
						'none'                => esc_html__( 'None', 'decibel' ),
						'standard_pagination' => esc_html__( 'Numeric Pagination', 'decibel' ),
						'load_more'           => esc_html__( 'Load More Button', 'decibel' ),
					),
					'description' => esc_html__( 'You must set a number of posts per page below. The category filter will not be disabled.', 'decibel' ),
				),

				'artists_per_page'    => array(
					'label'       => esc_html__( 'Artists per Page', 'decibel' ),
					'id'          => 'artists_per_page',
					'type'        => 'text',
					'placeholder' => 6,
				),
			),
		);
	}

	return $mods;

}
add_filter( 'decibel_customizer_mods', 'decibel_set_artist_mods' );
