<?php
/**
 * Decibel customizer blog mods
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Blog mods
 *
 * @param array $mods Array of mods.
 * @return array
 */
function decibel_set_post_mods( $mods ) {

	$mods['blog'] = array(
		'id'      => 'blog',
		'icon'    => 'welcome-write-blog',
		'title'   => esc_html__( 'Blog', 'decibel' ),
		'options' => array(

			'post_layout'           => array(
				'id'          => 'post_layout',
				'label'       => esc_html__( 'Blog Archive Layout', 'decibel' ),
				'type'        => 'select',
				'choices'     => array(
					'standard'      => esc_html__( 'Standard', 'decibel' ),
					'fullwidth'     => esc_html__( 'Full width', 'decibel' ),
					'sidebar-right' => esc_html__( 'Sidebar at right', 'decibel' ),
					'sidebar-left'  => esc_html__( 'Sidebar at left', 'decibel' ),
				),
				'transport'   => 'postMessage',
				'description' => esc_html__( 'For "Sidebar" layouts, the sidebar will be visible if it contains widgets.', 'decibel' ),
			),

			'post_display'          => array(
				'id'      => 'post_display',
				'label'   => esc_html__( 'Blog Archive Display', 'decibel' ),
				'type'    => 'select',
				'choices' => apply_filters(
					'decibel_post_display_options',
					array(
						'standard' => esc_html__( 'Standard', 'decibel' ),
					)
				),
			),

			'post_grid_padding'     => array(
				'id'        => 'post_grid_padding',
				'label'     => esc_html__( 'Padding (for grid style display only)', 'decibel' ),
				'type'      => 'select',
				'choices'   => array(
					'yes' => esc_html__( 'Yes', 'decibel' ),
					'no'  => esc_html__( 'No', 'decibel' ),
				),
				'transport' => 'postMessage',
			),

			'date_format'           => array(
				'id'      => 'date_format',
				'label'   => esc_html__( 'Blog Date Format', 'decibel' ),
				'type'    => 'select',
				'choices' => array(
					''           => esc_html__( 'Default', 'decibel' ),
					'human_diff' => esc_html__( '"X Time ago"', 'decibel' ),
				),
			),

			'post_pagination'       => array(
				'id'      => 'post_pagination',
				'label'   => esc_html__( 'Blog Archive Pagination', 'decibel' ),
				'type'    => 'select',
				'choices' => array(
					'standard_pagination' => esc_html__( 'Numeric Pagination', 'decibel' ),
					'load_more'           => esc_html__( 'Load More Button', 'decibel' ),
				),
			),

			'post_excerpt_type'     => array(
				'id'          => 'post_excerpt_type',
				'label'       => esc_html__( 'Blog Archive Post Excerpt Type', 'decibel' ),
				'type'        => 'select',
				'choices'     => array(
					'auto'   => esc_html__( 'Auto', 'decibel' ),
					'manual' => esc_html__( 'Manual', 'decibel' ),
				),
				'description' => sprintf( decibel_kses( __( 'Only for the "Standard" display type. To split your post manually, you can use the <a href="%s" target="_blank">"read more"</a> tag.', 'decibel' ) ), 'https://codex.wordpress.org/Customizing_the_Read_More' ),
			),

			'post_single_layout'    => array(
				'id'      => 'post_single_layout',
				'label'   => esc_html__( 'Single Post Layout', 'decibel' ),
				'type'    => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Sidebar Right', 'decibel' ),
					'sidebar-left'  => esc_html__( 'Sidebar Left', 'decibel' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'decibel' ),
					'fullwidth'     => esc_html__( 'Full width', 'decibel' ),
				),
			),

			'post_author_box'       => array(
				'id'      => 'post_author_box',
				'label'   => esc_html__( 'Single Post Author Box', 'decibel' ),
				'type'    => 'select',
				'choices' => array(
					'yes' => esc_html__( 'Yes', 'decibel' ),
					'no'  => esc_html__( 'No', 'decibel' ),
				),
			),

			'post_related_posts'    => array(
				'id'      => 'post_related_posts',
				'label'   => esc_html__( 'Single Post Related Posts', 'decibel' ),
				'type'    => 'select',
				'choices' => array(
					'yes' => esc_html__( 'Yes', 'decibel' ),
					'no'  => esc_html__( 'No', 'decibel' ),
				),
			),

			'post_item_animation'   => array(
				'label'   => esc_html__( 'Blog Archive Item Animation', 'decibel' ),
				'id'      => 'post_item_animation',
				'type'    => 'select',
				'choices' => decibel_get_animations(),
			),

			'post_display_elements' => array(
				'id'          => 'post_display_elements',
				'label'       => esc_html__( 'Elements to show by default', 'decibel' ),
				'type'        => 'group_checkbox',
				'choices'     => array(
					'show_thumbnail'  => esc_html__( 'Thumbnail', 'decibel' ),
					'show_date'       => esc_html__( 'Date', 'decibel' ),
					'show_text'       => esc_html__( 'Text', 'decibel' ),
					'show_category'   => esc_html__( 'Category', 'decibel' ),
					'show_author'     => esc_html__( 'Author', 'decibel' ),
					'show_tags'       => esc_html__( 'Tags', 'decibel' ),
					'show_extra_meta' => esc_html__( 'Extra Meta', 'decibel' ),
				),
				'description' => esc_html__( 'Note that some options may be ignored depending on the post display.', 'decibel' ),
			),
		),
	);

	if ( class_exists( 'Wolf_Custom_Post_Meta' ) ) {

		$mods['blog']['options'][] = array(
			'label'   => esc_html__( 'Enable Custom Post Meta', 'decibel' ),
			'id'      => 'enable_custom_post_meta',
			'type'    => 'group_checkbox',
			'choices' => array(
				'post_enable_views'        => esc_html__( 'Views', 'decibel' ),
				'post_enable_likes'        => esc_html__( 'Likes', 'decibel' ),
				'post_enable_reading_time' => esc_html__( 'Reading Time', 'decibel' ),
			),
		);
	}

	return $mods;
}
add_filter( 'decibel_customizer_mods', 'decibel_set_post_mods' );
