<?php
/**
 * Decibel discography
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Discography mods
 *
 * @param array $mods Array of mods.
 * @return array
 */
function decibel_set_release_mods( $mods ) {

	if ( class_exists( 'Wolf_Discography' ) ) {
		$mods['wolf_discography'] = array(
			'priority' => 45,
			'id'       => 'wolf_discography',
			'title'    => esc_html__( 'Discography', 'decibel' ),
			'icon'     => 'album',
			'options'  => array(
				'release_layout'       => array(
					'id'          => 'release_layout',
					'label'       => esc_html__( 'Layout', 'decibel' ),
					'type'        => 'select',
					'choices'     => array(
						'standard'      => esc_html__( 'Standard', 'decibel' ),
						'fullwidth'     => esc_html__( 'Full width', 'decibel' ),
						'sidebar-right' => esc_html__( 'Sidebar at right', 'decibel' ),
						'sidebar-left'  => esc_html__( 'Sidebar at left', 'decibel' ),
					),
					'transport'   => 'postMessage',
					'description' => esc_html__( 'For "Sidebar" layouts, the sidebar will be visible if it contains widgets.', 'decibel' ),
				),

				'release_display'      => array(
					'id'      => 'release_display',
					'label'   => esc_html__( 'Display', 'decibel' ),
					'type'    => 'select',
					'choices' => apply_filters(
						'decibel_release_display_options',
						array(
							'grid' => esc_html__( 'Grid', 'decibel' ),
						)
					),
				),

				'release_grid_padding' => array(
					'id'        => 'release_grid_padding',
					'label'     => esc_html__( 'Padding (for grid display)', 'decibel' ),
					'type'      => 'select',
					'choices'   => array(
						'yes' => esc_html__( 'Yes', 'decibel' ),
						'no'  => esc_html__( 'No', 'decibel' ),
					),
					'transport' => 'postMessage',
				),

				'release_pagination'   => array(
					'id'          => 'release_pagination',
					'label'       => esc_html__( 'Discography Archive Pagination', 'decibel' ),
					'type'        => 'select',
					'choices'     => array(
						'none'                => esc_html__( 'None', 'decibel' ),
						'standard_pagination' => esc_html__( 'Numeric Pagination', 'decibel' ),
						'load_more'           => esc_html__( 'Load More Button', 'decibel' ),
					),
					'description' => esc_html__( 'You must set a number of posts per page below. The category filter will not be disabled.', 'decibel' ),
				),

				'releases_per_page'    => array(
					'label'       => esc_html__( 'Releases per Page', 'decibel' ),
					'id'          => 'releases_per_page',
					'type'        => 'text',
					'placeholder' => 6,
				),
			),
		);
	}

	return $mods;

}
add_filter( 'decibel_customizer_mods', 'decibel_set_release_mods' );
