<?php
/**
 * Decibel events
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Events mods
 *
 * @param array $mods Array of mods.
 * @return array
 */
function decibel_set_event_mods( $mods ) {

	if ( class_exists( 'Wolf_Events' ) ) {
		$mods['wolf_events'] = array(
			'priority' => 45,
			'id'       => 'wolf_events',
			'title'    => esc_html__( 'Events', 'decibel' ),
			'icon'     => 'calendar-alt',
			'options'  => array(

				'event_layout'       => array(
					'id'          => 'event_layout',
					'label'       => esc_html__( 'Layout', 'decibel' ),
					'type'        => 'select',
					'choices'     => array(
						'standard'      => esc_html__( 'Standard', 'decibel' ),
						'fullwidth'     => esc_html__( 'Full width', 'decibel' ),
						'sidebar-right' => esc_html__( 'Sidebar at right', 'decibel' ),
						'sidebar-left'  => esc_html__( 'Sidebar at left', 'decibel' ),
					),
					'transport'   => 'postMessage',
					'description' => esc_html__( 'For "Sidebar" layouts, the sidebar will be visible if it contains widgets.', 'decibel' ),
				),

				'event_display'      => array(
					'id'      => 'event_display',
					'label'   => esc_html__( 'Display', 'decibel' ),
					'type'    => 'select',
					'choices' => apply_filters(
						'decibel_list_display_options',
						array(
							'list' => esc_html__( 'List', 'decibel' ),
						)
					),
				),

				'event_grid_padding' => array(
					'id'        => 'event_grid_padding',
					'label'     => esc_html__( 'Padding', 'decibel' ),
					'type'      => 'select',
					'choices'   => array(
						'yes' => esc_html__( 'Yes', 'decibel' ),
						'no'  => esc_html__( 'No', 'decibel' ),
					),
					'transport' => 'postMessage',
				),
			),
		);
	}

	return $mods;

}
add_filter( 'decibel_customizer_mods', 'decibel_set_event_mods' );
