<?php
/**
 * Decibel extra
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Extra mods
 *
 * @param array $mods Array of mods.
 * @return array
 */
function decibel_set_extra_mods( $mods ) {

	$mods['extra'] = array(

		'id'      => 'extra',
		'title'   => esc_html__( 'Extra', 'decibel' ),
		'icon'    => 'plus-alt',
		'options' => array(
			array(
				'label' => esc_html__( 'Enable Scroll Animations on Mobile (not recommended)', 'decibel' ),
				'id'    => 'enable_mobile_animations',
				'type'  => 'checkbox',
			),
			array(
				'label' => esc_html__( 'Enable Parallax on Mobile (not recommended)', 'decibel' ),
				'id'    => 'enable_mobile_parallax',
				'type'  => 'checkbox',
			),
		),
	);
	return $mods;
}
add_filter( 'decibel_customizer_mods', 'decibel_set_extra_mods' );
