<?php
/**
 * Decibel customizer font mods
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Font mods
 *
 * @param array $mods Array of mods.
 * @return array
 */
function decibel_set_font_mods( $mods ) {

	$mods['fonts'] = array(
		'id'      => 'fonts',
		'title'   => esc_html__( 'Fonts', 'decibel' ),
		'icon'    => 'editor-textcolor',
		'options' => array(),
	);

	if ( decibel_is_elementor_fonts_enabled() ) {

		$mods['fonts']['options']['no_font'] = array(
			'label'       => esc_html__( 'Theme Fonts Disabled', 'decibel' ),
			'id'          => 'no_font',
			'type'        => 'text_helper',
			'description' => sprintf(
				decibel_kses(
					__( 'Please disable the default fonts options in the <a href="%s" target="_blank">Elementor settings</a> to use the theme font options.', 'decibel' )
				),
				esc_url( admin_url( 'admin.php?page=elementor' ) )
			),
		);

		return $mods;
	}

	/**
	 * Get Google Fonts from Font loader
	 */
	$_fonts = apply_filters( 'decibel_mods_fonts', decibel_get_google_fonts_options() );

	$font_choices = array( 'default' => esc_html__( 'Default', 'decibel' ) );

	foreach ( $_fonts as $key => $value ) {
		$font_choices[ $key ] = $key;
	}

	$mods['fonts']['options']['body_font_name'] = array(
		'label'     => esc_html__( 'Body Font Name', 'decibel' ),
		'id'        => 'body_font_name',
		'type'      => 'select',
		'choices'   => $font_choices,
		'transport' => 'postMessage',
	);

	$mods['fonts']['options']['body_font_size'] = array(
		'label'       => esc_html__( 'Body Font Size', 'decibel' ),
		'id'          => 'body_font_size',
		'type'        => 'text',
		'transport'   => 'postMessage',
		'description' => esc_html__( 'Don\'t ommit px. Leave empty to use the default font size.', 'decibel' ),
	);

	/*************************Menu*/

	$mods['fonts']['options']['menu_font_name'] = array(
		'id'        => 'menu_font_name',
		'label'     => esc_html__( 'Menu Font', 'decibel' ),
		'type'      => 'select',
		'choices'   => $font_choices,
		'transport' => 'postMessage',
	);

	$mods['fonts']['options']['menu_font_weight'] = array(
		'label'     => esc_html__( 'Menu Font Weight', 'decibel' ),
		'id'        => 'menu_font_weight',
		'type'      => 'text',
		'transport' => 'postMessage',
	);

	$mods['fonts']['options']['menu_font_transform'] = array(
		'id'        => 'menu_font_transform',
		'label'     => esc_html__( 'Menu Font Transform', 'decibel' ),
		'type'      => 'select',
		'choices'   => array(
			'none'      => esc_html__( 'None', 'decibel' ),
			'uppercase' => esc_html__( 'Uppercase', 'decibel' ),
			'lowercase' => esc_html__( 'Lowercase', 'decibel' ),
		),
		'transport' => 'postMessage',
	);

	$mods['fonts']['options']['menu_font_letter_spacing'] = array(
		'label'     => esc_html__( 'Menu Letter Spacing (omit px)', 'decibel' ),
		'id'        => 'menu_font_letter_spacing',
		'type'      => 'int',
		'transport' => 'postMessage',
	);

	$mods['fonts']['options']['menu_font_style'] = array(
		'id'        => 'menu_font_style',
		'label'     => esc_html__( 'Menu Font Style', 'decibel' ),
		'type'      => 'select',
		'choices'   => array(
			'normal'  => esc_html__( 'Normal', 'decibel' ),
			'italic'  => esc_html__( 'Italic', 'decibel' ),
			'oblique' => esc_html__( 'Oblique', 'decibel' ),
		),
		'transport' => 'postMessage',
	);

	$mods['fonts']['options']['submenu_font_name'] = array(
		'id'        => 'submenu_font_name',
		'label'     => esc_html__( 'Submenu Font', 'decibel' ),
		'type'      => 'select',
		'choices'   => $font_choices,
		'transport' => 'postMessage',
	);

	$mods['fonts']['options']['submenu_font_weight'] = array(
		'label'     => esc_html__( 'Submenu Font Weight', 'decibel' ),
		'id'        => 'submenu_font_weight',
		'type'      => 'text',
		'transport' => 'postMessage',
	);

	$mods['fonts']['options']['submenu_font_transform'] = array(
		'id'        => 'submenu_font_transform',
		'label'     => esc_html__( 'Submenu Font Transform', 'decibel' ),
		'type'      => 'select',
		'choices'   => array(
			'none'      => esc_html__( 'None', 'decibel' ),
			'uppercase' => esc_html__( 'Uppercase', 'decibel' ),
			'lowercase' => esc_html__( 'Lowercase', 'decibel' ),
		),
		'transport' => 'postMessage',
	);

	$mods['fonts']['options']['submenu_font_style'] = array(
		'id'        => 'submenu_font_style',
		'label'     => esc_html__( 'Submenu Font Style', 'decibel' ),
		'type'      => 'select',
		'choices'   => array(
			'normal'  => esc_html__( 'Normal', 'decibel' ),
			'italic'  => esc_html__( 'Italic', 'decibel' ),
			'oblique' => esc_html__( 'Oblique', 'decibel' ),
		),
		'transport' => 'postMessage',
	);

	$mods['fonts']['options']['submenu_font_letter_spacing'] = array(
		'label'     => esc_html__( 'Submenu Letter Spacing (omit px)', 'decibel' ),
		'id'        => 'submenu_font_letter_spacing',
		'type'      => 'int',
		'transport' => 'postMessage',
	);

	/*************************Heading*/

	$mods['fonts']['options']['heading_font_name'] = array(
		'id'        => 'heading_font_name',
		'label'     => esc_html__( 'Heading Font', 'decibel' ),
		'type'      => 'select',
		'choices'   => $font_choices,
		'transport' => 'postMessage',
	);

	$mods['fonts']['options']['heading_font_weight'] = array(
		'label'       => esc_html__( 'Heading Font weight', 'decibel' ),
		'id'          => 'heading_font_weight',
		'type'        => 'text',
		'description' => esc_html__( 'For example: "400" is normal, "700" is bold.The available font weights depend on the font.', 'decibel' ),
		'transport'   => 'postMessage',
	);

	$mods['fonts']['options']['heading_font_transform'] = array(
		'id'        => 'heading_font_transform',
		'label'     => esc_html__( 'Heading Font Transform', 'decibel' ),
		'type'      => 'select',
		'choices'   => array(
			'none'      => esc_html__( 'None', 'decibel' ),
			'uppercase' => esc_html__( 'Uppercase', 'decibel' ),
			'lowercase' => esc_html__( 'Lowercase', 'decibel' ),
		),
		'transport' => 'postMessage',
	);

	$mods['fonts']['options']['heading_font_style'] = array(
		'id'        => 'heading_font_style',
		'label'     => esc_html__( 'Heading Font Style', 'decibel' ),
		'type'      => 'select',
		'choices'   => array(
			'normal'  => esc_html__( 'Normal', 'decibel' ),
			'italic'  => esc_html__( 'Italic', 'decibel' ),
			'oblique' => esc_html__( 'Oblique', 'decibel' ),
		),
		'transport' => 'postMessage',
	);

	$mods['fonts']['options']['heading_font_letter_spacing'] = array(
		'label'     => esc_html__( 'Heading Letter Spacing (omit px)', 'decibel' ),
		'id'        => 'heading_font_letter_spacing',
		'type'      => 'int',
		'transport' => 'postMessage',
	);

	return $mods;

}
add_filter( 'decibel_customizer_mods', 'decibel_set_font_mods', 10 );
