<?php
/**
 * Decibel footer_bg
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Footer background mods
 *
 * @param array $mods Array of mods.
 * @return array
 */
function decibel_set_footer_bg_mods( $mods ) {

	$mods['footer_bg'] = array(
		'id'         => 'footer_bg',
		'label'      => esc_html__( 'Footer Background', 'decibel' ),
		'background' => true,
		'font_color' => true,
		'icon'       => 'format-image',
	);

	return $mods;
}
add_filter( 'decibel_customizer_mods', 'decibel_set_footer_bg_mods' );
