<?php
/**
 * Decibel footer
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Footer mods
 *
 * @param array $mods Array of mods.
 * @return array
 */
function decibel_set_footer_mods( $mods ) {

	$mods['footer'] = array(

		'id'      => 'footer',
		'title'   => esc_html__( 'Footer', 'decibel' ),
		'icon'    => 'welcome-widgets-menus',
		'options' => array(

			'footer_type'    => array(
				'label'     => esc_html__( 'Footer Type', 'decibel' ),
				'id'        => 'footer_type',
				'type'      => 'select',
				'choices'   => array(
					'standard' => esc_html__( 'Standard', 'decibel' ),
					'uncover'  => esc_html__( 'Uncover', 'decibel' ),
					'hidden'   => esc_html__( 'No Footer', 'decibel' ),
				),
				'transport' => 'postMessage',
			),

			array(
				'label'     => esc_html__( 'Footer Width', 'decibel' ),
				'id'        => 'footer_layout',
				'type'      => 'select',
				'choices'   => array(
					'boxed' => esc_html__( 'Boxed', 'decibel' ),
					'wide'  => esc_html__( 'Wide', 'decibel' ),
				),
				'transport' => 'postMessage',
			),

			array(
				'label'     => esc_html__( 'Foot Widgets Layout', 'decibel' ),
				'id'        => 'footer_widgets_layout',
				'type'      => 'select',
				'choices'   => array(
					'3-cols'               => esc_html__( '3 Columns', 'decibel' ),
					'4-cols'               => esc_html__( '4 Columns', 'decibel' ),
					'one-half-two-quarter' => esc_html__( '1 Half/2 Quarters', 'decibel' ),
					'two-quarter-one-half' => esc_html__( '2 Quarters/1 Half', 'decibel' ),
				),
				'transport' => 'postMessage',
			),

			array(
				'label'     => esc_html__( 'Bottom Bar Layout', 'decibel' ),
				'id'        => 'bottom_bar_layout',
				'type'      => 'select',
				'choices'   => array(
					'centered' => esc_html__( 'Centered', 'decibel' ),
					'inline'   => esc_html__( 'Inline', 'decibel' ),
				),
				'transport' => 'postMessage',
			),

			'footer_socials' => array(
				'id'          => 'footer_socials',
				'label'       => esc_html__( 'Socials', 'decibel' ),
				'type'        => 'text',
				'description' => esc_html__( 'The list of social services to display in the bottom bar. (eg: facebook,twitter,instagram)', 'decibel' ),
			),

			'copyright'      => array(
				'id'    => 'copyright',
				'label' => esc_html__( 'Copyright Text', 'decibel' ),
				'type'  => 'text',
			),
		),
	);

	if ( class_exists( 'Wolf_Vc_Content_Block' ) ) {
		$mods['footer']['options']['footer_type']['description'] = sprintf(
			decibel_kses(
				__( 'This is the default footer settings. You can leave the fields below empty and use a <a href="%s" target="_blank">content block</a> instead for more flexibility. See the customizer "Layout" tab or the page options below your text editor.', 'decibel' )
			),
			'http://wlfthm.es/content-blocks'
		);
	}

	return $mods;
}
add_filter( 'decibel_customizer_mods', 'decibel_set_footer_mods' );
