<?php
/**
 * Decibel header_image
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Header image mods
 *
 * @param array $mods Array of mods.
 * @return array
 */
function decibel_set_header_image_mods( $mods ) {

	/* Move header image setting here and rename the section title */
	$mods['header_image'] = array(
		'id'      => 'header_image',
		'title'   => esc_html__( 'Header Image', 'decibel' ),
		'icon'    => 'format-image',
		'options' => array(),
	);

	return $mods;
}
add_filter( 'decibel_customizer_mods', 'decibel_set_header_image_mods' );
