<?php
/**
 * Decibel header_settings
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

function decibel_set_header_settings_mods( $mods ) {

	$mods['header_settings'] = array(

		'id'      => 'header_settings',
		'title'   => esc_html__( 'Header Layout', 'decibel' ),
		'icon'    => 'editor-table',
		'options' => array(

			'hero_layout'            => array(
				'label'     => esc_html__( 'Page Header Layout', 'decibel' ),
				'id'        => 'hero_layout',
				'type'      => 'select',
				'choices'   => array(
					'standard'   => esc_html__( 'Standard', 'decibel' ),
					'big'        => esc_html__( 'Big', 'decibel' ),
					'small'      => esc_html__( 'Small', 'decibel' ),
					'fullheight' => esc_html__( 'Full Height', 'decibel' ),
					'none'       => esc_html__( 'No header', 'decibel' ),
				),
				'transport' => 'postMessage',
			),

			'hero_background_effect' => array(
				'id'      => 'hero_background_effect',
				'label'   => esc_html__( 'Header Image Effect', 'decibel' ),
				'type'    => 'select',
				'choices' => array(
					'parallax' => esc_html__( 'Parallax', 'decibel' ),
					'zoomin'   => esc_html__( 'Zoom', 'decibel' ),
					'none'     => esc_html__( 'None', 'decibel' ),
				),
			),

			'hero_scrolldown_arrow'  => array(
				'id'      => 'hero_scrolldown_arrow',
				'label'   => esc_html__( 'Scroll Down arrow', 'decibel' ),
				'type'    => 'select',
				'choices' => array(
					'yes' => esc_html__( 'Yes', 'decibel' ),
					''    => esc_html__( 'No', 'decibel' ),
				),
			),

			array(
				'label'   => esc_html__( 'Header Overlay', 'decibel' ),
				'id'      => 'hero_overlay',
				'type'    => 'select',
				'choices' => array(
					''       => esc_html__( 'Default', 'decibel' ),
					'custom' => esc_html__( 'Custom', 'decibel' ),
					'none'   => esc_html__( 'None', 'decibel' ),
				),
			),

			array(
				'label' => esc_html__( 'Overlay Color', 'decibel' ),
				'id'    => 'hero_overlay_color',
				'type'  => 'color',
				'value' => '#000000',
			),

			array(
				'label' => esc_html__( 'Overlay Opacity (in percent)', 'decibel' ),
				'id'    => 'hero_overlay_opacity',
				'desc'  => esc_html__( 'Adapt the header overlay opacity if needed', 'decibel' ),
				'type'  => 'text',
				'value' => 40,
			),
		),
	);

	if ( class_exists( 'Wolf_Vc_Content_Block' ) ) {
		$mods['header_settings']['options']['hero_layout']['description'] = sprintf(
			decibel_kses(
				__( 'The header can be overwritten by a <a href="%s" target="_blank">content block</a> on all pages or on specific pages. See the customizer "Layout" tab or the page options below your text editor.', 'decibel' )
			),
			'http://wlfthm.es/content-blocks'
		);
	}

	return $mods;
}
add_filter( 'decibel_customizer_mods', 'decibel_set_header_settings_mods' );
