<?php
/**
 * Decibel layout
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Site layout mods
 *
 * @param array $mods Array of mods.
 * @return array
 */
function decibel_set_layout_mods( $mods ) {

	$mods['layout'] = array(

		'id'      => 'layout',
		'title'   => esc_html__( 'Layout', 'decibel' ),
		'icon'    => 'layout',
		'options' => array(

			'site_layout'  => array(
				'id'        => 'site_layout',
				'label'     => esc_html__( 'General', 'decibel' ),
				'type'      => 'radio_images',
				'default'   => 'wide',
				'choices'   => array(
					array(
						'key'   => 'wide',
						'image' => get_parent_theme_file_uri( 'assets/img/customizer/site-layout/wide.png' ),
						'text'  => esc_html__( 'Wide', 'decibel' ),
					),

					array(
						'key'   => 'boxed',
						'image' => get_parent_theme_file_uri( 'assets/img/customizer/site-layout/boxed.png' ),
						'text'  => esc_html__( 'Boxed', 'decibel' ),
					),

					array(
						'key'   => 'frame',
						'image' => get_parent_theme_file_uri( 'assets/img/customizer/site-layout/frame.png' ),
						'text'  => esc_html__( 'Frame', 'decibel' ),
					),
				),
				'transport' => 'postMessage',
			),

			'button_style' => array(
				'id'        => 'button_style',
				'label'     => esc_html__( 'Button Shape', 'decibel' ),
				'type'      => 'select',
				'choices'   => array(
					'standard' => esc_html__( 'Standard', 'decibel' ),
					'square'   => esc_html__( 'Square', 'decibel' ),
					'round'    => esc_html__( 'Round', 'decibel' ),
				),
				'transport' => 'postMessage',
			),
		),
	);

	if ( class_exists( 'Wolf_Vc_Content_Block' ) || class_exists( 'Wolf_Core' ) ) {

		$content_block_post_slug = ( class_exists( 'Wolf_Core' ) ) ? 'wolf_content_block' : 'wvc_content_block';

		$content_block_posts = get_posts( 'post_type="' . $content_block_post_slug . '"&numberposts=-1' );

		$content_blocks = array( '' => esc_html__( 'None', 'decibel' ) );
		if ( $content_block_posts ) {
			foreach ( $content_block_posts as $content_block_options ) {
				$content_blocks[ $content_block_options->ID ] = $content_block_options->post_title;
			}
		} else {
			$content_blocks[0] = esc_html__( 'No Content Block Yet', 'decibel' );
		}

		/*
		$mods['layout']['options']['top_bar_block_id'] = [
			'label'	=> esc_html__( 'Top Bar Block', 'decibel' ),
			'id'	=> 'top_bar_block_id',
			'type'	=> 'select',
			'choices' => $content_blocks,
			'description' => esc_html__( 'A block to display above the navigation.', 'decibel' ),
		);
		*/

		$mods['layout']['options']['after_header_block'] = array(
			'label'       => esc_html__( 'Post-header Block', 'decibel' ),
			'id'          => 'after_header_block',
			'type'        => 'select',
			'choices'     => $content_blocks,
			'description' => esc_html__( 'A block to display below to header or in replacement of the header.', 'decibel' ),
		);

		$mods['layout']['options']['before_footer_block'] = array(
			'label'       => esc_html__( 'Pre-footer Block', 'decibel' ),
			'id'          => 'before_footer_block',
			'type'        => 'select',
			'choices'     => $content_blocks,
			'description' => esc_html__( 'A block to display above to footer or in replacement of the footer.', 'decibel' ),
		);
	}

	return $mods;
}
add_filter( 'decibel_customizer_mods', 'decibel_set_layout_mods' );
