<?php
/**
 * Decibel loading
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Loading animation mods
 *
 * @param array $mods Array of mods.
 * @return array
 */
function decibel_set_loading_mods( $mods ) {

	$mods['loading'] = array(

		'id'      => 'loading',
		'title'   => esc_html__( 'Loading', 'decibel' ),
		'icon'    => 'update',
		'options' => array(

			array(
				'label'   => esc_html__( 'Loading Animation Type', 'decibel' ),
				'id'      => 'loading_animation_type',
				'type'    => 'select',
				'choices' => array(
					'spinner' => esc_html__( 'Spinner', 'decibel' ),
					'none'    => esc_html__( 'None', 'decibel' ),
				),
			),
		),
	);
	return $mods;
}
add_filter( 'decibel_customizer_mods', 'decibel_set_loading_mods' );
