<?php
/**
 * Decibel navigation
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Navigation mods
 *
 * @param array $mods Array of mods.
 * @return array
 */
function decibel_set_navigation_mods( $mods ) {

	$mods['navigation'] = array(
		'id'      => 'navigation',
		'icon'    => 'menu',
		'title'   => esc_html__( 'Navigation', 'decibel' ),
		'options' => array(

			'menu_layout'           => array(
				'id'      => 'menu_layout',
				'label'   => esc_html__( 'Main Menu Layout', 'decibel' ),
				'type'    => 'select',
				'default' => 'top-justify',
				'choices' => array(
					'top-right'        => esc_html__( 'Top Right', 'decibel' ),
					'top-justify'      => esc_html__( 'Top Justify', 'decibel' ),
					'top-justify-left' => esc_html__( 'Top Justify Left', 'decibel' ),
					'centered-logo'    => esc_html__( 'Centered', 'decibel' ),
					'top-left'         => esc_html__( 'Top Left', 'decibel' ),
					'offcanvas'        => esc_html__( 'Off Canvas', 'decibel' ),
					'overlay'          => esc_html__( 'Overlay', 'decibel' ),
					'lateral'          => esc_html__( 'Lateral', 'decibel' ),
				),
			),

			'menu_width'            => array(
				'id'        => 'menu_width',
				'label'     => esc_html__( 'Main Menu Width', 'decibel' ),
				'type'      => 'select',
				'choices'   => array(
					'wide'  => esc_html__( 'Wide', 'decibel' ),
					'boxed' => esc_html__( 'Boxed', 'decibel' ),
				),
				'transport' => 'postMessage',
			),

			'menu_style'            => array(
				'id'        => 'menu_style',
				'label'     => esc_html__( 'Main Menu Style', 'decibel' ),
				'type'      => 'select',
				'choices'   => array(
					'semi-transparent-white' => esc_html__( 'Semi-transparent White', 'decibel' ),
					'semi-transparent-black' => esc_html__( 'Semi-transparent Black', 'decibel' ),
					'solid'                  => esc_html__( 'Solid', 'decibel' ),
					'transparent'            => esc_html__( 'Transparent', 'decibel' ),
				),
				'transport' => 'postMessage',
			),

			'menu_hover_style'      => array(
				'id'        => 'menu_hover_style',
				'label'     => esc_html__( 'Main Menu Hover Style', 'decibel' ),
				'type'      => 'select',
				'choices'   => apply_filters(
					'decibel_main_menu_hover_style_options',
					array(
						'none'               => esc_html__( 'None', 'decibel' ),
						'opacity'            => esc_html__( 'Opacity', 'decibel' ),
						'underline'          => esc_html__( 'Underline', 'decibel' ),
						'underline-centered' => esc_html__( 'Underline Centered', 'decibel' ),
						'border-top'         => esc_html__( 'Border Top', 'decibel' ),
						'plain'              => esc_html__( 'Plain', 'decibel' ),
					)
				),
				'transport' => 'postMessage',
			),

			'mega_menu_width'       => array(
				'id'        => 'mega_menu_width',
				'label'     => esc_html__( 'Mega Menu Width', 'decibel' ),
				'type'      => 'select',
				'choices'   => array(
					'boxed'     => esc_html__( 'Boxed', 'decibel' ),
					'wide'      => esc_html__( 'Wide', 'decibel' ),
					'fullwidth' => esc_html__( 'Full Width', 'decibel' ),
				),
				'transport' => 'postMessage',
			),

			'menu_breakpoint'       => array(
				'id'          => 'menu_breakpoint',
				'label'       => esc_html__( 'Main Menu Breakpoint', 'decibel' ),
				'type'        => 'text',
				'description' => esc_html__( 'Below each width would you like to display the mobile menu? 0 will always show the desktop menu and 99999 will always show the mobile menu.', 'decibel' ),
			),

			'menu_sticky_type'      => array(
				'id'        => 'menu_sticky_type',
				'label'     => esc_html__( 'Sticky Menu', 'decibel' ),
				'type'      => 'select',
				'choices'   => array(
					'none' => esc_html__( 'Disabled', 'decibel' ),
					'soft' => esc_html__( 'Sticky on scroll up', 'decibel' ),
					'hard' => esc_html__( 'Always sticky', 'decibel' ),
				),
				'transport' => 'postMessage',
			),

			'menu_skin'             => array(
				'id'          => 'menu_skin',
				'label'       => esc_html__( 'Menu Skin', 'decibel' ),
				'type'        => 'select',
				'choices'     => array(
					'light' => esc_html__( 'Light', 'decibel' ),
					'dark'  => esc_html__( 'Dark', 'decibel' ),
				),
				'transport'   => 'postMessage',
				'description' => esc_html__( 'Can be overwite on single page.', 'decibel' ),
			),

			'menu_cta_content_type' => array(
				'id'      => 'menu_cta_content_type',
				'label'   => esc_html__( 'Additional Content', 'decibel' ),
				'type'    => 'select',
				'default' => 'icons',
				'choices' => apply_filters(
					'decibel_menu_cta_content_type_options',
					array(
						'search_icon'    => esc_html__( 'Search Icon', 'decibel' ),
						'secondary-menu' => esc_html__( 'Secondary Menu', 'decibel' ),
						'none'           => esc_html__( 'None', 'decibel' ),
					)
				),
			),
		),
	);

	$mods['navigation']['options']['menu_socials'] = array(
		'id'          => 'menu_socials',
		'label'       => esc_html__( 'Menu Socials', 'decibel' ),
		'type'        => 'text',
		'description' => esc_html__( 'The list of social services to display in the menu. (eg: facebook,twitter,instagram)', 'decibel' ),
	);

	$mods['navigation']['options']['side_panel_position'] = array(
		'id'          => 'side_panel_position',
		'label'       => esc_html__( 'Side Panel', 'decibel' ),
		'type'        => 'select',
		'choices'     => array(
			'none'  => esc_html__( 'None', 'decibel' ),
			'right' => esc_html__( 'At Right', 'decibel' ),
			'left'  => esc_html__( 'At Left', 'decibel' ),
		),
		'description' => esc_html__( 'Note that it will be disable with a vertical menu layout (offcanvas and lateral layout).', 'decibel' ),
	);

	return $mods;
}
add_filter( 'decibel_customizer_mods', 'decibel_set_navigation_mods' );
