<?php
/**
 * Decibel videos
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Video mods
 *
 * @param array $mods Array of mods.
 * @return array
 */
function decibel_set_video_mods( $mods ) {

	if ( class_exists( 'Wolf_Videos' ) ) {
		$mods['wolf_videos'] = array(
			'id'      => 'wolf_videos',
			'title'   => esc_html__( 'Videos', 'decibel' ),
			'icon'    => 'editor-video',
			'options' => array(

				'video_layout'         => array(
					'id'          => 'video_layout',
					'label'       => esc_html__( 'Layout', 'decibel' ),
					'type'        => 'select',
					'choices'     => array(
						'standard'      => esc_html__( 'Standard', 'decibel' ),
						'fullwidth'     => esc_html__( 'Full width', 'decibel' ),
						'sidebar-right' => esc_html__( 'Sidebar at right', 'decibel' ),
						'sidebar-left'  => esc_html__( 'Sidebar at left', 'decibel' ),
					),
					'description' => esc_html__( 'For "Sidebar" layouts, the sidebar will be visible if it contains widgets.', 'decibel' ),
				),

				'video_grid_padding'   => array(
					'id'        => 'video_grid_padding',
					'label'     => esc_html__( 'Padding', 'decibel' ),
					'type'      => 'select',
					'choices'   => array(
						'yes' => esc_html__( 'Yes', 'decibel' ),
						'no'  => esc_html__( 'No', 'decibel' ),
					),
					'transport' => 'postMessage',
				),

				'video_display'        => array(
					'id'      => 'video_display',
					'label'   => esc_html__( 'Display', 'decibel' ),
					'type'    => 'select',
					'choices' => apply_filters(
						'decibel_video_display_options',
						array(
							'grid' => esc_html__( 'Grid', 'decibel' ),
						)
					),
				),

				'video_item_animation' => array(
					'label'   => esc_html__( 'Video Archive Item Animation', 'decibel' ),
					'id'      => 'video_item_animation',
					'type'    => 'select',
					'choices' => decibel_get_animations(),
				),

				'video_onclick'        => array(
					'label'   => esc_html__( 'On Click', 'decibel' ),
					'id'      => 'video_onclick',
					'type'    => 'select',
					'choices' => apply_filters(
						'decibel_video_onclick',
						array(
							'lightbox' => esc_html__( 'Open Video in Lightbox', 'decibel' ),
							'default'  => esc_html__( 'Go to the Video Page', 'decibel' ),
						)
					),
				),

				'video_pagination'     => array(
					'id'          => 'video_pagination',
					'label'       => esc_html__( 'Video Archive Pagination', 'decibel' ),
					'type'        => 'select',
					'choices'     => array(
						'none'                => esc_html__( 'None', 'decibel' ),
						'standard_pagination' => esc_html__( 'Numeric Pagination', 'decibel' ),
						'load_more'           => esc_html__( 'Load More Button', 'decibel' ),
					),
					'description' => esc_html__( 'You must set a number of posts per page below. The category filter will not be disabled.', 'decibel' ),
				),

				'videos_per_page'      => array(
					'label'       => esc_html__( 'Videos per Page', 'decibel' ),
					'id'          => 'videos_per_page',
					'type'        => 'text',
					'placeholder' => 6,
				),

				'video_single_layout'  => array(
					'id'      => 'video_single_layout',
					'label'   => esc_html__( 'Single Post Layout', 'decibel' ),
					'type'    => 'select',
					'choices' => array(
						'sidebar-right' => esc_html__( 'Sidebar Right', 'decibel' ),
						'sidebar-left'  => esc_html__( 'Sidebar Left', 'decibel' ),
						'no-sidebar'    => esc_html__( 'No Sidebar', 'decibel' ),
						'fullwidth'     => esc_html__( 'Full width', 'decibel' ),
					),
				),

				/*
				'video_columns' => [
					'id' => 'video_columns',
					'label' => esc_html__( 'Columns', 'decibel' ),
					'type' => 'select',
					'choices' => [
						3 => 3,
						2 => 2,
						4 => 4,
						5 => 5,
						6 => 6,
					),
					'transport' => 'postMessage',
				),*/
			),
		);
	}

	return $mods;
}
add_filter( 'decibel_customizer_mods', 'decibel_set_video_mods' );
