<?php
/**
 * Decibel Page Builder
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * WPBAkery Page Builder Extension plugin mods
 *
 * @param array $mods Array of mods.
 * @return array
 */
function decibel_set_wvc_mods( $mods ) {

	if ( class_exists( 'Wolf_Visual_Composer' ) ) {
		$mods['blog']['options']['newsletter'] = array(
			'id'          => 'newsletter_form_single_blog_post',
			'label'       => esc_html__( 'Add newsletter form below single post', 'decibel' ),
			'type'        => 'checkbox',
			'description' => esc_html__( 'Display a newsletter sign up form at the bottom of each blog post.', 'decibel' ),
		);

	}

	if ( class_exists( 'Wolf_Core' ) ) {
		$mods['blog']['options']['newsletter'] = array(
			'id'          => 'newsletter_form_single_blog_post',
			'label'       => esc_html__( 'Add newsletter form below single post', 'decibel' ),
			'type'        => 'checkbox',
			'description' => esc_html__( 'Display a newsletter sign up form at the bottom of each blog post.', 'decibel' ),
		);

	}

	return $mods;
}
add_filter( 'decibel_customizer_mods', 'decibel_set_wvc_mods' );
