<?php
/**
 * Decibel Frontend Scripts
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/**
 * Remove plugin scripts
 * Allow an easier customization
 */
function decibel_dequeue_plugin_scripts() {
	wp_dequeue_script( 'wolf-portfolio' );
	wp_dequeue_script( 'wolf-videos' );
	wp_dequeue_script( 'wolf-albums' );
	wp_dequeue_script( 'wolf-discography' );
}
add_action( 'wp_enqueue_scripts', 'decibel_dequeue_plugin_scripts' );

/**
 * Register scripts
 *
 * @param array $scripts The scripts to register.
 */
function decibel_register_scripts( $scripts = array() ) {

	$theme_version = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? time() : decibel_get_theme_version();

	foreach ( $scripts as $handle => $properties ) {
		$src          = esc_url( $properties['src'] );
		$dependencies = ( isset( $properties['dependencies'] ) ) ? $properties['dependencies'] : array( 'jquery' );
		$version      = ( isset( $properties['version'] ) ) ? $properties['version'] : $theme_version;
		$in_footer    = ( isset( $properties['in_footer'] ) ) ? $properties['in_footer'] : true;

		wp_register_script( $handle, $src, $dependencies, $version, $in_footer );
	}
}

/**
 * JS params
 */
function decibel_get_theme_js_params() {
	return apply_filters(
		'decibel_js_params',
		array(
			'defaultPageLoadingAnimation'    => apply_filters( 'decibel_default_page_loading_animation', true ),
			'defaultPageTransitionAnimation' => apply_filters( 'decibel_default_page_transition_animation', true ),
			'siteUrl'                        => esc_url( site_url( '/' ) ),
			'homeUrl'                        => esc_url( home_url( '/' ) ),
			'ajaxUrl'                        => esc_url( admin_url( 'admin-ajax.php' ) ),
			'ajaxNonce'                      => wp_create_nonce( 'decibel_ajax_nonce' ),
			'themeUrl'                       => esc_url( get_template_directory_uri() ),
			'isUserLoggedIn'                 => is_user_logged_in(),
			'isMobile'                       => wp_is_mobile(),
			'isPostTypeArchive'              => decibel_is_post_type_archive(),
			'isPage'                         => is_page(),
			'themeSlug'                      => decibel_get_theme_slug(),
			'accentColor'                    => decibel_get_inherit_mod( 'accent_color', '#007acc' ),
			'breakPoint'                     => apply_filters( 'decibel_menu_breakpoint', decibel_get_inherit_mod( 'menu_breakpoint', 1100 ) ),
			'menuLayout'                     => decibel_get_inherit_mod( 'menu_layout' ),
			'menuSkin'                       => decibel_get_inherit_mod( 'menu_skin' ),
			'menuOffset'                     => apply_filters( 'decibel_menu_offset', decibel_get_inherit_mod( 'menu_offset', 0 ) ),
			'menuHoverStyle'                 => decibel_get_inherit_mod( 'menu_hover_style', 'opacity' ),
			'subMenuWidth'                   => apply_filters( 'decibel_submenu_width', 230 ),
			'stickyMenuType'                 => decibel_get_inherit_mod( 'menu_sticky_type', 'soft' ),
			'stickyMenuScrollPoint'          => apply_filters( 'decibel_sticky_menu_scrollpoint', 0 ), // ??
			'stickyMenuHeight'               => apply_filters( 'decibel_sticky_menu_height', 60 ),
			'desktopMenuHeight'              => apply_filters( 'decibel_desktop_menu_height', 80 ),

			'mobileScreenBreakpoint'         => apply_filters( 'decibel_mobile_screen_breakpoint', 499 ),
			'tabletScreenBreakpoint'         => apply_filters( 'decibel_tablet_screen_breakpoint', 768 ),
			'notebookScreenBreakpoint'       => apply_filters( 'decibel_notebook_screen_breakpoint', 1024 ),
			'desktopScreenBreakpoint'        => apply_filters( 'decibel_desktop_screen_breakpoint', 1224 ),
			'desktopBigScreenBreakpoint'     => apply_filters( 'decibel_desktop_big_screen_breakpoint', 1350 ),

			'isWolfCore'                     => class_exists( 'Wolf_Core' ),
			'pageBuilder'                    => decibel_get_plugin_in_use(),

			'lightbox'                       => apply_filters( 'decibel_lightbox', decibel_get_inherit_mod( 'lightbox', 'fancybox' ) ),
			'WOWAnimationOffset'             => apply_filters( 'decibel_wow_animation_offset', 0 ),
			'fullPageAnimation'              => decibel_do_fullpage(),
			'forceAnimationMobile'           => apply_filters( 'decibel_force_animation_mobile', false ),
			'parallaxNoIos'                  => apply_filters( 'decibel_parallax_no_ios', true ),
			'parallaxNoAndroid'              => apply_filters( 'decibel_parallax_no_android', true ),
			'parallaxNoSmallScreen'          => apply_filters( 'decibel_parallax_no_small_screen', true ),
			'portfolioSidebarOffsetTop'      => ( 'soft' === decibel_get_inherit_mod( 'menu_sticky_type', 'soft' ) || 'hard' === decibel_get_inherit_mod( 'menu_sticky_type', 'soft' ) ) ? apply_filters( 'decibel_sticky_menu_height', 60 ) : 0,
			'isWooCommerce'                  => function_exists( 'WC' ),
			'WooCommerceCartUrl'             => ( function_exists( 'wc_get_cart_url' ) ) ? wc_get_cart_url() : '',
			'WooCommerceCheckoutUrl'         => ( function_exists( 'wc_get_checkout_url' ) ) ? wc_get_checkout_url() : '',
			'WooCommerceAccountUrl'          => ( function_exists( 'WC' ) ) ? get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) : '',
			'isWooCommerceVariationSwatches' => defined( 'TAWC_VS_PLUGIN_FILE' ),
			'relatedProductCount'            => apply_filters( 'decibel_related_products_count', 4 ),
			'doWoocommerceLightbox'          => ( 'no' === get_option( 'woocommerce_enable_lightbox' ) ),
			'doVideoLightbox'                => ( 'yes' === decibel_get_inherit_mod( 'videos_lightbox' ) ),
			'doLiveSearch'                   => apply_filters( 'decibel_live_search', true ),
			'doLoadMorePaginationHashChange' => apply_filters( 'decibel_loadmore_pagination_hashchange', true ),
			'smoothScrollSpeed'              => apply_filters( 'decibel_smooth_scroll_speed', 1000 ),
			'smoothScrollEase'               => apply_filters( 'decibel_smooth_scroll_ease', 'swing' ),
			'infiniteScrollEmptyLoad'        => get_template_directory_uri() . '/assets/img/blank.gif',
			'infiniteScrollGif'              => apply_filters( 'decibel_infinite_scroll_loading_gif_url', get_template_directory_uri() . '/assets/img/loading.gif' ),
			'isCustomizer'                   => decibel_is_customizer(),
			'isAjaxNav'                      => decibel_do_ajax_nav(),
			'ajaxNavigateToggleClass'        => apply_filters(
				'decibel_ajax_navigate_toggle_class',
				array(
					'mobile-menu-toggle',
					'side-panel-toggle',
					'search-form-toggle',
					'overlay-menu-toggle',
					'offcanvas-menu-toggle',
					'lateral-menu-toggle',
				)
			),
			'pageLoadingAnimationType'       => decibel_get_inherit_mod( 'loading_animation_type', 'none' ),
			'hasLoadingOverlay'              => apply_filters( 'decibel_display_overlay', 'none' !== decibel_get_inherit_mod( 'loading_animation_type', 'none' ) ),
			'pageLoadedDelay'                => apply_filters( 'decibel_page_loaded_delay', 1000 ),
			'pageTransitionDelayBefore'      => apply_filters( 'decibel_page_transition_delay_before', 0 ),
			'pageTransitionDelayAfter'       => apply_filters( 'decibel_page_transition_delay_after', 0 ),
			'mediaelementLegacyCssUri'       => includes_url( 'js/mediaelement/mediaelementplayer-legacy.min.css' ),
			'fancyboxMediaelementCssUri'     => get_template_directory_uri() . '/assets/css/fancybox-mediaelement.min.css',
			'fancyboxSettings'               => apply_filters(
				'decibel_fancybox_settings',
				array(
					'loop'             => true,
					'transitionEffect' => 'slide',
					'wheel'            => false,
					'hideScrollbar'    => false,
					'buttons'          => array(
						'slideShow',
						'fullScreen',
						'thumbs',
						'close',
					),
				)
			),
			'entrySliderAnimation'           => apply_filters( 'decibel_entry_slider_animation', 'fade' ),
			'is404'                          => is_404(),
			'isUserLoggedIn'                 => is_user_logged_in(),
			'allowedMimeTypes'               => array_keys( get_allowed_mime_types() ),
			'logoMarkup'                     => decibel_logo( false ),
			'language'                       => get_locale(),
			'l10n'                           => array(
				'chooseImage'               => esc_html__( 'Choose an image', 'decibel' ),
				'useImage'                  => esc_html__( 'Use image', 'decibel' ),
				'replyTitle'                => esc_html__( 'Post a comment', 'decibel' ),
				'editPost'                  => esc_html__( 'Edit Post', 'decibel' ),
				'infiniteScrollMsg'         => esc_html__( 'Loading', 'decibel' ) . '<span class="load-more-hellip">.</span><span class="load-more-hellip">.</span><span class="load-more-hellip">.</span>',
				'infiniteScrollEndMsg'      => esc_html__( 'No more post to load', 'decibel' ),
				'loadMoreMsg'               => apply_filters( 'decibel_load_more_posts_text', esc_html__( 'Load More', 'decibel' ) ),
				'infiniteScrollDisabledMsg' => esc_html__( 'The infinitescroll is disabled in live preview mode', 'decibel' ),
				'addToCart'                 => esc_html__( 'Add to cart', 'decibel' ),
				'viewCart'                  => esc_html__( 'View cart', 'decibel' ),
				'addedToCart'               => esc_html__( 'Added to cart', 'decibel' ),
				'playText'                  => esc_html__( 'Play', 'decibel' ),
				'pauseText'                 => esc_html__( 'Pause', 'decibel' ),
			),
		)
	);
}

/**
 * Returns script sto register
 */
function decibel_get_register_scripts() {

	$suffix  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	$version = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? time() : decibel_get_theme_version();
	if ( defined( 'AUTOPTIMIZE_PLUGIN_DIR' ) ) {
		$suffix = '';
	}

	return apply_filters(
		'decibel_register_scripts',
		array(
			'infinitescroll'                     => array(
				'src'     => get_template_directory_uri() . '/assets/js/lib/jquery.infinitescroll.min.js',
				'version' => '2.0.0',
			),

			'jarallax'                           => array(
				'src'     => get_template_directory_uri() . '/assets/js/lib/jarallax.min.js',
				'version' => '1.8.0',
			),

			'aos'                                => array(
				'src'     => get_template_directory_uri() . '/assets/js/lib/aos.js',
				'version' => '2.0.0',
			),

			'vimeo-player'                       => array(
				'src'     => get_template_directory_uri() . '/assets/js/lib/player.min.js',
				'version' => '2.6.1',
			),

			'imagesloaded'                       => array(
				'src'     => get_template_directory_uri() . '/assets/js/lib/imagesloaded.pkgd.min.js',
				'version' => '4.1.4',
			),

			'isotope'                            => array(
				'src'     => get_template_directory_uri() . '/assets/js/lib/isotope.pkgd.min.js',
				'version' => '3.0.5',
			),

			'packery-mode'                       => array(
				'src'     => get_template_directory_uri() . '/assets/js/lib/packery-mode.pkgd.min.js',
				'version' => '2.0.1',
			),
			'flex-images'                        => array(
				'src'     => get_template_directory_uri() . '/assets/js/lib/jquery.flex-images.min.js',
				'version' => '1.0.4',
			),

			'flickity'                           => array(
				'src'     => get_template_directory_uri() . '/assets/js/lib/flickity.pkgd.min.js',
				'version' => '2.0.5',
			),

			'decibel-youtube-video-background' => array(
				'src' => get_template_directory_uri() . '/assets/js/YT-background' . $suffix . '.js',
			),

			'decibel-vimeo'                    => array(
				'src' => get_template_directory_uri() . '/assets/js/vimeo' . $suffix . '.js',
			),

			'decibel-masonry'                  => array(
				'src' => get_template_directory_uri() . '/assets/js/masonry' . $suffix . '.js',
			),

			'decibel-category-filter'          => array(
				'src' => get_template_directory_uri() . '/assets/js/category-filter' . $suffix . '.js',
			),

			'decibel-masonry'                  => array(
				'src' => get_template_directory_uri() . '/assets/js/masonry' . $suffix . '.js',
			),

			'decibel-carousels'                => array(
				'src' => get_template_directory_uri() . '/assets/js/carousels' . $suffix . '.js',
			),

			'decibel-loadposts'                => array(
				'src' => get_template_directory_uri() . '/assets/js/loadposts' . $suffix . '.js',
			),

			'decibel-one-page'                 => array(
				'src' => get_template_directory_uri() . '/assets/js/one-page' . $suffix . '.js',
			),

			'decibel-ajax-nav'                 => array(
				'src' => get_template_directory_uri() . '/assets/js/ajax-nav' . $suffix . '.js',
			),

			'decibel-elementor-editor'         => array(
				'src'        => get_template_directory_uri() . '/assets/js/elementor-editor' . $suffix . '.js',
				'dependency' => array( 'elementor-frontend' ),
			),
		)
	);
}

if ( ! function_exists( 'decibel_enqueue_scripts' ) ) {
	/**
	 * Register theme scripts for the theme
	 */
	function decibel_enqueue_scripts() {

		$suffix  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
		$version = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? time() : decibel_get_theme_version();
		if ( defined( 'AUTOPTIMIZE_PLUGIN_DIR' ) ) {
			$suffix = '';
		}

		$lightbox = apply_filters( 'decibel_lightbox', decibel_get_theme_mod( 'lightbox', 'fancybox' ) );

		/* Register conditional scripts */
		decibel_register_scripts( decibel_get_register_scripts() );
		wp_enqueue_script( 'wp-mediaelement' );
		wp_enqueue_script( 'jquery-migrate' );

		/**
		 * Enqueue main scripts
		 */
		wp_enqueue_script( 'js-cookie', get_template_directory_uri() . '/assets/js/lib/js.cookie.min.js', array( 'jquery' ), '2.1.4', true );
		wp_enqueue_script( 'flexslider', get_template_directory_uri() . '/assets/js/lib/jquery.flexslider.min.js', array( 'jquery' ), '2.6.3', true );

		if ( 'fancybox' === $lightbox ) {
			wp_enqueue_script( 'fancybox', get_template_directory_uri() . '/assets/js/lib/jquery.fancybox.min.js', array( 'jquery' ), '3.5.7', true );

		} elseif ( 'swipebox' === $lightbox ) {
			wp_enqueue_script( 'swipebox', get_template_directory_uri() . '/assets/js/lib/jquery.swipebox.min.js', array( 'jquery' ), '1.4.4', true );
		}
		wp_enqueue_script( 'lazyloadxt', get_template_directory_uri() . '/assets/js/lib/jquery.lazyloadxt.min.js', array( 'jquery' ), '1.1.0', true );
		wp_enqueue_script( 'sticky-kit', get_template_directory_uri() . '/assets/js/lib/sticky-kit.min.js', array( 'jquery' ), '1.1.3', true );
		wp_enqueue_script( 'wolftheme', get_template_directory_uri() . '/assets/js/functions' . $suffix . '.js', array( 'jquery' ), $version, true );
		wp_enqueue_script( 'tooltipsy', get_template_directory_uri() . '/assets/js/lib/tooltipsy.min.js', array( 'jquery' ), '1.0.0', true );

		/**
		 * Enqueue condition scripts
		 */
		if ( decibel_is_edge() ) {
			wp_enqueue_script( 'object-fit-images', get_template_directory_uri() . '/assets/lib/ofi.min.js', array(), '3.2.3', true );
		}

		/**
		 * Enqueuing scripts
		 */
		wp_enqueue_script( 'flexslider' );
		wp_enqueue_script( 'jarallax' );
		if ( decibel_is_wolf_extension_activated() ) {
			wp_enqueue_script( 'bigtext' );
			wp_enqueue_script( 'wvc-bigtext' );
			wp_enqueue_script( 'wolf-core-bigtext' );
		}

		if ( is_search() || is_singular( 'proof_gallery' ) ) {
			wp_enqueue_script( 'imagesloaded' );
			wp_enqueue_script( 'isotope' );
			wp_enqueue_script( 'decibel-masonry' );
		}

		if ( is_singular( 'work' ) ) {
		}

		if ( is_singular( 'artist' ) ) {
			wp_enqueue_script( 'jquery-ui-tabs', true );
		}

		if ( is_singular( 'product' ) ) {
			wp_enqueue_script( 'flickity' );
			wp_enqueue_script( 'decibel-carousels' );
		}

		if ( decibel_do_onepage_menu() || decibel_is_elementor_editor() ) {
			wp_enqueue_script( 'decibel-one-page' );
		}

		/**
		 * If AJAX navigation is enabled, we enqueued everything we may need from start
		 */
		if ( decibel_do_ajax_nav() ) {
			wp_enqueue_script( 'wp-mediaelement' );
			wp_enqueue_script( 'jarallax' );
			wp_enqueue_script( 'imagesloaded' );
			wp_enqueue_script( 'isotope' );
			wp_enqueue_script( 'packery-mode' );
			wp_enqueue_script( 'infinitescroll' );
			wp_enqueue_script( 'sticky-kit' );
			wp_enqueue_script( 'decibel-masonry' );
			wp_enqueue_script( 'decibel-infinitescroll' );
			wp_enqueue_script( 'decibel-loadposts' );
			wp_enqueue_script( 'decibel-category-filter' );
			wp_enqueue_script( 'decibel-carousels' );
			if ( class_exists( 'WooCommerce' ) ) {

				wp_enqueue_script( 'wc-single-product' );
				wp_enqueue_script( 'wc-add-to-cart-variation' );
				wp_enqueue_script( 'wc-jquery-ui-touchpunch', WC()->plugin_url() . '/assets/js/jquery-ui-touch-punch/jquery-ui-touch-punch' . $suffix . '.js', array( 'jquery-ui-slider' ), WC_VERSION, true );
				wp_enqueue_script( 'wc-price-slider', WC()->plugin_url() . '/assets/js/frontend/price-slider' . $suffix . '.js', array( 'jquery-ui-slider', 'wc-jquery-ui-touchpunch' ), WC_VERSION, true );
			}

			wp_enqueue_script( 'decibel-ajax-nav' );
			wp_enqueue_script( 'decibel-one-page' );
		}
		wp_localize_script(
			'wolftheme',
			'DecibelParams',
			decibel_get_theme_js_params()
		);
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}
	add_action( 'wp_enqueue_scripts', 'decibel_enqueue_scripts' );
} // end function check

/**
 * Enqueue Elementor preview needed scripts
 */
function decibel_enqueue_elementor_preview_scripts() {

	$scripts = array(
		'imagesloaded',
		'isotope',
		'packery-mode',
		'flex-images',
		'flickity',
		'decibel-functions',
		'decibel-masonry',
		'decibel-carousel',
		'decibel-category-filter',
		'decibel-elementor-editor',
	);

	foreach ( $scripts as $script ) {
		wp_enqueue_script( $script );
	}
}
add_action( 'elementor/preview/enqueue_scripts', 'decibel_enqueue_elementor_preview_scripts' );

/**
 * Force WWPBPBE to enqueue all scripts for AJAX
 *
 * Wolf WPBakery Page Builder Extension enqueue scripts conditionally. We need all scripts from start for AJAX navigation.
 * We set the wvc_force_enqueue_scripts filter to true right here if AJAX nav is enabled
 */
function decibel_wvc_force_enqueue_scripts() {

	if ( decibel_do_ajax_nav() ) {
		return true;
	}
}
add_filter( 'wvc_force_enqueue_scripts', 'decibel_wvc_force_enqueue_scripts' );

/**
 * Remove CSS and/or JS for Select2 used by WooCommerce.
 *
 * @link https://gist.github.com/Willem-Siebe/c6d798ccba249d5bf080.
 */
function decibel_dequeue_stylesandscripts_select2() {
	if ( class_exists( 'WooCommerce' ) && wp_is_mobile() ) {
		wp_dequeue_style( 'selectWoo' );
		wp_deregister_style( 'selectWoo' );

		wp_dequeue_script( 'selectWoo' );
		wp_deregister_script( 'selectWoo' );
	}
}
add_action( 'wp_enqueue_scripts', 'decibel_dequeue_stylesandscripts_select2', 100 );
