<?php
/**
 * Decibel frontend theme specific functions
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

/*
--------------------------------------------------------------------

	FONTS

----------------------------------------------------------------------
*/

/**
 * Add custom fonts
 *
 * @param  array $google_fonts array of Google fonts.
 * @return array
 */
function decibel_add_google_font( $google_fonts ) {

	$default_fonts = array(
		'Open Sans'        => 'Open+Sans:400,500,600,700,900',
		'Lato'             => 'Lato:400,500,600,700,900',
		'Montserrat'       => 'Montserrat:400,500,600,700,900',
		'Oswald'           => 'Oswald',
		'Special Elite'    => 'Special+Elite',
		'Playfair Display' => 'Playfair+Display:400,700',
	);

	foreach ( $default_fonts as $key => $value ) {
		if ( ! isset( $google_fonts[ $key ] ) ) {
			$google_fonts[ $key ] = $value;
		}
	}

	return $google_fonts;
}
add_filter( 'decibel_google_fonts', 'decibel_add_google_font' );

/**
 * Added selector to menu_selectors
 *
 * @param  array $selectors navigation items CSS selectors.
 * @return array $selectors
 */
function decibel_add_menu_selectors( $selectors ) {

	$selectors[] = '.category-filter ul li a';
	$selectors[] = '.cart-panel-buttons a';

	return $selectors;
}
add_filter( 'decibel_menu_selectors', 'decibel_add_menu_selectors' );
/**
 * Added selector to heading_family_selectors
 *
 * @param  array $selectors headings related CSS selectors.
 * @return array $selectors
 */
function decibel_add_heading_family_selectors( $selectors ) {

	$selectors[] = '.wvc-tabs-menu li a';
	$selectors[] = '.woocommerce-tabs ul.tabs li a';
	$selectors[] = '.wvc-process-number';
	$selectors[] = '.wvc-button';
	$selectors[] = '.wvc-svc-item-title';
	$selectors[] = '.button';
	$selectors[] = '.onsale, .category-label';
	$selectors[] = '.entry-post-grid_classic .sticky-post';
	$selectors[] = '.entry-post-metro .sticky-post';
	$selectors[] = 'input[type=submit], .wvc-mailchimp-submit';
	$selectors[] = '.nav-next,.nav-previous';
	$selectors[] = '.wvc-embed-video-play-button';
	// $selectors[] = '.category-filter ul li';
	$selectors[] = '.wvc-ati-title';
	$selectors[] = '.wvc-team-member-role';
	$selectors[] = '.wvc-svc-item-tagline';
	$selectors[] = '.entry-metro insta-username';
	$selectors[] = '.wvc-testimonial-cite';
	$selectors[] = '.decibel-button-special';
	$selectors[] = '.decibel-button-special-accent';
	$selectors[] = '.decibel-button-solid';
	$selectors[] = '.decibel-button-outline';
	$selectors[] = '.decibel-button-solid-accent';
	$selectors[] = '.decibel-button-outline-accent';
	$selectors[] = '.decibel-button-text';
	$selectors[] = '.decibel-button-text-accent';
	$selectors[] = '.wvc-wc-cat-title';
	$selectors[] = '.wvc-pricing-table-button a';
	// $selectors[] = '.load-more-button-line';
	$selectors[] = '.view-post';
	$selectors[] = '.wolf-gram-follow-button';
	// $selectors[] = '#decibel-percent';
	$selectors[] = '.wvc-pie-counter';
	$selectors[] = '.work-meta-label';
	$selectors[] = '.comment-reply-link';
	$selectors[] = '.logo-text, .date-block';
	$selectors[] = '.menu-button-primary a, .menu-button-secondary a';
	$selectors[] = '.single-post-nav-item > a, .post-nav-title, .related-posts .entry-title';
	$selectors[] = '.decibel-modern .navigation-number, #back-to-top:before';

	return $selectors;
}
add_filter( 'decibel_heading_family_selectors', 'decibel_add_heading_family_selectors' );

/**
 * Added selector to heading_family_selectors
 *
 * @param  array $selectors headings related CSS selectors.
 * @return array $selectors
 */
function decibel_add_decibel_heading_selectors( $selectors ) {

	$selectors[] = '.wvc-tabs-menu li a';
	$selectors[] = '.woocommerce-tabs ul.tabs li a';
	$selectors[] = '.wvc-process-number';
	$selectors[] = '.wvc-svc-item-title';
	$selectors[] = '.wvc-wc-cat-title';
	$selectors[] = '.logo-text';
	$selectors[] = '.onsale, .category-label';
	$selectors[] = '.single-post-nav-item > a, .post-nav-title';
	// $selectors[] = '.menu-button-primary a, .menu-button-secondary a';

	return $selectors;
}
add_filter( 'decibel_heading_selectors', 'decibel_add_decibel_heading_selectors' );

/*
--------------------------------------------------------------------

	POST TYPES DISPLAY

----------------------------------------------------------------------
*/

/**
 * Get available display options for posts
 *
 * @return array
 */
function decibel_set_post_display_options() {

	return array(
		'grid'        => esc_html__( 'Grid', 'decibel' ),
		'grid_modern' => esc_html__( 'Grid Modern', 'decibel' ),
		'masonry'     => esc_html__( 'Masonry', 'decibel' ),
		'lateral'     => esc_html__( 'Lateral', 'decibel' ),
		'standard'    => esc_html__( 'Standard', 'decibel' ),
	);
}
add_filter( 'decibel_post_display_options', 'decibel_set_post_display_options' );

/**
 * Get available display options for works
 *
 * @return array
 */
function decibel_set_work_display_options() {

	return array(
		'grid'    => esc_html__( 'Grid', 'decibel' ),
		'metro'   => esc_html__( 'Metro', 'decibel' ),
		'masonry' => esc_html__( 'Masonry', 'decibel' ),
	);
}
add_filter( 'decibel_work_display_options', 'decibel_set_work_display_options' );

/**
 * Get available display options for galleries/albums
 *
 * @return array
 */
function decibel_set_gallery_display_options() {

	return array(
		'grid'    => esc_html__( 'Grid', 'decibel' ),
		'masonry' => esc_html__( 'Masonry', 'decibel' ),
		'metro'   => esc_html__( 'Metro', 'decibel' ),
	);
}
add_filter( 'decibel_gallery_display_options', 'decibel_set_gallery_display_options' );

/**
 * Get available display options for products
 *
 * @return array
 */
function decibel_set_product_display_options() {

	return array(
		'grid' => esc_html__( 'Grid', 'decibel' ),
		// 'metro' => esc_html__( 'Metro', 'decibel' ),
	);
}
add_filter( 'decibel_product_display_options', 'decibel_set_product_display_options' );

/**
 * Set shop display
 *
 * @param string $string
 * @return string
 */
function decibel_set_product_display( $string ) {

	return 'grid';
}
add_filter( 'decibel_mod_product_display', 'decibel_set_product_display', 40 );

/**
 * Get available display options for releases
 *
 * @return array
 */
function decibel_set_release_display_options() {

	$layouts = array(
		'grid'    => esc_html__( 'Grid', 'decibel' ),
		'metro'   => esc_html__( 'Metro', 'decibel' ),
		'lateral' => esc_html__( 'Lateral', 'decibel' ),
		// 'offgrid' => esc_html__( 'Off Grid', 'decibel' ),
		// 'brokengrid' => esc_html__( 'Broken Grid', 'decibel' ),
	);

	if ( decibel_is_wolf_extension_activated() ) {
		$layouts['animated_cover'] = esc_html__( 'Animated Cover', 'decibel' );
	}

	return $layouts;
}
add_filter( 'decibel_release_display_options', 'decibel_set_release_display_options' );

/**
 * Get available display options for events
 *
 * @return array
 */
function decibel_set_event_display_options() {

	return array(
		'list' => esc_html__( 'List', 'decibel' ),
		'grid' => esc_html__( 'Grid', 'decibel' ),
	);
}
add_filter( 'decibel_event_display_options', 'decibel_set_event_display_options' );

/**
 * Discography "band" text
 */
function wolf_set_discography_band_string( $string ) {
	return esc_html__( 'Artist', 'decibel' );
}
add_filter( 'wolf_discography_band_string', 'wolf_set_discography_band_string', 40 );

/**
 * Set release taxonomy before string
 *
 * @param  string $string String to append before release taxonomy.
 * @return string
 */
function decibel_set_release_tax_before( $string ) {

	return esc_html__( 'by', 'decibel' ) . ' ';

}
add_filter( 'decibel_release_tax_before', 'decibel_set_release_tax_before' );

/*
--------------------------------------------------------------------

	THEME HOOKS

----------------------------------------------------------------------
*/

/**
 * Login popup markup
 */
function decibel_login_form_markup() {
	if ( function_exists( 'wvc_login_form' ) && class_exists( 'WooCommerce' ) ) {

		$skin_class = apply_filters( 'decibel_login_form_container_class', 'wvc-font-dark' );
		?>
		<div id="loginform-overlay">
			<div id="loginform-overlay-inner">
				<div id="loginform-overlay-content" class="<?php echo esc_attr( $skin_class ); ?>">
					<a href="#" id="close-vertical-bar-menu-icon" class="close-panel-button close-loginform-button">X</a>
					<?php
						// Loaded vis AJAX.
					?>
				</div>
			</div>
		</div>
		<?php
	}
}
add_action( 'decibel_body_start', 'decibel_login_form_markup', 5 );

add_filter(
	'wvc_default_twitter_text_align',
	function( $align ) {
		return $align;
	}
);

add_filter(
	'wvc_login_form_submit_button_class',
	function( $class ) {
		$class = 'button decibel-button-solid';

		return $class;
	}
);

add_filter(
	'decibel_proceed_to_checkout_button_class',
	function( $class ) {
		$class = 'checkout-button button decibel-button-solid';

		return $class;
	}
);

add_filter(
	'decibel_event_grid_entry_title_class',
	function() {
		return '';
	}
);

add_filter(
	'decibel_site_footer_class',
	function( $class ) {
		return 'wvc-font-light wvc-parent-row ' . $class;
	}
);

add_filter(
	'wvc_last_posts_big_slider_caption_container_additional_class',
	function( $class ) {
		return 'wvc-font-light wvc-row-bg-transparent';
	}
);

/**
 * Default separtor height
 */
add_filter(
	'wvc_separator_default_height',
	function( $string ) {
		return '3px';
	}
);

/**
 * Default separtor height
 */
add_filter(
	'wvc_separator_default_width',
	function( $string ) {
		return '50px';
	}
);

/**
 * Add currency switcher
 */
function decibel_output_currency_switcher() {

	$cta_content = decibel_get_inherit_mod( 'menu_cta_content_type', 'none' );

	$is_wc_page_child = is_page() && wp_get_post_parent_id( get_the_ID() ) == decibel_get_woocommerce_shop_page_id() && decibel_get_woocommerce_shop_page_id(); // phpcs:ignore
	$is_wc            = decibel_is_woocommerce_page() || is_singular( 'product' ) || $is_wc_page_child;

	if ( apply_filters( 'decibel_force_display_nav_shop_icons', $is_wc ) ) { // can be disable just in case.
		$cta_content = 'shop_icons';
	}

	if ( 'shop_icons' === $cta_content && decibel_get_inherit_mod( 'currency_switcher' ) ) {

		if ( function_exists( 'wwcs_currency_switcher' ) ) {
			echo '<div class="cta-item currency-switcher">';
			wwcs_currency_switcher();
			echo '</div>';
		} elseif ( defined( 'WOOCS_VERSION' ) ) {
			echo '<div class="cta-item currency-switcher">';
			echo do_shortcode( '[woocs style=1]' );
			echo '</div>';
		}
	}
}
add_action( 'decibel_secondary_menu', 'decibel_output_currency_switcher', 100 );

/**
 * Overwrite standard post entry slider image size
 */
function decibel_overwrite_entry_slider_img_size( $size ) {

	 add_filter(
		'decibel_entry_slider_image_size',
		function() {
			return '847x508';
		}
	);
	add_image_size( 'decibel-masonry', 700, 1500, false );
}
add_action( 'after_setup_theme', 'decibel_overwrite_entry_slider_img_size', 50 );

/**
 * Single release image size
 */
add_filter(
	'decibel_release_img_size',
	function() {
		return '650x650';
	}
);

/*
--------------------------------------------------------------------

	NAVIGATION

----------------------------------------------------------------------
*/

/**
 * Set sticky menu scrollpoint
 *
 * @param int|string $int
 * @return int
 */
function decibel_set_sticky_menu_scrollpoint( $int ) {

	$int = 200;

	return $int;
}
add_filter( 'decibel_sticky_menu_scrollpoint', 'decibel_set_sticky_menu_scrollpoint' );

/**
 * Add vertical menu location
 */
function decibel_add_lateral_menu( $menus ) {

	$menus['vertical'] = esc_html__( 'Vertical Menu (optional)', 'decibel' );

	return $menus;

}
add_filter( 'decibel_menus', 'decibel_add_lateral_menu' );

/**
 * Set mobile menu template
 *
 * @param string $string Mobile menu template slug.
 * @return string
 */
function decibel_set_mobile_menu_template( $string ) {

	return 'content-mobile-alt';
}
add_filter( 'decibel_mobile_menu_template', 'decibel_set_mobile_menu_template' );

/**
 * Add mobile closer overlay
 */
function decibel_add_mobile_panel_closer_overlay() {
	?>
	<div id="mobile-panel-closer-overlay" class="panel-closer-overlay toggle-mobile-menu"></div>
	<?php
}
add_action( 'decibel_main_content_start', 'decibel_add_mobile_panel_closer_overlay' );

/**
 * Mobile menu
 */
function decibel_mobile_alt_menu() {
	?>
	<div id="mobile-menu-panel">
		<a href="#" id="close-mobile-menu-icon" class="close-panel-button toggle-mobile-menu">X</a>
		<div id="mobile-menu-panel-inner">
		<?php
			/**
			 * Menu
			 */
			decibel_primary_mobile_navigation();
		?>
		</div><!-- .mobile-menu-panel-inner -->
	</div><!-- #mobile-menu-panel -->
	<?php
}
add_action( 'decibel_body_start', 'decibel_mobile_alt_menu' );

/**
 * Secondary navigation hook
 *
 * Display cart icons, social icons or secondary menu depending on cuzstimizer option
 */
function decibel_output_mobile_complementary_menu( $context = 'desktop' ) {

	if ( 'mobile' === $context ) {

		$cta_content = decibel_get_inherit_mod( 'menu_cta_content_type', 'none' );

		/* Force shop icons on woocommerce pages  */
		$is_wc_page_child = is_page() && wp_get_post_parent_id( get_the_ID() ) == decibel_get_woocommerce_shop_page_id() && decibel_get_woocommerce_shop_page_id(); // phpcs:ignore
		$is_wc            = decibel_is_woocommerce_page() || is_singular( 'product' ) || $is_wc_page_child;

		if ( apply_filters( 'decibel_force_display_nav_shop_icons', $is_wc ) ) { // can be disable just in case.
			$cta_content = 'shop_icons';
		}

		// dd( $cta_content );

		if ( 'shop_icons' === $cta_content || 'custom' === $cta_content ) {
			if ( decibel_display_account_menu_item() && 'shop_icons' === $cta_content ) :
				?>
				<div class="account-container cta-item">
					<?php
						/**
						 * account icon
						 */
						decibel_account_menu_item();
					?>
				</div><!-- .cart-container -->
				<?php
			endif;

			if ( decibel_display_cart_menu_item() ) {
				?>
				<div class="cart-container cta-item">
					<?php
						/**
						 * Cart icon
						 */
						decibel_cart_menu_item();
					?>
				</div><!-- .cart-container -->
				<?php
			}
		}
	}
}
add_action( 'decibel_secondary_menu', 'decibel_output_mobile_complementary_menu', 10, 1 );

/**
 * Sidepanel font class
 */
function decibel_set_sidepanel_font_class( $class ) {

	if ( decibel_get_inherit_mod( 'side_panel_bg_img' ) ) {
		$class .= ' wvc-font-light';
	} else {
		if ( 'light' === decibel_get_color_tone( decibel_get_inherit_mod( 'submenu_background_color' ) ) ) {
			$class .= ' wvc-font-dark';
		} else {
			$class .= ' wvc-font-light';
		}
	}

	return $class;
}
add_filter( 'decibel_side_panel_class', 'decibel_set_sidepanel_font_class' );

/**
 *  Enable side panel with overlay menu
 *
 * @param string $layouts
 * @return string $layouts
 */
function decibel_set_excluded_side_panel_menu_layout( $layouts ) {

	$overlay_key = null;
	foreach ( $layouts as $key => $value ) {
		if ( 'overlay' === $value ) {
			$overlay_key = $key;
		}
	}

	if ( $overlay_key && isset( $layouts[ $overlay_key ] ) ) {
		unset( $layouts[ $overlay_key ] );
	}

	return $layouts;
}
add_filter( 'decibel_excluded_side_panel_menu_layout', 'decibel_set_excluded_side_panel_menu_layout', 40 );

/*
--------------------------------------------------------------------

	THEME FILTERS

----------------------------------------------------------------------
*/

/**
 * Add additional JS scripts and functions
 */
function decibel_enqueue_additional_scripts() {

	$version = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? time() : decibel_get_theme_version();

	if ( ! decibel_is_wolf_extension_activated() ) {

		wp_register_style( 'ionicons', get_template_directory_uri() . '/assets/css/lib/fonts/ionicons/ionicons.min.css', array(), decibel_get_theme_version() );
		wp_register_style( 'elegant-icons', get_template_directory_uri() . '/assets/css/lib/fonts/elegant-icons/elegant-icons.min.css', array(), decibel_get_theme_version() );
		wp_register_style( 'dripicons', get_template_directory_uri() . '/assets/css/lib/fonts/dripicons-v2/dripicons.min.css', array(), decibel_get_theme_version() );
		wp_register_script( 'countup', get_template_directory_uri() . '/assets/js/lib/countUp.min.js', array(), '1.9.3', true );
		wp_register_script( 'inview', get_template_directory_uri() . '/assets/js/lib/jquery.inview.min.js', array( 'jquery' ), '1.3.0', true );
	}

	if ( is_singular( 'product' ) ) {
		wp_enqueue_script( 'jquery-ui-accordion' );
		wp_enqueue_script( 'wvc-accordion' );
	}

	if ( is_singular( 'event' ) && decibel_is_wolf_extension_activated() ) {
		wp_enqueue_style( 'wolficons' );
	}

	wp_enqueue_style( 'ionicons' );
	wp_enqueue_style( 'dripicons' );
	wp_enqueue_style( 'elegant-icons' );

	wp_enqueue_script( 'jquery-effects-core' );
	wp_enqueue_script( 'inview' );
	wp_enqueue_script( 'parallax-scroll' );
	wp_enqueue_script( 'decibel-custom', get_template_directory_uri() . '/assets/js/t/decibel.js', array( 'jquery' ), $version, true );

	if ( 'hard' === decibel_get_inherit_mod( 'menu_sticky_type' ) ) {
		wp_localize_script(
			'wolftheme',
			'WolfFrameworkJSParams',
			array(
				'menuOffsetDesktop'    => 60,
				'menuOffsetMobile'     => 60,
				'menuOffsetBreakpoint' => 60,
				'menuOffset'           => 60,
			)
		);
	}
}
add_action( 'wp_enqueue_scripts', 'decibel_enqueue_additional_scripts', 40 );

/**
 * Add addictional post class
 *
 * @param array
 * @return array
 */
function decibel_additional_post_classes( $classes ) {

	$post_id        = get_the_ID();
	$post_type      = get_post_type();
	$force_is_loop  = apply_filters( 'decibel_post_force_loop_class', false );
	$loop_condition = ( ! is_single() && ! is_search() ) || decibel_is_portfolio() || decibel_is_videos() || decibel_is_blog() || $force_is_loop || ( is_search() && decibel_is_woocommerce_page() );

	// debug(  $loop_condition );

	if ( $loop_condition ) {
		if ( in_array( $post_type, array( 'post', 'work', 'product', 'video', 'release', 'event' ) ) ) {
			$skin = decibel_get_inherit_mod( $post_type . '_skin', '', $post_id );
			if ( $skin ) {
				$classes[] = 'entry-post-skin-' . $skin;
			}
		}

		if ( 'product' === $post_type ) {
			global $product;

			if ( $product->get_gallery_image_ids() ) {
				$classes[] = 'entry-product-has-gallery';
			}
		}
	} elseif ( is_singular( 'product' ) ) {
		$skin = decibel_get_inherit_mod( $post_type . '_skin', '', $post_id );
		if ( $skin ) {
			$classes[] = 'entry-post-skin-' . $skin;
		}
	}

	return $classes;
}
add_filter( 'post_class', 'decibel_additional_post_classes' );

/**
 * Add addictional body class
 *
 * @param array
 * @return array
 */
function decibel_additional_body_classes( $classes ) {

	$classes[] = 'wrapper-width-' . decibel_get_inherit_mod( 'wrapper_width', 1400 );

	$sticky_details_meta   = decibel_get_inherit_mod( 'product_sticky' ) && 'no' !== decibel_get_inherit_mod( 'product_sticky' );
	$single_product_layout = decibel_get_inherit_mod( 'product_single_layout' );

	if ( is_singular( 'product' ) && $sticky_details_meta && 'sidebar-right' !== $single_product_layout && 'sidebar-left' !== $single_product_layout ) {
		$classes[] = 'sticky-product-details';
	}

	if ( decibel_get_theme_mod( 'custom_cursor' ) ) {
		$classes[] = 'custom-cursor-enabled';
	}

	if ( get_post_meta( decibel_get_the_id(), '_hero_mousewheel', true ) ) {
		$classes[] = 'hero-mousewheel';
	}

	if ( class_exists( 'Wolf_Share' ) ) {
		$classes[] = 'wolf-share';
	}

	if ( decibel_get_inherit_mod( 'sticky_menu_transparent' ) ) {
		$classes[] = 'sticky-menu-transparent';
	}

	return $classes;

}
add_filter( 'body_class', 'decibel_additional_body_classes' );

/**
 * Set menu layout for shop children pages
 */
function decibel_set_shop_menu_layout( $layout ) {

	$is_wc_page_child = is_page() && wp_get_post_parent_id( get_the_ID() ) == decibel_get_woocommerce_shop_page_id() && decibel_get_woocommerce_shop_page_id(); // phpcs:ignore
	$is_wc            = decibel_is_woocommerce_page() || is_singular( 'product' ) || $is_wc_page_child;

	$shop_menu_layout_meta = get_post_meta( decibel_get_woocommerce_shop_page_id(), '_post_menu_layout', true );

	if ( $is_wc && $shop_menu_layout_meta ) {
		$layout = $shop_menu_layout_meta;
	}

	return $layout;

}
add_filter( 'decibel_menu_layout', 'decibel_set_shop_menu_layout' );

/**
 * Overwrite hamburger icon
 */
function decibel_set_hamburger_icon( $html, $class, $title_attr ) {

	if ( 'toggle-side-panel' === $class ) {

		$title_attr = esc_html__( 'Side Panel', 'decibel' );

	} else {
		$title_attr = esc_html__( 'Menu', 'decibel' );
	}

	ob_start();
	?>
	<a class="hamburger-link <?php echo esc_attr( $class ); ?>" href="#" title="<?php echo esc_attr( $title_attr ); ?>">
		<span class="hamburger-icon">
			<span class="line line-first"></span>
			<span class="line line-second"></span>
			<span class="line line-third"></span>
			<span class="cross">
				<span></span>
				<span></span>
			</span>
		</span>
	</a>
	<?php
	$html = ob_get_clean();

	return $html;

}
add_filter( 'decibel_hamburger_icon', 'decibel_set_hamburger_icon', 10, 3 );

/**
 * Disable single post pagination
 *
 * @param bool $bool
 * @return bool
 */
add_filter( 'decibel_disable_single_post_pagination', '__return_true' );

/**
 * Filter single work title
 *
 * @param string $string
 * @return string
 */
function decibel_set_single_work_title( $string ) {

	return esc_html__( 'Details & Info', 'decibel' );
}
add_filter( 'decibel_single_work_title', 'decibel_set_single_work_title', 40 );

/**
 * Excerpt more
 *
 * Add span to allow more CSS tricks
 *
 * @return string
 */
function decibel_custom_more_text( $string ) {

	$text = '<small class="wvc-button-background-fill"></small><span>' . esc_html__( 'continue reading', 'decibel' ) . '</span>';

	return $text;
}
add_filter( 'decibel_more_text', 'decibel_custom_more_text', 40 );

/**
 * Set related posts text
 *
 * @param string $string
 * @return string
 */
function decibel_set_related_posts_text( $text ) {

	return esc_html__( 'You May Also Like', 'decibel' );
}
add_filter( 'decibel_related_posts_text', 'decibel_set_related_posts_text' );

/**
 * Returns large
 */
function decibel_set_large_metro_thumbnail_size() {
	return 'large';
}

/**
 * Filter metro thumnail size depending on row context
 */
function decibel_optimize_metro_thumbnail_size( $atts ) {

	$column_type   = isset( $atts['column_type'] ) ? $atts['column_type'] : null;
	$content_width = isset( $atts['content_width'] ) ? $atts['content_width'] : null;

	if ( 'column' === $column_type ) {
		if ( 'full' === $content_width || 'large' === $content_width ) {
			add_filter( 'decibel_metro_thumbnail_size_name', 'decibel_set_large_metro_thumbnail_size' );
		}
	}
}
add_action( 'wvc_add_row_filters', 'decibel_optimize_metro_thumbnail_size', 10, 1 );

/* Remove metro thumbnail size filter */
add_action(
	'wvc_remove_row_filters',
	function() {
		remove_filter( 'decibel_metro_thumbnail_size_name', 'decibel_set_large_metro_thumbnail_size' );
	}
);

/**
 * Filter post modules
 *
 * @param array $atts
 * @return array $atts
 */
function decibel_filter_post_module_atts( $atts ) {

	$post_type           = $atts['post_type'];
	$affected_post_types = array( 'release', 'gallery' );

	if ( in_array( $post_type, $affected_post_types ) ) {

		if ( isset( $atts[ $post_type . '_display' ] ) && 'offgrid' === $atts[ $post_type . '_display' ] ) {
			$atts['item_animation']         = '';
			$atts[ $post_type . '_layout' ] = 'standard';
		}

		if ( isset( $atts[ $post_type . '_display' ] ) && 'brokengrid' === $atts[ $post_type . '_display' ] ) {
			$atts[ $post_type . '_layout' ] = 'standard';
			$atts['el_class']               = $atts['el_class'] . ' broken-grid';
		}

		if ( 'release' === $post_type ) {
			if ( isset( $atts[ $post_type . '_hover_effect' ] ) ) {
				if ( 'old' === $atts[ $post_type . '_hover_effect' ] ) {
					$atts[ $post_type . '_layout' ] = 'overlay';
					$atts['overlay_color']          = 'white';
					$atts['overlay_opacity']        = '70';
					$atts['overlay_text_color']     = 'black';
				}

				if ( 'none' === $atts[ $post_type . '_hover_effect' ] ) {
					$atts[ $post_type . '_layout' ] = 'standard';
				}
			}
		}

		if ( 'gallery' === $post_type ) {
			if ( isset( $atts[ $post_type . '_hover_effect' ] ) ) {
				if ( 'old' === $atts[ $post_type . '_hover_effect' ] ) {
					$atts[ $post_type . '_layout' ] = 'overlay';
					$atts['overlay_color']          = 'white';
					$atts['overlay_opacity']        = '100';
					$atts['overlay_text_color']     = 'black';
				}

				if ( 'none' === $atts[ $post_type . '_hover_effect' ] ) {
					$atts[ $post_type . '_layout' ] = 'standard';
				}
			}
		}

		if ( 'grunge' === $atts[ $post_type . '_hover_effect' ] ) {
			$atts[ $post_type . '_layout' ] = 'overlay';
			$atts['overlay_color']          = '';
			$atts['overlay_text_color']     = 'white';
		}

		if ( 'slide-up' === $atts[ $post_type . '_hover_effect' ] ) {
			$atts[ $post_type . '_layout' ] = 'overlay';
		}
	}

	return $atts;
}
add_filter( 'decibel_post_module_atts', 'decibel_filter_post_module_atts' );

/**
 * No header post types
 *
 * @param  array $post_types Post types where the default hero block is disabled.
 * @return array
 */
function decibel_filter_no_hero_post_types( $post_types ) {

	$post_types = array( 'product', 'attachment' );
	$post_types = array( 'attachment' );

	return $post_types;
}
add_filter( 'decibel_no_header_post_types', 'decibel_filter_no_hero_post_types', 40 );

/**
 *
 */
function decibel_show_shop_header_content_block_single_product( $bool ) {

	if ( is_singular( 'product' ) ) {
		$bool = true;
	}

	return $bool;
}
add_filter( 'decibel_force_display_shop_after_header_block', 'decibel_show_shop_header_content_block_single_product' );

/**
 * Read more text
 */
function decibel_view_post_text( $string ) {
	return esc_html__( 'Read more', 'decibel' );
}
add_filter( 'decibel_view_post_text', 'decibel_view_post_text' );

/**
 * Filter empty p tags in excerpt
 */
function decibel_filter_excerpt_empty_p_tags( $excerpt ) {

	return str_replace( '<p></p>', '', $excerpt );

}
add_filter( 'get_the_excerpt', 'decibel_filter_excerpt_empty_p_tags', 100 );

/**
 *  Set entry slider animation
 *
 * @param string $animation
 * @return string $animation
 */
function decibel_set_entry_slider_animation( $animation ) {
	return 'slide';
}
add_filter( 'decibel_entry_slider_animation', 'decibel_set_entry_slider_animation', 40 );

/**
 * Search form placeholder
 */
function decibel_set_searchform_placeholder( $string ) {
	return esc_attr_x( 'Search&hellip;', 'placeholder', 'decibel' );
}
add_filter( 'decibel_searchform_placeholder', 'decibel_set_searchform_placeholder', 40 );
add_filter( 'decibel_product_searchform_placeholder', 'decibel_set_searchform_placeholder', 40 );

/**
 * Search form placeholder text
 */
function decibel_searchform_placeholder_text( $string ) {
	return esc_html__( 'Type your search and hit enter&hellip;', 'decibel' );
}
add_filter( 'decibel_searchform_placeholder', 'decibel_searchform_placeholder_text' );

/**
 * Add form in no result page
 */
function decibel_add_no_result_form() {
	get_search_form();
}
add_action( 'decibel_no_result_end', 'decibel_add_no_result_form' );

/**
 *  Set smooth scroll speed
 *
 * @param string $speed
 * @return string $speed
 */
function decibel_set_smooth_scroll_speed( $speed ) {
	return 1500;
}
add_filter( 'decibel_smooth_scroll_speed', 'decibel_set_smooth_scroll_speed' );
add_filter( 'wvc_smooth_scroll_speed', 'decibel_set_smooth_scroll_speed' );

/**
 *  Set smooth scroll easing effect
 *
 * @param string $ease
 * @return string $ease
 */
function decibel_set_smooth_scroll_ease( $ease ) {
	return 'easeInOutQuint';
}
add_filter( 'decibel_smooth_scroll_ease', 'decibel_set_smooth_scroll_ease' );
add_filter( 'wvc_smooth_scroll_ease', 'decibel_set_smooth_scroll_ease' );
add_filter( 'wvc_fp_easing', 'decibel_set_smooth_scroll_ease' );

/**
 *  Set smooth scroll speed
 *
 * @param string $speed
 * @return string $speed
 */
function decibel_set_fp_anim_time( $speed ) {

	$speed = 1500;

	if ( is_page() || is_single() ) {
		if ( get_post_meta( decibel_get_the_id(), '_post_fullpage_animtime', true ) ) {
			$speed = absint( get_post_meta( decibel_get_the_id(), '_post_fullpage_animtime', true ) );
		}
	}

	return $speed;
}
add_filter( 'wvc_fp_animtime', 'decibel_set_fp_anim_time', 40 );

/**
 * Filter lightbox settings
 */
function decibel_filter_lightbox_settings( $settings ) {

	$settings['transitionEffect'] = 'fade';
	$settings['buttons']          = array(
		'zoom',
		// 'share',
		'close',
	);

	return $settings;
}
add_filter( 'decibel_fancybox_settings', 'decibel_filter_lightbox_settings' );

/**
 * Save modal window content after import
 */
function decibel_set_modal_window_content_after_import() {
	$post = get_page_by_title( 'Modal Window Content', OBJECT, 'wvc_content_block' );

	if ( $post && function_exists( 'wvc_update_option' ) ) {
		wvc_update_option( 'modal_window', 'content_block_id', $post->ID );
	}
}
add_action( 'pt-ocdi/after_import', 'decibel_set_modal_window_content_after_import' );

/**
 * Returns CSS for the color schemes.
 *
 * @param array $colors Color scheme colors.
 * @return string Color scheme CSS.
 */
function decibel_edit_color_scheme_css( $output, $colors ) {

	extract( $colors );

	$output = '';

	$overlay_accent_bg_color = sprintf( 'rgba( %s, 0.95)', decibel_hex_to_rgb( $accent_color ) );
	$border_color            = sprintf( 'rgba( %s, 0.03)', decibel_hex_to_rgb( $strong_text_color ) );
	$overlay_panel_bg_color  = sprintf( 'rgba( %s, 0.95)', decibel_hex_to_rgb( $submenu_background_color ) );

	$link_selector       = '.link, p:not(.attachment) > a:not(.no-link-style):not(.button):not(.button-download):not(.added_to_cart):not(.button-secondary):not(.menu-link):not(.filter-link):not(.entry-link):not(.more-link):not(.wvc-image-inner):not(.wvc-button):not(.wvc-bigtext-link):not(.wvc-fittext-link):not(.ui-tabs-anchor):not(.wvc-icon-title-link):not(.wvc-icon-link):not(.wvc-social-icon-link):not(.wvc-team-member-social):not(.wolf-tweet-link):not(.author-link):not(.gallery-quickview)';
	$link_selector_after = '.link:after, p:not(.attachment) > a:not(.no-link-style):not(.button):not(.button-download):not(.added_to_cart):not(.button-secondary):not(.menu-link):not(.filter-link):not(.entry-link):not(.more-link):not(.wvc-image-inner):not(.wvc-button):not(.wvc-bigtext-link):not(.wvc-fittext-link):not(.ui-tabs-anchor):not(.wvc-icon-title-link):not(.wvc-icon-link):not(.wvc-social-icon-link):not(.wvc-team-member-social):not(.wolf-tweet-link):not(.author-link):not(.gallery-quickview):after';

	$output .= "/* Color Scheme */

	/* Body Background Color */
	body,
	.frame-border,
	.site-container{
		background-color: $body_background_color;
	}

	/* Page Background Color */
	.site-header,
	.post-header-container,
	.content-inner,
	#logo-bar,
	.nav-bar,
	.loading-overlay,
	.no-hero #hero,
	.wvc-font-default,
	#topbar{
		background-color: $page_background_color;
	}

	/* Submenu color */
	#site-navigation-primary-desktop .mega-menu-panel,
	#site-navigation-primary-desktop ul.sub-menu,
	#mobile-menu-panel,
	.offcanvas-menu-panel,
	.lateral-menu-panel,
	.cart-panel,
	.wwcs-selector{
		background:$submenu_background_color;
	}

	.cart-panel{
		background:$submenu_background_color!important;
	}

	.panel-closer-overlay{
		//background:$submenu_background_color;
	}

	.overlay-menu-panel{
		background:$overlay_panel_bg_color;
	}

	/* Sub menu Font Color */
	.nav-menu-desktop li ul li:not(.menu-button-primary):not(.menu-button-secondary) .menu-item-text-container,
	.nav-menu-desktop li ul.sub-menu li:not(.menu-button-primary):not(.menu-button-secondary).menu-item-has-children > a:before,
	.nav-menu-desktop li ul li.not-linked > a:first-child .menu-item-text-container,
	.mega-menu-tagline-text,
	.wwcs-selector,
	.currency-switcher .woocs-style-1-dropdown .woocs-style-1-dropdown-menu{
		color: $submenu_font_color;
	}

	.cart-panel,
	.cart-panel a,
	.cart-panel strong,
	.cart-panel b{
		color: $submenu_font_color!important;
	}

	#close-side-panel-icon{
		color: $submenu_font_color!important;
	}

	.nav-menu-vertical li a,
	.nav-menu-mobile li a,
	.nav-menu-vertical li.menu-item-has-children:before,
	.nav-menu-vertical li.page_item_has_children:before,
	.nav-menu-vertical li.active:before,
	.nav-menu-mobile li.menu-item-has-children:before,
	.nav-menu-mobile li.page_item_has_children:before,
	.nav-menu-mobile li.active:before{
		color: $submenu_font_color!important;
	}

	.lateral-menu-panel .wvc-icon:before{
		color: $submenu_font_color!important;
	}

	.nav-menu-desktop li ul.sub-menu li.menu-item-has-children > a:before{
		color: $submenu_font_color;
	}

	.cart-panel,
	.cart-panel a,
	.cart-panel strong,
	.cart-panel b{
		color: $submenu_font_color!important;
	}

	/* Accent Color */
	.accent{
		color:$accent_color;
	}

	.accent-color-is-black .wvc-font-color-light .accent{
		color:white;
	}

	.logo-text:after{
		color:$accent_color;
	}

	#decibel-loading-point{
		color:$accent_color;
	}

	#back-to-top:hover{
		background:$accent_color!important;
		border-color:$accent_color!important;
	}

	#decibel-cursor-dot{
		background-color:$accent_color;
	}

	blockquote:before{
		color:$accent_color!important;
	}

	.decibel-heading:after{
		color:$accent_color;
	}

	.wvc-single-image-overlay-title span:after,
	.work-meta-value a:hover{
		color:$accent_color;
	}

	.nav-menu li.sale .menu-item-text-container:before,
	.nav-menu-mobile li.sale .menu-item-text-container:before
	{
		background:$accent_color!important;
	}

	.widget_price_filter .ui-slider .ui-slider-range,
	mark,
	p.demo_store,
	.woocommerce-store-notice{
		background-color:$accent_color;
	}

	.button-secondary{
		background-color:$accent_color;
		border-color:$accent_color;
	}

	.decibel-button-special-accent,
	.decibel-button-solid-accent{
		border-color:$accent_color;
	}


	.decibel-button-solid-accent,
	.decibel-button-special-accent{
		background-color:$accent_color;
	}

	.decibel-button-outline-accent{
		border-color:$accent_color;
	}

	.decibel-button-outline-accent:hover{
		background-color:$accent_color;
	}

	.entry-post-standard .entry-title a:hover,
	.entry-post-standard .entry-meta a:hover,
	.entry-post-grid .entry-title a:hover,
	.entry-post-grid .entry-meta a:hover,
	.entry-post-masonry .entry-title a:hover,
	.entry-post-masonry .entry-meta a:hover{
		color:$accent_color!important;
	}

	.wolf-twitter-widget a.wolf-tweet-link,
	.wolf-bigtweet-content a,
	.widget.widget_categories a:hover,
	.widget.widget_pages a:hover,
	.widget .tagcloud a:hover,
	.widget.widget_recent_comments a:hover,
	.widget.widget_recent_entries a:hover,
	.widget.widget_archive a:hover,
	.widget.widget_meta a:hover,
	.widget.widget_product_categories a:hover,
	.widget.widget_nav_menu a:hover,
	a.rsswidget:hover,
	.wvc-font-dark .wolf-twitter-widget a.wolf-tweet-link:hover,
	.wvc-font-dark .widget.widget_categories a:hover,
	.wvc-font-dark .widget.widget_pages a:hover,
	.wvc-font-dark .widget .tagcloud a:hover,
	.wvc-font-dark .widget.widget_recent_comments a:hover,
	.wvc-font-dark .widget.widget_recent_entries a:hover,
	.wvc-font-dark .widget.widget_archive a:hover,
	.wvc-font-dark .widget.widget_meta a:hover,
	.wvc-font-dark .widget.widget_product_categories a:hover,
	.wvc-font-dark .widget.widget_nav_menu a:hover,
	.wvc-font-dark a.rsswidget:hover{
		color:$accent_color!important;
	}

	.wolf-tweet-link{
		color:$accent_color!important;
	}

	.group_table td a:hover{
		color:$accent_color;
	}

	.fancybox-thumbs>ul>li:before{
		border-color:$accent_color;
	}

	.wvc-background-color-accent{
		background-color:$accent_color;
	}

	.accent-color-is-black .wvc-font-color-light .wvc_bar_color_filler{
		background-color:white!important;
	}

	.wvc-accordion-tab.ui-state-active a:after,
	.wvc-testimonial-avatar:after{
		color:$accent_color;
	}

	.wvc-tabs-menu li.ui-tabs-active a{
		color:$accent_color!important;
	}

	.wvc-highlight-accent{
		background-color:$accent_color;
		color:#fff;
	}

	.wvc-icon-background-color-accent{
		box-shadow:0 0 0 0 $accent_color;
		background-color:$accent_color;
		color:$accent_color;
		border-color:$accent_color;
	}

	.wvc-icon-background-color-accent .wvc-icon-background-fill{
		box-shadow:0 0 0 0 $accent_color;
		background-color:$accent_color;
	}

	.wvc-button-background-color-accent{
		background-color:$accent_color;
		color:$accent_color;
		border-color:$accent_color;
	}

	.wvc-button-background-color-accent .wvc-button-background-fill{
		box-shadow:0 0 0 0 $accent_color;
		background-color:$accent_color;
	}

	.wvc-svg-icon-color-accent svg * {
		stroke:$accent_color!important;
	}

	.wvc-one-page-nav-bullet-tip{
		background-color: $accent_color;
	}

	.wvc-one-page-nav-bullet-tip:before{
		border-color: transparent transparent transparent $accent_color;
	}

	.accent,
	.comment-reply-link,
	.bypostauthor .avatar{
		color:$accent_color;
	}

	.wvc-button-color-button-accent,
	.more-link,
	.buton-accent{
		background-color: $accent_color;
		border-color: $accent_color;
	}

	.wvc-ils-item-title:before {
		background-color: $accent_color!important;
	}

	.wvc-io-active .wvc-io-item-title:after,
	.wvc-interactive-overlay-item a:hover .wvc-io-item-title:after {
	    color:$accent_color;
	}

	.widget .tagcloud:before{
		 color:$accent_color;
	}

	.group_table td a:hover{
		color:$accent_color;
	}

	.added_to_cart, .button,
	.button-download,
	.more-link,
	.wvc-mailchimp-submit,
	input[type=submit]{
		background-color: $accent_color;
		border-color: $accent_color;
	}

	/* WVC icons */
	.wvc-icon-color-accent{
		color:$accent_color;
	}

	.wvc-icon-background-color-accent{
		box-shadow:0 0 0 0 $accent_color;
		background-color:$accent_color;
		color:$accent_color;
		border-color:$accent_color;
	}

	.wvc-icon-background-color-accent .wvc-icon-background-fill{
		box-shadow:0 0 0 0 $accent_color;
		background-color:$accent_color;
	}

	#ajax-progress-bar{
		background:$accent_color;
	}

	.background-accent{
		background: $accent_color!important;
	}

	.mejs-container .mejs-controls .mejs-time-rail .mejs-time-current,
	.mejs-container .mejs-controls .mejs-time-rail .mejs-time-current, .mejs-container .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-current{
		background: $accent_color!important;
	}

	.trigger{
		background-color: $accent_color!important;
		border : solid 1px $accent_color;
	}

	.bypostauthor .avatar {
		border: 3px solid $accent_color;
	}

	::selection {
		background: $accent_color;
	}
	::-moz-selection {
		background: $accent_color;
	}

	.spinner{
		color:$main_text_color;
	}

	/*********************
		WVC
	***********************/

	.wvc-it-label{
		color:$accent_color;
	}

	.wvc-icon-box.wvc-icon-type-circle .wvc-icon-no-custom-style.wvc-hover-fill-in:hover, .wvc-icon-box.wvc-icon-type-square .wvc-icon-no-custom-style.wvc-hover-fill-in:hover {
		-webkit-box-shadow: inset 0 0 0 1em $accent_color;
		box-shadow: inset 0 0 0 1em $accent_color;
		border-color: $accent_color;
	}

	.wvc-pricing-table-featured-text,
	.wvc-pricing-table-featured .wvc-pricing-table-button a{
		background: $accent_color;
	}

	.wvc-pricing-table-featured .wvc-pricing-table-price,
	.wvc-pricing-table-featured .wvc-pricing-table-currency {
		color: $accent_color;
	}

	.wvc-pricing-table-featured .wvc-pricing-table-price-strike:before {
		background-color: $accent_color;
	}

	.wvc-team-member-social-container a:hover{
		color: $accent_color;
	}

	/* Main Text Color */
	body,
	.nav-label{
		color:$main_text_color;
	}

	.spinner-color, .sk-child:before, .sk-circle:before, .sk-cube:before{
		background-color: $main_text_color!important;
	}

	/* Strong Text Color */
	a,strong,
	.products li .price,
	.products li .star-rating,
	.wr-print-button,
	table.cart thead, #content table.cart thead{
		color: $strong_text_color;
	}

	.bit-widget-container,
	.entry-link{
		color: $strong_text_color;
	}

	.wr-stars>span.wr-star-voted:before, .wr-stars>span.wr-star-voted~span:before{
		color: $strong_text_color!important;
	}

	/* Border Color */

	.widget-title,
	.woocommerce-tabs ul.tabs{
		border-bottom-color:$border_color;
	}

	.widget_layered_nav_filters ul li a{
		border-color:$border_color;
	}

	hr{
		background:$border_color;
	}
	";

	$link_selector_after  = '.link:after, .underline:after, p:not(.attachment) > a:not(.no-link-style):not(.button):not(.button-download):not(.added_to_cart):not(.button-secondary):not(.menu-link):not(.filter-link):not(.entry-link):not(.more-link):not(.wvc-image-inner):not(.wvc-button):not(.wvc-bigtext-link):not(.wvc-fittext-link):not(.ui-tabs-anchor):not(.wvc-icon-title-link):not(.wvc-icon-link):not(.wvc-social-icon-link):not(.wvc-team-member-social):not(.wolf-tweet-link):not(.author-link):after';
	$link_selector_before = '.link:before, .underline:before, p:not(.attachment) > a:not(.no-link-style):not(.button):not(.button-download):not(.added_to_cart):not(.button-secondary):not(.menu-link):not(.filter-link):not(.entry-link):not(.more-link):not(.wvc-image-inner):not(.wvc-button):not(.wvc-bigtext-link):not(.wvc-fittext-link):not(.ui-tabs-anchor):not(.wvc-icon-title-link):not(.wvc-icon-link):not(.wvc-social-icon-link):not(.wvc-team-member-social):not(.wolf-tweet-link):not(.author-link):before';

	$output .= "

		/*$link_selector_after,
		$link_selector_before{
			background: $accent_color!important;
		}*/

		.category-filter ul li a:before{
			background:$accent_color!important;
		}

		.category-label{
			//background:$accent_color!important;
		}

		/*.wvc-breadcrumb a:hover,*/
		.wvc-list a:hover{
			color:$accent_color!important;
		}

		/*.nav-menu-desktop > li:not(.menu-button-primary):not(.menu-button-secondary) > a:first-child .menu-item-text-container:before{
			color:$accent_color;
		}*/

		.nav-menu li.menu-button-primary > a:first-child > .menu-item-inner:not(:hover){
			background:$accent_color!important;
		}

		.nav-menu li.menu-button-primary > a:first-child > .menu-item-inner,
		.nav-menu li.menu-button-secondary > a:first-child > .menu-item-inner{
			border-color:$accent_color
		}

		.nav-menu li.menu-button-secondary > a:first-child > .menu-item-inner:hover{
			background:$accent_color;
		}

		.decibel-heading:after{
			color:$accent_color;
		}

		input[type=text]:focus,
		input[type=search]:focus,
		input[type=tel]:focus,
		input[type=time]:focus,
		input[type=url]:focus,
		input[type=week]:focus,
		input[type=password]:focus,
		input[type=checkbox]:focus,
		input[type=color]:focus,
		input[type=date]:focus,
		input[type=datetime]:focus,
		input[type=datetime-local]:focus,
		input[type=email]:focus,
		input[type=month]:focus,
		input[type=number]:focus,
		select:focus,
		textarea:focus{
			border-color:$accent_color!important;
		}

		/* Button */


		.entry-mp-event .entry-container,
		.wvc-recipe-instructions o li:before,
		.wvc-recipe .wvc-recipe-counter-circle {
			background:$accent_color;
		}

		.accent-color-light .category-label{
			//color:#333!important;
		}

		.accent-color-dark .category-label{
			//color:#fff!important;
		}

		.coupon .button:hover{
			background:$accent_color!important;
			border-color:$accent_color!important;
		}

		.menu-item-fill{
			background:$accent_color!important;
		}

		.audio-shortcode-container .mejs-container .mejs-controls > .mejs-playpause-button{
			background:$accent_color;
		}

		.menu-hover-style-h-underline .nav-menu-desktop li a span.menu-item-text-container:after{
			background-color:$accent_color!important;
		}

		ul.wc-tabs li:hover:after,
		ul.wc-tabs li.ui-tabs-active:after,
		ul.wc-tabs li.active:after,
		ul.wvc-tabs-menu li:hover:after,
		ul.wvc-tabs-menu li.ui-tabs-active:after,
		ul.wvc-tabs-menu li.active:after
		{
			color:$accent_color!important;
		}

		.wvc-font-dark ul.wvc-tabs-menu li.ui-tabs-active,
		.wvc-font-light ul.wvc-tabs-menu li.ui-tabs-active{
			box-shadow: inset 0 -3px 0 0 $accent_color!important;
		}

		.wvc-accordion-tab.ui-state-active .wvc-at-title-text,
		.wvc-accordion-tab.ui-state-active:hover .wvc-at-title-text{
			color:$accent_color!important;
		}

		/*.entry-product ins .woocommerce-Price-amount,
		.entry-single-product ins .woocommerce-Price-amount{
			color:$accent_color;
		}*/
	";

	$heading_selectors = apply_filters( 'decibel_heading_selectors', decibel_list_to_array( 'h1:not(.wvc-bigtext), h2:not(.wvc-bigtext), h3:not(.wvc-bigtext), h4:not(.wvc-bigtext), h5:not(.wvc-bigtext), .post-title, .entry-title, h2.entry-title > .entry-link, h2.entry-title, .widget-title, .wvc-counter-text, .wvc-countdown-period, .location-title, .logo-text, .wvc-interactive-links, .wvc-interactive-overlays, .heading-font' ) );

	$heading_selectors = decibel_array_to_list( $heading_selectors );
	$output           .= "$heading_selectors{text-rendering: auto;}";

	// If dark
	if ( preg_match( '/dark/', decibel_get_theme_mod( 'color_scheme' ) ) ) {
		$output .= ".wvc-background-color-default.wvc-font-light{
			background-color:$page_background_color;
		}";
	}

	// if light
	if ( preg_match( '/light/', decibel_get_theme_mod( 'color_scheme' ) ) ) {
		$output .= ".wvc-background-color-default.wvc-font-dark{
			background-color:$page_background_color;
		}";
	}

	return $output;
}
add_filter( 'decibel_color_scheme_output', 'decibel_edit_color_scheme_css', 10, 2 );

/**
 * Additional styles
 */
function decibel_output_additional_styles() {

	$output = '';

	/* Content inner background */
	$c_ci_bg_color = decibel_get_inherit_mod( 'content_inner_bg_color' );

	if ( $c_ci_bg_color ) {
		$output .= ".content-inner{
	background-color: $c_ci_bg_color;
}";
	}

	/* Product thumbnail padding */
	$p_t_padding = decibel_get_inherit_mod( 'product_thumbnail_padding' );

	if ( $p_t_padding ) {
		$p_t_padding = decibel_sanitize_css_value( $p_t_padding );
		$output     .= ".entry-product-masonry .product-thumbnail-container,
.entry-product-grid .product-thumbnail-container,
.wwcq-product-quickview-container .product-images .slide-content img{
	padding: $p_t_padding;
}";
	}

	$output .= '.wolf-share-buttons-container:before{
	content: "' . esc_html__( 'Share', 'decibel' ) . ':";

}';

	// $output .= '#back-to-top:before{
	// content: "' . esc_html__( 'top', 'decibel' ) . '";
	//
	// }';

	if ( ! SCRIPT_DEBUG ) {
		$output = decibel_compact_css( $output );
	}

	wp_add_inline_style( 'decibel-style', $output );
}
add_action( 'wp_enqueue_scripts', 'decibel_output_additional_styles', 999 );

/*
--------------------------------------------------------------------

	POST HOOKS

----------------------------------------------------------------------
*/

/**
 * Redefine post standard hook
 */
function decibel_remove_loop_post_default_hooks() {

	remove_action( 'decibel_before_post_content_standard_title', 'decibel_output_post_content_standard_date' );
	remove_action( 'decibel_post_content_standard_title', 'decibel_output_post_content_standard_title' );
	remove_action( 'decibel_after_post_content_standard', 'decibel_output_post_content_standard_meta' );

	remove_action( 'decibel_before_post_content_grid_title', 'decibel_output_post_content_grid_date' );
	remove_action( 'decibel_before_post_content_grid_title', 'decibel_output_post_content_grid_media' );
	remove_action( 'decibel_post_content_grid_title', 'decibel_output_post_grid_title' );

	remove_action( 'decibel_before_post_content_masonry_title', 'decibel_output_post_content_grid_date' );
	remove_action( 'decibel_before_post_content_masonry_title', 'decibel_output_post_content_grid_media' );
	remove_action( 'decibel_post_content_masonry_title', 'decibel_output_post_grid_title' );

	remove_action( 'decibel_after_post_content_grid', 'decibel_output_post_content_grid_meta' );
	remove_action( 'decibel_after_post_content_masonry', 'decibel_output_post_content_grid_meta' );

	remove_action( 'decibel_after_post_content_grid_title', 'decibel_output_post_content_grid_excerpt' );
	remove_action( 'decibel_after_post_content_masonry_title', 'decibel_output_post_content_grid_excerpt' );

	// Add title
	add_action( 'decibel_before_post_content_standard_title', 'decibel_overwrite_post_standard_title', 10, 2 );

	add_action( 'decibel_before_post_content_masonry', 'decibel_output_post_content_grid_custom_media', 10, 2 );
	add_action( 'decibel_before_post_content_masonry_title', 'decibel_output_post_content_grid_open_tag', 10, 1 );

	add_action( 'decibel_before_post_content_grid', 'decibel_output_post_content_grid_custom_media', 10, 2 );
	add_action( 'decibel_before_post_content_grid', 'decibel_output_post_content_grid_summary_open_tag', 10, 2 );
	add_action( 'decibel_post_content_grid_title', 'decibel_overwrite_post_standard_title', 10, 2 );
	add_action( 'decibel_after_post_content_grid_title', 'decibel_overwrite_post_content_grid_excerpt', 10, 2 );

	add_action( 'decibel_post_content_masonry_title', 'decibel_overwrite_post_standard_title', 10, 2 );

	// add_action( 'decibel_before_post_content_grid_title', 'decibel_output_post_content_grid_open_tag', 10, 1 );

	add_action( 'decibel_after_post_content_masonry_title', 'decibel_overwrite_post_content_grid_excerpt', 10, 2 );

	add_action( 'decibel_after_post_content_grid', 'decibel_output_post_content_grid_summary_close_tag', 10, 1 );
	add_action( 'decibel_after_post_content_masonry', 'decibel_output_post_content_grid_summary_close_tag', 10, 1 );

	add_action( 'decibel_after_post_content_standard', 'decibel_output_post_content_standard_inner_close_tag', 10, 1 );
}
add_action( 'init', 'decibel_remove_loop_post_default_hooks' );

/**
 * Post open tag
 */
function decibel_output_post_content_grid_summary_open_tag( $post_display_elements ) {
	?>
	<div class="entry-summary">
		<div class="entry-summary-inner">
	<?php
}

/**
 * Post close tag
 */
function decibel_output_post_content_grid_summary_close_tag( $post_display_elements ) {
	?>
		</div><!-- .entry-summary-inner -->
	</div><!-- .entry-summary -->
	<?php
}

/**
 * Post standard inner close tag
 */
function decibel_output_post_content_standard_inner_close_tag() {
	?>
	</div><!-- .entry-post-standard-inner -->
	<?php
}

/**
 * Post Media
 */
function decibel_output_post_content_grid_custom_media( $post_display_elements, $display ) {
	$show_thumbnail = ( in_array( 'show_thumbnail', $post_display_elements ) );
	$show_category  = ( in_array( 'show_category', $post_display_elements ) );
	$format         = get_post_format();
	$post_id        = get_the_ID();

	?>
	<?php if ( $show_thumbnail ) : ?>
		<?php if ( decibel_has_post_thumbnail() || decibel_is_instagram_post( $post_id ) ) : ?>
			<div class="entry-image">
				<?php if ( $show_category ) : ?>
					<a class="category-label" href="<?php echo decibel_get_first_category_url(); ?>"><?php echo decibel_get_first_category(); ?></a>
				<?php endif; ?>
				<?php
				if ( 'masonry' === $display ) {

					decibel_get_post_masonry_media();

				} else {
					?>
						<div class="entry-cover">
						<?php
							echo decibel_background_img( array( 'background_img_size' => 'medium' ) );
						?>
						</div><!-- entry-cover -->
						<?php
				}
				?>
			</div><!-- .entry-image -->
		<?php endif; ?>
	<?php endif; ?>
	<?php
}

/**
 * Get media for post masonry display
 */
function decibel_get_post_masonry_media() {

	$format  = get_post_format();
	$post_id = get_the_ID();

	// if ( 141 === $post_id ) {
	// debug( decibel_featured_media( $post_id ) );
	// die();
	// }

	if ( 'video' === $format ) {

		echo decibel_featured_media( $post_id );

	} elseif ( 'image' === $format && decibel_is_instagram_post( $post_id ) ) {

		echo decibel_get_instagram_image( $post_id );

	} elseif ( 'image' === $format ) {

		echo decibel_post_thumbnail( 'decibel-masonry' );

	} elseif ( 'gallery' === $format && decibel_background_slideshow() ) {

		echo decibel_background_slideshow(
			array(
				'slideshow_image_size' => '447x250',
				'slideshow_img_count'  => 3,
			)
		);

		?>
		<div class="slideshow-gallery-direction-nav">
			<a href="#" class="slideshow-gallery-direction-nav-prev">
				<span class="slideshow-gallery-direction-nav-prev-icon"></span>
			</a>
			<a href="#" class="slideshow-gallery-direction-nav-next">
				<span class="slideshow-gallery-direction-nav-next-icon"></span>
			</a>
		</div>
		<?php

	} elseif ( 'audio' === $format && decibel_featured_media() ) {

		echo decibel_featured_media();

	} else {
		?>
		<div class="entry-cover">
			<?php
				echo decibel_background_img( array( 'background_img_size' => 'medium' ) );
			?>
		</div><!-- entry-cover -->
		<?php
	}
}

/**
 * Re-assign post masonry open hook
 */
function decibel_output_post_content_grid_open_tag( $post_display_elements ) {
	$show_date      = ( in_array( 'show_date', $post_display_elements ) );
	$show_thumbnail = ( in_array( 'show_thumbnail', $post_display_elements ) );
	?>
	<div class="entry-summary">
		<div class="entry-summary-inner">
	<?php
}

/**
 * Post Text
 */
function decibel_overwrite_post_content_grid_excerpt( $post_display_elements, $post_excerpt_length, $display = 'grid' ) {

	$show_text = ( in_array( 'show_text', $post_display_elements ) );

	if ( 'metro' === $display ) {
		$post_excerpt_length = 5;
	}
	?>
	<?php if ( $show_text ) : ?>
		<div class="entry-excerpt">
			<?php do_action( 'decibel_post_' . $display . '_excerpt', $post_excerpt_length ); ?>
		</div><!-- .entry-excerpt -->
	<?php endif; ?>
	<?php
}

/**
 * Redefine single post hook
 */
function decibel_remove_single_post_default_hooks() {

	/**
	 * Remove default Hooks
	 */
	remove_action( 'decibel_post_content_start', 'decibel_add_custom_post_meta' );
	remove_action( 'decibel_post_content_end', 'decibel_ouput_single_post_taxonomy' );
	remove_action( 'decibel_related_post_content', 'decibel_output_related_post_content' );

	/**
	 * Add new hooks
	 */
	add_action( 'decibel_post_content_before', 'decibel_output_single_post_featured_image' );
	add_action( 'decibel_post_content_before', 'decibel_output_single_post_meta', 10, 1 );

}
add_action( 'init', 'decibel_remove_single_post_default_hooks' );

/**
 * Output single post meta
 */
function decibel_output_single_post_meta() {
	?>
	<div class="entry-meta">
		<span class="entry-date">
			<?php decibel_entry_date( true, true ); ?>
		</span>
			<?php decibel_get_author_avatar(); ?>
		<span class="entry-category-list">
			<?php echo apply_filters( 'decibel_entry_category_list_icon', '<span class="meta-icon category-icon"></span>' ); ?>
			<?php echo get_the_term_list( get_the_ID(), 'category', '', esc_html__( ', ', 'decibel' ), '' ); ?>
		</span>
		<?php decibel_entry_tags(); ?>
		<?php decibel_get_extra_meta(); ?>
		<?php decibel_edit_post_link(); ?>
	</div><!-- .entry-meta -->
	<?php
}

/**
 * Single Post Featured Image
 */
function decibel_output_single_post_featured_image() {

	if ( decibel_get_inherit_mod( 'hide_single_post_featured_image' ) ) {
		return;
	}

	?>
	<div class="single-featured-image">
	<?php
	the_post_thumbnail( 'large' );
	?>
	</div>
	<?php

}

add_filter(
	'decibel_entry_tag_list_separator',
	function() {
		return ', ';
	}
);

/**
 * Output single post pagination
 */
function decibel_output_custom_single_post_pagination() {

	if ( ! is_singular( 'post' ) || 'no' === decibel_get_inherit_mod( 'single_post_nav' ) ) {
		return; // event are ordered by custom date so it's better to hide the pagination
	}

	global $post;

	// Don't print empty markup if there's nowhere to navigate.
	$previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
	$next     = get_adjacent_post( false, '', false );

	if ( ! $next && ! $previous || ! is_single() || 'wvc_content_block' === get_post_type() ) {
		return;
	}

	$prev_post = get_previous_post();
	$next_post = get_next_post();

	$prev_post_id = ( is_object( $prev_post ) && isset( $prev_post->ID ) ) ? $prev_post->ID : null;
	$next_post_id = ( is_object( $next_post ) && isset( $next_post->ID ) ) ? $next_post->ID : null;

	$prev_post_featured_img_id = ( $prev_post_id ) ? get_post_thumbnail_id( $prev_post_id ) : null;
	$next_post_featured_img_id = ( $next_post_id ) ? get_post_thumbnail_id( $next_post_id ) : null;

	$index_class = 'nav-index';
	$prev_class  = 'nav-previous';
	$next_class  = 'nav-next';
	?>
	<nav class="decibel-single-post-pagination clearfix">
		<?php if ( $prev_post ) : ?>
			<div class="single-post-nav-item post-previous">
				<a href="<?php echo esc_url( get_permalink( $prev_post_id ) ); ?>" class="post-nav-link-overlay"></a>
				<div class="entry-cover">
						<?php echo decibel_background_img( array( 'background_img' => $prev_post_featured_img_id ) ); ?></div>
				<div class="post-nav-content">
					<div class="post-nav-summary">
						<?php if ( decibel_get_first_category( $prev_post_id ) ) : ?>
							<div class="post-nav-category"><?php echo decibel_get_first_category( $prev_post_id ); ?></div>
						<?php endif; ?>
						<div class="post-nav-title"><?php echo get_the_title( $prev_post_id ); ?></div>
						<span class="post-nav-entry-date">
							<?php decibel_entry_date( true, '', $prev_post_id ); ?>
						</span>
					</div>
				</div>
				<?php previous_post_link( '%link', '<span class="nav-label">' . esc_html__( 'Previous Article', 'decibel' ) . ' </span>' ); ?>
			</div><!-- .nav-previous -->
		<?php endif; ?>
		<?php if ( $next_post ) : ?>
			<div class="single-post-nav-item post-next">
				<a href="<?php echo esc_url( get_permalink( $next_post_id ) ); ?>" class="post-nav-link-overlay"></a>
				<div class="entry-cover">
					<?php echo decibel_background_img( array( 'background_img' => $next_post_featured_img_id ) ); ?>
					</div>
				<div class="post-nav-content">
					<div class="post-nav-summary">
						<?php if ( decibel_get_first_category( $next_post_id ) ) : ?>
							<div class="post-nav-category"><?php echo decibel_get_first_category( $next_post_id ); ?></div>
						<?php endif; ?>
						<div class="post-nav-title"><?php echo get_the_title( $next_post_id ); ?></div>
						<span class="post-nav-entry-date">
							<?php decibel_entry_date( true, '', $next_post_id ); ?>
						</span>
					</div>
				</div>
				<?php next_post_link( '%link', '<span class="nav-label">' . esc_html__( 'Next Article', 'decibel' ) . ' </span>' ); ?>
			</div><!-- .nav-next -->
		<?php endif; ?>
	</nav><!-- .single-post-pagination -->
	<?php
}
add_action( 'decibel_post_content_after', 'decibel_output_custom_single_post_pagination', 14 );

/**
 * Output related posts
 */
function decibel_overwrite_related_post_content() {
	?>
	<div class="entry-related-post">
		<a href="<?php the_permalink(); ?>" class="entry-related-post-img-link">
			<?php the_post_thumbnail( apply_filters( 'decibel_related_post_thumbnail_size', 'thumbnail' ) ); ?>
		</a>
		<div class="entry-related-post-summary">
			<a href="<?php the_permalink(); ?>" class="entry-related-post-title-link">
				<?php the_title( '<h4 class="entry-title">', '</h4>' ); ?>
			</a>
			<!-- <a class="entry-related-post-category" href="<?php // echo decibel_get_first_category_url(); ?>"><?php // echo decibel_get_first_category(); ?></a> -->
			<span class="entry-related-post-entry-date">
				<?php decibel_entry_date(); ?>
			</span>
		</div><!-- .entry-summary -->
	</div><!-- .entry-box -->
	<?php
}
add_action( 'decibel_related_post_content', 'decibel_overwrite_related_post_content' );

/**
 * Add post meta before title
 */
function decibel_overwrite_post_standard_title( $post_display_elements, $display ) {

	if ( 'standard' === $display ) {
		echo '<div class="entry-post-standard-inner">';
	}

	if ( '' == get_post_format() || 'video' === get_post_format() || 'gallery' === get_post_format() || 'image' === get_post_format() || 'audio' === get_post_format() || 'grid' === $display || 'masonry' === $display ) {
		the_title( '<h2 class="entry-title"><a class="entry-link" href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
	}

	echo '<header class="entry-meta">';

	if ( in_array( 'show_date', $post_display_elements ) && '' == get_post_format() || 'video' === get_post_format() || 'gallery' === get_post_format() || 'image' === get_post_format() || 'audio' === get_post_format() || 'grid' === $display || 'masonry' === $display ) {
		?>
		<span class="entry-date">
			<?php decibel_entry_date( true, true ); ?>
		</span>
		<?php
	}

	$show_author     = ( in_array( 'show_author', $post_display_elements ) );
	$show_category   = ( in_array( 'show_category', $post_display_elements ) );
	$show_tags       = ( in_array( 'show_tags', $post_display_elements ) );
	$show_extra_meta = ( in_array( 'show_extra_meta', $post_display_elements ) );
	?>
	<?php if ( ( $show_author || $show_extra_meta || $show_category || decibel_edit_post_link( false ) ) && 'grid' === $display || 'masonry' === $display || ( ! decibel_is_short_post_format() && 'standard' === $display ) ) : ?>

			<?php if ( $show_author ) : ?>
				<?php decibel_get_author_avatar(); ?>
			<?php endif; ?>
			<?php if ( $show_category ) : ?>
				<span class="entry-category-list">
					<?php echo apply_filters( 'decibel_entry_category_list_icon', '<span class="meta-icon category-icon"></span>' ); ?>
					<?php echo get_the_term_list( get_the_ID(), 'category', '', esc_html__( ', ', 'decibel' ), '' ); ?>
				</span>
			<?php endif; ?>
			<?php if ( $show_tags ) : ?>
				<?php decibel_entry_tags(); ?>
			<?php endif; ?>
			<?php if ( $show_extra_meta ) : ?>
				<?php decibel_get_extra_meta(); ?>
			<?php endif; ?>
			<?php decibel_edit_post_link(); ?>
		<?php endif; ?>
	<?php
	echo '</header>';
}

add_filter(
	'decibel_author_heading_avatar_size',
	function() {
		return 150;
	}
);
add_filter(
	'decibel_author_box_avatar_size',
	function() {
		return 150;
	}
);

/**
 * Post excerpt read more
 */
function decibel_output_post_grid_classic_excerpt_read_more() {
	?>
	<p class="post-grid-read-more-container"><a href="<?php the_permalink(); ?>" class="<?php echo esc_attr( apply_filters( 'decibel_more_link_button_class', 'more-link' ) ); ?>"><small class="wvc-button-background-fill"></small><span><?php esc_html_e( 'read more', 'decibel' ); ?></span></a></p>
	<?php
}
add_action( 'decibel_post_grid_excerpt', 'decibel_output_post_grid_classic_excerpt_read_more', 44 );
add_action( 'decibel_post_masonry_excerpt', 'decibel_output_post_grid_classic_excerpt_read_more', 44 );
add_action( 'decibel_post_search_excerpt', 'decibel_output_post_grid_classic_excerpt_read_more', 44 );

/*
--------------------------------------------------------------------

	WVC FILTERS

----------------------------------------------------------------------
*/

/**
 * Add custom elements to theme
 *
 * @param array $elements
 * @return  array $elements
 */
function decibel_add_available_wvc_elements( $elements ) {

	$elements[] = 'audio-button';
	$elements[] = 'album-disc';
	$elements[] = 'album-tracklist';
	$elements[] = 'album-tracklist-item';
	$elements[] = 'artist-lineup';
	$elements[] = 'bandsintown-tracking-button';

	if ( class_exists( 'WooCommerce' ) ) {
		$elements[] = 'wc-searchform';
		$elements[] = 'login-form';
		$elements[] = 'product-presentation';
	}

	if ( class_exists( 'Wolf_Videos' ) ) {
		$elements[] = 'video-switcher';
	}

	return $elements;
}
add_filter( 'wvc_element_list', 'decibel_add_available_wvc_elements', 44 );

/**
 * Filter heading attribute
 *
 * @param array $atts
 * @return array $atts
 */
function woltheme_filter_heading_atts( $atts ) {

	// heading
	if ( isset( $atts['style'] ) ) {
		$atts['el_class'] = $atts['el_class'] . ' ' . $atts['style'];
	}

	return $atts;
}
add_filter( 'wvc_heading_atts', 'woltheme_filter_heading_atts' );

/**
 * Remove some params
 */
function decibel_remove_vc_params() {

	if ( function_exists( 'vc_remove_param' ) ) {

		vc_remove_param( 'wvc_product_index', 'product_layout' );
		vc_remove_param( 'wvc_product_index', 'product_display' );
		vc_remove_param( 'wvc_product_index', 'product_metro_pattern' );
		vc_remove_param( 'wvc_product_index', 'product_text_align' );
		vc_remove_param( 'wvc_video_index', 'video_preview' );

		// vc_remove_param( 'wvc_release_index', 'caption_text_alignment' );
		// vc_remove_param( 'wvc_release_index', 'release_category_filter_text_alignment' );
		// vc_remove_param( 'wvc_release_index', 'overlay_color' );
		// vc_remove_param( 'wvc_release_index', 'overlay_custom_color' );
		// vc_remove_param( 'wvc_release_index', 'overlay_text_color' );
		// vc_remove_param( 'wvc_release_index', 'overlay_text_custom_color' );
		// vc_remove_param( 'wvc_release_index', 'overlay_opacity' );
		// vc_remove_param( 'wvc_release_index', 'caption_v_align' );

		vc_remove_param( 'wvc_interactive_links', 'align' );
		vc_remove_param( 'wvc_interactive_links', 'v_align' );
		vc_remove_param( 'wvc_interactive_links', 'display' );
		vc_remove_param( 'wvc_interactive_overlays', 'align' );
		vc_remove_param( 'wvc_interactive_overlays', 'display' );
		vc_remove_param( 'wvc_interactive_overlays', 'font_size' );

		vc_remove_param( 'wvc_team_member', 'layout' );
		vc_remove_param( 'wvc_team_member', 'alignment' );
		vc_remove_param( 'wvc_team_member', 'v_alignment' );
		vc_remove_param( 'wvc_team_member', 'overlay_color' );
		vc_remove_param( 'wvc_team_member', 'overlay_custom_color' );
		vc_remove_param( 'wvc_team_member', 'overlay_text_color' );
		vc_remove_param( 'wvc_team_member', 'overlay_text_custom_color' );
		vc_remove_param( 'wvc_team_member', 'overlay_opacity' );
		vc_remove_param( 'wvc_team_member', 'caption_v_align' );

		vc_remove_param( 'wvc_testimonial_slider', 'text_alignment' );
	}
}
add_action( 'init', 'decibel_remove_vc_params' );

/**
 * Post slider button text markup
 */
add_filter(
	'wvc_last_posts_big_slide_button_text',
	function( $text ) {
		return '<span>' . $text . '</span>';
	}
);

/**
 * Interactive links
 */
add_filter(
	'wvc_interactive_links_align',
	function( $value ) {
		return 'center';
	},
	44
);

add_filter(
	'wvc_interactive_links_display',
	function( $value ) {
		return 'inline-block';
	},
	100
);

/**
 * Album disc
 */
add_filter(
	'wvc_default_album_disc_rotation_speed',
	function() {
		return 10000;
	}
);

/**
 * Set release taxonomy before string
 *
 * @param  string $string String to append before release taxonomy.
 * @return string
 */
function decibel_set_breadcrump_delimiter( $string ) {

	return ' <i class="fa ion-chevron-right"></i> ';

}
add_filter( 'wvc_breadcrumb_delimiter', 'decibel_set_breadcrump_delimiter' );

/**
 * Filter fullPage Transition
 *
 * @return array
 */
function decibel_set_fullpage_transition( $transition ) {

	if ( is_page() || is_single() ) {
		if ( get_post_meta( wvc_get_the_ID(), '_post_fullpage', true ) ) {
			$transition = get_post_meta( wvc_get_the_ID(), '_post_fullpage_transition', true );
		}
	}

	return $transition;
}
add_filter( 'wvc_fp_transition_effect', 'decibel_set_fullpage_transition' );

/**
 * Set overlay effects
 *
 * @param array $atts
 * @return string $html
 */
function decibel_set_bg_effects( $atts ) {

	if ( isset( $atts['add_filmgrain'] ) || isset( $atts['add_grunge'] ) ) {
		$atts['add_effect'] = true;
	}

	return $atts;
}
add_filter( 'wvc_row_atts', 'decibel_set_bg_effects' );
add_filter( 'wvc_row_inner_atts', 'decibel_set_bg_effects' );
add_filter( 'wvc_column_atts', 'decibel_set_bg_effects' );
add_filter( 'wvc_column_inner_atts', 'decibel_set_bg_effects' );
add_filter( 'wvc_advanced_slider_atts', 'decibel_set_bg_effects' );
add_filter( 'wvc_interactive_link_item_bg_atts', 'decibel_set_bg_effects' );

/**
 * Get row overlay effects
 *
 * @param string $html
 * @param array  $atts
 * @return string $html
 */
function decibel_get_overlay_effects( $html, $atts ) {

	if ( isset( $atts['add_filmgrain'] ) && $atts['add_filmgrain'] ) {
		ob_start();
		?>
		<div class="decibel-bg-filmgrain"></div>
		<?php
		$html .= ob_get_clean();
	}

	if ( isset( $atts['add_grunge'] ) && $atts['add_grunge'] ) {
		ob_start();
		?>
		<div class="decibel-bg-grunge"></div>
		<?php
		$html .= ob_get_clean();
	}

	return $html;
}
add_filter( 'wvc_background_effect', 'decibel_get_overlay_effects', 10, 2 );


/*
--------------------------------------------------------------------

	WC FILTERS

----------------------------------------------------------------------
*/

/**
 * Quickview product excerpt lenght
 */
add_filter(
	'wwcqv_excerpt_length',
	function() {
		return 28;
	}
);

/**
 * After quickview summary hook
 */
add_action(
	'wwcqv_product_summary',
	function() {
		?>
	<div class="single-add-to-wishlist">
		<span class="single-add-to-wishlist-label"><?php esc_html_e( 'Wishlist', 'decibel' ); ?></span>
		<?php decibel_add_to_wishlist(); ?>
	</div><!-- .single-add-to-wishlist -->
		<?php
	},
	20
);



/**
 * Display sale label condition
 *
 * @param bool $bool
 * @return bool
 */
function decibel_do_show_sale_label( $bool ) {

	if ( get_post_meta( get_the_ID(), '_post_product_label', true ) ) {
		$bool = true;
	}

	return $bool;
}
add_filter( 'decibel_show_sale_label', 'decibel_do_show_sale_label' );

/**
 * Sale label text
 *
 * @param string $string
 * @return string
 */
function decibel_sale_label( $string ) {

	if ( get_post_meta( get_the_ID(), '_post_product_label', true ) ) {

		$style = '';

		$string = '<span' . $style . ' class="onsale">' . esc_attr( get_post_meta( get_the_ID(), '_post_product_label', true ) ) . '</span>';
	}

	return $string;
}
add_filter( 'woocommerce_sale_flash', 'decibel_sale_label' );

/**
 * Product quickview button
 *
 * @param string $string
 * @return string
 */
function decibel_output_product_quickview_button() {

	if ( function_exists( 'wolf_quickview_button' ) ) {
		wolf_quickview_button();
	}
}
add_filter( 'decibel_product_quickview_button', 'decibel_output_product_quickview_button' );

/**
 * Product wishlist button
 *
 * @param string $string
 * @return string
 */
function decibel_output_product_wishlist_button() {

	if ( function_exists( 'wolf_add_to_wishlist' ) ) {
		wolf_add_to_wishlist();
	}
}
add_filter( 'decibel_add_to_wishlist_button', 'decibel_output_product_wishlist_button' );

/**
 * Product Add to cart button
 *
 * @param string $string
 * @return string
 */
function decibel_output_product_add_to_cart_button() {

	global $product;

	if ( $product->is_type( 'variable' ) ) {

		echo '<a class="product-quickview-button" href="' . esc_url( get_permalink() ) . '"><span class="fa quickview-product-add-to-cart-icon" title="' . esc_attr( __( 'Select option', 'decibel' ) ) . '"></span></a>';

	} elseif ( $product->is_type( 'external' ) || $product->is_type( 'grouped' ) ) {

		echo '<a class="product-quickview-button" href="' . esc_url( get_permalink() ) . '"><span class="fa quickview-product-add-to-cart-icon" title="' . esc_attr( __( 'View product', 'decibel' ) ) . '"></span></a>';

	} else {

		echo decibel_add_to_cart(
			get_the_ID(),
			'quickview-product-add-to-cart product-quickview-button',
			'<span class="fa quickview-product-add-to-cart-icon" title="' . esc_attr( __( 'Add to cart', 'decibel' ) ) . '"></span>'
		);
	}
}
add_filter( 'decibel_product_add_to_cart_button', 'decibel_output_product_add_to_cart_button' );

/**
 * Product more button
 *
 * @param string $string
 * @return string
 */
function decibel_output_product_more_button() {

	?>
	<a class="product-quickview-button product-more-button" href="<?php the_permalink(); ?>" title="<?php esc_attr_e( 'More details', 'decibel' ); ?>"><span class="fa ion-android-more-vertical"></span></a>
	<?php
}
add_filter( 'decibel_product_more_button', 'decibel_output_product_more_button' );

/*
--------------------------------------------------------------------

	WC HOOKS

----------------------------------------------------------------------
*/

/**
 * Product Size Chart Image
 */
function decibel_product_size_chart_img() {

	$hide_sizechart = get_post_meta( get_the_ID(), '_post_wc_product_hide_size_chart_img', true );

	if ( $hide_sizechart || ! is_singular( 'product' ) ) {
		return;
	}

	global $post;
	$sc_img = null;
	$terms  = get_the_terms( $post, 'product_cat' );

	foreach ( $terms as $term ) {

		$sizechart_id = absint( get_term_meta( $term->term_id, 'sizechart_id', true ) );

		if ( $sizechart_id ) {
			$sc_img = $sizechart_id;
		}
	}

	if ( get_post_meta( get_the_ID(), '_post_wc_product_size_chart_img', true ) ) {
		$sc_img = get_post_meta( get_the_ID(), '_post_wc_product_size_chart_img', true );
	}

	if ( is_single() && $sc_img ) {
		$href = decibel_get_url_from_attachment_id( $sc_img, 'decibel-XL' );
		?>
		<div class="size-chart-img">
			<a href="<?php echo esc_url( $href ); ?>" class="lightbox"><?php esc_html_e( 'Size Chart', 'decibel' ); ?></a>
		</div>
		<?php
	}
}
add_action( 'woocommerce_single_product_summary', 'decibel_product_size_chart_img', 25 );

/**
 * WC gallery image size overwrite
 */
add_filter(
	'woocommerce_gallery_thumbnail_size',
	function( $size ) {
		return array( 100, 137 );
	},
	40
);

/**
 * Category thumbnail fields.
 */
function decibel_add_category_fields() {
	?>
	<div class="form-field term-thumbnail-wrap">
		<label><?php esc_html_e( 'Size Chart', 'decibel' ); ?></label>
		<div id="sizechart_img" style="float: left; margin-right: 10px;"><img src="<?php echo esc_url( wc_placeholder_img_src() ); ?>" width="60px" height="60px" /></div>
		<div style="line-height: 60px;">
			<input type="hidden" id="product_cat_sizechart_img_id" name="product_cat_sizechart_img_id">
			<button type="button" id="upload_sizechart_image_button" class="upload_sizechart_image_button button"><?php esc_html_e( 'Upload/Add image', 'decibel' ); ?></button>
				<button type="button" id="remove_sizechart_image_button" class="remove_sizechart_image_button button" style="display:none;"><?php esc_html_e( 'Remove image', 'decibel' ); ?></button>
		</div>
		<script type="text/javascript">

			// Only show the "remove image" button when needed
			if ( ! jQuery( '#product_cat_sizechart_img_id' ).val() ) {
				jQuery( '#remove_sizechart_image_button' ).hide();
			}

			// Uploading files
			var sizechart_frame;

			jQuery( document ).on( 'click', '#upload_sizechart_image_button', function( event ) {

				event.preventDefault();

				// If the media frame already exists, reopen it.
				if ( sizechart_frame ) {
					sizechart_frame.open();
					return;
				}

				// Create the media frame.
				sizechart_frame = wp.media.frames.downloadable_file = wp.media({
					title: '<?php esc_html_e( 'Choose an image', 'decibel' ); ?>',
					button: {
						text: '<?php esc_html_e( 'Use image', 'decibel' ); ?>'
					},
					multiple: false
				} );

				// When an image is selected, run a callback.
				sizechart_frame.on( 'select', function() {
					var attachment           = sizechart_frame.state().get( 'selection' ).first().toJSON();
					var attachment_thumbnail = attachment.sizes.thumbnail || attachment.sizes.full;

					jQuery( '#product_cat_sizechart_img_id' ).val( attachment.id );
					jQuery( '#sizechart_img' ).find( 'img' ).attr( 'src', attachment_thumbnail.url );
					jQuery( '#remove_sizechart_image_button' ).show();
				} );

				// Finally, open the modal.
				sizechart_frame.open();
			} );

			jQuery( document ).on( 'click', '#remove_sizechart_image_button', function() {
				jQuery( '#sizechart_img' ).find( 'img' ).attr( 'src', '<?php echo esc_js( wc_placeholder_img_src() ); ?>' );
				jQuery( '#product_cat_sizechart_img_id' ).val( '' );
				jQuery( '#remove_sizechart_image_button' ).hide();
				return false;
			} );

			jQuery( document ).ajaxComplete( function( event, request, options ) {
				if ( request && 4 === request.readyState && 200 === request.status
					&& options.data && 0 <= options.data.indexOf( 'action=add-tag' ) ) {

					var res = wpAjax.parseAjaxResponse( request.responseXML, 'ajax-response' );
					if ( ! res || res.errors ) {
						return;
					}
					// Clear Thumbnail fields on submit
					jQuery( '#sizechart_img' ).find( 'img' ).attr( 'src', '<?php echo esc_js( wc_placeholder_img_src() ); ?>' );
					jQuery( '#product_cat_sizechart_img_id' ).val( '' );
					jQuery( '#remove_sizechart_image_button' ).hide();
					// Clear Display type field on submit
					jQuery( '#display_type' ).val( '' );
					return;
				}
			} );

		</script>
		<div class="clear"></div>
	</div>
	<?php
}
add_action( 'product_cat_add_form_fields', 'decibel_add_category_fields', 100 );

/**
 * Edit category thumbnail field.
 *
 * @param mixed $term Term (category) being edited
 */
function decibel_edit_category_fields( $term ) {

	$sizechart_id = absint( get_term_meta( $term->term_id, 'sizechart_id', true ) );

	if ( $sizechart_id ) {
		$image = wp_get_attachment_thumb_url( $sizechart_id );
	} else {
		$image = wc_placeholder_img_src();
	}
	?>
	<tr class="form-field">
		<th scope="row" valign="top"><label><?php esc_html_e( 'Size Chart', 'decibel' ); ?></label></th>
		<td>
			<div id="sizechart_img" style="float: left; margin-right: 10px;"><img src="<?php echo esc_url( $image ); ?>" width="60px" height="60px" /></div>
			<div style="line-height: 60px;">
				<input type="hidden" id="product_cat_sizechart_img_id" name="product_cat_sizechart_img_id" value="<?php echo absint( $sizechart_id ); ?>" />
				<button type="button" id="upload_sizechart_image_button" class="upload_sizechart_image_button button"><?php esc_html_e( 'Upload/Add image', 'decibel' ); ?></button>
				<button type="button" id="remove_sizechart_image_button" class="remove_sizechart_image_button button" style="display:none;"><?php esc_html_e( 'Remove image', 'decibel' ); ?></button>
			</div>
			<script type="text/javascript">

				// Only show the "remove image" button when needed
				if ( jQuery( '#product_cat_sizechart_img_id' ).val() ) {
					jQuery( '#remove_sizechart_image_button' ).show();
				}

				// Uploading files
				var sizechart_frame;

				jQuery( document ).on( 'click', '#upload_sizechart_image_button', function( event ) {

					event.preventDefault();

					// If the media frame already exists, reopen it.
					if ( sizechart_frame ) {
						sizechart_frame.open();
						return;
					}

					// Create the media frame.
					sizechart_frame = wp.media.frames.downloadable_file = wp.media({
						title: '<?php esc_html_e( 'Choose an image', 'decibel' ); ?>',
						button: {
							text: '<?php esc_html_e( 'Use image', 'decibel' ); ?>'
						},
						multiple: false
					} );

					// When an image is selected, run a callback.
					sizechart_frame.on( 'select', function() {
						var attachment           = sizechart_frame.state().get( 'selection' ).first().toJSON();
						var attachment_thumbnail = attachment.sizes.thumbnail || attachment.sizes.full;

						jQuery( '#product_cat_sizechart_img_id' ).val( attachment.id );
						jQuery( '#sizechart_img' ).find( 'img' ).attr( 'src', attachment_thumbnail.url );
						jQuery( '#remove_sizechart_image_button' ).show();
					} );

					// Finally, open the modal.
					sizechart_frame.open();
				} );

				jQuery( document ).on( 'click', '#remove_sizechart_image_button', function() {
					jQuery( '#sizechart_img' ).find( 'img' ).attr( 'src', '<?php echo esc_js( wc_placeholder_img_src() ); ?>' );
					jQuery( '#product_cat_sizechart_img_id' ).val( '' );
					jQuery( '#remove_sizechart_image_button' ).hide();
					return false;
				} );

			</script>
			<div class="clear"></div>
		</td>
	</tr>
	<?php
}
add_action( 'product_cat_edit_form_fields', 'decibel_edit_category_fields', 100 );

/**
 * save_category_fields function.
 *
 * @param mixed  $term_id Term ID being saved
 * @param mixed  $tt_id
 * @param string $taxonomy
 */
function decibel_save_category_fields( $term_id, $tt_id = '', $taxonomy = '' ) {

	if ( isset( $_POST['product_cat_sizechart_img_id'] ) && 'product_cat' === $taxonomy ) {
		update_woocommerce_term_meta( $term_id, 'sizechart_id', absint( $_POST['product_cat_sizechart_img_id'] ) );
	}
}
add_action( 'created_term', 'decibel_save_category_fields', 10, 3 );
add_action( 'edit_term', 'decibel_save_category_fields', 10, 3 );

/**
 * Single Product Subheading
 */
function decibel_add_single_product_subheading() {

	$subheading = get_post_meta( get_the_ID(), '_post_subheading', true );

	if ( is_single() && $subheading ) {
		?>
		<div class="product-subheading">
			<?php echo sanitize_text_field( $subheading ); ?>
		</div>
		<?php
	}

}
add_action( 'woocommerce_single_product_summary', 'decibel_add_single_product_subheading', 6 );
add_action( 'wwcqv_product_summary', 'decibel_add_single_product_subheading', 6 );

/**
 * Redefine product hook
 */
function decibel_remove_loop_item_default_wc_hooks() {

	remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open' );
	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash' );
	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail' );
	remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title' );
	remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
	remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price' );
	remove_action( 'woocommerce_after_shop_loop_item', 'www_output_add_to_wishlist_button', 15 );
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart' );

	add_action( 'woocommerce_before_shop_loop_item', 'decibel_wc_loop_thumbnail', 10, 1 );
	add_action( 'woocommerce_after_shop_loop_item', 'decibel_wc_loop_summary' );
}
add_action( 'woocommerce_init', 'decibel_remove_loop_item_default_wc_hooks' );

/**
 * WC loop thumbnail
 */
function decibel_wc_loop_thumbnail( $template_args ) {

	extract(
		wp_parse_args(
			$template_args,
			array(
				'display' => '',
			)
		)
	);

	$product_thumbnail_size = ( 'metro' === $display ) ? 'decibel-metro' : 'woocommerce_thumbnail';
	$product_thumbnail_size = apply_filters( 'decibel_' . $display . '_thumbnail_size_name', $product_thumbnail_size );
	$product_thumbnail_size = ( decibel_is_gif( get_post_thumbnail_id() ) ) ? 'full' : $product_thumbnail_size;
	$product_bg_color       = get_post_meta( get_the_ID(), '_post_product_bg_color', true );
	$product_bg_color       = decibel_get_inherit_mod( 'product_bg_color' );
	// $product_bg_color = '#f1f1f1';
	?>
	<div class="product-box">
		<a class="entry-link-mask" href="<?php the_permalink(); ?>"></a>
		<div class="product-thumbnail-container clearfix">
			<?php do_action( 'decibel_product_minimal_player' ); ?>
			<?php if ( $product_bg_color ) : ?>
				<div class="product-bg-color" style="background-color:<?php echo esc_attr( $product_bg_color ); ?>"></div>
			<?php endif; ?>
			<div class="product-thumbnail-inner">
				<?php woocommerce_show_product_loop_sale_flash(); ?>
				<?php echo woocommerce_get_product_thumbnail( $product_thumbnail_size ); ?>
				<div class="product-second-thumbnail-bg-color" style="background-color:<?php echo esc_attr( $product_bg_color ); ?>"></div>
				<?php decibel_woocommerce_second_product_thumbnail( $product_thumbnail_size ); ?>

			</div><!-- .product-thumbnail-inner -->
		</div><!-- .product-thumbnail-container -->
	<?php
}

function decibel_wc_loop_summary() {
	?>
	<div class="product-summary clearfix">
		<div class="product-caption">
			<?php woocommerce_template_loop_product_link_open(); ?>

				<?php woocommerce_template_loop_product_title(); ?>
				<?php
					/**
					 * After title
					 */
					do_action( 'decibel_after_shop_loop_item_title' );
				?>
			<?php woocommerce_template_loop_product_link_close(); ?>
			<?php woocommerce_template_loop_price(); ?>
		</div>
		<div class="product-actions">
			<?php
				/**
				 * Quickview button
				 */
				do_action( 'decibel_product_quickview_button' );

				/**
				 * Wishlist button
				 */
				do_action( 'decibel_add_to_wishlist_button' );
				/**
				 * Add to cart button
				 */
				do_action( 'decibel_product_add_to_cart_button' );
			?>
		</div><!-- .product-actions -->
	</div><!-- .product-summary -->

	</div><!-- .product-box -->
	<?php
}

/**
 * Product stacked images + sticky details
 */
function decibel_single_product_sticky_layout() {

	if ( ! decibel_get_inherit_mod( 'product_sticky' ) || 'no' === decibel_get_inherit_mod( 'product_sticky' ) ) {
		return;
	}

	/* Remove default images */
	remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_images', 20 );

	global $product;

	$product_id = $product->get_id();

	echo '<div class="images">';

	woocommerce_show_product_sale_flash();
	/**
	 * If gallery
	 */
	$attachment_ids = $product->get_gallery_image_ids();

	if ( is_array( $attachment_ids ) && ! empty( $attachment_ids ) ) {

		echo '<ul>';

		if ( has_post_thumbnail( $product_id ) ) {

			$caption = get_post_field( 'post_excerpt', get_post_thumbnail_id( $post_thumbnail_id ) );
			?>
			<li class="stacked-image">
				<a class="lightbox" data-fancybox="wc-stacked-images-<?php echo absint( $product_id ); ?>" href="<?php echo get_the_post_thumbnail_url( $product_id, 'full' ); ?>" data-caption="<?php echo esc_attr( $caption ); ?>">
					<?php echo decibel_kses( $product->get_image( 'large' ) ); ?>
				</a>
			</li>
			<?php
		}

		foreach ( $attachment_ids as $attachment_id ) {
			if ( wp_attachment_is_image( $attachment_id ) ) {

				$caption = get_post_field( 'post_excerpt', $attachment_id );
				?>
				<li class="stacked-image">
					<a class="lightbox" data-fancybox="wc-stacked-images-<?php echo absint( $product_id ); ?>" href="<?php echo wp_get_attachment_url( $attachment_id, 'full' ); ?>" data-caption="<?php echo esc_attr( $caption ); ?>">
						<?php echo wp_get_attachment_image( $attachment_id, 'large' ); ?>
					</a>
				</li>
				<?php
			}
		}

		echo '</ul>';

		/**
		 * If featured image only
		 */
	} elseif ( has_post_thumbnail( $product_id ) ) {
		?>
		<span class="stacked-image">
			<a class="lightbox" data-fancybox="wc-stacked-images-<?php echo absint( $product_id ); ?>" href="<?php echo get_the_post_thumbnail_url( $product_id, 'full' ); ?>">
				<?php echo decibel_kses( $product->get_image( 'large' ) ); ?>
			</a>
		</span>
		<?php
		/**
		 * Placeholder
		 */
	} else {

		$html  = '<span class="woocommerce-product-gallery__image--placeholder">';
		$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src() ), esc_html__( 'Awaiting product image', 'decibel' ) );
		$html .= '</span>';

		echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $attachment_id );
	}

	echo '</div>';
}
add_action( 'woocommerce_before_single_product_summary', 'decibel_single_product_sticky_layout' );

add_action(
	'woocommerce_before_quantity_input_field',
	function() {
		echo '<span class="wt-quantity-plus"></span>';
	}
);

add_action(
	'woocommerce_after_quantity_input_field',
	function() {
		echo '<span class="wt-quantity-minus"></span>';
	}
);

/**
 * Filter WC tab
 *
 * Replace tabs by accordion
 */
function decibel_filter_wc_tabs( $markup, $tabs ) {
	if ( ! empty( $tabs ) ) :
		?>
		<?php ob_start(); ?>
		<div class="woocommerce-tabs">
			<div id="wvc-wc-accordion" class="wvc-accordion tabs-container">
				<?php
				$link_class = '';
				$i = 0;
				foreach ( $tabs as $key => $tab ) {
					if ( 2 === $i ) {
						$link_class = 'review-accordion-link';
					}
				?>
					<h2 class="wvc-accordion-tab"><a href="#" class="<?php echo esc_attr( $link_class ); ?>"><span class="wvc-at-title-container"><span class="wvc-at-title-text"><?php echo apply_filters( 'woocommerce_product_' . $key . '_tab_title', esc_html( $tab['title'] ), $key ); ?></span></span></a></h2>
					<div class="wvc-clearfix" ><div class="wbp_wrapper"><?php call_user_func( $tab['callback'], $key, $tab ); ?>
					</div><!--.wbp_wrapper--></div><!--.wvc-text-block-->
				<?php
				$i++;
				} ?>
			</div>
		</div>
		<?php
	endif;
	return ob_get_clean();
}
add_filter( 'decibel_wc_tabs', 'decibel_filter_wc_tabs', 10, 2 );

/**
 * Overwrite post types menu order
 *
 * @param array  $args
 * @param string $post_type
 * @return array $args
 */
function decibel_overwrite_post_type_menu_order( $args, $post_type ) {

	if ( 'release' === $post_type ) {

		$args['menu_position'] = 5.1;
	}

	if ( 'event' === $post_type ) {

		$args['menu_position'] = 5.2;
	}

	if ( 'video' === $post_type ) {

		$args['menu_position'] = 5.3;
	}

	if ( 'work' === $post_type ) {

		$args['menu_position'] = 5.4;
	}

	if ( 'wpm_playlist' === $post_type ) {

		$args['menu_position'] = 35;
	}

	if ( 'wvc_content_block' === $post_type ) {

		$args['menu_position'] = 40;
	}

	return $args;
}
add_filter( 'register_post_type_args', 'decibel_overwrite_post_type_menu_order', 99, 2 );

/**
 * Reorder admin menu
 */
function custom_menu_order( $menu_ord ) {
	if ( ! $menu_ord ) {
		return true;
	}

	return $menu_ord;
}

add_filter( 'custom_menu_order', 'custom_menu_order' );
add_filter( 'menu_order', 'custom_menu_order' );


/*
--------------------------------------------------------------------

	PLUGIN SETTINGS

----------------------------------------------------------------------
*/

/**
 * Set portfolio template folder
 */
function decibel_set_portfolio_template_url( $template_url ) {

	return decibel_get_template_url() . '/portfolio/';
}
add_filter( 'wolf_portfolio_template_url', 'decibel_set_portfolio_template_url' );

/**
 * Add custom fields in work meta
 */
add_action(
	'decibel_work_meta',
	function() {
		decibel_the_work_meta();
	},
	15
);

add_filter(
	'decibel_work_meta_separator',
	function() {
		return ' : ';
	}
);

/**
 * Set videos template folder
 */
function decibel_set_videos_template_url( $template_url ) {

	return decibel_get_template_url() . '/videos/';
}
add_filter( 'wolf_videos_template_url', 'decibel_set_videos_template_url' );

/**
 * Set video display
 *
 * @param string $string
 * @return string
 */
function decibel_set_video_display( $string ) {

	return 'grid';
}
add_filter( 'decibel_mod_video_display', 'decibel_set_video_display', 44 );

/**
 * Set discography template folder
 */
function decibel_set_discography_template_url( $template_url ) {

	return decibel_get_template_url() . '/discography/';
}
add_filter( 'wolf_discography_template_url', 'decibel_set_discography_template_url' );
add_filter( 'wolf_discography_url', 'decibel_set_discography_template_url' );

/**
 * Rewrite band taxonomy slug
 *
 * @param array  $args Array of taxonomy arguments.
 * @param string $taxonomy The taxonomy slug.
 * @return array
 */
function decibel_change_band_taxonomies_slug( $args, $taxonomy ) {
	if ( 'band' === $taxonomy ) {
		$args['rewrite']['slug'] = 'artist-releases';
	}
	return $args;
}
add_filter( 'register_taxonomy_args', 'decibel_change_band_taxonomies_slug', 10, 2 );

/**
 * Rewrite band taxonomy slug
 *
 * @param array  $args Array of taxonomy arguments.
 * @param string $taxonomy The taxonomy slug.
 * @return array
 */
function decibel_band_url_rewrite() {
	add_rewrite_rule( '^artist-releases/([^/]*)$', 'index.php?band=$matches[1]', 'top' );
	flush_rewrite_rules();
}
add_action( 'admin_init', 'decibel_band_url_rewrite' );

/**
 * Set events template folder
 */
function decibel_set_events_template_url( $template_url ) {

	return decibel_get_template_url() . '/events/';
}
add_filter( 'wolf_events_template_url', 'decibel_set_events_template_url' );

/*
--------------------------------------------------------------------

	MODS

----------------------------------------------------------------------
*/

/**
 * Remove unused mods
 *
 * @param array $mods The default mods.
 * @return void
 */
function decibel_remove_mods( $mods ) {

	// Unset

	unset( $mods['layout']['options']['button_style'] );
	// unset( $mods['layout']['options']['site_layout'] );

	unset( $mods['fonts']['options']['body_font_size'] );

	unset( $mods['wolf_videos']['options']['video_display'] );

	unset( $mods['shop']['options']['product_display'] );

	unset( $mods['navigation']['options']['menu_skin'] );

	unset( $mods['header_settings']['options']['hero_scrolldown_arrow'] );

	unset( $mods['navigation']['options']['menu_layout']['choices']['offcanvas'] );

	// unset( $mods['navigation']['options']['menu_sticky_type']['choices']['soft'] );

	// unset( $mods['navigation']['options']['side_panel_position'] );

	// unset( $mods['blog']['options']['post_display'] );

	return $mods;
}
add_filter( 'decibel_customizer_mods', 'decibel_remove_mods', 20 );

/**
 * Spinners folder
 */
add_filter(
	'decibel_spinners_folder',
	function() {
		return decibel_get_template_dirname() . '/components/spinners/';
	}
);

/**
 * Add mods
 */
function decibel_add_mods( $mods ) {

	$color_scheme = decibel_get_color_scheme();

	$mods['layout']['options']['wrapper_width'] = array(
		'id'      => 'wrapper_width',
		'label'   => esc_html__( 'Wrapper Width', 'decibel' ),
		'type'    => 'select',
		'choices' => array(
			1400 => esc_html__( 'Large (1400px)', 'decibel' ),
			1140 => esc_html__( 'Small (1140px)', 'decibel' ),
		),
	);

	$mods['navigation']['options']['menu_hover_style'] = array(
		'id'        => 'menu_hover_style',
		'label'     => esc_html__( 'Menu Hover effect', 'decibel' ),
		'type'      => 'select',
		'choices'   => apply_filters(
			'decibel_main_menu_hover_style_options',
			array(
				'none'        => esc_html__( 'None', 'decibel' ),
				'opacity'     => esc_html__( 'Opacity', 'decibel' ),
				'd-underline' => esc_html__( 'Underline', 'decibel' ),
			)
		),
		'transport' => 'postMessage',
	);

	$mods['navigation']['options']['sticky_menu_transparent'] = array(
		'label' => esc_html__( 'Transparent Sticky Menu', 'decibel' ),
		'id'    => 'sticky_menu_transparent',
		'type'  => 'checkbox',
	);

	$mods['loading'] = array(

		'id'      => 'loading',
		'title'   => esc_html__( 'Loading', 'decibel' ),
		'icon'    => 'update',
		'options' => array(

			array(
				'label'   => esc_html__( 'Loading Animation Type', 'decibel' ),
				'id'      => 'loading_animation_type',
				'type'    => 'select',
				'choices' => array(
					'none'             => esc_html__( 'None', 'decibel' ),
					'overlay'          => esc_html__( 'Simple Overlay', 'decibel' ),
					'logo'             => esc_html__( 'Overlay with Logo', 'decibel' ),
					'spinner-loader1'  => esc_html__( 'Rotating plane', 'decibel' ),
					'spinner-loader2'  => esc_html__( 'Double Pulse', 'decibel' ),
					'spinner-loader3'  => esc_html__( 'Wave', 'decibel' ),
					'spinner-loader4'  => esc_html__( 'Wandering cubes', 'decibel' ),
					'spinner-loader5'  => esc_html__( 'Pulse', 'decibel' ),
					'spinner-loader6'  => esc_html__( 'Chasing dots', 'decibel' ),
					'spinner-loader7'  => esc_html__( 'Three bounce', 'decibel' ),
					'spinner-loader8'  => esc_html__( 'Circle', 'decibel' ),
					'spinner-loader9'  => esc_html__( 'Cube grid', 'decibel' ),
					'spinner-loader10' => esc_html__( 'Classic Loader', 'decibel' ),
					'spinner-loader11' => esc_html__( 'Folding cube', 'decibel' ),
					'spinner-loader12' => esc_html__( 'Ball Pulse', 'decibel' ),
					'spinner-loader13' => esc_html__( 'Ball Grid Pulse', 'decibel' ),
					'spinner-loader15' => esc_html__( 'Ball Clip Rotate Pulse', 'decibel' ),
					'spinner-loader16' => esc_html__( 'Ball Clip Rotate Pulse Multiple', 'decibel' ),
					'spinner-loader17' => esc_html__( 'Ball Pulse Rise', 'decibel' ),
					'spinner-loader19' => esc_html__( 'Ball Zigzag', 'decibel' ),
					'spinner-loader20' => esc_html__( 'Ball Zigzag Deflect', 'decibel' ),
					'spinner-loader21' => esc_html__( 'Ball Triangle Path', 'decibel' ),
					'spinner-loader22' => esc_html__( 'Ball Scale', 'decibel' ),
					'spinner-loader23' => esc_html__( 'Ball Line Scale', 'decibel' ),
					'spinner-loader24' => esc_html__( 'Ball Line Scale Party', 'decibel' ),
					'spinner-loader25' => esc_html__( 'Ball Scale Multiple', 'decibel' ),
					'spinner-loader26' => esc_html__( 'Ball Pulse Sync', 'decibel' ),
					'spinner-loader27' => esc_html__( 'Ball Beat', 'decibel' ),
					'spinner-loader28' => esc_html__( 'Ball Scale Ripple Multiple', 'decibel' ),
					'spinner-loader29' => esc_html__( 'Ball Spin Fade Loader', 'decibel' ),
					'spinner-loader30' => esc_html__( 'Line Spin Fade Loader', 'decibel' ),
					'spinner-loader31' => esc_html__( 'Pacman', 'decibel' ),
					'spinner-loader32' => esc_html__( 'Ball Grid Beat ', 'decibel' ),
				),
			),

			'loading_logo' => array(
				'id'          => 'loading_logo',
				'description' => esc_html__( 'The loading animation will be disabled if you upload a loading logo.', 'decibel' ),
				'label'       => esc_html__( 'Optional Loading Logo', 'decibel' ),
				'type'        => 'image',
			),

			array(
				'label'   => esc_html__( 'Loading Logo Animation', 'decibel' ),
				'id'      => 'loading_logo_animation',
				'type'    => 'select',
				'choices' => array(
					'none'  => esc_html__( 'None', 'decibel' ),
					'pulse' => esc_html__( 'Pulse', 'decibel' ),
				),
			),
		),
	);

	$mods['blog']['options']['post_skin'] = array(
		'label'   => esc_html__( 'Color Tone in Loop', 'decibel' ),
		'id'      => 'post_skin',
		'type'    => 'select',
		'choices' => array(
			'dark'  => esc_html__( 'Dark', 'decibel' ),
			'light' => esc_html__( 'Light', 'decibel' ),
		),
	);

	$mods['blog']['options']['single_post_nav'] = array(
		'label'   => esc_html__( 'Prev/Next Post Pagination', 'decibel' ),
		'id'      => 'single_post_nav',
		'type'    => 'select',
		'choices' => array(
			'yes' => esc_html__( 'Yes', 'decibel' ),
			'no'  => esc_html__( 'No', 'decibel' ),
		),
	);

	$mods['blog']['options']['single_post_nav'] = array(
		'label'   => esc_html__( 'Prev/Next Post Pagination', 'decibel' ),
		'id'      => 'single_post_nav',
		'type'    => 'select',
		'choices' => array(
			'yes' => esc_html__( 'Yes', 'decibel' ),
			'no'  => esc_html__( 'No', 'decibel' ),
		),
	);

	$mods['blog']['options']['date_format'] = array(
		'label'   => esc_html__( 'Date Format', 'decibel' ),
		'id'      => 'date_format',
		'type'    => 'select',
		'choices' => array(
			''           => esc_html__( 'Default', 'decibel' ),
			'human_diff' => esc_html__( '"X Time ago"', 'decibel' ),
		// 'custom' => esc_html__( 'Calendar Syle', 'decibel' ),
		),
	);

	$mods['blog']['options']['post_hero_layout'] = array(
		'label'   => esc_html__( 'Single Post Header Layout', 'decibel' ),
		'id'      => 'post_hero_layout',
		'type'    => 'select',
		'choices' => array(
			''           => esc_html__( 'Default', 'decibel' ),
			'standard'   => esc_html__( 'Standard', 'decibel' ),
			'big'        => esc_html__( 'Big', 'decibel' ),
			'small'      => esc_html__( 'Small', 'decibel' ),
			'fullheight' => esc_html__( 'Full Height', 'decibel' ),
			'none'       => esc_html__( 'No header', 'decibel' ),
		),
	);

	$mods['blog']['options']['hide_single_post_featured_image'] = array(
		'label' => esc_html__( 'Hide Featured Image in Post', 'decibel' ),
		'id'    => 'hide_single_post_featured_image',
		'type'  => 'checkbox',
	);

	/*
	$mods['navigation']['options']['menu_sticky_type'] = array(
			'label'	=> esc_html__( 'Sticky Menu', 'decibel' ),
			'id'	=> 'menu_sticky_type',
			'type'	=> 'select',
			'choices' => array(
				'none' => esc_html__( 'Disabled', 'decibel' ),
				'hard' => esc_html__( 'Enabled', 'decibel' ),
			),
			'transport' => 'postMessage',
		);*/

	$mods['navigation']['options']['mega_menu_bg_img'] = array(
		'label' => esc_html__( 'Mega Menu Background', 'decibel' ),
		'id'    => 'mega_menu_bg_img',
		'type'  => 'image',
	);

	$mods['navigation']['options']['side_panel_bg_img'] = array(
		'label' => esc_html__( 'Side Panel Background', 'decibel' ),
		'id'    => 'side_panel_bg_img',
		'type'  => 'image',
	);

	$mods['navigation']['options']['nav_player_mp3'] = array(
		'label' => esc_html__( 'Add a minimalist player to the navbar', 'decibel' ),
		'id'    => 'nav_player_mp3',
		'type'  => 'media',
	);

	$mods['navigation']['options']['show_nav_player'] = array(
		'label'   => esc_html__( 'Show Navigation Player by Default', 'decibel' ),
		'id'      => 'show_nav_player',
		'type'    => 'select',
		'choices' => array(
			''    => esc_html__( 'No', 'decibel' ),
			'yes' => esc_html__( 'Yes', 'decibel' ),
		),
	);

	$mods['navigation']['options']['overlay_menu_bg_img'] = array(
		'label' => esc_html__( 'Overlay Menu Background', 'decibel' ),
		'id'    => 'overlay_menu_bg_img',
		'type'  => 'image',
	);

	// $mods['navigation']['options']['mobile_menu_bg_img'] = array(
	// 'label' => esc_html__( 'Mobile Menu Background', 'decibel' ),
	// 'id'    => 'mobile_menu_bg_img',
	// 'type'  => 'image',
	// );

	// $mods['navigation']['options']['menu_offset'] = array(
	// 'id' => 'menu_offset',
	// 'label' => esc_html__( 'Menu Offset Top', 'decibel' ),
	// 'type' => 'text',
	// 'placeholder' => 400,
	// 'description' => sprintf( decibel_kses( __( 'Enter %s to display the navbar at the bottom of the screen', 'decibel' ) ), '100%' ),
	// );

	if ( isset( $mods['wolf_videos'] ) ) {

		$mods['wolf_videos']['options']['video_hero_layout'] = array(
			'label'   => esc_html__( 'Single Video Header Layout', 'decibel' ),
			'id'      => 'video_hero_layout',
			'type'    => 'select',
			'choices' => array(
				''           => esc_html__( 'Default', 'decibel' ),
				'standard'   => esc_html__( 'Standard', 'decibel' ),
				'big'        => esc_html__( 'Big', 'decibel' ),
				'small'      => esc_html__( 'Small', 'decibel' ),
				'fullheight' => esc_html__( 'Full Height', 'decibel' ),
				'none'       => esc_html__( 'No header', 'decibel' ),
			),
		);

		$mods['wolf_videos']['options']['video_category_filter'] = array(
			'id'    => 'video_category_filter',
			'label' => esc_html__( 'Category filter (not recommended with a lot of videos)', 'decibel' ),
			'type'  => 'checkbox',
		);

		$mods['wolf_videos']['options']['products_per_page'] = array(
			'label' => esc_html__( 'Videos per Page', 'decibel' ),
			'id'    => 'videos_per_page',
			'type'  => 'text',
		);

		$mods['wolf_videos']['options']['video_pagination'] = array(
			'id'      => 'video_pagination',
			'label'   => esc_html__( 'Video Archive Pagination', 'decibel' ),
			'type'    => 'select',
			'choices' => array(
				'standard_pagination' => esc_html__( 'Numeric Pagination', 'decibel' ),
				// 'ajax_pagination' => esc_html__( 'AJAX Pagination', 'decibel' ),
				'load_more'           => esc_html__( 'Load More Button', 'decibel' ),
				// 'infinitescroll' => esc_html__( 'Infinite Scroll', 'decibel' ),
			),
		);

		$mods['wolf_videos']['options']['video_display_elements'] = array(
			'id'          => 'video_display_elements',
			'label'       => esc_html__( 'Post meta to show in single video page', 'decibel' ),
			'type'        => 'group_checkbox',
			'choices'     => array(
				'show_date'       => esc_html__( 'Date', 'decibel' ),
				'show_author'     => esc_html__( 'Author', 'decibel' ),
				'show_category'   => esc_html__( 'Category', 'decibel' ),
				'show_tags'       => esc_html__( 'Tags', 'decibel' ),
				'show_extra_meta' => esc_html__( 'Extra Meta', 'decibel' ),
			),
			'description' => esc_html__( 'Note that some options may be ignored depending on the post display.', 'decibel' ),
		);

		if ( class_exists( 'Wolf_Custom_Post_Meta' ) ) {

			$mods['wolf_videos']['options'][] = array(
				'label'   => esc_html__( 'Enable Custom Post Meta', 'decibel' ),
				'id'      => 'video_enable_custom_post_meta',
				'type'    => 'group_checkbox',
				'choices' => array(
					'video_enable_views' => esc_html__( 'Views', 'decibel' ),
					'video_enable_likes' => esc_html__( 'Likes', 'decibel' ),
				),
			);
		}
	}

	if ( isset( $mods['wolf_events'] ) ) {
		$mods['wolf_events']['options']['event_skin'] = array(
			'label'   => esc_html__( 'Color Tone in Loop', 'decibel' ),
			'id'      => 'event_skin',
			'type'    => 'select',
			'choices' => array(
				'dark'  => esc_html__( 'Dark', 'decibel' ),
				'light' => esc_html__( 'Light', 'decibel' ),
			),
			// 'transport' => 'postMessage',
		);
	}

	if ( isset( $mods['portfolio'] ) ) {
		$mods['portfolio']['options']['work_skin'] = array(
			'label'   => esc_html__( 'Color Tone in Loop', 'decibel' ),
			'id'      => 'work_skin',
			'type'    => 'select',
			'choices' => array(
				'dark'  => esc_html__( 'Dark', 'decibel' ),
				'light' => esc_html__( 'Light', 'decibel' ),
			),
			// 'transport' => 'postMessage',
		);
		$mods['portfolio']['options']['work_hero_layout'] = array(
			'label'   => esc_html__( 'Single Work Header Layout', 'decibel' ),
			'id'      => 'work_hero_layout',
			'type'    => 'select',
			'choices' => array(
				''           => esc_html__( 'Default', 'decibel' ),
				'standard'   => esc_html__( 'Standard', 'decibel' ),
				'big'        => esc_html__( 'Big', 'decibel' ),
				'small'      => esc_html__( 'Small', 'decibel' ),
				'fullheight' => esc_html__( 'Full Height', 'decibel' ),
				'none'       => esc_html__( 'No header', 'decibel' ),
			),
			// 'transport' => 'postMessage',
		);
	}

	if ( isset( $mods['shop'] ) && class_exists( 'WooCommerce' ) ) {

		/*
		$mods['shop']['options']['product_skin'] = array(
			'label'	=> esc_html__( 'Color Tone in Loop', 'decibel' ),
			'id'	=> 'product_skin',
			'type'	=> 'select',
			'choices' => array(
				'dark' => esc_html__( 'Dark', 'decibel' ),
				'light' => esc_html__( 'Light', 'decibel' ),
			),
			//'transport' => 'postMessage',
		);*/

		$mods['shop']['options']['product_bg_color'] = array(
			'label'       => esc_html__( 'Product Background Color', 'decibel' ),
			'id'          => 'product_bg_color',
			'type'        => 'color',
			'description' => esc_html__( 'Background color of the post in the loop. You can use this option if your product image is a image in PNG format with a transparent background.', 'decibel' ),
			// 'transport' => 'postMessage',
		);

		$mods['shop']['options']['product_sticky'] = array(
			'label'       => esc_html__( 'Stacked Images with Sticky Product Details', 'decibel' ),
			'id'          => 'product_sticky',
			'type'        => 'checkbox',
			'description' => esc_html__( 'Not compatible with sidebar layouts.', 'decibel' ),
		);
	}

	if ( isset( $mods['wolf_discography'] ) ) {

		$mods['wolf_discography']['options']['release_hover_effect'] = array(
			'label'       => esc_html__( 'Release Hover Effect', 'decibel' ),
			'id'          => 'release_hover_effect',
			'type'        => 'select',
			'choices'     => array_flip( decibel_get_hover_effects() ),
			'description' => esc_html__( 'The default hover effect on archive pages.', 'decibel' ),
		);
	}

	if ( isset( $mods['wolf_albums'] ) ) {

		$mods['wolf_albums']['options']['gallery_hover_effect'] = array(
			'label'       => esc_html__( 'Album Hover Effect', 'decibel' ),
			'id'          => 'gallery_hover_effect',
			'type'        => 'select',
			'choices'     => array_flip( decibel_get_hover_effects() ),
			'description' => esc_html__( 'The default hover effect on archive pages.', 'decibel' ),
		);
	}

	return $mods;
}
add_filter( 'decibel_customizer_mods', 'decibel_add_mods', 40 );

/*
--------------------------------------------------------------------

	CUSTOM FUNCTIONS

----------------------------------------------------------------------
*/

/**
 * Custom calendar date format
 */
function decibel_custom_date( $date = '' ) {

	$date = ( $date ) ? $date : get_the_date( 'Y/m/d' );

	list( $year, $monthnbr, $day ) = explode( '/', $date );
	$search                        = array( '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12' );
	$replace                       = array( esc_html__( 'Jan', 'decibel' ), esc_html__( 'Feb', 'decibel' ), esc_html__( 'Mar', 'decibel' ), esc_html__( 'Apr', 'decibel' ), esc_html__( 'May', 'decibel' ), esc_html__( 'Jun', 'decibel' ), esc_html__( 'Jul', 'decibel' ), esc_html__( 'Aug', 'decibel' ), esc_html__( 'Sep', 'decibel' ), esc_html__( 'Oct', 'decibel' ), esc_html__( 'Nov', 'decibel' ), esc_html__( 'Dec', 'decibel' ) );
	$month                         = str_replace( $search, $replace, $monthnbr );

	$output = '<div class="date-format-custom wvc-bigtext"><span class="custom-date-day">' . $day . '</span><span class="custom-date-month">' . $month . '</span>';

	if ( 1 < absint( date( 'Y' ) ) - $year ) {
		$output .= '<span class="custom-date-year">' . $year . '</span>';
	}

	$output .= '</div>';

	return $output;
}

/*
--------------------------------------------------------------------

	DEFAULT MODS & SETTINGS

----------------------------------------------------------------------
*/

/**
 *  Set default icon font
 *
 * @param string $shape
 * @return string $shape
 */
function decibel_set_default_icon_font( $shape ) {
	return 'ionicons';
}
// add_filter( 'wvc_default_icon_font', 'decibel_set_default_icon_font', 40 );

/**
 *  Set default item overlay color
 *
 * @param string $color
 * @return string $color
 */
function decibel_set_default_item_overlay_color( $color ) {
	return 'white';
}
add_filter( 'wvc_default_item_overlay_color', 'decibel_set_default_item_overlay_color' );

/**
 *  Set default item overlay text color
 *
 * @param string $color
 * @return string $color
 */
function decibel_set_item_overlay_text_color( $color ) {
	return 'darkgrey';
}
add_filter( 'wvc_default_item_overlay_text_color', 'decibel_set_item_overlay_text_color', 10 );


// add_filter( 'wvc_release_overlay_text_color', function() {
// return null;
// } );

/**
 *  Set default item overlay opacity
 *
 * @param int $color
 * @return int $color
 */
function decibel_set_item_overlay_opacity( $opacity ) {
	return 70;
}
add_filter( 'wvc_default_item_overlay_opacity', 'decibel_set_item_overlay_opacity' );

/**
 * Excerpt length hook
 * Set the number of character to display in the excerpt
 *
 * @param int $length
 * @return int
 */
function decibel_overwrite_excerpt_length( $length ) {

	return 23;
}
add_filter( 'decibel_excerpt_length', 'decibel_overwrite_excerpt_length' );

/**
 *  Set menu skin
 *
 * @param string $skin
 * @return string $skin
 */
function decibel_set_menu_skin( $skin ) {
	return 'light';
}
// add_filter( 'decibel_mod_menu_skin', 'decibel_set_menu_skin', 40 );

/**
 * Excerpt length hook
 * Set the number of character to display in the excerpt
 *
 * @param int $length
 * @return int
 */
function decibel_overwrite_sticky_menu_height( $length ) {

	return 66;
}
add_filter( 'decibel_sticky_menu_height', 'decibel_overwrite_sticky_menu_height' );

/**
 * Standard row width
 */
add_filter(
	'wvc_row_standard_width',
	function( $string ) {
		return '1400px';
	},
	40
);

/**
 * Small width
 */
add_filter(
	'wvc_row_small_width',
	function( $string ) {

		$string = '960px';

		if ( 1140 === decibel_get_inherit_mod( 'wrapper_width' ) ) {
			$string = '750px';
		}

		return $string;
	},
	40
);

/**
 * Load more pagination hash change
 */
add_filter(
	'decibel_loadmore_pagination_hashchange',
	function( $size ) {
		return false;
	},
	40
);

add_filter(
	'decibel_load_more_posts_text',
	function( $text ) {
		return esc_html__( 'load More', 'decibel' );
	},
	40
);

/**
 *  Set embed video title
 *
 * @param string $title
 * @return string $title
 */
function wvc_set_embed_video_title( $title ) {

	return esc_html__( '&mdash; %s', 'decibel' );
}
add_filter( 'wvc_embed_video_title', 'wvc_set_embed_video_title', 40 );

/**
 *  Set embed video title
 *
 * @param string $title
 * @return string $title
 */
function decibel_set_default_video_opener_button( $title ) {

	return '<span class="video-opener" data-aos="fade" data-aos-once="true"></span>';
}
add_filter( 'wvc_default_video_opener_button', 'decibel_set_default_video_opener_button', 40 );

/**
 *  Set default pie chart line width
 *
 * @param string $width
 * @return string $width
 */
function wvc_set_default_pie_chart_line_width( $width ) {
	return 5;
}
add_filter( 'wvc_default_pie_chart_line_width', 'wvc_set_default_pie_chart_line_width', 40 );



/**
 *  Set default button shape
 *
 * @param string $shape
 * @return string $shape
 */
function decibel_set_default_wvc_button_shape( $shape ) {
	return 'boxed';
}
add_filter( 'wvc_default_button_shape', 'decibel_set_default_wvc_button_shape', 40 );

/**
 *  Set default button shape
 *
 * @param string $shape
 * @return string $shape
 */
function decibel_set_default_theme_button_shape( $shape ) {
	return 'square';
}
add_filter( 'decibel_mod_button_style', 'decibel_set_default_theme_button_shape', 40 );

/**
 * Default font weight
 */
add_filter(
	'wvc_button_default_font_weight',
	function( $font_weight ) {
		return 700;
	}
);

/**
 *  Set default team member title font size
 *
 * @param string $font_size
 * @return string $font_size
 */
function wvc_set_default_team_member_font_size( $font_size ) {
	return 18;
}
add_filter( 'wvc_default_team_member_title_font_size', 'wvc_set_default_team_member_font_size', 40 );
add_filter( 'wvc_default_single_image_title_font_size', 'wvc_set_default_team_member_font_size', 40 );

/**
 *  Set default team member text align
 *
 * @param string $string
 * @return string $string
 */
function wvc_set_default_team_member_text_alignement( $string ) {
	return 'center';
}
add_filter( 'wvc_default_team_member_text_alignement', 'wvc_set_default_team_member_text_alignement', 40 );

/**
 *  Set default team member v align
 *
 * @param string $string
 * @return string $string
 */
function wvc_set_default_team_member_text_vertical_alignement( $string ) {

	return 'bottom';
}
add_filter( 'wvc_default_team_member_text_vertical_alignement', 'wvc_set_default_team_member_text_vertical_alignement', 40 );

/**
 *  Set default heading layout
 *
 * @param string $layout
 * @return string $layout
 */
function wvc_set_default_team_member_layout( $layout ) {
	return 'standard';
}
add_filter( 'wvc_default_team_member_layout', 'wvc_set_default_team_member_layout', 40 );

/**
 *  Set default heading font size
 *
 * @param int $font_size
 * @return int $font_size
 */
function wvc_set_default_custom_heading_font_size( $font_size ) {
	return 32;
}
add_filter( 'wvc_default_custom_heading_font_size', 'wvc_set_default_custom_heading_font_size', 40 );
add_filter( 'wvc_default_advanced_slide_title_font_size', 'wvc_set_default_custom_heading_font_size', 40 );

/**
 *  Set default heading font family
 *
 * @param string $font_family
 * @return string $font_family
 */
function decibel_set_default_custom_heading_font_family( $font_family ) {
	return 'Oswald';
}
add_filter( 'wvc_default_bigtext_font_family', 'decibel_set_default_custom_heading_font_family', 40 );
// add_filter( 'wvc_default_advanced_slide_title_font_family', 'decibel_set_default_custom_heading_font_family', 40 );
// add_filter( 'wvc_default_custom_heading_font_family', 'decibel_set_default_custom_heading_font_family', 40 );
// add_filter( 'wvc_default_cta_font_family', 'decibel_set_default_custom_heading_font_family', 40 );

/**
 *  Set default heading font weight
 *
 * @param string $font_weight
 * @return string $font_weight
 */
function decibel_set_default_custom_heading_font_weight( $font_weight ) {
	return '';
}
add_filter( 'wvc_default_advanced_slide_title_font_weight', 'decibel_set_default_custom_heading_font_weight', 40 );
add_filter( 'wvc_default_custom_heading_font_weight', 'decibel_set_default_custom_heading_font_weight', 40 );
add_filter( 'wvc_default_bigtext_font_weight', 'decibel_set_default_custom_heading_font_weight', 40 );
add_filter( 'wvc_default_cta_font_weight', 'decibel_set_default_custom_heading_font_weight', 40 );
add_filter( 'wvc_default_pie_font_weight', 'decibel_set_default_custom_heading_font_weight', 40 );

/**
 *  Set default heading font size
 *
 * @param string $font_size
 * @return string $font_size
 */
function wvc_set_default_cta_font_size( $font_size ) {
	return 22;
}
add_filter( 'wvc_default_cta_font_size', 'wvc_set_default_cta_font_size', 40 );

/**
 * Post Slider color tone
 */
function decibel_add_post_slider_color_block() {
	?>
	<div class="wvc-big-slide-color-block" style="background-color:<?php echo wvc_color_brightness( wvc_get_image_dominant_color( get_post_thumbnail_id() ), 10 ); ?>"></div>
	<?php
}
add_action( 'wvc_post_big_slide_start', 'decibel_add_post_slider_color_block' );

/*
--------------------------------------------------------------------

	BUTTONS

----------------------------------------------------------------------
*/

/**
 * Custom button types
 */
function decibel_custom_button_types() {
	return array(
		esc_html__( 'Default', 'decibel' )            => 'default',
		esc_html__( 'Special Accent', 'decibel' )     => 'decibel-button-special-accent',
		esc_html__( 'Solid Accent', 'decibel' )       => 'decibel-button-solid-accent',
		esc_html__( 'Outline Accent', 'decibel' )     => 'decibel-button-outline-accent',
		esc_html__( 'Simple Text Accent', 'decibel' ) => 'decibel-button-text-accent',
		esc_html__( 'Special', 'decibel' )            => 'decibel-button-special',
		esc_html__( 'Solid', 'decibel' )              => 'decibel-button-solid',
		esc_html__( 'Outline', 'decibel' )            => 'decibel-button-outline',
		esc_html__( 'Simple Text', 'decibel' )        => 'decibel-button-text',
		// esc_html__( 'Simple Text Alt', 'decibel' ) => 'decibel-button-simple-alt',
	);
}

/**
 * Primary Special buttons class
 *
 * @param string $string
 * @return string
 */
function decibel_set_primary_special_button_class( $class ) {

	$decibel_button_class = 'decibel-button-solid';

	$class = $decibel_button_class . ' wvc-button wvc-button-size-sm';

	return $class;
}
add_filter( 'wvc_last_posts_big_slide_button_class', 'decibel_set_primary_special_button_class' );

/**
 * Primary Special buttons class
 *
 * @param string $string
 * @return string
 */
function decibel_set_primary_special_button_outline( $class ) {

	$decibel_button_class = 'decibel-button-text';

	$class = $decibel_button_class . ' wvc-button wvc-button-size-sm';

	return $class;
}
add_filter( 'decibel_loadmore_button_class', 'decibel_set_primary_special_button_outline' );

/**
 * Primary Outline buttons class
 *
 * @param string $string
 * @return string
 */
function decibel_set_primary_button_class( $class ) {

	$decibel_button_class = 'decibel-button-solid';

	$class = $decibel_button_class . ' wvc-button wvc-button-size-sm';

	return $class;
}
add_filter( 'decibel_404_button_class', 'decibel_set_primary_button_class' );
add_filter( 'decibel_single_event_buy_ticket_button_class', 'decibel_set_primary_button_class' );

/**
 * Event ticket button class
 *
 * @param string $string
 * @return string
 */
function decibel_set_single_add_to_cart_button_class( $class ) {

	$class = 'single_add_to_cart_button button decibel-button-solid-accent';

	return $class;
}
add_filter( 'decibel_single_add_to_cart_button_class', 'decibel_set_single_add_to_cart_button_class', 40 );

/**
 * Main buttons class
 *
 * @param string $string
 * @return string
 */
function decibel_set_alt_button_class( $class ) {

	$decibel_button_class = 'decibel-button-solid-accent';

	$class = $decibel_button_class . ' wvc-button wvc-button-size-xs';

	return $class;
}
add_filter( 'decibel_release_button_class', 'decibel_set_alt_button_class' );

/**
 * Text buttons class
 *
 * @param string $string
 * @return string
 */
function decibel_set_more_link_button_class( $class ) {

	$decibel_button_class = 'decibel-button-text';

	$class = $decibel_button_class . ' wvc-button wvc-button-size-sm';

	return $class;
}
add_filter( 'decibel_more_link_button_class', 'decibel_set_more_link_button_class' );
add_filter( 'wvc_showcase_vertical_carousel_button_class', 'decibel_set_more_link_button_class' );

/**
 * Author box buttons class
 *
 * @param string $string
 * @return string
 */
function decibel_set_author_box_button_class( $class ) {

	$class = ' wvc-button wvc-button-size-xs decibel-button-text';

	return $class;
}
add_filter( 'decibel_author_page_link_button_class', 'decibel_set_author_box_button_class' );

/**
 * Add button dependencies
 */
function decibel_add_button_dependency_params() {

	if ( ! class_exists( 'WPBMap' ) || ! class_exists( 'Wolf_Visual_Composer' ) || ! defined( 'WVC_OK' ) || ! WVC_OK ) {
		return;
	}

	$param               = WPBMap::getParam( 'vc_button', 'color' );
	$param['dependency'] = array(
		'element' => 'button_type',
		'value'   => 'default',
	);
	vc_update_shortcode_param( 'vc_button', $param );

	$param               = WPBMap::getParam( 'vc_button', 'shape' );
	$param['dependency'] = array(
		'element' => 'button_type',
		'value'   => 'default',
	);
	vc_update_shortcode_param( 'vc_button', $param );

	$param               = WPBMap::getParam( 'vc_button', 'hover_effect' );
	$param['dependency'] = array(
		'element' => 'button_type',
		'value'   => 'default',
	);
	vc_update_shortcode_param( 'vc_button', $param );

	$param               = WPBMap::getParam( 'vc_cta', 'btn_color' );
	$param['dependency'] = array(
		'element' => 'btn_button_type',
		'value'   => 'default',
	);
	vc_update_shortcode_param( 'vc_cta', $param );

	$param               = WPBMap::getParam( 'vc_cta', 'btn_shape' );
	$param['dependency'] = array(
		'element' => 'btn_button_type',
		'value'   => 'default',
	);
	vc_update_shortcode_param( 'vc_cta', $param );

	$param               = WPBMap::getParam( 'vc_cta', 'btn_hover_effect' );
	$param['dependency'] = array(
		'element' => 'btn_button_type',
		'value'   => 'default',
	);
	vc_update_shortcode_param( 'vc_cta', $param );

	$param               = WPBMap::getParam( 'wvc_advanced_slide', 'b1_color' );
	$param['dependency'] = array(
		'element' => 'b1_button_type',
		'value'   => 'default',
	);
	vc_update_shortcode_param( 'wvc_advanced_slide', $param );

	$param               = WPBMap::getParam( 'wvc_advanced_slide', 'b1_shape' );
	$param['dependency'] = array(
		'element' => 'b1_button_type',
		'value'   => 'default',
	);
	vc_update_shortcode_param( 'wvc_advanced_slide', $param );

	$param               = WPBMap::getParam( 'wvc_advanced_slide', 'b1_hover_effect' );
	$param['dependency'] = array(
		'element' => 'b1_button_type',
		'value'   => 'default',
	);
	vc_update_shortcode_param( 'wvc_advanced_slide', $param );

	$param               = WPBMap::getParam( 'wvc_advanced_slide', 'b2_color' );
	$param['dependency'] = array(
		'element' => 'b2_button_type',
		'value'   => 'default',
	);
	vc_update_shortcode_param( 'wvc_advanced_slide', $param );

	$param               = WPBMap::getParam( 'wvc_advanced_slide', 'b2_shape' );
	$param['dependency'] = array(
		'element' => 'b2_button_type',
		'value'   => 'default',
	);
	vc_update_shortcode_param( 'wvc_advanced_slide', $param );

	$param               = WPBMap::getParam( 'wvc_advanced_slide', 'b2_hover_effect' );
	$param['dependency'] = array(
		'element' => 'b2_button_type',
		'value'   => 'default',
	);
	vc_update_shortcode_param( 'wvc_advanced_slide', $param );
}
add_action( 'init', 'decibel_add_button_dependency_params', 15 );

/**
 *  Add background loader effect
 *
 * @param string $effects
 * @return string $effects
 */
function decibel_add_wvc_custom_background_effect( $effects ) {

	if ( function_exists( 'vc_add_param' ) ) {

		vc_add_param(
			'vc_row',
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Add Filmgrain Overlay', 'decibel' ),
				'param_name' => 'add_filmgrain',
				'group'      => esc_html__( 'Style', 'decibel' ),
			)
		);

		vc_add_param(
			'vc_row',
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Add Grunge Overlay', 'decibel' ),
				'param_name' => 'add_grunge',
				'group'      => esc_html__( 'Style', 'decibel' ),
			)
		);

		vc_add_param(
			'vc_column',
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Add Filmgrain Overlay', 'decibel' ),
				'param_name' => 'add_filmgrain',
				'group'      => esc_html__( 'Style', 'decibel' ),
			)
		);

		vc_add_param(
			'vc_column',
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Add Grunge Overlay', 'decibel' ),
				'param_name' => 'add_grunge',
				'group'      => esc_html__( 'Style', 'decibel' ),
			)
		);

		vc_add_param(
			'wvc_advanced_slide',
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Add Filmgrain Overlay', 'decibel' ),
				'param_name' => 'add_filmgrain',
				'group'      => esc_html__( 'Style', 'decibel' ),
			)
		);

		vc_add_param(
			'wvc_advanced_slide',
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Add Grunge Overlay', 'decibel' ),
				'param_name' => 'add_grunge',
				// 'group' => esc_html__( 'Background', 'decibel' ),
			)
		);

		vc_add_param(
			'vc_column',
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Add Filmgrain Overlay', 'decibel' ),
				'param_name' => 'add_filmgrain',
				'group'      => esc_html__( 'Style', 'decibel' ),
			)
		);

		vc_add_param(
			'vc_column',
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Add Grunge Overlay', 'decibel' ),
				'param_name' => 'add_grunge',
				'group'      => esc_html__( 'Style', 'decibel' ),
			)
		);

		vc_add_param(
			'vc_column_inner',
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Add Filmgrain Overlay', 'decibel' ),
				'param_name' => 'add_filmgrain',
				'group'      => esc_html__( 'Style', 'decibel' ),
			)
		);

		vc_add_param(
			'vc_column_inner',
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Add Grunge Overlay', 'decibel' ),
				'param_name' => 'add_grunge',
				'group'      => esc_html__( 'Style', 'decibel' ),
			)
		);

		vc_add_param(
			'rev_slider_vc',
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Preloader Background', 'decibel' ),
				'param_name' => 'preloader_bg',
			)
		);
	}
}
add_action( 'init', 'decibel_add_wvc_custom_background_effect' );

/**
 *  Add work gallery
 *
 * @param string $effects
 * @return string $effects
 */
function decibel_add_work_gallery_param( $effects ) {

	if ( function_exists( 'vc_add_param' ) ) {
		vc_add_param(
			'wvc_work_index',
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Use as gallery', 'decibel' ),
				'param_name' => 'work_is_gallery',
				'desc'       => esc_html__( 'The first gallery in the posts will open directly in a lightbox.', 'decibel' ),
			)
		);
	}
}
add_action( 'init', 'decibel_add_work_gallery_param' );

/**
 * Get hover effects
 */
function decibel_get_hover_effects() {
	return array(
		esc_html__( 'None', 'decibel' )              => 'none',
		esc_html__( 'Simple', 'decibel' )            => 'simple',
		esc_html__( 'Slide Up', 'decibel' )          => 'slide-up',
		esc_html__( 'Grunge', 'decibel' )            => 'grunge',
		esc_html__( 'Old Version Style', 'decibel' ) => 'old',
	);
}

/**
 * Add hover effects
 */
function decibel_add_hover_effects() {
	if ( function_exists( 'vc_add_params' ) ) {
		vc_add_params(
			'wvc_release_index',
			array(
				array(
					'heading'     => esc_html__( 'Hover Effect', 'decibel' ),
					'param_name'  => 'release_hover_effect',
					'type'        => 'dropdown',
					'value'       => decibel_get_hover_effects(),
					'description' => esc_html__( 'Settings above may be overwritten.', 'decibel' ),
					'dependency'  => array(
						'element' => 'release_display',
						'value'   => array( 'grid', 'metro' ),
					),
					'std'         => decibel_get_theme_mod( 'release_hover_effect' ),
					'admin_label' => true,
				),
			)
		);

		vc_add_params(
			'wvc_gallery_index',
			array(
				array(
					'heading'     => esc_html__( 'Hover Effect', 'decibel' ),
					'param_name'  => 'gallery_hover_effect',
					'type'        => 'dropdown',
					'value'       => decibel_get_hover_effects(),
					'description' => esc_html__( 'Settings above may be overwritten.', 'decibel' ),
					'dependency'  => array(
						'element' => 'gallery_display',
						'value'   => array( 'grid', 'metro', 'masonry' ),
					),
					'std'         => decibel_get_theme_mod( 'gallery_hover_effect' ),
					'admin_label' => true,
				),
			)
		);
	}
}
add_action( 'init', 'decibel_add_hover_effects' );

/**
 * Default release hover effect
 */
add_filter(
	'release_default_hover_effect',
	function() {
		decibel_get_theme_mod( 'release_hover_effect', 'none' );
	}
);

/**
 * Release default align
 */
add_filter(
	'release_caption_align',
	function() {
		return 'center';
	}
);

/**
 * Release default align
 */
add_filter(
	'release_caption_valign',
	function() {
		return 'bottom';
	}
);


/**
 * Gallery release hover effect
 */
add_filter(
	'gallery_default_hover_effect',
	function() {
		decibel_get_theme_mod( 'gallery_hover_effect', 'none' );
	}
);

/**
 * Albums default align
 */
add_filter(
	'gallery_caption_align',
	function() {
		return 'center';
	}
);

/**
 * Albums default align
 */
add_filter(
	'gallery_caption_valign',
	function() {
		return 'bottom';
	}
);


/**
 * Filter button attribute
 *
 * @param array $atts
 * @return array $atts
 */
function woltheme_filter_button_atts( $atts ) {

	// button
	if ( isset( $atts['button_type'] ) && 'default' !== $atts['button_type'] ) {
		$atts['shape']        = '';
		$atts['color']        = '';
		$atts['hover_effect'] = '';
		$atts['el_class']    .= ' ' . $atts['button_type'];
	}

	return $atts;
}
add_filter( 'wvc_button_atts', 'woltheme_filter_button_atts' );

/**
 * Filter audio button attribute
 *
 * @param array $atts
 * @return array $atts
 */
function woltheme_filter_audio_button_atts( $atts ) {

	// button
	if ( isset( $atts['btn_button_type'] ) && 'default' !== $atts['btn_button_type'] ) {
		$atts['shape']        = '';
		$atts['color']        = '';
		$atts['hover_effect'] = '';
		$atts['el_class']    .= ' ' . $atts['btn_button_type'];
	}

	return $atts;
}
add_filter( 'wvc_audio_button_atts', 'woltheme_filter_audio_button_atts' );

add_filter(
	'wvc_revslider_container_class',
	function( $class, $atts ) {

		if ( isset( $atts['preloader_bg'] ) && 'true' === $atts['preloader_bg'] ) {
			$class .= ' wvc-preloader-bg';
		}

		return $class;

	},
	10,
	2
);

/**
 * Filter CTA button attribute
 *
 * @param array $atts the shortcode atts we get
 * @param array $btn_params the button attribute to filter
 * @return array $btn_params
 */
function woltheme_filter_cta_button_atts( $btn_params, $atts ) {

	// button
	if ( isset( $atts['btn_button_type'] ) && 'default' !== $atts['btn_button_type'] ) {
		$btn_params['shape']        = '';
		$btn_params['color']        = '';
		$btn_params['hover_effect'] = '';
		$btn_params['el_class']    .= ' ' . $atts['btn_button_type'];
	}

	return $btn_params;
}
add_filter( 'wvc_cta_button_atts', 'woltheme_filter_cta_button_atts', 10, 2 );

/**
 * Filter advanced slider button 1 attribute
 *
 * @param array $atts the shortcode atts we get
 * @param array $b1_params the button attribute to filter
 * @return array $b1_params
 */
function woltheme_filter_b1_button_atts( $b1_params, $atts ) {

	// button
	if ( isset( $atts['b1_button_type'] ) && 'default' !== $atts['b1_button_type'] ) {
		$b1_params['shape']        = '';
		$b1_params['color']        = '';
		$b1_params['hover_effect'] = '';
		$b1_params['el_class']    .= ' ' . $atts['b1_button_type'];
	}

	return $b1_params;
}
add_filter( 'wvc_advanced_slider_b1_button_atts', 'woltheme_filter_b1_button_atts', 10, 2 );

/**
 * Filter advanced slider button 1 attribute
 *
 * @param array $atts the shortcode atts we get
 * @param array $b2_params the button attribute to filter
 * @return array $b2_params
 */
function woltheme_filter_b2_button_atts( $b2_params, $atts ) {

	// button
	if ( isset( $atts['b2_button_type'] ) && 'default' !== $atts['b2_button_type'] ) {
		$b2_params['shape']        = '';
		$b2_params['color']        = '';
		$b2_params['hover_effect'] = '';
		$b2_params['el_class']    .= ' ' . $atts['b2_button_type'];
	}

	return $b2_params;
}
add_filter( 'wvc_advanced_slider_b2_button_atts', 'woltheme_filter_b2_button_atts', 10, 2 );

/**
 * Add theme button option to Button element
 */
function decibel_add_theme_buttons() {

	if ( function_exists( 'vc_add_params' ) ) {
		vc_add_params(
			'vc_button',
			array(
				array(
					'heading'    => esc_html__( 'Button Type', 'decibel' ),
					'param_name' => 'button_type',
					'type'       => 'dropdown',
					'value'      => decibel_custom_button_types(),
					'weight'     => 1000,
				),
			)
		);

		vc_add_params(
			'vc_cta',
			array(
				array(
					'heading'    => esc_html__( 'Button Type', 'decibel' ),
					'param_name' => 'btn_button_type',
					'type'       => 'dropdown',
					'value'      => decibel_custom_button_types(),
					'weight'     => 10,
					'group'      => esc_html__( 'Button', 'decibel' ),
				),
			)
		);

		vc_add_params(
			'wvc_audio_button',
			array(
				array(
					'heading'    => esc_html__( 'Button Type', 'decibel' ),
					'param_name' => 'btn_button_type',
					'type'       => 'dropdown',
					'value'      => decibel_custom_button_types(),
					'weight'     => 10,
					// 'group' => esc_html__( 'Button', 'decibel' ),
				),
			)
		);

		vc_add_params(
			'wvc_advanced_slide',
			array(
				array(
					'heading'    => esc_html__( 'Button Type', 'decibel' ),
					'param_name' => 'b1_button_type',
					'type'       => 'dropdown',
					'value'      => decibel_custom_button_types(),
					'weight'     => 10,
					'group'      => esc_html__( 'Button 1', 'decibel' ),
					'dependency' => array(
						'element' => 'add_button_1',
						'value'   => array( 'true' ),
					),
				),
			)
		);

		vc_add_params(
			'wvc_advanced_slide',
			array(
				array(
					'heading'    => esc_html__( 'Button Type', 'decibel' ),
					'param_name' => 'b2_button_type',
					'type'       => 'dropdown',
					'value'      => decibel_custom_button_types(),
					'weight'     => 10,
					'group'      => esc_html__( 'Button 2', 'decibel' ),
					'dependency' => array(
						'element' => 'add_button_2',
						'value'   => array( 'true' ),
					),
				),
			)
		);

		/*
		vc_add_params(
			'wvc_product_index',
			array(
				array(
					'heading' => esc_html__( 'Layout', 'decibel' ),
					'param_name' => 'product_layout',
					'type' => 'dropdown',
					'value' => array(
						esc_html__( 'Standard', 'decibel' ) => 'standard',
						//esc_html__( 'Overlay', 'decibel' ) => 'overlay',
						esc_html__( 'Label', 'decibel' ) => 'label',
					),
					'weight' => 10,
				),
			)
		);*/

		vc_add_params(
			'wvc_work_index',
			array(
				array(
					'heading'    => esc_html__( 'Filter Alignement', 'decibel' ),
					'param_name' => 'work_category_filter_text_alignment',
					'type'       => 'dropdown',
					'value'      => array(
						esc_html__( 'Centered', 'decibel' ) => 'center',
						esc_html__( 'Spread', 'decibel' ) => 'spread',
					),
					'dependency' => array(
						'element' => 'work_category_filter',
						'value'   => array( 'true' ),
					),
				),
			)
		);

		vc_add_params(
			'wvc_video_index',
			array(
				array(
					'heading'    => esc_html__( 'Filter Alignement', 'decibel' ),
					'param_name' => 'video_category_filter_text_alignment',
					'type'       => 'dropdown',
					'value'      => array(
						esc_html__( 'Centered', 'decibel' ) => 'center',
						esc_html__( 'Spread', 'decibel' ) => 'spread',
					),
					'dependency' => array(
						'element' => 'video_category_filter',
						'value'   => array( 'true' ),
					),
				),
			)
		);

		vc_add_params(
			'wvc_release_index',
			array(

				array(
					'heading'    => esc_html__( 'Filter Alignement', 'decibel' ),
					'param_name' => 'release_category_filter_text_alignment',
					'type'       => 'dropdown',
					'value'      => array(
						esc_html__( 'Centered', 'decibel' ) => 'center',
						esc_html__( 'Spread', 'decibel' ) => 'spread',
					),
					'dependency' => array(
						'element' => 'release_category_filter',
						'value'   => array( 'true' ),
					),
				),
			)
		);
	}
}
add_action( 'init', 'decibel_add_theme_buttons' );

/*
--------------------------------------------------------------------

	CUSTOM WVC ELEMENT

----------------------------------------------------------------------
*/

if ( defined( 'WVC_OK' ) ) {

	$wvc_custom_heading_params = array();

	if ( function_exists( 'wvc_heading_params' ) && function_exists( 'vc_map_integrate_shortcode' ) ) {

		$wvc_custom_heading_params = vc_map_integrate_shortcode(
			wvc_heading_params(),
			'',
			'',
			array(
				'exclude' => array(
					'add_background',
					'background_img',
					'background_position',
					'background_repeat',
					'background_size',
				),
			)
		);

		if ( is_array( $wvc_custom_heading_params ) && ! empty( $wvc_custom_heading_params ) ) {
			foreach ( $wvc_custom_heading_params as $key => $param ) {
				if ( is_array( $param ) && ! empty( $param ) ) {

					if ( 'responsive' == $param['param_name'] ) {
						// force dependency
						$wvc_custom_heading_params[ $key ]['std'] = 'no';
					}

					if ( 'font_size' == $param['param_name'] ) {
						// force dependency
						$wvc_custom_heading_params[ $key ]['std'] = 24;
					}
				}
			}
		}
	}
}

/**
 * Add MP3 player on single product page
 *
 * @return string
 */
function decibel_add_audio_player_on_single_product_page() {

	$output     = '';
	$audio_meta = get_post_meta( get_the_ID(), '_post_product_mp3', true );

	if ( $audio_meta ) {
		$audio_attrs = array(
			'src'      => esc_url( $audio_meta ),
			'loop'     => false,
			'autoplay' => false,
			'preload'  => 'auto',
		);

		$output = wp_audio_shortcode( $audio_attrs );
	}

	echo decibel_kses( $output );
}
add_action( 'woocommerce_single_product_summary', 'decibel_add_audio_player_on_single_product_page', 14 );

/**
 * Minimal player
 *
 * Displays a play/pause audio player on product grid
 */
function decibel_minimal_player( $post_id = null ) {
	$post_id    = ( $post_id ) ? $post_id : get_the_ID();
	$audio_meta = get_post_meta( get_the_ID(), '_post_product_mp3', true );
	$rand       = rand( 0, 99999 );

	if ( ! $audio_meta ) {
		return;
	}
	?>
	<a href="#" class="minimal-player-play-button">
	<i class="minimal-player-icon minimal-player-play"></i><i class="minimal-player-icon minimal-player-pause"></i>
	</a>
	<audio class="minimal-player-audio" id="minimal-player-audio-<?php echo absint( $rand ); ?>" src="<?php echo esc_url( $audio_meta ); ?> "></audio>
	<?php
}
/* Output player in loop */
add_action( 'decibel_product_minimal_player', 'decibel_minimal_player' );

function decibel_add_menu_cta_content_type_options( $array ) {

	$array['custom'] = esc_html__( 'Mixed (cart, socials and search icon)', 'decibel' );

	return $array;
}
add_filter( 'decibel_menu_cta_content_type_options', 'decibel_add_menu_cta_content_type_options' );

/**
 * Output old style CTA
 */
function decibel_output_mixed_cta_content() {
	?>
	<div class="cart-container cta-item">
		<?php
			/**
			 * Cart icon
			 */
			decibel_cart_menu_item();

			/**
			 * Cart panel
			 */
			echo decibel_cart_panel();
		?>
	</div><!-- .cart-container -->
	<div class="search-container cta-item">
		<?php
			/**
			 * Search
			 */
			echo decibel_search_menu_item();
		?>
	</div><!-- .search-container -->
	<?php
	if ( function_exists( 'wvc_socials' ) ) {
		echo wvc_socials( array( 'services' => decibel_get_inherit_mod( 'menu_socials', 'facebook,twitter,instagram' ) ) );
	}
	?>
	<?php
}
add_action( 'decibel_custom_menu_cta_content', 'decibel_output_mixed_cta_content' );


function decibel_add_play_pause_button_to_secondary_menu( $context ) {

	$mp3_id      = decibel_get_inherit_mod( 'nav_player_mp3' );
	$show_player = decibel_get_inherit_mod( 'show_nav_player' );

	if ( $mp3_id && 'yes' === $show_player && 'desktop' === $context ) {
		$mp3_url = wp_get_attachment_url( $mp3_id );
		echo '<div id="nav-player-container" class="nav-player-container cta-item">';
		echo '<span class="fa nav-play-icon nav-play-button" title="' . esc_attr( __( 'Play', 'decibel' ) ) . '"></span>';
		echo '<audio class="nav-player" id="' . uniqid( 'nav-player-' ) . '" src="' . esc_url( $mp3_url ) . '"></audio>';
		echo '</div>';
	}

}
add_action( 'decibel_secondary_menu', 'decibel_add_play_pause_button_to_secondary_menu', 10, 1 );

if ( ! function_exists( 'decibel_release_meta' ) ) {
	/**
	 * Display release meta
	 */
	function decibel_release_meta() {

		if ( ! class_exists( 'Wolf_Discography' ) ) {
			return;
		}

		$meta            = wd_get_meta();
		$release_title   = $meta['title'];
		$release_date    = $meta['date'];
		$release_catalog = $meta['catalog'];
		$release_format  = $meta['format'];
		$artists         = get_the_terms( get_the_ID(), 'band' );
		$artist_tax      = get_taxonomy( 'band' );
		$genre           = get_the_terms( get_the_ID(), 'release_genre' );
		$genre_tax       = get_taxonomy( 'release_genre' );
		$rewrite         = '';
		$artist_tax_slug = '';
		$genre_tax_slug  = '';

		if ( taxonomy_exists( 'band' ) && isset( $artist_tax->rewrite['slug'] ) ) {

			$artist_tax_slug = $artist_tax->rewrite['slug'];
		}

		if ( taxonomy_exists( 'release_genre' ) && isset( $genre_tax->rewrite['slug'] ) ) {

			$genre_tax_slug = $genre_tax->rewrite['slug'];
		}

		// Date
		if ( $release_date ) :
			?>
		<strong><?php esc_html_e( 'Release Date', 'decibel' ); ?></strong> : <?php echo sanitize_text_field( $release_date ); ?><br>
		<?php endif; ?>

		<?php
		if ( $artists ) {
			$artist_label = ( 1 < count( $artists ) ) ? esc_html__( 'Artists', 'decibel' ) : esc_html__( 'Artist', 'decibel' );
			?>
				<strong><?php echo sanitize_text_field( $artist_label ); ?></strong> :
				<?php
				$artists_html = '';
				foreach ( $artists as $artist ) {
					$artist_slug   = $artist->slug;
					$artist_name   = $artist->name;
					$artists_html .= '<a href="' . esc_url( home_url( '/' . $artist_tax_slug . '/' . $artist_slug ) ) . '">' . sanitize_text_field( $artist_name ) . '</a>, ';
				}

				echo rtrim( $artists_html, ', ' );
				echo '<br>';
		}
		?>
		<?php

		if ( $genre ) {
			$genre_label = ( 1 < count( $genre ) ) ? esc_html__( 'Genres', 'decibel' ) : esc_html__( 'Genre', 'decibel' );
			?>
				<strong><?php echo sanitize_text_field( $genre_label ); ?></strong> :
				<?php
				$genre_html = '';
				foreach ( $genre as $g ) {
					// debug( $g );
					$genre_slug  = $g->slug;
					$genre_name  = $g->name;
					$genre_html .= '<a href="' . esc_url( home_url( '/' . $genre_tax_slug . '/' . $genre_slug ) ) . '">' . sanitize_text_field( $genre_name ) . '</a>, ';
				}

				echo rtrim( $genre_html, ', ' );
				echo '<br>';
		}
		?>
		<?php
		// Catalog number
		if ( $release_catalog ) :
			?>
		<strong><?php esc_html_e( 'Catalog ref.', 'decibel' ); ?></strong> : <?php echo sanitize_text_field( $release_catalog ); ?><br>
		<?php endif; ?>

		<?php
		// Type
		if ( $release_format && wolf_get_release_option( 'display_format' ) ) :
			?>
		<strong><?php esc_html_e( 'Format', 'decibel' ); ?></strong> : <?php echo sanitize_text_field( $release_format ); ?><br>
		<?php endif; ?>
		<?php
		edit_post_link( esc_html__( 'Edit', 'decibel' ), '<span class="edit-link">', '</span>' );
	}
}

/**
 * Overwrite release button
 */
function decibel_release_buttons( $html ) {

	$meta                = wd_get_meta();
	$release_itunes      = $meta['itunes'];
	$release_google_play = $meta['google_play'];
	$release_amazon      = $meta['amazon'];
	$release_spotify     = $meta['spotify'];
	$release_buy         = $meta['buy'];
	$release_free        = $meta['free'];

	$product_id = get_post_meta( get_the_ID(), '_post_wc_product_id', true );

	ob_start();
	?>
	<span class="wolf-release-buttons">
		<?php if ( $release_free ) : ?>
		<span class="wolf-release-button">
			<a class="wolf-release-free <?php echo apply_filters( 'decibel_release_button_class', 'button' ); ?>" title="<?php esc_html_e( 'Download Now', 'decibel' ); ?>" href="<?php echo esc_url( $release_free ); ?>"><?php esc_html_e( 'Free Download', 'decibel' ); ?></a>
		</span>
		<?php endif; ?>
		<?php if ( $release_spotify ) : ?>
		<span class="wolf-release-button">
			<a target="_blank" title="<?php printf( esc_html__( 'Listen on %s', 'decibel' ), 'Spotify' ); ?>" class="wolf-release-spotify <?php echo apply_filters( 'decibel_release_button_class', 'button' ); ?>" href="<?php echo esc_url( $release_spotify ); ?>"><?php esc_html_e( 'Spotify', 'decibel' ); ?></a>
		</span>
		<?php endif; ?>
		<?php if ( $release_itunes ) : ?>
		<span class="wolf-release-button">
			<a target="_blank" title="<?php printf( esc_html__( 'Buy on %s', 'decibel' ), 'iTunes' ); ?>" class="wolf-release-itunes <?php echo apply_filters( 'decibel_release_button_class', 'button' ); ?>" href="<?php echo esc_url( $release_itunes ); ?>"><?php esc_html_e( 'iTunes', 'decibel' ); ?></a>
		</span>
		<?php endif; ?>
		<?php if ( $release_amazon ) : ?>
		<span class="wolf-release-button">
			<a target="_blank" title="<?php printf( esc_html__( 'Buy on %s', 'decibel' ), 'amazon' ); ?>" class="wolf-release-amazon <?php echo apply_filters( 'decibel_release_button_class', 'button' ); ?>" href="<?php echo esc_url( $release_amazon ); ?>"><?php esc_html_e( 'Amazon', 'decibel' ); ?></a>
		</span>
		<?php endif; ?>
		<?php if ( $release_google_play ) : ?>
		<span class="wolf-release-button">
			<a target="_blank" title="<?php printf( esc_html__( 'Buy on %s', 'decibel' ), 'YouTube Music' ); ?>" class="wolf-release-google_play <?php echo apply_filters( 'decibel_release_button_class', 'button' ); ?>" href="<?php echo esc_url( $release_google_play ); ?>"><?php esc_html_e( 'YouTube Music', 'decibel' ); ?></a>
		</span>
		<?php endif; ?>
		<?php if ( $release_buy ) : ?>
		<span class="wolf-release-button">
			<a target="_blank" title="<?php esc_html_e( 'Buy Now', 'decibel' ); ?>" class="wolf-release-buy <?php echo apply_filters( 'decibel_release_button_class', 'button' ); ?>" href="<?php echo esc_url( $release_buy ); ?>"><?php esc_html_e( 'Buy', 'decibel' ); ?></a>
		</span>
		<?php endif; ?>
		<?php if ( $product_id && 0 != $product_id ) : ?>
			<span class="wolf-release-button">
				<?php echo decibel_add_to_cart( $product_id, 'wolf-release-add-to-cart ' . apply_filters( 'decibel_release_button_class', 'button' ), '<span class="wolf-release-add-to-cart-button-title" title="' . esc_html__( 'Add to cart', 'decibel' ) . '"></span>' ); ?>
			</span>
		<?php endif; ?>
	</span><!-- .wolf-release-buttons -->
	<?php
	$html = ob_get_clean();

	return $html;
}
add_filter( 'wolf_discography_release_buttons', 'decibel_release_buttons' );

if ( ! function_exists( 'decibel_gallery_meta' ) ) {
	/**
	 * Gallery meta
	 */
	function decibel_gallery_meta() {

		?>
		<a href="#" data-gallery-params="<?php echo esc_js( wp_json_encode( decibel_get_gallery_params() ) ); ?>" class="gallery-quickview" title="<?php esc_html_e( 'Quickview', 'decibel' ); ?>">
		<?php
			/**
			 * Photo count
			 */
			printf( esc_html__( '%d photos', 'decibel' ), decibel_get_first_gallery_image_count() );
		?>
		</a>
		<?php
		if ( get_the_term_list( get_the_ID(), 'gallery_type', '', ' / ', '' ) ) {
			?>
			<span class="gallery-meta-separator">&mdash;</span>
			<?php
				/**
				 * Gallery taxonomy
				 */
				echo get_the_term_list( get_the_ID(), 'gallery_type', '', ' / ', '' );

		}
	}
}

function decibel_remove_gallery_post_type_comment( $args, $post_type ) {
	if ( 'gallery' === $post_type ) {
		$args['supports'] = array( 'title', 'editor', 'thumbnail' );
	}

	return $args;
}
add_filter( 'register_post_type_args', 'decibel_remove_gallery_post_type_comment', 10, 2 );

/*
----------------------------------------------------------------------------------

	Playlist function

--------------------------------------------------------------------------------------
*/

// add_theme_support( 'wpm_bar' );

/**
 * Can we display a player?
 *
 * @return bool
 */
function decibel_sticky_playlist_id() {
	if ( is_page() && get_post_meta( get_the_ID(), '_post_sticky_playlist_id', true ) ) {
		$playlist_id = get_post_meta( get_the_ID(), '_post_sticky_playlist_id', true );

		if ( $playlist_id && 'none' !== $playlist_id ) {
			return $playlist_id;
		}
	}
}

/**
 * Add body classes
 *
 * @param  array $classes
 * @return array
 */
function decibel_sticky_player_body_class( $classes ) {

	if ( decibel_sticky_playlist_id() ) {
		$classes[] = 'is-wpm-bar-player';
	}

	return $classes;
}
add_filter( 'body_class', 'decibel_sticky_player_body_class' );

/**
 * Output bottom bar holder
 *
 * @param  array $classes
 * @return array
 */
function decibel_output_sticky_playlist_holder() {

	if ( decibel_sticky_playlist_id() ) {
		echo '<div class="wpm-bar-holder"></div>';
	}
}
add_action( 'wp_footer', 'decibel_output_sticky_playlist_holder' );

/**
 * Output bottom bar player
 */
function decibel_output_sticky_playlist() {

	if ( decibel_sticky_playlist_id() ) {

		$playlist_id = decibel_sticky_playlist_id();
		$skin        = get_post_meta( get_the_ID(), '_post_sticky_playlist_skin', true );

		$attrs = array(
			'show_tracklist'   => false,
			'is_sticky_player' => true,
		);

		if ( $skin ) {
			$attrs['theme'] = $skin;
		}

		if ( function_exists( 'wpm_playlist' ) ) {
			wpm_playlist( $playlist_id, $attrs );
		}
	}
}
add_action( 'decibel_body_start', 'decibel_output_sticky_playlist' );

/*
----------------------------------------------------------------------------------

	ADMIN TAB

--------------------------------------------------------------------------------------
*/

/**
 * Theme license tab
 */
function decibel_output_v3_tab() {
	?>
	<a href="#decibel-v3" class="nav-tab"><?php esc_html_e( 'What\'s New', 'decibel' ); ?></a>
	<?php
}
add_action( 'decibel_before_about_tabs', 'decibel_output_v3_tab' );

/**
 * Theme license tab
 */
function decibel_output_v3_content() {
	?>
	<div id="decibel-v3" class="wvc-options-panel">
		<div id="decibel-img">
			<img src="<?php echo esc_url( get_template_directory_uri() . '/config/decibel-v3.png' ); ?>" alt="<?php esc_html_e( 'Decibel v3', 'decibel' ); ?>">
		</div>
		<div id="dv3-content">
			<h3><?php esc_html_e( 'Welcome to Decibel version 3', 'decibel' ); ?></h3>

			<p class="big-tagline"><?php esc_html_e( 'We took the best from our most recent music themes and put it back to Decibel to make it even better. We also added new exlusive features.', 'decibel' ); ?></p>
			<?php
				/**
				 * Update instructions from Decibel updater plugin
				 */
			if ( get_option( 'wolf_theme_options_decibel' ) && ! get_option( 'decibel_v2_fully_updated' ) ) {
				if ( function_exists( 'decibel_v3_update_instructions' ) ) {
					decibel_v3_update_instructions();
				}
			}
			?>
			<h4><?php esc_html_e( 'What\'s New', 'decibel' ); ?></h4>
			<ul class="bullet-list">
				<li><?php esc_html_e( 'The backend has been completely rebuilt.', 'decibel' ); ?></li>
				<li><?php esc_html_e( 'The theme design has been fully repolished and modernized.', 'decibel' ); ?></li>
				<li><?php esc_html_e( 'Some deprecated design featured have been removed.', 'decibel' ); ?></li>
				<li><?php esc_html_e( 'The theme options have been moved to the customizer.', 'decibel' ); ?></li>
				<li><?php esc_html_e( 'Many design options have been added.', 'decibel' ); ?></li>
				<li><?php esc_html_e( 'Many page options have been added below your page editor.', 'decibel' ); ?></li>
				<li>
				<?php
				printf(
					decibel_kses( __( 'Tons of features and page builder elements have been added via our <a href="%1$s" target="_blank">%2$s</a>.', 'decibel' ) ),
					'https://wolfthemes.ticksy.com/article/14866/',
					'Wolf WPBakery Page Builder Extension'
				);
				?>
				 </li>
				<li><?php esc_html_e( 'We have added many new homepages, inner pages and post type layouts to the demo content.', 'decibel' ); ?></li>
				<li><?php esc_html_e( 'Wolf Tour Dates plugin has been updated to Wolf Events.', 'decibel' ); ?></li>
				<li>
				<?php
				printf(
					decibel_kses( __( 'The Wolf Slider plugin has been deprecated in favor of the page builder slider elements and the <a href="%s" target="_blank">content block system</a>.', 'decibel' ) ),
					'https://wolfthemes.ticksy.com/article/12792'
				);
				?>
				</li>
			</ul>
		</div>
		<div class="clear"></div>
	</div><!-- #decibel-v3 -->
	<?php
}
add_action( 'decibel_before_about_tabs_content', 'decibel_output_v3_content' );
