<?php
/**
 * The sidebar containing the footer widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

if ( is_active_sidebar( 'sidebar-footer' ) ) :
	$decibel_tertiary_widget_area_class  = 'sidebar-footer';
	$decibel_tertiary_widget_area_class .= ' ' . apply_filters( 'decibel_sidebar_footer_class', '' );
	?>
	<div id="tertiary" class="<?php echo decibel_sanitize_html_classes( $decibel_tertiary_widget_area_class ); ?>">
		<div class="sidebar-footer-inner wrap">
			<div class="widget-area">
				<?php dynamic_sidebar( 'sidebar-footer' ); ?>
			</div><!-- .widget-area -->
		</div><!-- .sidebar-footer-inner -->
	</div><!-- #tertiary .sidebar-footer -->
<?php endif; ?>
