<?php
/**
 * The category filter for gallery posts
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */

// Get template vars
extract( wp_parse_args( $filter_args, array(
	'gallery_type_include' => '',
	'gallery_type_exclude' => '',
	'gallery_category_filter_text_alignment' => 'center',
) ) );

/* Term query args */
$terms_args = array(
	'taxonomy' => 'gallery_type',
	'hide_empty' => true,
);

/* If gallery types are defined, add them to the arguments */
if ( $gallery_type_include ) {

	$gallery_types_ids = array();
	$gallery_types_array = decibel_list_to_array( $gallery_type_include );

	if ( array() !== $gallery_types_array ) {
		foreach ( $gallery_types_array as $slug ) {

			$term = get_term_by( 'slug', $slug, 'gallery_type' );

			if ( is_object( $term ) ) {
				$gallery_types_ids[] = $term->term_id;
			}
		}
	}

	$terms_args['include'] = $gallery_types_ids;
}

/* If exlucded gallery types are defined, add them to the arguments */
if ( $gallery_type_exclude ) {

	$gallery_types_ids = array();
	$gallery_types_array = decibel_list_to_array( $gallery_type_exclude );

	if ( array() !== $gallery_types_array ) {
		foreach ( $gallery_types_array as $slug ) {

			$term = get_term_by( 'slug', $slug, 'gallery_type' );

			if ( is_object( $term ) ) {
				$gallery_types_ids[] = $term->term_id;
			}
		}
	}

	$terms_args['exclude'] = $gallery_types_ids;
}

// Get terms
$terms = get_terms( $terms_args );

if ( array() === $terms ) {
	return;
}

$filter_class = 'category-filter category-filter-gallery';

$filter_class .= " category-filter-text-align-$gallery_category_filter_text_alignment";

$albums_url = ( wolf_get_albums_url() ) ? wolf_get_albums_url() : home_url();

$all_active_class = ( ! is_tax( 'gallery_type' ) ) ? 'active' : '';
?>
<div class="<?php echo decibel_sanitize_html_classes( $filter_class ); ?>">
	<ul>
		<li><a class="filter-link <?php echo esc_attr( $all_active_class ); ?>" href="<?php echo esc_url( $albums_url  ); ?>" data-filter="gallery"><?php esc_html_e( 'All', 'decibel' ) ?></a></li>
		<?php foreach ( $terms as $term ) :
			$term_active_class = ( $term->slug === get_query_var( 'gallery_type' ) ) ? 'active' : '';
		?>
			<li>
				<a class="filter-link <?php echo esc_attr( $term_active_class ); ?>" data-filter="gallery_type-<?php echo sanitize_title( $term->slug ); ?>" href="<?php echo esc_url( get_term_link( $term ) ); ?>"><?php echo sanitize_text_field( $term->name ); ?></a>
			</li>
		<?php endforeach; ?>
	</ul>
</div><!-- .category-filter -->
