<?php
/**
 * Template part for displaying gallery posts common layout
 *
 * As all work posts share the same markup, we use this common template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Decibel
 * @version 3.3.2
 */
extract( wp_parse_args( $template_args, array(
	'layout' => '',
	'overlay_color' => 'auto',
	'overlay_custom_color' => '',
	'overlay_text_color' => '',
	'overlay_text_custom_color' => '',
	'overlay_opacity' => 88,
) ) );

$text_style = '';

if ( $overlay_text_color && 'overlay' === $layout ) {
	$text_color = decibel_convert_color_class_to_hex_value( $overlay_text_color, $overlay_text_custom_color );
	if ( $text_color ) {
		$text_style .= 'color:' . decibel_sanitize_color( $text_color ) . ';';
	}
}

$dominant_color = decibel_get_image_dominant_color( get_post_thumbnail_id() );
$actual_overlay_color = '';

if ( 'auto' === $overlay_color ) {

	$actual_overlay_color = $dominant_color;

} else {
	$actual_overlay_color = decibel_convert_color_class_to_hex_value( $overlay_color, $overlay_custom_color );
}

$overlay_tone_class = 'overlay-tone-' . decibel_get_color_tone( $actual_overlay_color );
?>
<figure <?php decibel_post_attr( array( $overlay_tone_class ) ); ?>>
	<div class="entry-box">
		<div class="entry-container">
			<a class="entry-link" href="<?php the_permalink(); ?>">
				<div class="entry-image">
					<div class="entry-cover">
						<?php
							echo decibel_background_img();
						?>
					</div><!-- entry-cover -->
				</div>
			</a>
			<div class="entry-inner">
				<a class="entry-link entry-link-mask" href="<?php the_permalink(); ?>"></a>
				<?php

					if ( $dominant_color && 'auto' === $overlay_color ) {
						$overlay_custom_color = $dominant_color;
					}

					/**
					 * Overlay
					 */
					echo decibel_background_overlay( array(
						'overlay_color' => $overlay_color,
						'overlay_custom_color' => $overlay_custom_color,
						'overlay_opacity' => $overlay_opacity, )
					);
				?>
				<div style="<?php echo decibel_esc_style_attr( $text_style ); ?>" class="entry-summary">
					<h3 class="entry-title"><a href="<?php the_permalink(); ?>" style="<?php echo decibel_esc_style_attr( $text_style ); ?>"><?php the_title(); ?></a></h3>
					<div class="entry-meta">
						<?php
							/**
							 * Gallery meta
							 */
							decibel_gallery_meta();
						?>
					</div><!-- .entry-meta -->
				</div><!--  .entry-summary  -->
			</div><!--  .entry-summary-container  -->
		</div>
	</div><!-- .entry-container -->
</figure><!-- #post-## -->